/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import ro.sync.emf.common.notify.Notification;
import ro.sync.emf.common.notify.NotificationChain;
import ro.sync.emf.common.notify.impl.NotificationImpl;
import ro.sync.emf.common.util.BasicEList;
import ro.sync.emf.common.util.DelegatingEList;
import ro.sync.emf.common.util.EList;
import ro.sync.emf.ecore.EClassifier;
import ro.sync.emf.ecore.EObject;
import ro.sync.emf.ecore.EReference;
import ro.sync.emf.ecore.EStructuralFeature;
import ro.sync.emf.ecore.ETypedElement;
import ro.sync.emf.ecore.EcorePackage;
import ro.sync.emf.ecore.InternalEObject;
import ro.sync.emf.ecore.impl.ENotificationImpl;
import ro.sync.emf.ecore.impl.EObjectImpl;
import ro.sync.emf.ecore.util.DelegatingEcoreEList;
import ro.sync.emf.ecore.util.FeatureMap;
import ro.sync.emf.ecore.util.FeatureMapUtil;

public abstract class DelegatingFeatureMap
extends DelegatingEcoreEList<FeatureMap.Entry>
implements FeatureMap.Internal,
FeatureMap.Internal.Wrapper {
    private static final long serialVersionUID = 1L;
    protected FeatureMap.Internal.Wrapper wrapper = this;
    protected final FeatureMapUtil.Validator featureMapValidator;
    protected final EStructuralFeature eStructuralFeature;

    public DelegatingFeatureMap(InternalEObject owner, int featureID) {
        super(owner);
        this.eStructuralFeature = owner.eClass().getEStructuralFeature(featureID);
        this.featureMapValidator = FeatureMapUtil.getValidator(owner.eClass(), this.getEStructuralFeature());
    }

    public DelegatingFeatureMap(InternalEObject owner, EStructuralFeature eStructuralFeature) {
        super(owner);
        this.eStructuralFeature = eStructuralFeature;
        this.featureMapValidator = FeatureMapUtil.getValidator(owner.eClass(), this.getEStructuralFeature());
    }

    @Override
    public FeatureMap.Internal.Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(FeatureMap.Internal.Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public FeatureMap featureMap() {
        return this;
    }

    @Override
    protected FeatureMap.Entry validate(int index, FeatureMap.Entry object) {
        if (this.modCount == 0) {
            return object;
        }
        FeatureMap.Entry result = super.validate(index, object);
        EStructuralFeature eStructuralFeature = object.getEStructuralFeature();
        if (!eStructuralFeature.isChangeable() || !this.featureMapValidator.isValid(eStructuralFeature)) {
            throw new RuntimeException("Invalid entry feature '" + eStructuralFeature.getEContainingClass().getName() + "." + eStructuralFeature.getName() + "'");
        }
        return result;
    }

    @Override
    protected boolean isEObject() {
        return false;
    }

    @Override
    protected boolean isUnique() {
        return false;
    }

    @Override
    protected boolean canContainNull() {
        return false;
    }

    @Override
    protected EClassifier getFeatureType() {
        return EcorePackage.Literals.EJAVA_OBJECT;
    }

    @Override
    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    protected FeatureMap.Entry createEntry(EStructuralFeature eStructuralFeature, Object value) {
        return FeatureMapUtil.createEntry(eStructuralFeature, value);
    }

    protected FeatureMap.Entry.Internal createRawEntry(EStructuralFeature eStructuralFeature, Object value) {
        return FeatureMapUtil.createRawEntry(eStructuralFeature, value);
    }

    protected NotificationImpl createNotification(int eventType, EStructuralFeature feature, Object oldObject, Object newObject, int index, boolean wasSet) {
        return new FeatureMapUtil.FeatureENotificationImpl(this.owner, eventType, feature, oldObject, newObject, index, wasSet);
    }

    protected boolean isMany(EStructuralFeature feature) {
        return FeatureMapUtil.isMany(this.owner, feature);
    }

    @Override
    protected boolean hasInverse() {
        return true;
    }

    @Override
    protected boolean hasShadow() {
        return true;
    }

    protected int entryIndex(EStructuralFeature feature, int index) {
        int size;
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        int result = size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            if (index == count) {
                return i;
            }
            ++count;
            result = i + 1;
        }
        if (index == count) {
            return result;
        }
        throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
    }

    protected boolean isResolveProxies(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies();
    }

    @Override
    public Object resolveProxy(EStructuralFeature feature, int entryIndex, int index, Object object) {
        EObject resolved = this.resolveProxy((EObject)object);
        if (resolved != object) {
            FeatureMap.Entry oldObject = (FeatureMap.Entry)this.delegateGet(entryIndex);
            FeatureMap.Entry entry = this.createEntry(feature, resolved);
            this.delegateSet(entryIndex, this.validate(entryIndex, entry));
            this.didSet(entryIndex, entry, oldObject);
            if (this.isNotificationRequired()) {
                NotificationImpl notifications = this.createNotification(9, entry.getEStructuralFeature(), object, resolved, index, false);
                notifications.add(this.createNotification(9, oldObject, entry, index, false));
                notifications.dispatch();
            }
            return resolved;
        }
        return object;
    }

    @Override
    protected EObject resolveProxy(EObject eObject) {
        return this.owner.eResolveProxy((InternalEObject)eObject);
    }

    @Override
    public int getModCount() {
        return this.modCount;
    }

    @Override
    public EStructuralFeature getEStructuralFeature(int index) {
        return ((FeatureMap.Entry)this.get(index)).getEStructuralFeature();
    }

    @Override
    public Object getValue(int index) {
        return ((FeatureMap.Entry)this.get(index)).getValue();
    }

    @Override
    public Object setValue(int index, Object value) {
        return this.set(index, this.createEntry(this.getEStructuralFeature(index), value)).getValue();
    }

    @Override
    public NotificationChain shadowAdd(FeatureMap.Entry object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            EStructuralFeature feature = object.getEStructuralFeature();
            Object value = object.getValue();
            NotificationImpl notificationImpl = notification = feature.isMany() ? this.createNotification(3, feature, null, value, this.indexOf(feature, value), true) : this.createNotification(1, feature, feature.getDefaultValue(), value, -1, true);
            if (notifications != null) {
                notifications.add(notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    @Override
    public NotificationChain inverseAdd(FeatureMap.Entry object, NotificationChain notifications) {
        FeatureMap.Entry.Internal entry = (FeatureMap.Entry.Internal)object;
        return entry.inverseAdd(this.owner, this.getFeatureID(), notifications);
    }

    @Override
    public NotificationChain shadowRemove(FeatureMap.Entry object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            EStructuralFeature feature = object.getEStructuralFeature();
            Object value = object.getValue();
            NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, feature, value, null, this.indexOf(feature, value), true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, feature, value, feature.getDefaultValue(), -1, true));
            if (notifications != null) {
                notifications.add(notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    @Override
    public NotificationChain inverseRemove(FeatureMap.Entry object, NotificationChain notifications) {
        FeatureMap.Entry.Internal entry = (FeatureMap.Entry.Internal)object;
        return entry.inverseRemove(this.owner, this.getFeatureID(), notifications);
    }

    @Override
    public NotificationChain shadowSet(FeatureMap.Entry oldObject, FeatureMap.Entry newObject, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            EStructuralFeature feature = oldObject.getEStructuralFeature();
            Object oldValue = oldObject.getValue();
            Object newValue = newObject.getValue();
            NotificationImpl notification = this.createNotification(1, feature, oldValue, newValue, feature.isMany() ? this.indexOf(feature, newValue) : -1, true);
            if (notifications != null) {
                notifications.add(notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    public NotificationChain inverseTouch(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)object;
            EStructuralFeature feature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            NotificationImpl notification = this.createNotification(1, feature, value, value, feature.isMany() ? this.indexOf(feature, value) : -1, true);
            if (notifications != null) {
                notifications.add(notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    @Override
    public FeatureMap.Entry move(int targetIndex, int sourceIndex) {
        FeatureMap.Entry sourceEntry;
        EStructuralFeature feature;
        if (!this.isNotificationRequired()) {
            return (FeatureMap.Entry)this.doMove(targetIndex, sourceIndex);
        }
        if (targetIndex != sourceIndex && this.isMany(feature = (sourceEntry = (FeatureMap.Entry)this.delegateGet(sourceIndex)).getEStructuralFeature())) {
            int maxIndex;
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            int featureTargetIndex = -1;
            int featureSourceIndex = -1;
            int count = 0;
            int n = maxIndex = targetIndex > sourceIndex ? targetIndex : sourceIndex;
            for (int i = 0; i <= maxIndex; ++i) {
                if (i == sourceIndex) {
                    featureSourceIndex = count++;
                    continue;
                }
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                boolean isValid = validator.isValid(entry.getEStructuralFeature());
                if (i == targetIndex) {
                    int n2 = featureTargetIndex = i == maxIndex && !isValid ? count - 1 : count;
                }
                if (!isValid) continue;
                ++count;
            }
            FeatureMap.Entry result = (FeatureMap.Entry)super.move(targetIndex, sourceIndex);
            if (featureSourceIndex != featureTargetIndex) {
                this.dispatchNotification(new ENotificationImpl(this.owner, 7, feature, (Object)featureSourceIndex, sourceEntry.getValue(), featureTargetIndex));
            }
            return result;
        }
        return (FeatureMap.Entry)super.move(targetIndex, sourceIndex);
    }

    @Override
    public FeatureMap.Entry set(int index, FeatureMap.Entry object) {
        block3: {
            EStructuralFeature entryFeature;
            block2: {
                entryFeature = object.getEStructuralFeature();
                if (!this.isMany(entryFeature)) break block2;
                if (!entryFeature.isUnique()) break block3;
                int size = this.delegateSize();
                for (int i = 0; i < size; ++i) {
                    FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!otherEntry.equals(object) || i == index) continue;
                    throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                }
                break block3;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(otherEntry.getEStructuralFeature()) || i == index) continue;
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
        }
        return this.doSet(index, object);
    }

    public FeatureMap.Entry doSet(int index, FeatureMap.Entry object) {
        return super.set(index, object);
    }

    @Override
    public boolean add(FeatureMap.Entry object) {
        EStructuralFeature entryFeature = object.getEStructuralFeature();
        if (this.isMany(entryFeature)) {
            if (entryFeature.isUnique() && this.contains(entryFeature, object.getValue())) {
                return false;
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(otherEntry.getEStructuralFeature())) continue;
                if (otherEntry.equals(object)) {
                    return false;
                }
                this.doSet(i, object);
                return true;
            }
        }
        return this.doAdd(object);
    }

    protected boolean doAdd(FeatureMap.Entry object) {
        return super.add(object);
    }

    @Override
    public void add(int index, FeatureMap.Entry object) {
        EStructuralFeature entryFeature = object.getEStructuralFeature();
        if (this.isMany(entryFeature)) {
            if (entryFeature.isUnique()) {
                int size = this.delegateSize();
                for (int i = 0; i < size; ++i) {
                    FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!otherEntry.equals(object) || i == index) continue;
                    throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
                }
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(otherEntry.getEStructuralFeature())) continue;
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
        }
        this.doAdd(index, object);
    }

    public void doAdd(int index, FeatureMap.Entry object) {
        super.add(index, object);
    }

    @Override
    public boolean addAll(Collection<? extends FeatureMap.Entry> collection) {
        BasicEList<FeatureMap.Entry> uniqueCollection = new BasicEList<FeatureMap.Entry>(collection.size());
        for (FeatureMap.Entry entry : collection) {
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            if (this.isMany(entryFeature)) {
                if (entryFeature.isUnique() && (this.contains(entryFeature, entry.getValue()) || uniqueCollection.contains(entry))) continue;
                uniqueCollection.add(entry);
                continue;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            boolean include = true;
            int size = this.delegateSize();
            for (int j = 0; j < size; ++j) {
                FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(j);
                if (!validator.isValid(otherEntry.getEStructuralFeature())) continue;
                this.doSet(j, entry);
                include = false;
                break;
            }
            if (!include) continue;
            uniqueCollection.add(entry);
        }
        return this.doAddAll(uniqueCollection);
    }

    public boolean doAddAll(Collection<? extends FeatureMap.Entry> collection) {
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends FeatureMap.Entry> collection) {
        BasicEList<FeatureMap.Entry> uniqueCollection = new BasicEList<FeatureMap.Entry>(collection.size());
        for (FeatureMap.Entry entry : collection) {
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            if (this.isMany(entryFeature)) {
                if (entryFeature.isUnique() && (this.contains(entryFeature, entry.getValue()) || uniqueCollection.contains(entry))) continue;
                uniqueCollection.add(entry);
                continue;
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), entryFeature);
            boolean include = true;
            int size = this.delegateSize();
            for (int j = 0; j < size; ++j) {
                FeatureMap.Entry otherEntry = (FeatureMap.Entry)this.delegateGet(j);
                if (!validator.isValid(otherEntry.getEStructuralFeature())) continue;
                this.doSet(j, entry);
                include = false;
                break;
            }
            if (!include) continue;
            uniqueCollection.add(entry);
        }
        return this.doAddAll(index, uniqueCollection);
    }

    public boolean doAddAll(int index, Collection<? extends FeatureMap.Entry> collection) {
        return super.addAll(index, collection);
    }

    @Override
    public int size(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int result = 0;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean isEmpty(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(EStructuralFeature feature, Object object) {
        return this.contains(feature, object, this.isResolveProxies(feature));
    }

    @Override
    public boolean basicContains(EStructuralFeature feature, Object object) {
        return this.contains(feature, object, false);
    }

    protected boolean contains(EStructuralFeature feature, Object object, boolean resolve) {
        block5: {
            FeatureMapUtil.Validator validator;
            block6: {
                FeatureMap.Entry entry;
                int i;
                block4: {
                    validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                    if (!FeatureMapUtil.isFeatureMap(feature)) break block4;
                    int size = this.delegateSize();
                    for (int i2 = 0; i2 < size; ++i2) {
                        FeatureMap.Entry entry2 = (FeatureMap.Entry)this.delegateGet(i2);
                        if (!validator.isValid(entry2.getEStructuralFeature()) || !entry2.equals(object)) continue;
                        return true;
                    }
                    break block5;
                }
                if (object == null) break block6;
                int size = this.delegateSize();
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature()) || !object.equals(entry.getValue())) continue;
                    return true;
                }
                if (!resolve) break block5;
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature()) || object != this.resolveProxy((EObject)entry.getValue())) continue;
                    return true;
                }
                break block5;
            }
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature()) || entry.getValue() != null) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(EStructuralFeature feature, Collection<?> collection) {
        for (Object object : collection) {
            if (this.contains(feature, object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean basicContainsAll(EStructuralFeature feature, Collection<?> collection) {
        for (Object object : collection) {
            if (this.basicContains(feature, object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(EStructuralFeature feature, Object object) {
        return this.indexOf(feature, object, this.isResolveProxies(feature));
    }

    @Override
    public int basicIndexOf(EStructuralFeature feature, Object object) {
        return this.indexOf(feature, object, false);
    }

    protected int indexOf(EStructuralFeature feature, Object object, boolean resolve) {
        block9: {
            int result;
            FeatureMapUtil.Validator validator;
            block10: {
                FeatureMap.Entry entry;
                int i;
                block8: {
                    validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                    result = 0;
                    if (!FeatureMapUtil.isFeatureMap(feature)) break block8;
                    int size = this.delegateSize();
                    for (int i2 = 0; i2 < size; ++i2) {
                        FeatureMap.Entry entry2 = (FeatureMap.Entry)this.delegateGet(i2);
                        if (!validator.isValid(entry2.getEStructuralFeature())) continue;
                        if (entry2.equals(object)) {
                            return result;
                        }
                        ++result;
                    }
                    break block9;
                }
                if (object == null) break block10;
                int size = this.delegateSize();
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature())) continue;
                    if (object.equals(entry.getValue())) {
                        return result;
                    }
                    ++result;
                }
                if (!resolve) break block9;
                result = 0;
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature())) continue;
                    if (object == this.resolveProxy((EObject)entry.getValue())) {
                        return result;
                    }
                    ++result;
                }
                break block9;
            }
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (entry.getValue() == null) {
                    return result;
                }
                ++result;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(EStructuralFeature feature, Object object) {
        return this.lastIndexOf(feature, object, this.isResolveProxies(feature));
    }

    @Override
    public int basicLastIndexOf(EStructuralFeature feature, Object object) {
        return this.lastIndexOf(feature, object, false);
    }

    protected int lastIndexOf(EStructuralFeature feature, Object object, boolean resolve) {
        int result;
        block9: {
            int count;
            FeatureMapUtil.Validator validator;
            block10: {
                FeatureMap.Entry entry;
                int i;
                block8: {
                    validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                    result = -1;
                    count = 0;
                    if (!FeatureMapUtil.isFeatureMap(feature)) break block8;
                    int size = this.delegateSize();
                    for (int i2 = 0; i2 < size; ++i2) {
                        FeatureMap.Entry entry2 = (FeatureMap.Entry)this.delegateGet(i2);
                        if (!validator.isValid(entry2.getEStructuralFeature())) continue;
                        if (entry2.equals(object)) {
                            result = count;
                        }
                        ++count;
                    }
                    break block9;
                }
                if (object == null) break block10;
                int size = this.delegateSize();
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature())) continue;
                    if (object.equals(entry.getValue())) {
                        result = count;
                    }
                    ++count;
                }
                if (!resolve) break block9;
                result = -1;
                count = 0;
                for (i = 0; i < size; ++i) {
                    entry = (FeatureMap.Entry)this.delegateGet(i);
                    if (!validator.isValid(entry.getEStructuralFeature())) continue;
                    if (object == this.resolveProxy((EObject)entry.getValue())) {
                        result = count;
                    }
                    ++count;
                }
                break block9;
            }
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (entry.getValue() == null) {
                    result = count;
                }
                ++count;
            }
        }
        return result;
    }

    @Override
    public Iterator<Object> iterator(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator(feature, this) : new ResolvingFeatureEIterator(feature, this);
    }

    @Override
    public ListIterator<Object> listIterator(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator(feature, this) : new ResolvingFeatureEIterator(feature, this);
    }

    @Override
    public ListIterator<Object> listIterator(EStructuralFeature feature, int index) {
        ResolvingFeatureEIterator<Object> result = feature instanceof EReference && ((EReference)feature).isResolveProxies() ? new ResolvingFeatureEIterator<Object>(feature, this) : new ResolvingFeatureEIterator<Object>(feature, this);
        for (int i = 0; i < index; ++i) {
            result.next();
        }
        return result;
    }

    @Override
    public FeatureMap.ValueListIterator<Object> valueListIterator() {
        return new ValueListIteratorImpl<Object>();
    }

    @Override
    public FeatureMap.ValueListIterator<Object> valueListIterator(int index) {
        return new ValueListIteratorImpl<Object>(index);
    }

    @Override
    public <T> EList<T> list(EStructuralFeature feature) {
        return FeatureMapUtil.isFeatureMap(feature) ? new FeatureMapUtil.FeatureFeatureMap(feature, this) : new FeatureMapUtil.FeatureEList(feature, this);
    }

    @Override
    public EStructuralFeature.Setting setting(EStructuralFeature feature) {
        return this.isMany(feature) ? (EStructuralFeature.Setting)((Object)this.list(feature)) : new FeatureMapUtil.FeatureValue(feature, this);
    }

    @Override
    public List<Object> basicList(EStructuralFeature feature) {
        return new FeatureMapUtil.FeatureEList.Basic<Object>(feature, this);
    }

    @Override
    public Iterator<Object> basicIterator(EStructuralFeature feature) {
        return new FeatureEIterator<Object>(feature, this);
    }

    @Override
    public ListIterator<Object> basicListIterator(EStructuralFeature feature) {
        return new FeatureEIterator<Object>(feature, this);
    }

    @Override
    public ListIterator<Object> basicListIterator(EStructuralFeature feature, int index) {
        FeatureEIterator<Object> result = new FeatureEIterator<Object>(feature, this);
        for (int i = 0; i < index; ++i) {
            result.next();
        }
        return result;
    }

    @Override
    public Object[] toArray(EStructuralFeature feature) {
        return this.toArray(feature, this.isResolveProxies(feature));
    }

    @Override
    public Object[] basicToArray(EStructuralFeature feature) {
        return this.toArray(feature, false);
    }

    protected Object[] toArray(EStructuralFeature feature, boolean resolve) {
        BasicEList<Object> result = new BasicEList<Object>();
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                result.add(entry);
            }
        } else {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                Object value = entry.getValue();
                result.add(resolve ? this.resolveProxy(feature, i, result.size(), value) : value);
            }
        }
        return result.toArray();
    }

    @Override
    public <T> T[] toArray(EStructuralFeature feature, T[] array) {
        return this.toArray(feature, array, this.isResolveProxies(feature));
    }

    @Override
    public <T> T[] basicToArray(EStructuralFeature feature, T[] array) {
        return this.toArray(feature, array, false);
    }

    protected <T> T[] toArray(EStructuralFeature feature, T[] array, boolean resolve) {
        BasicEList<Object> result = new BasicEList<Object>();
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                result.add(entry);
            }
        } else {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                Object value = entry.getValue();
                result.add(resolve ? this.resolveProxy(feature, i, result.size(), value) : value);
            }
        }
        return result.toArray(array);
    }

    @Override
    public void set(EStructuralFeature feature, Object object) {
        if (this.isMany(feature)) {
            EList list = this.list(feature);
            list.clear();
            list.addAll((Collection)object);
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (this.shouldUnset(feature, object)) {
                    this.remove(i);
                } else {
                    this.doSet(i, FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                }
                return;
            }
            if (!this.shouldUnset(feature, object)) {
                this.doAdd(FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
            }
        }
    }

    protected boolean shouldUnset(EStructuralFeature feature, Object value) {
        if (feature.getUpperBound() != -2 && !feature.isUnsettable()) {
            Object defaultValue = feature.getDefaultValue();
            return defaultValue == null ? value == null : defaultValue.equals(value);
        }
        return false;
    }

    @Override
    public void add(int index, EStructuralFeature feature, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature()) || !(isFeatureMap ? entry.equals(object) : (object == null ? entry.getValue() == null : object.equals(entry.getValue())))) continue;
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
        }
        this.doAdd(index, isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    @Override
    public boolean add(EStructuralFeature feature, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                return false;
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (isFeatureMap ? entry.equals(object) : (object == null ? entry.getValue() == null : object.equals(entry.getValue()))) {
                    return false;
                }
                this.doSet(i, isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                return true;
            }
        }
        return this.doAdd(isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    @Override
    public void add(EStructuralFeature feature, int index, Object object) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        if (this.isMany(feature)) {
            if (feature.isUnique() && this.contains(feature, object)) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
        } else {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
        }
        this.doAdd(this.entryIndex(feature, index), isFeatureMap ? (FeatureMap.Entry)object : this.createEntry(feature, object));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, EStructuralFeature feature, Collection<?> collection) {
        BasicEList<FeatureMap.Entry> entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        BasicEList<FeatureMap.Entry> basicEList = entryCollection = isFeatureMap ? collection : new BasicEList<FeatureMap.Entry>(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                for (Object e : collection) {
                    FeatureMap.Entry entry;
                    if (this.contains(feature, e) || entryCollection.contains(entry = this.createEntry(feature, e))) continue;
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                for (Object e : collection) {
                    FeatureMap.Entry entry = this.createEntry(feature, e);
                    entryCollection.add(entry);
                }
            }
        } else {
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            if (isFeatureMap) {
                if (this.contains(feature, collection.iterator().next())) {
                    return false;
                }
            } else {
                void var7_12;
                FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
                boolean bl = false;
                int size = this.delegateSize();
                while (var7_12 < size) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet((int)var7_12);
                    if (validator.isValid(entry.getEStructuralFeature())) {
                        if (collection.contains(entry.getValue())) {
                            return false;
                        }
                        throw new IllegalArgumentException("The multiplicity constraint is violated");
                    }
                    ++var7_12;
                }
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(index, entryCollection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(EStructuralFeature feature, Collection<?> collection) {
        BasicEList<FeatureMap.Entry> entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        BasicEList<FeatureMap.Entry> basicEList = entryCollection = isFeatureMap ? collection : new BasicEList<FeatureMap.Entry>(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                for (Object e : collection) {
                    FeatureMap.Entry entry;
                    if (this.contains(feature, e) || entryCollection.contains(entry = this.createEntry(feature, e))) continue;
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                for (Object e : collection) {
                    FeatureMap.Entry entry = this.createEntry(feature, e);
                    entryCollection.add(entry);
                }
            }
        } else {
            void var6_11;
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            boolean bl = false;
            int size = this.delegateSize();
            while (var6_11 < size) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet((int)var6_11);
                if (validator.isValid(entry.getEStructuralFeature())) {
                    if (collection.contains(isFeatureMap ? entry : entry.getValue())) {
                        return false;
                    }
                    for (Object e : collection) {
                        this.doSet((int)var6_11, isFeatureMap ? (FeatureMap.Entry)e : this.createEntry(feature, e));
                    }
                    return true;
                }
                ++var6_11;
            }
            if (!isFeatureMap) {
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(entryCollection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(EStructuralFeature feature, int index, Collection<?> collection) {
        BasicEList<FeatureMap.Entry> entryCollection;
        if (collection.size() == 0) {
            return false;
        }
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        BasicEList<FeatureMap.Entry> basicEList = entryCollection = isFeatureMap ? collection : new BasicEList<FeatureMap.Entry>(collection.size());
        if (this.isMany(feature)) {
            if (feature.isUnique()) {
                for (Object e : collection) {
                    if (this.contains(feature, e)) continue;
                    FeatureMap.Entry entry = this.createEntry(feature, e);
                    entryCollection.add(entry);
                }
            } else if (!isFeatureMap) {
                for (Object e : collection) {
                    FeatureMap.Entry entry = this.createEntry(feature, e);
                    entryCollection.add(entry);
                }
            }
        } else {
            void var7_12;
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            boolean bl = false;
            int size = this.delegateSize();
            while (var7_12 < size) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet((int)var7_12);
                if (validator.isValid(entry.getEStructuralFeature())) {
                    throw new IllegalArgumentException("The multiplicity constraint is violated");
                }
                ++var7_12;
            }
            if (collection.size() > 1) {
                throw new IllegalArgumentException("The multiplicity constraint is violated");
            }
            if (!isFeatureMap) {
                FeatureMap.Entry entry = this.createEntry(feature, collection.iterator().next());
                entryCollection.add(entry);
            }
        }
        return this.doAddAll(this.entryIndex(feature, index), entryCollection);
    }

    @Override
    public void addUnique(EStructuralFeature feature, Object object) {
        this.modCount = -1;
        this.addUnique(this.createRawEntry(feature, object));
    }

    @Override
    public void addUnique(EStructuralFeature feature, int index, Object object) {
        this.modCount = -1;
        this.addUnique(this.entryIndex(feature, index), this.createRawEntry(feature, object));
    }

    @Override
    public void addUnique(FeatureMap.Entry object) {
        ++this.modCount;
        this.validate(this.delegateSize(), object);
        super.addUnique(object);
    }

    @Override
    public void addUnique(FeatureMap.Entry.Internal entry) {
        this.modCount = -1;
        super.addUnique(entry);
    }

    @Override
    public boolean addAllUnique(Collection<? extends FeatureMap.Entry> collection) {
        this.modCount = -1;
        return super.addAllUnique(collection);
    }

    @Override
    public boolean addAllUnique(FeatureMap.Entry.Internal[] entries, int start, int end) {
        this.modCount = -1;
        return super.addAllUnique(this.size(), entries, start, end);
    }

    @Override
    public boolean addAllUnique(int index, FeatureMap.Entry.Internal[] entries, int start, int end) {
        this.modCount = -1;
        return super.addAllUnique(index, entries, start, end);
    }

    @Override
    public NotificationChain basicAdd(EStructuralFeature feature, Object object, NotificationChain notifications) {
        if (object == null) {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (entry.getEStructuralFeature() != feature) continue;
                return super.basicRemove(entry, notifications);
            }
        }
        FeatureMap.Entry entry = FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object);
        notifications = this.basicAdd(entry, notifications);
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            boolean oldIsSet = !this.isEmpty(feature);
            NotificationImpl notificationImpl = notification = feature.isMany() ? this.createNotification(3, feature, null, object, this.indexOf(feature, object), oldIsSet) : this.createNotification(1, feature, feature.getDefaultValue(), object, -1, oldIsSet);
            if (notifications != null) {
                notifications.add(notification);
            } else {
                notifications = notification;
            }
        }
        return notifications;
    }

    @Override
    public boolean remove(EStructuralFeature feature, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (FeatureMapUtil.isFeatureMap(feature)) {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature()) || !entry.equals(object)) continue;
                this.remove(i);
                return true;
            }
        } else if (object != null) {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature()) || !object.equals(entry.getValue())) continue;
                this.remove(i);
                return true;
            }
        } else {
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature()) || entry.getValue() != null) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public Object remove(EStructuralFeature feature, int index) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            if (count == index) {
                this.remove(i);
                return FeatureMapUtil.isFeatureMap(feature) ? entry : entry.getValue();
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
    }

    @Override
    public boolean removeAll(EStructuralFeature feature, Collection<?> collection) {
        if (FeatureMapUtil.isFeatureMap(feature)) {
            return this.removeAll(collection);
        }
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList<FeatureMap.Entry> entryCollection = new BasicEList<FeatureMap.Entry>(collection.size());
        int i = this.delegateSize();
        while (--i >= 0) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature()) || !collection.contains(entry.getValue())) continue;
            entryCollection.add(entry);
        }
        return this.removeAll(entryCollection);
    }

    @Override
    public NotificationChain basicRemove(EStructuralFeature feature, Object object, NotificationChain notifications) {
        FeatureMap.Entry entry;
        int i;
        int size;
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        FeatureMap.Entry match = null;
        if (FeatureMapUtil.isFeatureMap(feature)) {
            size = this.delegateSize();
            for (i = 0; i < size; ++i) {
                entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (entry.equals(object)) {
                    match = entry;
                    break;
                }
                ++count;
            }
        }
        if (object != null) {
            size = this.delegateSize();
            for (i = 0; i < size; ++i) {
                entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (object.equals(entry.getValue())) {
                    match = entry;
                    break;
                }
                ++count;
            }
        } else {
            size = this.delegateSize();
            for (i = 0; i < size; ++i) {
                entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (entry.getValue() == null) {
                    match = entry;
                    break;
                }
                ++count;
            }
        }
        if (match != null) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, feature, object, null, count, true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, feature, object, feature.getDefaultValue(), -1, true));
                if (notifications != null) {
                    notifications.add(notification);
                } else {
                    notifications = notification;
                }
            }
            notifications = this.basicRemove(match, notifications);
        }
        return notifications;
    }

    @Override
    public boolean retainAll(EStructuralFeature feature, Collection<?> collection) {
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap(feature);
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList<FeatureMap.Entry> entryCollection = new BasicEList<FeatureMap.Entry>(collection.size());
        int i = this.delegateSize();
        while (--i >= 0) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature()) || collection.contains(isFeatureMap ? entry : entry.getValue())) continue;
            entryCollection.add(entry);
        }
        return this.removeAll(entryCollection);
    }

    @Override
    public void clear(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList<FeatureMap.Entry> entryCollection = new BasicEList<FeatureMap.Entry>();
        int i = this.delegateSize();
        while (--i >= 0) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            entryCollection.add(entry);
        }
        if (!this.removeAll(entryCollection)) {
            this.dispatchNotification(feature.isMany() ? this.createNotification(6, feature, Collections.EMPTY_LIST, null, -1, false) : this.createNotification(feature.isUnsettable() ? 2 : 1, feature, null, null, -1, false));
        }
    }

    @Override
    public void move(EStructuralFeature feature, int index, Object object) {
        this.move(feature, index, this.indexOf(feature, object));
    }

    @Override
    public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        if (this.isMany(feature)) {
            FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
            Object result = null;
            int entryTargetIndex = -1;
            int entrySourceIndex = -1;
            int count = 0;
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (count == targetIndex) {
                    entryTargetIndex = i;
                }
                if (count == sourceIndex) {
                    entrySourceIndex = i;
                    result = entry.getValue();
                }
                ++count;
            }
            if (entryTargetIndex == -1) {
                throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + count);
            }
            if (entrySourceIndex == -1) {
                throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + count);
            }
            super.move(entryTargetIndex, entrySourceIndex);
            if (this.isNotificationRequired()) {
                this.dispatchNotification(this.createNotification(7, feature, sourceIndex, result, targetIndex, true));
            }
            return result;
        }
        throw new IllegalArgumentException("The feature must be many-valued to support move");
    }

    @Override
    public Object get(EStructuralFeature feature, boolean resolve) {
        if (this.isMany(feature)) {
            return this.list(feature);
        }
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        int count = 0;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    return entry;
                }
                Object value = entry.getValue();
                if (value != null && resolve && this.isResolveProxies(feature)) {
                    value = this.resolveProxy(feature, i, count, value);
                }
                return value;
            }
            ++count;
        }
        return feature.getDefaultValue();
    }

    @Override
    public Object get(EStructuralFeature feature, int index, boolean resolve) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (this.isMany(feature)) {
            int count = 0;
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (count == index) {
                    if (FeatureMapUtil.isFeatureMap(feature)) {
                        return entry;
                    }
                    Object value = entry.getValue();
                    if (value != null && resolve && this.isResolveProxies(feature)) {
                        value = this.resolveProxy(feature, i, count, entry.getValue());
                    }
                    return value;
                }
                ++count;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int count = 0;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (validator.isValid(entry.getEStructuralFeature())) {
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    return entry;
                }
                Object value = entry.getValue();
                if (value != null && resolve && this.isResolveProxies(feature)) {
                    value = this.resolveProxy(feature, i, count, value);
                }
                return value;
            }
            ++count;
        }
        return feature.getDefaultValue();
    }

    @Override
    public Object set(EStructuralFeature feature, int index, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (this.isMany(feature)) {
            int currentIndex;
            if (feature.isUnique() && (currentIndex = this.indexOf(feature, object)) >= 0 && currentIndex != index) {
                throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
            }
            int count = 0;
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (count == index) {
                    return this.doSet(i, FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                }
                ++count;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            return FeatureMapUtil.isFeatureMap(feature) ? entry : entry.getValue();
        }
        return null;
    }

    @Override
    public Object setUnique(EStructuralFeature feature, int index, Object object) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        if (this.isMany(feature)) {
            int count = 0;
            int size = this.delegateSize();
            for (int i = 0; i < size; ++i) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
                if (!validator.isValid(entry.getEStructuralFeature())) continue;
                if (count == index) {
                    return this.setUnique(i, FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
                }
                ++count;
            }
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + count);
        }
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            return this.setUnique(i, FeatureMapUtil.isFeatureMap(feature) ? (FeatureMap.Entry)object : this.createEntry(feature, object));
        }
        return feature.getDefaultValue();
    }

    @Override
    public boolean isSet(EStructuralFeature feature) {
        return !this.isEmpty(feature);
    }

    @Override
    public void unset(EStructuralFeature feature) {
        FeatureMapUtil.Validator validator = FeatureMapUtil.getValidator(this.owner.eClass(), feature);
        BasicEList<FeatureMap.Entry> removals = null;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!validator.isValid(entry.getEStructuralFeature())) continue;
            if (removals == null) {
                removals = new BasicEList<FeatureMap.Entry>();
            }
            removals.add(entry);
        }
        if (removals != null) {
            this.removeAll(removals);
        }
    }

    @Override
    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        if (object instanceof FeatureMap.Entry) {
            return super.basicRemove(object, notifications);
        }
        FeatureMap.Entry match = null;
        ETypedElement feature = null;
        int size = this.delegateSize();
        for (int i = 0; i < size; ++i) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.delegateGet(i);
            if (!object.equals(entry.getValue()) || !((feature = entry.getEStructuralFeature()) instanceof EReference) || !((EReference)feature).isContainment()) continue;
            match = entry;
            break;
        }
        if (match != null) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                NotificationImpl notificationImpl = feature.isMany() ? this.createNotification(4, (EStructuralFeature)feature, object, null, this.indexOf((EStructuralFeature)feature, object), true) : (notification = this.createNotification(feature.isUnsettable() ? 2 : 1, (EStructuralFeature)feature, object, feature.getDefaultValue(), -1, true));
                if (notifications != null) {
                    notifications.add(notification);
                } else {
                    notifications = notification;
                }
            }
            notifications = this.basicRemove(match, notifications);
        }
        return notifications;
    }

    @Override
    public void set(Object newValue) {
        super.set(newValue instanceof FeatureMap ? newValue : ((FeatureMap.Internal.Wrapper)newValue).featureMap());
    }

    public static class ResolvingFeatureEIterator<E>
    extends FeatureEIterator<E> {
        public ResolvingFeatureEIterator(EStructuralFeature eStructuralFeature, FeatureMap.Internal featureMap) {
            super(eStructuralFeature, featureMap);
        }

        @Override
        protected boolean resolve() {
            return true;
        }
    }

    public static class FeatureEIterator<E>
    extends FeatureMapUtil.BasicFeatureEIterator<E> {
        public FeatureEIterator(EStructuralFeature eStructuralFeature, FeatureMap.Internal featureMap) {
            super(eStructuralFeature, featureMap);
        }

        @Override
        protected boolean scanNext() {
            int size = this.featureMap.size();
            while (this.entryCursor < size) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.featureMap.get(this.entryCursor);
                if (this.validator.isValid(entry.getEStructuralFeature())) {
                    this.preparedResult = this.extractValue(entry);
                    this.prepared = 2;
                    return true;
                }
                ++this.entryCursor;
            }
            this.prepared = 1;
            this.lastCursor = -1;
            return false;
        }

        @Override
        protected boolean scanPrevious() {
            while (--this.entryCursor >= 0) {
                FeatureMap.Entry entry = (FeatureMap.Entry)this.featureMap.get(this.entryCursor);
                if (!this.validator.isValid(entry.getEStructuralFeature())) continue;
                this.preparedResult = this.extractValue(entry);
                this.prepared = -2;
                return true;
            }
            this.prepared = -1;
            this.lastCursor = -1;
            return false;
        }
    }

    protected class ValueListIteratorImpl<E>
    extends DelegatingEList.EListIterator<E>
    implements FeatureMap.ValueListIterator<E> {
        public ValueListIteratorImpl() {
            super(DelegatingFeatureMap.this);
        }

        public ValueListIteratorImpl(int index) {
            super(DelegatingFeatureMap.this, index);
        }

        @Override
        public EStructuralFeature feature() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            return DelegatingFeatureMap.this.getEStructuralFeature(this.lastCursor);
        }

        @Override
        public E next() {
            return (E)((FeatureMap.Entry)this.doNext()).getValue();
        }

        @Override
        public E previous() {
            return (E)((FeatureMap.Entry)this.doPrevious()).getValue();
        }

        @Override
        public void add(E value) {
            this.doAdd(FeatureMapUtil.createEntry(this.feature(), value));
        }

        @Override
        public void add(EStructuralFeature eStructuralFeature, Object value) {
            this.doAdd(FeatureMapUtil.createEntry(eStructuralFeature, value));
        }
    }

    public static class FeatureMapEObjectImpl
    extends EObjectImpl {
        protected DelegatingFeatureMap featureMap = new DelegatingFeatureMap(this, -1){
            private static final long serialVersionUID = 1L;
            protected List<FeatureMap.Entry> theList;
            {
                super(owner, featureID);
                this.theList = new ArrayList<FeatureMap.Entry>();
            }

            @Override
            protected List<FeatureMap.Entry> delegateList() {
                return this.theList;
            }
        };

        @Override
        public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                return this.eSettingDelegate(eFeature).dynamicGet(this, null, -1, true, true);
            }
            return this.featureMap.setting(eFeature).get(resolve);
        }

        @Override
        public void eDynamicSet(EStructuralFeature eFeature, Object newValue) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                this.eSettingDelegate(eFeature).dynamicSet(this, null, -1, newValue);
            } else {
                Object defaultValue;
                if (!eFeature.isUnsettable() && ((defaultValue = eFeature.getDefaultValue()) == null ? newValue == null : defaultValue.equals(newValue))) {
                    this.featureMap.setting(eFeature).unset();
                    return;
                }
                this.featureMap.setting(eFeature).set(newValue);
            }
        }

        @Override
        public void eDynamicUnset(EStructuralFeature eFeature) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                this.eSettingDelegate(eFeature).dynamicUnset(this, null, -1);
            } else {
                this.featureMap.setting(eFeature).unset();
            }
        }

        @Override
        public boolean eDynamicIsSet(EStructuralFeature eFeature) {
            if (eFeature instanceof EReference && ((EReference)eFeature).isContainer()) {
                return this.eSettingDelegate(eFeature).dynamicIsSet(this, null, -1);
            }
            return this.featureMap.setting(eFeature).isSet();
        }

        @Override
        public NotificationChain eDynamicInverseAdd(InternalEObject otherEnd, int featureID, Class<?> inverseClass, NotificationChain notifications) {
            EStructuralFeature.Internal feature = (EStructuralFeature.Internal)this.eClass().getEStructuralFeature(featureID);
            if (feature.isMany()) {
                return this.featureMap.basicAdd(feature, otherEnd, notifications);
            }
            if (feature instanceof EReference && ((EReference)((Object)feature)).isContainer()) {
                return this.eSettingDelegate(feature).dynamicInverseAdd(this, null, -1, otherEnd, notifications);
            }
            InternalEObject oldValue = (InternalEObject)this.eDynamicGet(feature, false);
            if (oldValue != null) {
                notifications = oldValue.eInverseRemove(this, oldValue.eClass().getFeatureID(((EReference)((Object)feature)).getEOpposite()), null, notifications);
                notifications = this.featureMap.basicRemove(feature, oldValue, notifications);
            }
            return this.featureMap.basicAdd(feature, otherEnd, notifications);
        }

        @Override
        public NotificationChain eDynamicInverseRemove(InternalEObject otherEnd, int featureID, Class<?> inverseClass, NotificationChain notifications) {
            EStructuralFeature.Internal feature = (EStructuralFeature.Internal)this.eClass().getEStructuralFeature(featureID);
            if (feature instanceof EReference && ((EReference)((Object)feature)).isContainer()) {
                return this.eSettingDelegate(feature).dynamicInverseRemove(this, null, -1, otherEnd, notifications);
            }
            return this.featureMap.basicRemove(feature, otherEnd, notifications);
        }

        public FeatureMap featureMap() {
            return this.featureMap;
        }

        @Override
        public void eNotify(Notification notification) {
            if (notification.getFeatureID(null) != -1) {
                super.eNotify(notification);
            }
        }

        @Override
        public String toString() {
            Object result = super.toString();
            result = "ro.sync.emf.ecore.impl.EObjectImpl" + ((String)result).substring(((String)result).indexOf("@"));
            return result;
        }
    }
}

