/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.emf.common.notify.impl;

import java.util.Collection;
import ro.sync.emf.common.notify.Adapter;
import ro.sync.emf.common.notify.Notification;
import ro.sync.emf.common.notify.Notifier;
import ro.sync.emf.common.notify.impl.NotificationImpl;
import ro.sync.emf.common.util.BasicEList;
import ro.sync.emf.common.util.ECollections;
import ro.sync.emf.common.util.EList;

public class BasicNotifierImpl
implements Notifier {
    @Override
    public EList<Adapter> eAdapters() {
        return ECollections.emptyEList();
    }

    protected BasicEList<Adapter> eBasicAdapters() {
        return null;
    }

    @Override
    public boolean eDeliver() {
        return false;
    }

    @Override
    public void eSetDeliver(boolean deliver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eNotify(Notification notification) {
        int size;
        BasicEList<Adapter> eAdapters = this.eBasicAdapters();
        if (eAdapters != null && this.eDeliver() && (size = eAdapters.size()) > 0) {
            Adapter[] adapters = (Adapter[])eAdapters.data();
            for (int i = 0; i < size; ++i) {
                adapters[i].notifyChanged(notification);
            }
        }
    }

    public boolean eNotificationRequired() {
        BasicEList<Adapter> eAdapters = this.eBasicAdapters();
        return eAdapters != null && this.eDeliver() && !eAdapters.isEmpty();
    }

    public static class EAdapterList<E>
    extends BasicEList<E> {
        private static final long serialVersionUID = 1L;
        protected Notifier notifier;
        protected boolean safe;

        public EAdapterList(Notifier notifier) {
            this.notifier = notifier;
        }

        @Override
        protected boolean canContainNull() {
            return false;
        }

        @Override
        protected boolean useEquals() {
            return false;
        }

        @Override
        protected Object[] newData(int capacity) {
            return new Adapter[capacity];
        }

        @Override
        protected void didAdd(int index, E newObject) {
            ((Adapter)newObject).setTarget(this.notifier);
        }

        @Override
        protected void didRemove(int index, E oldObject) {
            E adapter = oldObject;
            if (this.notifier.eDeliver()) {
                NotificationImpl notification = new NotificationImpl(8, oldObject, null, index){

                    @Override
                    public Object getNotifier() {
                        return notifier;
                    }
                };
                ((Adapter)adapter).notifyChanged(notification);
            }
            if (adapter instanceof Adapter.Internal) {
                ((Adapter.Internal)adapter).unsetTarget(this.notifier);
            } else if (((Adapter)adapter).getTarget() == this.notifier) {
                ((Adapter)adapter).setTarget(null);
            }
        }

        @Override
        public Object[] data() {
            this.safe = true;
            return this.data;
        }

        protected void ensureSafety() {
            if (this.safe && this.data != null) {
                Object[] oldData = this.data;
                this.data = this.newData(this.data.length);
                System.arraycopy(oldData, 0, this.data, 0, this.size);
                this.safe = false;
            }
        }

        @Override
        public boolean add(E object) {
            this.ensureSafety();
            return super.add(object);
        }

        @Override
        public void add(int index, E object) {
            this.ensureSafety();
            super.add(index, object);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            this.ensureSafety();
            return super.addAll(collection);
        }

        @Override
        public boolean remove(Object object) {
            this.ensureSafety();
            return super.remove(object);
        }

        @Override
        public E remove(int index) {
            this.ensureSafety();
            return super.remove(index);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            this.ensureSafety();
            return super.removeAll(collection);
        }

        @Override
        public void clear() {
            this.ensureSafety();
            super.clear();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            this.ensureSafety();
            return super.retainAll(collection);
        }

        @Override
        public E set(int index, E object) {
            this.ensureSafety();
            return super.set(index, object);
        }

        @Override
        public void move(int newPosition, E object) {
            this.ensureSafety();
            super.move(newPosition, object);
        }

        @Override
        public E move(int newPosition, int oldPosition) {
            this.ensureSafety();
            return super.move(newPosition, oldPosition);
        }
    }
}

