/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.encoding;

import java.util.Hashtable;
import org.apache.xerces.util.EncodingMap;

class AdditionalEncodingMap
extends EncodingMap {
    static final Hashtable fIANA2JavaMap = new Hashtable();
    static final Hashtable fJava2IANAMap = new Hashtable();

    AdditionalEncodingMap() {
    }

    public static Hashtable getFJava2IANAMap() {
        return fJava2IANAMap;
    }

    public static String getIANA2JavaMapping(String ianaEncoding) {
        return (String)fIANA2JavaMap.get(ianaEncoding);
    }

    public static String getJava2IANAMapping(String javaEncoding) {
        return (String)fJava2IANAMap.get(javaEncoding);
    }

    static {
        fIANA2JavaMap.putAll(EncodingMap.fIANA2JavaMap);
        fJava2IANAMap.putAll(EncodingMap.fJava2IANAMap);
        fIANA2JavaMap.put("UTF-16BE", "UnicodeBigUnmarked");
        fIANA2JavaMap.put("UTF-16LE", "UnicodeLittleUnmarked");
        fIANA2JavaMap.put("ISO-10646-UCS-4", "UTF-32");
        fIANA2JavaMap.put("ISO-10646-UCS-4 LE", "UTF-32LE");
        fJava2IANAMap.put("UnicodeLittle", "UTF-16");
        fJava2IANAMap.put("UnicodeBig", "UTF-16");
        fJava2IANAMap.put("UnicodeLittleUnmarked", "UTF-16LE");
        fJava2IANAMap.put("UnicodeBigUnmarked", "UTF-16BE");
    }
}

