/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.util.Arrays;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ro.sync.basic.xml.BasicXmlUtil;

public class AttrOrderDomParser
extends DOMParser {
    public static final String NOT_NORMALIZED_VALUES = "nnv";
    private static Logger logger = LoggerFactory.getLogger((String)AttrOrderDomParser.class.getName());
    private boolean sortAttributes;
    private boolean preserveNotNormalizedAttributeValues;

    public AttrOrderDomParser(boolean sortAttributes, boolean preserveNotNormalizedAttributeValues) {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.sortAttributes = sortAttributes;
            this.preserveNotNormalizedAttributeValues = preserveNotNormalizedAttributeValues;
        }
        catch (SAXException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
        super.startElement(elementQName, attrList, augs);
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
        int len = attrList.getLength();
        if (len != 0) {
            String qName;
            int i;
            if (!this.sortAttributes) {
                String[] order = new String[len];
                for (i = 0; i < len; ++i) {
                    order[i] = qName = attrList.getQName(i);
                }
                if (node != null) {
                    BasicXmlUtil.setAttributesOrderData(node, order);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Order for " + node.getNodeName() + " is : " + Arrays.asList(order));
                    }
                }
            }
            if (this.preserveNotNormalizedAttributeValues) {
                String[][] nv = new String[len][2];
                for (i = 0; i < len; ++i) {
                    nv[i][0] = qName = attrList.getQName(i);
                    nv[i][1] = ((XMLAttributesImpl)attrList).getNonNormalizedValue(i);
                }
                BasicXmlUtil.setUserdata(node, NOT_NORMALIZED_VALUES, nv, null);
            }
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion && !this.fFilterReject && this.fCurrentCDATASection == null) {
            this.fInCDATASection = false;
            CDATASection cdataNode = this.fDocument.createCDATASection("");
            this.fCurrentNode.appendChild(cdataNode);
        } else {
            super.endCDATA(augs);
        }
    }
}

