/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.classloader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class LateDelegationClassLoader
extends URLClassLoader {
    private Set addedExtensionURLs = new HashSet(1);
    private boolean shouldDelegateLoggingToParent = true;

    public LateDelegationClassLoader(URL[] urls) {
        this(urls, true);
    }

    public LateDelegationClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public LateDelegationClassLoader(URL[] urls, boolean shouldDelegateLoggingToParent) {
        super(urls);
        this.shouldDelegateLoggingToParent = shouldDelegateLoggingToParent;
    }

    @Override
    public URL getResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                URL url = LateDelegationClassLoader.this.findResource(name);
                if (url == null) {
                    url = LateDelegationClassLoader.super.getResource(name);
                }
                return url;
            }
        });
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.delegateToParent(name)) {
                c = super.loadClass(name, false);
            } else {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, false);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public void addURL(URL url) {
        if (!this.addedExtensionURLs.contains(url)) {
            this.addedExtensionURLs.add(url);
            super.addURL(url);
        }
    }

    public void addPriorityURL(URL url) {
        try {
            if (!this.addedExtensionURLs.contains(url)) {
                Class<?> superclass = this.getClass().getSuperclass();
                Field ucpFld = superclass.getDeclaredField("ucp");
                ucpFld.setAccessible(true);
                Object ucp = ucpFld.get(this);
                Method getLoader = ucp.getClass().getDeclaredMethod("getLoader", URL.class);
                getLoader.setAccessible(true);
                Field loadersFld = ucp.getClass().getDeclaredField("loaders");
                loadersFld.setAccessible(true);
                Object loaders = loadersFld.get(ucp);
                Field lmapFld = ucp.getClass().getDeclaredField("lmap");
                lmapFld.setAccessible(true);
                Object lmap = lmapFld.get(ucp);
                Field pathFld = ucp.getClass().getDeclaredField("path");
                pathFld.setAccessible(true);
                Object path = pathFld.get(ucp);
                Object loader = getLoader.invoke(ucp, url);
                loaders.getClass().getMethod("add", Integer.TYPE, Object.class).invoke(loaders, 0, loader);
                lmap.getClass().getMethod("put", Object.class, Object.class).invoke(lmap, url, loader);
                path.getClass().getMethod("add", Integer.TYPE, Object.class).invoke(path, 0, url);
                this.addedExtensionURLs.add(url);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.addURL(url);
        }
    }

    protected boolean delegateToParent(String className) {
        if (className.equals(this.getClass().getName())) {
            return true;
        }
        return className.startsWith("java.") || className.startsWith("javax.swing.") || className.startsWith("org.w3c.dom.") || className.startsWith("javax.xml.datatype.") || className.startsWith("javax.xml.parsers.") || className.startsWith("javax.xml.transform.") || className.startsWith("javax.xml.validation.") || className.startsWith("javax.xml.namespace.") || className.startsWith("org.xml.sax.") || className.startsWith("javax.xml.stream.") || className.startsWith("org.junit.") || this.shouldDelegateLoggingToParent && (className.startsWith("ch.qos.logback") || className.startsWith("org.slf4j"));
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new AllPermission());
        return perms;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> myResources = this.findResources(name);
        Enumeration<URL> superResources = super.getResources(name);
        if (myResources == null || !myResources.hasMoreElements()) {
            return superResources;
        }
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        while (myResources.hasMoreElements()) {
            resources.add(myResources.nextElement());
        }
        if (superResources != null) {
            while (superResources.hasMoreElements()) {
                URL url = superResources.nextElement();
                if (resources.contains(url)) continue;
                resources.add(url);
            }
        }
        return new Vector(resources).elements();
    }
}

