/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.schematron;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SchematronNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)SchematronNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = SchematronNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(SchematronNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String nodeNS = context.getNodeNamespace();
            String iconPath = null;
            if ("http://www.ascc.net/xml/schematron".equals(nodeNS) || "http://purl.oclc.org/dsdl/schematron".equals(nodeNS)) {
                String imageKey = nodeName;
                int index = nodeName.indexOf(":");
                imageKey = index == -1 ? nodeName : nodeName.substring(index + 1);
                iconPath = nameToIconPath.get(imageKey);
                renderingInfo.setIconPath(iconPath);
            }
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "Schematron Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("assert", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchAssert16.png"));
        nameToIconPath.put("report", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchReport16.png"));
        nameToIconPath.put("rule", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchRule16.png"));
        nameToIconPath.put("pattern", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchPattern16.png"));
        nameToIconPath.put("phase", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchPhase16.png"));
        nameToIconPath.put("active", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchActive16.png"));
        nameToIconPath.put("diagnostics", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchDiagnostics16.png"));
        nameToIconPath.put("diagnostic", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchDiagnostic16.png"));
        nameToIconPath.put("schema", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchSchema16.png"));
        nameToIconPath.put("ns", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchNameSpace16.png"));
        nameToIconPath.put("let", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/SchLet16.png"));
        nameToIconPath.put("include", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/Include16.png"));
        nameToIconPath.put("title", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTitle16.png"));
        nameToIconPath.put("p", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementPara16.png"));
        nameToIconPath.put("span", SchematronNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementStylesheet16.png"));
    }
}

