/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dita.xsltextensions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public class ImageInfo {
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static String getImageSize(String uri) {
        if (uri.endsWith("svg")) {
            return ImageInfo.getSVGImageSize(uri);
        }
        return ImageInfo.getRasterImageSize(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRasterImageSize(String uri) {
        int height;
        int width;
        block13: {
            width = -1;
            height = -1;
            try {
                URL url = new URL(uri);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(url.openConnection().getInputStream());
                Iterator<ImageReader> iter = ImageIO.getImageReaders(imageInputStream);
                if (!iter.hasNext()) break block13;
                ImageReader reader = iter.next();
                try {
                    reader.setInput(imageInputStream);
                    width = reader.getWidth(reader.getMinIndex());
                    height = reader.getHeight(reader.getMinIndex());
                }
                catch (IOException iOException) {
                }
                finally {
                    reader.dispose();
                    try {
                        imageInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                System.err.println("Cannot determine the image size for " + uri + " because of " + ex);
            }
        }
        return width + "," + height;
    }

    private static String getSVGImageSize(String uri) {
        String width = "-1";
        String height = "-1";
        try {
            URL url = new URL(uri);
            InputStream inputStream = url.openConnection().getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature(LOAD_EXTERNAL_DTD, false);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            NamedNodeMap attributes = document.getDocumentElement().getAttributes();
            if (attributes != null && attributes.getNamedItem("width") != null && attributes.getNamedItem("height") != null) {
                width = attributes.getNamedItem("width").getNodeValue();
                height = attributes.getNamedItem("height").getNodeValue();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.err.println("Cannot determine the image size for " + uri + " because of " + ex);
        }
        return width + "," + height;
    }
}

