/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.function.Supplier;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public interface Logger {
    public static final Marker FATAL_MARKER = MarkerFactory.getMarker("FATAL");
    public static final String ROOT_LOGGER_NAME = "ROOT";

    public String getName();

    public boolean isTraceEnabled();

    public void trace(String var1);

    public void trace(String var1, Object var2);

    public void trace(String var1, Object var2, Object var3);

    public void trace(String var1, Object ... var2);

    public void trace(String var1, Throwable var2);

    public boolean isTraceEnabled(Marker var1);

    public void trace(Marker var1, String var2);

    public void trace(Marker var1, String var2, Object var3);

    public void trace(Marker var1, String var2, Object var3, Object var4);

    public void trace(Marker var1, String var2, Object ... var3);

    public void trace(Marker var1, String var2, Throwable var3);

    public boolean isDebugEnabled();

    public void debug(String var1);

    public void debug(String var1, Object var2);

    public void debug(String var1, Object var2, Object var3);

    public void debug(String var1, Object ... var2);

    public void debug(String var1, Throwable var2);

    public boolean isDebugEnabled(Marker var1);

    public void debug(Marker var1, String var2);

    public void debug(Marker var1, String var2, Object var3);

    public void debug(Marker var1, String var2, Object var3, Object var4);

    public void debug(Marker var1, String var2, Object ... var3);

    public void debug(Marker var1, String var2, Throwable var3);

    public boolean isInfoEnabled();

    public void info(String var1);

    public void info(String var1, Object var2);

    public void info(String var1, Object var2, Object var3);

    public void info(String var1, Object ... var2);

    public void info(String var1, Throwable var2);

    public boolean isInfoEnabled(Marker var1);

    public void info(Marker var1, String var2);

    public void info(Marker var1, String var2, Object var3);

    public void info(Marker var1, String var2, Object var3, Object var4);

    public void info(Marker var1, String var2, Object ... var3);

    public void info(Marker var1, String var2, Throwable var3);

    public boolean isWarnEnabled();

    public void warn(String var1);

    public void warn(String var1, Object var2);

    public void warn(String var1, Object ... var2);

    public void warn(String var1, Object var2, Object var3);

    public void warn(String var1, Throwable var2);

    public boolean isWarnEnabled(Marker var1);

    public void warn(Marker var1, String var2);

    public void warn(Marker var1, String var2, Object var3);

    public void warn(Marker var1, String var2, Object var3, Object var4);

    public void warn(Marker var1, String var2, Object ... var3);

    public void warn(Marker var1, String var2, Throwable var3);

    public boolean isErrorEnabled();

    public void error(String var1);

    public void error(String var1, Object var2);

    public void error(String var1, Object var2, Object var3);

    public void error(String var1, Object ... var2);

    public void error(String var1, Throwable var2);

    public boolean isErrorEnabled(Marker var1);

    public void error(Marker var1, String var2);

    public void error(Marker var1, String var2, Object var3);

    public void error(Marker var1, String var2, Object var3, Object var4);

    public void error(Marker var1, String var2, Object ... var3);

    public void error(Marker var1, String var2, Throwable var3);

    default public void info(Object msg) {
        this.info(String.valueOf(msg));
    }

    default public void info(Object msg, Throwable t) {
        this.info(String.valueOf(msg), t);
    }

    default public void info(Throwable t) {
        this.info(t, t);
    }

    default public void info(Supplier<?> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get());
        }
    }

    default public void info(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get(), throwable);
        }
    }

    default public void info(String message, Supplier<?> ... paramSuppliers) {
        if (this.isInfoEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.info(message, params);
        }
    }

    default public void warn(Object msg) {
        this.warn(String.valueOf(msg));
    }

    default public void warn(Object msg, Throwable t) {
        this.warn(String.valueOf(msg), t);
    }

    default public void warn(Throwable t) {
        this.warn(t, t);
    }

    default public void warn(Supplier<?> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get());
        }
    }

    default public void warn(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get(), throwable);
        }
    }

    default public void warn(String message, Supplier<?> ... paramSuppliers) {
        if (this.isWarnEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.warn(message, params);
        }
    }

    default public void trace(Object msg) {
        this.trace(String.valueOf(msg));
    }

    default public void trace(Object msg, Throwable t) {
        this.trace(String.valueOf(msg), t);
    }

    default public void trace(Throwable t) {
        this.trace(t, t);
    }

    default public void trace(Supplier<?> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get());
        }
    }

    default public void trace(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get(), throwable);
        }
    }

    default public void trace(String message, Supplier<?> ... paramSuppliers) {
        if (this.isTraceEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.trace(message, params);
        }
    }

    default public void debug(Object msg) {
        this.debug(String.valueOf(msg));
    }

    default public void debug(Object msg, Throwable t) {
        this.debug(String.valueOf(msg), t);
    }

    default public void debug(Throwable t) {
        this.debug(t, t);
    }

    default public void debug(Supplier<?> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get());
        }
    }

    default public void debug(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get(), throwable);
        }
    }

    default public void debug(String message, Supplier<?> ... paramSuppliers) {
        if (this.isDebugEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.debug(message, params);
        }
    }

    default public void error(Object msg) {
        this.error(String.valueOf(msg));
    }

    default public void error(Object msg, Throwable t) {
        this.error(String.valueOf(msg), t);
    }

    default public void error(Throwable t) {
        this.error(t, t);
    }

    default public void error(Supplier<?> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get());
        }
    }

    default public void error(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get(), throwable);
        }
    }

    default public void error(String message, Supplier<?> ... paramSuppliers) {
        if (this.isErrorEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.error(message, params);
        }
    }

    default public boolean isFatalEnabled() {
        return this.isErrorEnabled();
    }

    default public void fatal(String msg) {
        this.error(FATAL_MARKER, msg);
    }

    default public void fatal(String msg, Throwable t) {
        this.error(FATAL_MARKER, msg, t);
    }

    default public void fatal(String format, Object ... arguments) {
        this.error(FATAL_MARKER, format, arguments);
    }

    default public void fatal(Object msg) {
        this.fatal(String.valueOf(msg));
    }

    default public void fatal(Object msg, Throwable t) {
        this.fatal(String.valueOf(msg), t);
    }

    default public void fatal(Throwable t) {
        this.fatal(t, t);
    }

    default public void fatal(Supplier<?> messageSupplier) {
        if (this.isFatalEnabled()) {
            this.fatal(messageSupplier.get());
        }
    }

    default public void fatal(Supplier<?> messageSupplier, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.fatal(messageSupplier.get(), throwable);
        }
    }

    default public void fatal(String message, Supplier<?> ... paramSuppliers) {
        if (this.isFatalEnabled()) {
            int nuOfSuppliers = paramSuppliers.length;
            Object[] params = new Object[nuOfSuppliers];
            for (int i = 0; i < nuOfSuppliers; ++i) {
                params[i] = paramSuppliers[i].get();
            }
            this.fatal(message, params);
        }
    }
}

