/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.ConversionArguments;
import org.dita.dost.invoker.DeliverablesArguments;
import org.dita.dost.invoker.HelpArguments;
import org.dita.dost.invoker.InitArguments;
import org.dita.dost.invoker.InstallArguments;
import org.dita.dost.invoker.PluginsArguments;
import org.dita.dost.invoker.TranstypesArguments;
import org.dita.dost.invoker.UninstallArguments;
import org.dita.dost.invoker.ValidateArguments;
import org.dita.dost.invoker.VersionArguments;
import org.dita.dost.platform.Plugins;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Element;

final class ArgumentParser {
    private static final Map<String, String> TRUTHY_VALUES = Map.of("true", "false", "TRUE", "FALSE", "yes", "no", "YES", "NO", "1", "0", "on", "off", "ON", "OFF");
    private static Map<String, Arguments.Argument> PLUGIN_ARGUMENTS;

    ArgumentParser() {
    }

    static Arguments.Argument mergeArguments(Arguments.Argument a, Arguments.Argument b) {
        if (a instanceof Arguments.EnumArgument && b instanceof Arguments.EnumArgument) {
            HashSet<String> vals = new HashSet<String>();
            vals.addAll(((Arguments.EnumArgument)a).values);
            vals.addAll(((Arguments.EnumArgument)b).values);
            return new Arguments.EnumArgument(a.property, a.desc, Collections.unmodifiableSet(vals));
        }
        return a;
    }

    static Arguments.Argument getArgument(Element param) {
        String name = param.getAttribute("name");
        String type = param.getAttribute("type");
        String desc = param.getAttribute("desc");
        return switch (type) {
            case "file" -> new Arguments.FileArgument(name, desc);
            case "enum" -> {
                Set<String> vals = XMLUtils.getChildElements(param).stream().map(XMLUtils::getText).collect(Collectors.toSet());
                if (vals.size() == 2) {
                    for (Map.Entry<String, String> pair : TRUTHY_VALUES.entrySet()) {
                        if (!vals.contains(pair.getKey()) || !vals.contains(pair.getValue())) continue;
                        yield new Arguments.BooleanArgument(name, desc, pair.getKey(), pair.getValue());
                    }
                }
                yield new Arguments.EnumArgument(name, desc, vals);
            }
            default -> new Arguments.StringArgument(name, desc);
        };
    }

    static synchronized Map<String, Arguments.Argument> getPluginArguments() {
        if (PLUGIN_ARGUMENTS == null) {
            List params = XMLUtils.toList(Plugins.getPluginConfiguration().getElementsByTagName("param"));
            PLUGIN_ARGUMENTS = params.stream().map(ArgumentParser::getArgument).collect(Collectors.toMap(arg -> "--" + arg.property, arg -> arg, ArgumentParser::mergeArguments));
        }
        return PLUGIN_ARGUMENTS;
    }

    public Arguments processArgs(String[] arguments) {
        for (String subcommand : arguments) {
            switch (this.getName(subcommand)) {
                case "help": {
                    return new HelpArguments().parse(arguments);
                }
                case "plugins": {
                    return new PluginsArguments().parse(arguments);
                }
                case "version": {
                    return new VersionArguments().parse(arguments);
                }
                case "validate": {
                    return new ValidateArguments().parse(arguments);
                }
                case "transtypes": {
                    return new TranstypesArguments().parse(arguments);
                }
                case "deliverables": {
                    return new DeliverablesArguments().parse(arguments);
                }
                case "install": {
                    return new InstallArguments().parse(arguments);
                }
                case "uninstall": {
                    return new UninstallArguments().parse(arguments);
                }
                case "init": {
                    return new InitArguments().parse(arguments);
                }
            }
        }
        return new ConversionArguments().parse(arguments);
    }

    private String getName(String subcommand) {
        int start = subcommand.startsWith("--") ? 2 : (subcommand.startsWith("-") ? 1 : 0);
        int end = subcommand.indexOf(61);
        return subcommand.substring(start, end != -1 ? end : subcommand.length());
    }
}

