/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class SQLClose
extends ExtensionInstruction {
    Expression connection = null;

    protected void prepareAttributes() {
        AttributeInfo connectAtt = this.attributes().get(NamespaceUri.NULL, "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt.getValue(), connectAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new CloseInstruction(this.connection);
    }

    private static class CloseInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;

        public CloseInstruction(Expression connect) {
            Expression[] sub = new Expression[]{connect};
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:close";
        }

        protected int computeCardinality() {
            return 24576;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL) Failed to close connection: " + ex.getMessage(), "SXSQ0002", context);
            }
            return EmptySequence.getInstance();
        }
    }
}

