/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.trans.XPathException;

public class SQLQueryFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item it;
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String tableName = arguments[1].head().getStringValue();
        ArrayList<String> columnNames = new ArrayList<String>();
        SequenceIterator colIter = arguments[2].iterate();
        while ((it = colIter.next()) != null) {
            columnNames.add(it.getStringValue());
        }
        String predicate = null;
        if (arguments.length >= 4) {
            predicate = arguments[3].head().getStringValue();
        }
        Statement ps = null;
        try {
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT ");
            boolean first = true;
            for (String c : columnNames) {
                if (!first) {
                    statement.append(", ");
                }
                statement.append(c);
                first = false;
            }
            statement.append(" FROM ").append(tableName);
            if (predicate != null && !"".equals(predicate)) {
                statement.append(" WHERE ").append(predicate);
            }
            try {
                ps = connection.prepareStatement(statement.toString());
            }
            catch (SQLException e) {
                throw new XPathException("sql:query failed: " + e.getMessage() + " Failed to prepare query {" + statement + '}', "SXSQ0004", context);
            }
            ResultSet rs = ps.executeQuery();
            List<MapItem> out = SQLFunctionSet.sqlQueryResult(rs);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            ZeroOrMore zeroOrMore = new ZeroOrMore(out);
            return zeroOrMore;
        }
        catch (SQLException ex) {
            throw new XPathException("sql:query() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

