/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class SQLPreparedStatementFn
extends SystemFunction {
    public FunctionItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String statement = arguments[1].head().getStringValue();
        PreparedStatement ps = null;
        try {
            try {
                ps = connection.prepareStatement(statement);
            }
            catch (SQLException e) {
                throw new XPathException("sql:prepared-statement() failed: " + e.getMessage() + " Failed to prepare statement {" + statement + '}', "SXSQ0004", context);
            }
            PreparedStatement ps2 = ps;
            Callable callable = (context1, arguments1) -> {
                for (int i = 0; i < arguments1.length; ++i) {
                    SQLFunctionSet.setSqlStatementParam(ps2, i + 1, arguments1[i], context1);
                }
                try {
                    ps2.execute();
                    return EmptySequence.getInstance();
                }
                catch (SQLException e) {
                    throw new XPathException("Failure executing prepared SQL statement", (Throwable)e);
                }
            };
            ParameterMetaData metaData = ps2.getParameterMetaData();
            int arity = metaData.getParameterCount();
            SequenceType[] parameterTypes = new SequenceType[arity];
            SQLFunctionSet.supplyParameters(metaData, parameterTypes);
            SpecificFunctionType type = new SpecificFunctionType(parameterTypes, SequenceType.OPTIONAL_ITEM);
            return new CallableFunction(arity, callable, (FunctionItemType)type);
        }
        catch (SQLException ex) {
            throw new XPathException("sql:prepared-statement() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
    }
}

