/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class SQLDeleteFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String tableName = arguments[1].head().getStringValue();
        String predicate = arguments[2].head().getStringValue();
        String statement = "DELETE FROM " + tableName;
        if (!predicate.equals("")) {
            statement = statement + " WHERE " + predicate;
        }
        try (PreparedStatement ps = connection.prepareStatement(statement);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new XPathException("sql:delete() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
        return EmptySequence.getInstance();
    }
}

