/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.NameChecker;

public class PrefixDeclarationParser {
    private static EnumSet<State> FINAL_STATES = EnumSet.of(State.START, State.PREFIX, State.WHITESPACE);

    public static Map<String, String> parsePrefixMappings(String value, Report report, EPUBLocation location) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        if (value == null) {
            return builder.build();
        }
        StringReader reader = new StringReader(value);
        String prefix = null;
        String uri = null;
        try {
            int c;
            State state = State.START;
            String chars = "";
            while ((c = reader.read()) != -1) {
                List<String> parsed = PrefixDeclarationParser.consume(reader, c, state);
                chars = parsed.get(0);
                String badChars = parsed.get(1);
                switch (state) {
                    case START: {
                        prefix = null;
                        uri = null;
                        if (!chars.isEmpty()) {
                            report.message(MessageId.OPF_004, location, new Object[0]);
                        }
                        state = State.PREFIX;
                        break;
                    }
                    case PREFIX: {
                        if (chars.isEmpty()) {
                            report.message(MessageId.OPF_004a, location, new Object[0]);
                        } else if (!PrefixDeclarationParser.isValidNCName(chars)) {
                            report.message(MessageId.OPF_004b, location, new Object[]{chars});
                        } else {
                            prefix = chars;
                        }
                        state = State.PREFIX_END;
                        break;
                    }
                    case PREFIX_END: {
                        if (chars.isEmpty()) {
                            if ((char)(c = PrefixDeclarationParser.skip(reader, c, CharMatcher.whitespace(), State.PREFIX_END.accepted)) == ':') {
                                report.message(MessageId.OPF_004c, location, new Object[]{prefix});
                                state = State.PREFIX_END;
                            } else {
                                report.message(MessageId.OPF_004c, location, new Object[]{prefix});
                                state = State.URI;
                            }
                            prefix = null;
                            break;
                        }
                        state = State.SPACE;
                        break;
                    }
                    case SPACE: {
                        if (chars.isEmpty()) {
                            report.message(MessageId.OPF_004d, location, new Object[]{prefix});
                            prefix = null;
                        } else if (!badChars.isEmpty()) {
                            report.message(MessageId.OPF_004e, location, new Object[]{prefix});
                        }
                        state = State.URI;
                        break;
                    }
                    case URI: {
                        try {
                            uri = new URI(chars).toString();
                            if (prefix != null) {
                                builder.put((Object)prefix, (Object)uri);
                            }
                        }
                        catch (URISyntaxException e) {
                            report.message(MessageId.OPF_006, location, new Object[]{chars, prefix});
                        }
                        prefix = null;
                        state = State.WHITESPACE;
                        break;
                    }
                    case WHITESPACE: {
                        if (!badChars.isEmpty()) {
                            report.message(MessageId.OPF_004f, location, new Object[]{prefix});
                        }
                        state = State.PREFIX;
                    }
                }
            }
            if (!FINAL_STATES.contains((Object)state)) {
                report.message(MessageId.OPF_005, location, new Object[]{prefix});
            }
            if (state == State.PREFIX && !chars.isEmpty()) {
                report.message(MessageId.OPF_004, location, new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            reader.close();
        }
        return builder.build();
    }

    private static boolean isValidNCName(String chars) {
        Method checkValid = null;
        try {
            checkValid = NameChecker.class.getMethod("isValidNCName", CharSequence.class);
        }
        catch (Exception e) {
            try {
                checkValid = NameChecker.class.getMethod("isValidNCName", String.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            return (Boolean)checkValid.invoke(null, chars);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<String> consume(Reader reader, int c, State state) throws IOException {
        StringBuilder sb = new StringBuilder();
        StringBuilder illegal = new StringBuilder();
        while (c != -1 && state.accepted.matches((char)c)) {
            reader.mark(1);
            sb.append((char)c);
            if (!state.allowed.matches((char)c)) {
                illegal.append((char)c);
            }
            reader.mark(1);
            c = reader.read();
        }
        reader.reset();
        return ImmutableList.of((Object)sb.toString(), (Object)illegal.toString());
    }

    private static int skip(Reader reader, int c, CharMatcher skipped, CharMatcher stopping) throws IOException {
        while (c != -1 && !stopping.matches((char)c) && skipped.matches((char)c)) {
            reader.mark(1);
            c = reader.read();
        }
        reader.reset();
        return c;
    }

    private static enum State {
        START(CharMatcher.whitespace(), CharMatcher.none()),
        PREFIX(CharMatcher.whitespace().or(CharMatcher.is((char)':')).negate(), CharMatcher.any()),
        PREFIX_END(CharMatcher.is((char)':'), CharMatcher.any()),
        SPACE(CharMatcher.whitespace(), CharMatcher.is((char)' ')),
        URI(CharMatcher.whitespace().negate(), CharMatcher.any()),
        WHITESPACE(CharMatcher.whitespace(), CharMatcher.anyOf((CharSequence)" \t\r\n"));

        public final CharMatcher accepted;
        public final CharMatcher allowed;

        private State(CharMatcher accepted, CharMatcher allowed) {
            this.accepted = accepted;
            this.allowed = allowed;
        }
    }
}

