/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.ErrorPublishingTemplateType;
import com.oxygenxml.publishing.template.ITemplateValidationListener;
import com.oxygenxml.publishing.template.binding.CSSFile;
import com.oxygenxml.publishing.template.binding.FaviconFile;
import com.oxygenxml.publishing.template.binding.HTMLFragment;
import com.oxygenxml.publishing.template.binding.HTMLPageTemplate;
import com.oxygenxml.publishing.template.binding.JsModule;
import com.oxygenxml.publishing.template.binding.LogoFile;
import com.oxygenxml.publishing.template.binding.PublishingTemplate;
import com.oxygenxml.publishing.template.binding.PublishingTemplateType;
import com.oxygenxml.publishing.template.binding.WebHelpResources;
import com.oxygenxml.publishing.template.binding.XSLTExtensionPoint;
import com.oxygenxml.publishing.template.i18n.MessagesBundleProvider;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="publishing-template", namespace="")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FilePublishingTemplate
extends PublishingTemplate {
    private static ResourceBundle messages = MessagesBundleProvider.getBundle();

    public FilePublishingTemplate() {
    }

    public FilePublishingTemplate(PublishingTemplate source) {
        super(source);
    }

    @Override
    public void validatePackageContent(ITemplateValidationListener templateValidationListener) {
        if (this.webhelpTemplateInfo != null) {
            this.validateWebHelpInformation(templateValidationListener);
        }
        if (this.pdfTemplateInfo != null) {
            this.validatePDFInformation(templateValidationListener);
        }
    }

    private void validatePDFInformation(ITemplateValidationListener templateValidationListener) {
        List<XSLTExtensionPoint> xsltExtensionPoints;
        List<CSSFile> cssFiles;
        if (!templateValidationListener.shouldIgnoreUiEvents()) {
            if (this.pdfTemplateInfo.getPreviewImage() != null) {
                String imagePath = this.pdfTemplateInfo.getPreviewImage().getImagePath();
                this.reportProblem(this.checkRelativePath(imagePath, "Pdf_the_preview_image_does_not_exist"), templateValidationListener, true, ErrorPublishingTemplateType.PDF);
            } else {
                this.reportProblem(messages.getString("Pdf_no_preview_image_in_template_descriptor"), templateValidationListener, true, ErrorPublishingTemplateType.PDF);
            }
        }
        if ((cssFiles = this.pdfTemplateInfo.getCssFiles()) != null) {
            for (CSSFile cssF : cssFiles) {
                this.reportProblem(this.checkRelativePath(cssF.getFilePath(), "Pdf_CSS_file_missing"), templateValidationListener, true, ErrorPublishingTemplateType.PDF);
            }
        }
        if ((xsltExtensionPoints = this.pdfTemplateInfo.getXSLTExtensionPoints()) != null && !xsltExtensionPoints.isEmpty()) {
            for (XSLTExtensionPoint xsltExtensionPoint : xsltExtensionPoints) {
                this.reportProblem(this.checkRelativePath(xsltExtensionPoint.getFilePath(), "Pdf_Xslt_extension_missing"), templateValidationListener, false, ErrorPublishingTemplateType.PDF);
            }
        }
    }

    private void validateWebHelpInformation(ITemplateValidationListener templateValidationListener) {
        WebHelpResources webhelpResources;
        List<HTMLFragment> htmnlFragments;
        List<XSLTExtensionPoint> xsltExtensionPoints;
        if (!templateValidationListener.shouldIgnoreUiEvents()) {
            if (this.webhelpTemplateInfo.getPreviewImage() != null) {
                String imagePath = this.webhelpTemplateInfo.getPreviewImage().getImagePath();
                this.reportProblem(this.checkRelativePath(imagePath, "The_preview_image_does_not_exist"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            } else {
                this.reportProblem(messages.getString("No_preview_image_in_template_descriptor"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
        }
        if (this.webhelpTemplateInfo.hasPageTemplates()) {
            String htmlTemplatesWarning = messages.getString("Verify_html_page_templates");
            HTMLPageTemplate pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("main");
            if (pageTemplate != null) {
                this.reportProblem(this.checkRelativePath(pageTemplate.getFilePath(), "Main_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            } else {
                this.reportProblem(messages.getString("Main_layout_not_defined") + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            }
            pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("search");
            if (pageTemplate != null) {
                this.reportProblem(this.checkRelativePath(pageTemplate.getFilePath(), "Search_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            } else {
                this.reportProblem(messages.getString("Search_layout_not_defined") + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            }
            pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("topic");
            if (pageTemplate != null) {
                this.reportProblem(this.checkRelativePath(pageTemplate.getFilePath(), "Topic_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            } else {
                this.reportProblem(messages.getString("Topic_layout_not_defined") + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            }
            pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("index-terms");
            if (pageTemplate != null) {
                this.reportProblem(this.checkRelativePath(pageTemplate.getFilePath(), "Indexterms_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            } else {
                this.reportProblem(messages.getString("Indexterms_layout_not_defined") + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            }
        }
        if ((xsltExtensionPoints = this.webhelpTemplateInfo.getXSLTExtensionPoints()) != null && !xsltExtensionPoints.isEmpty()) {
            for (XSLTExtensionPoint xsltExtensionPoint : xsltExtensionPoints) {
                this.reportProblem(this.checkRelativePath(xsltExtensionPoint.getFilePath(), "Xslt_extension_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
            }
        }
        if ((htmnlFragments = this.webhelpTemplateInfo.getHTMLFragments()) != null && !htmnlFragments.isEmpty()) {
            for (HTMLFragment htmlFragment : htmnlFragments) {
                this.reportProblem(this.checkRelativePath(htmlFragment.getFilePath(), "Html_fragment_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
        }
        if ((webhelpResources = this.webhelpTemplateInfo.getWebhelpResources()) != null) {
            JsModule scriptFile;
            FaviconFile favIconFile;
            List<CSSFile> cssFiles = webhelpResources.getCssFiles();
            for (CSSFile cssF : cssFiles) {
                this.reportProblem(this.checkRelativePath(cssF.getFilePath(), "CSS_file_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
            LogoFile logoFile = webhelpResources.getLogoFile();
            if (logoFile != null) {
                this.reportProblem(this.checkRelativePath(logoFile.getFilePath(), "Logo_file_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
            if ((favIconFile = webhelpResources.getFaviconFile()) != null) {
                this.reportProblem(this.checkRelativePath(favIconFile.getFilePath(), "Favicon_file_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
            if ((scriptFile = webhelpResources.getJsModule()) != null) {
                this.reportProblem(this.checkRelativePath(scriptFile.getFilePath(), "Js_module_file_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
            }
        }
    }

    private String checkRelativePath(String relPath, String errorTag) {
        String errorMessage = null;
        if ("".equals(relPath)) {
            errorMessage = MessageFormat.format(messages.getString(errorTag), "\"" + relPath + "\"");
        } else {
            File file = new File(this.packageRoot, relPath);
            if (!file.exists()) {
                errorMessage = MessageFormat.format(messages.getString(errorTag), file.getAbsolutePath());
            }
        }
        return errorMessage;
    }

    @Override
    public PublishingTemplateType getType() {
        return PublishingTemplateType.FOLDER;
    }
}

