/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.cssvalidator.properties.oxygen;

import java.util.regex.Pattern;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssString;
import ro.sync.cssvalidator.properties.oxygen.ValueValidator;

public final class ValueValidators {
    public static final ValueValidator NUMBER_0_OR_LENGTH_POSITIVE_OR_FUNCTION_VALID = (value, property, ac) -> {
        switch (value.getType()) {
            case 5: {
                value.getCheckableValue().checkEqualsZero(ac, property);
                break;
            }
            case 6: {
                value.getCheckableValue().checkPositiveness(ac, property);
                break;
            }
            default: {
                int rawType = value.getRawType();
                if (rawType == 11 && property.validateFunction((CssFunction)value, ac)) break;
                property.signalInvalidValue(value.toString(), ac);
            }
        }
    };
    private static final Pattern QUOTES_PATTERN = Pattern.compile("['\"]");
    public static final ValueValidator STRING_OR_ATTR_OR_FUNCTION_VALID = (value, property, ac) -> {
        if (value instanceof CssString) {
            String str = QUOTES_PATTERN.matcher((String)value.get()).replaceAll("");
            if (str.length() == 0) {
                property.signalInvalidValue(ac);
            }
        } else if (!property.isAttrOrFunctionAndValid(ac)) {
            property.signalInvalidValue(ac);
        }
    };
    public static final ValueValidator NUMBER_POSITIVE_OR_ATTR_OR_FUNCTION_VALID = (value, property, ac) -> {
        if (value instanceof CssNumber) {
            int cc = ((CssNumber)value).getInt();
            if (cc < 1) {
                property.signalInvalidValue(ac);
            }
        } else if (!property.isAttrOrFunctionAndValid(ac)) {
            property.signalInvalidValue(ac);
        }
    };

    private ValueValidators() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }
}

