/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.Arrays;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssListStyleType
extends org.w3c.css.properties.css.CssListStyleType {
    public static final CssIdent[] allowed_values;
    public static CssIdent[] symbols_type;

    public static final CssIdent getAllowedIdent(CssIdent ident) {
        int idx = Arrays.binarySearch(allowed_values, ident);
        return idx < 0 ? null : allowed_values[idx];
    }

    public static CssIdent getSymbolsFunctionAllowedIdent(CssIdent ident) {
        for (CssIdent id : symbols_type) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    protected CssIdent getAllowedIdentInternal(CssIdent ident) {
        return CssListStyleType.getAllowedIdent(ident);
    }

    public CssListStyleType() {
        this.value = initial;
    }

    public CssListStyleType(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssListStyleType(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 1: {
                this.value = val;
                break;
            }
            case 0: {
                CssIdent id = val.getIdent();
                if (none.equals(id)) {
                    this.value = val;
                    break;
                }
                if (CssIdent.isCssWide(id)) {
                    this.value = val;
                    break;
                }
                this.value = this.getAllowedIdentInternal(id);
                if (this.value == null) {
                    this.value = val;
                }
                this.value = val;
                break;
            }
            case 11: {
                if (this.validateFunction((CssFunction)val, ac)) break;
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    protected static CssFunction parseSymbolsFunction(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        CssFunction function = value.getFunction();
        CssExpression exp = function.getParameters();
        boolean got_symbol = false;
        if (!"symbols".equals(function.getName())) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 0: {
                    if (got_symbol) {
                        throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                    }
                    if (CssListStyleType.getSymbolsFunctionAllowedIdent(val.getIdent()) != null) break;
                    throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                }
                case 1: 
                case 2: 
                case 16: {
                    got_symbol = true;
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
            }
            exp.next();
        }
        if (!got_symbol) {
            throw new InvalidParamException("unrecognize", ac);
        }
        return function;
    }

    static {
        String[] _allowed_values = new String[]{"none", "decimal", "decimal-leading-zero", "arabic-indic", "armenian", "upper-armenian", "lower-armenian", "bengali", "cambodian", "khmer", "cjk-decimal", "devanagari", "georgian", "gujarati", "gurmukhi", "hebrew", "kannada", "lao", "malayalam", "mongolian", "myanmar", "oriya", "persian", "lower-roman", "upper-roman", "tamil", "telugu", "thai", "tibetan", "lower-alpha", "lower-latin", "upper-alpha", "upper-latin", "cjk-earthly-branch", "cjk-heavenly-stem", "lower-greek", "hiragana", "hiragana-iroha", "katakana", "katakana-iroha", "disc", "circle", "square", "disclosure-open", "disclosure-closed", "cjk-earthly-branch", "cjk-heavenly-stem", "japanese-informal", "japanese-formal", "korean-hangul-formal", "korean-hanja-informal", "cjk-ideographic", "korean-hanja-formal", "simp-chinese-informal", "simp-chinese-formal", "trad-chinese-informal", "trad-chinese-formal", "ethiopic-numeric"};
        int i = 0;
        allowed_values = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssListStyleType.allowed_values[i++] = CssIdent.getIdent(s);
        }
        Arrays.sort(allowed_values);
        String[] _allowed_symbols_type_values = new String[]{"cyclic", "numeric", "alphabetic", "symbolic", "fixed"};
        symbols_type = new CssIdent[_allowed_symbols_type_values.length];
        i = 0;
        for (String s : _allowed_symbols_type_values) {
            CssListStyleType.symbols_type[i++] = CssIdent.getIdent(s);
        }
    }
}

