/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import org.w3c.css.css.StyleSheetOrigin;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperties;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;
import ro.sync.cssvalidator.properties.oxygen.CustomFunctionValidator;

public abstract class CssProperty
implements Cloneable,
StyleSheetOrigin {
    public CssValue value = null;
    public boolean important;
    public int origin;
    public long order = increment++;
    public int line;
    public String sourceFile;
    public CssSelectors context;
    private static long increment;
    public boolean byUser = false;
    public static final CssIdent inherit;
    public static final CssIdent transparent;
    public static final CssIdent initial;
    public static final CssIdent none;
    public static final CssIdent currentColor;
    public static final CssIdent unset;
    public static final CssIdent revert;

    public boolean inherited() {
        return CssProperties.getInheritance(this);
    }

    public boolean isSoftlyInherited() {
        return false;
    }

    public abstract Object get();

    public abstract String getPropertyName();

    public String getPropertyNameEscaped() {
        return Messages.escapeString(this.getPropertyName());
    }

    public abstract boolean equals(CssProperty var1);

    public abstract String toString();

    public String getEscaped() {
        return Messages.escapeString(this.toString());
    }

    public void setImportant() {
        this.important = true;
    }

    public boolean getImportant() {
        return this.important;
    }

    public final int hashCode() {
        return this.getPropertyName().hashCode();
    }

    public void setInfo(int line, String source) {
        this.line = line;
        this.sourceFile = source;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public boolean isDefault() {
        return false;
    }

    public void setSelectors(CssSelectors context) {
        this.context = context;
    }

    public CssSelectors getSelectors() {
        return this.context;
    }

    public CssProperty duplicate() {
        try {
            return (CssProperty)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract void addToStyle(ApplContext var1, CssStyle var2);

    public abstract CssProperty getPropertyInStyle(CssStyle var1, boolean var2);

    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getExplicitWeight() {
        return this.origin + (this.important ? 3 : 0);
    }

    public final long getOrderSpecified() {
        return this.order;
    }

    public final void setByUser() {
        this.byUser = true;
    }

    public boolean isByUser() {
        return this.byUser;
    }

    public boolean validateFunction(CssFunction cssFunction, ApplContext ac) throws InvalidParamException {
        return CssProperty.validateFunction(cssFunction, ac, this.getPropertyName());
    }

    public static boolean validateFunction(CssFunction cssFunction, ApplContext ac, String propertyName) throws InvalidParamException {
        CustomFunctionValidator functionValidator = ac.getFunctionValidator();
        boolean valid = false;
        if (functionValidator != null) {
            valid = functionValidator.validateFunctionSignature(propertyName, cssFunction, ac);
        }
        if (!valid) {
            CssFunction funct = cssFunction;
            CssExpression params = funct.getParameters();
            CssValue v = params.getValue();
            if (funct.getName().equals("attr")) {
                if (params.getCount() == 2 && v instanceof CssIdent) {
                    params.next();
                    v = params.getValue();
                    if (!(v instanceof CssIdent)) {
                        throw new InvalidParamException("attr", params.getValue(), propertyName, ac);
                    }
                } else if (params.getCount() != 1 || !(v instanceof CssIdent)) {
                    throw new InvalidParamException("attr", params.getValue(), propertyName, ac);
                }
            } else if (funct.getName().equals("content")) {
                if (!(params.getCount() == 0 || params.getCount() == 1 && v instanceof CssIdent)) {
                    throw new InvalidParamException("unrecognized-value", params.getValue(), propertyName, ac);
                }
                params.starts();
            } else if (funct.getName().equals("string")) {
                if (params.getCount() != 1 || !(v instanceof CssIdent)) {
                    if (params.getCount() == 2 && v instanceof CssIdent) {
                        params.next();
                        v = params.getValue();
                        if (!(v instanceof CssIdent) || !"first".equals(v.get()) && !"last".equals(v.get())) {
                            throw new InvalidParamException("string", params.getValue(), propertyName, ac);
                        }
                    } else {
                        throw new InvalidParamException("string", params.getValue(), propertyName, ac);
                    }
                }
                params.starts();
            } else if (funct.getName().equals("leader")) {
                if (!(params.getCount() == 0 || params.getCount() == 1 && (v instanceof CssString || v instanceof CssIdent || CssProperty.isFunction(v)))) {
                    throw new InvalidParamException("unrecognized-value", params.getValue(), propertyName, ac);
                }
                params.ends();
            } else if (funct.getName().equals("url")) {
                if (params.getCount() != 1 || !(v instanceof CssString) && !CssProperty.isFunction(v)) {
                    throw new InvalidParamException("url", params.getValue(), propertyName, ac);
                }
                params.starts();
            } else if (funct.getName().equals("counter")) {
                if (params.getCount() != 1 || !(v instanceof CssIdent)) {
                    if (params.getCount() == 2 && v instanceof CssIdent) {
                        char op = params.getOperator();
                        params.next();
                        v = params.getValue();
                        if (op != ',' || !(v instanceof CssIdent)) {
                            throw new InvalidParamException("counter", params.getValue(), propertyName, ac);
                        }
                    } else {
                        throw new InvalidParamException("counter", params.getValue(), propertyName, ac);
                    }
                }
                params.starts();
            } else if (funct.getName().equals("target-counter")) {
                if (params.getCount() == 2 && (CssProperty.isFunction(v) || v instanceof CssIdent || v instanceof CssString)) {
                    char op = params.getOperator();
                    params.next();
                    v = params.getValue();
                    if (op != ',' || !(v instanceof CssIdent)) {
                        throw new InvalidParamException("unrecognized-value", params.getValue(), propertyName, ac);
                    }
                } else {
                    throw new InvalidParamException("unrecognized-value", params.getValue(), propertyName, ac);
                }
                params.end();
            } else if (funct.getName().equals("counters")) {
                if (params.getCount() == 2 && v instanceof CssIdent) {
                    char op = params.getOperator();
                    params.next();
                    v = params.getValue();
                    if (op != ',' || !(v instanceof CssString)) {
                        throw new InvalidParamException("counters", params.getValue(), propertyName, ac);
                    }
                } else if (params.getCount() == 3 && v instanceof CssIdent) {
                    char op = params.getOperator();
                    params.next();
                    v = params.getValue();
                    if (op != ',' || !(v instanceof CssString)) {
                        throw new InvalidParamException("counters", params.getValue(), propertyName, ac);
                    }
                    op = params.getOperator();
                    params.next();
                    v = params.getValue();
                    if (op != ',' || !(v instanceof CssIdent)) {
                        throw new InvalidParamException("counters", params.getValue(), propertyName, ac);
                    }
                } else {
                    throw new InvalidParamException("counters", params.getValue(), propertyName, ac);
                }
                params.starts();
            } else {
                throw new InvalidParamException("value", cssFunction, propertyName, ac);
            }
        }
        return true;
    }

    private static boolean isFunction(CssValue v) {
        return v instanceof CssFunction || v instanceof CssAttr;
    }

    static {
        inherit = CssIdent.getIdent("inherit");
        transparent = CssIdent.getIdent("transparent");
        initial = CssIdent.getIdent("initial");
        none = CssIdent.getIdent("none");
        unset = CssIdent.getIdent("unset");
        revert = CssIdent.getIdent("revert");
        currentColor = CssIdent.getIdent("currentColor");
    }
}

