/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.css.atrules.css.AtRuleMedia;
import org.w3c.css.atrules.css.media.Media;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import ro.sync.cssvalidator.properties.generic.CSSCustomProperty;
import ro.sync.cssvalidator.properties.generic.CssCustomValidatorFactory;

public class CssPropertyFactory
implements Cloneable {
    private static final String[] NONSTANDARD_PROPERTIES = new String[]{"zoom"};
    private Utf8Properties properties;
    private static String[] SORTEDPROFILES = PropertiesLoader.getProfiles();

    private static boolean isNonstandardProperty(String property) {
        if (property.charAt(0) == '-' || property.charAt(0) == '_') {
            return true;
        }
        for (String s : NONSTANDARD_PROPERTIES) {
            if (!s.equals(property)) continue;
            return true;
        }
        return false;
    }

    public CssPropertyFactory getClone() {
        try {
            return (CssPropertyFactory)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CssPropertyFactory(String profile) {
        this.properties = PropertiesLoader.getProfile(profile);
        if (this.properties == null) {
            throw new NullPointerException();
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private ArrayList<String> getMediaList(String media) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(media, ",");
        while (tok.hasMoreTokens()) {
            String medium = tok.nextToken();
            medium = medium.trim();
            list.add(medium);
        }
        return list;
    }

    public synchronized MediaFeature createMediaFeature(ApplContext ac, AtRule atRule, String feature, CssExpression expression) throws Exception {
        String classname;
        String modifier = null;
        int dashpos = feature.indexOf(45);
        feature = feature.toLowerCase();
        if (dashpos != -1) {
            if (dashpos == 0) {
                throw this.vendorMediaException(ac, atRule, feature);
            }
            modifier = feature.substring(0, dashpos);
            if (modifier.equals("min") || modifier.equals("max")) {
                feature = feature.substring(dashpos + 1);
            } else {
                modifier = null;
            }
        }
        if ((classname = this.properties.getProperty("mf." + feature.toLowerCase())) == null) {
            throw this.vendorMediaException(ac, atRule, feature);
        }
        try {
            Class expressionclass = CssExpression.class;
            if (expression != null) {
                expressionclass = expression.getClass();
            }
            Class[] parametersType = new Class[]{ac.getClass(), String.class, expressionclass};
            Constructor<?> constructor = Class.forName(classname).getConstructor(parametersType);
            Object[] parameters = new Object[]{ac, modifier, expression};
            return (MediaFeature)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Exception ex = (Exception)e.getTargetException();
            throw ex;
        }
    }

    private Exception vendorMediaException(ApplContext ac, AtRule atRule, String feature) throws Exception {
        try {
            AtRuleMedia atRuleMedia = (AtRuleMedia)atRule;
            if (ac.getTreatVendorExtensionsAsWarnings()) {
                throw new WarningParamException("vendor-extension", feature);
            }
            throw new InvalidParamException("noexistence-media", feature, atRuleMedia.getCurrentMedia(), ac);
        }
        catch (ClassCastException cce) {
            throw new InvalidParamException("noexistence", feature, "not media @rule", ac);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized CssProperty createProperty(ApplContext ac, AtRule atRule, String property, CssExpression expression) throws Exception {
        boolean customPropertySupport;
        CssCustomValidatorFactory customValidatorFactory;
        CSSCustomProperty toReturn;
        String classname;
        block31: {
            classname = null;
            String media = null;
            try {
                AtRuleMedia atRuleMedia = (AtRuleMedia)atRule;
                for (Media m : atRuleMedia.getMediaList()) {
                    if (m.getNot()) continue;
                    media = m.getMedia();
                    break;
                }
            }
            catch (ClassCastException cce) {
                media = "all";
            }
            toReturn = null;
            customValidatorFactory = ac.getCustomValidatorFactory();
            customPropertySupport = false;
            if (customValidatorFactory != null) {
                if (customValidatorFactory.propertyIsIgnored(property)) {
                    return null;
                }
                customPropertySupport = customValidatorFactory.supportsProperty(property);
                String propertyForAlias = customValidatorFactory.getPropertyForAlias(property);
                if (propertyForAlias != null) {
                    property = propertyForAlias;
                }
            }
            if (!customPropertySupport) {
                if (ac.getCssProfile() == CssProfile.OXYGEN_EXT && property.startsWith("--")) {
                    return new CSSCustomProperty(property, Collections.emptyList(), new String[0]);
                }
                if (ac.getTreatVendorExtensionsAsWarnings() && this.isVendorExtension(property)) {
                    throw new WarningParamException("vendor-extension", property);
                }
            }
            if ((classname = this.setClassName(atRule, media, ac, property)) == null && !customPropertySupport) {
                ArrayList<String> pfsOk = new ArrayList<String>();
                String spec = ac.getPropertyKey();
                for (String string : SORTEDPROFILES) {
                    if (string.equals(spec) || !PropertiesLoader.getProfile(string).containsKey(property)) continue;
                    pfsOk.add(string);
                }
                if (pfsOk.size() > 0) {
                    if (ac.getCssProfile() == CssProfile.NONE) {
                        String latestVersion = (String)pfsOk.get(pfsOk.size() - 1);
                        CssVersion v = CssVersion.resolve(ac, latestVersion);
                        if (v.compareTo(ac.getCssVersion()) > 0) {
                            ac.getFrame().addWarning("noexistence", new String[]{property, ac.getMsg().getString(ac.getPropertyKey()), pfsOk.toString()});
                            ac.setCssVersion(v);
                        }
                        classname = this.setClassName(atRule, media, ac, property);
                        break block31;
                    } else {
                        StringBuilder renderString = new StringBuilder();
                        int i = pfsOk.size() - 1;
                        while (true) {
                            if (i < 0) {
                                throw new InvalidParamException("noexistence", new String[]{property, ac.getMsg().getString(ac.getPropertyKey()), renderString.toString()}, ac);
                            }
                            if (renderString.length() > 0) {
                                renderString.append(", ");
                            }
                            renderString.append(ac.getMsg().getString(((String)pfsOk.get(i)).toString()));
                            --i;
                        }
                    }
                }
                if (!ac.getSuggestPropertyName()) throw new InvalidParamException("noexistence-at-all", property, ac);
                String possibleName = this.findClosestPropertyName(atRule, ac, property);
                if (possibleName == null) throw new InvalidParamException("noexistence-at-all", property, ac);
                throw new InvalidParamException("noexistence-typo", new String[]{property, possibleName}, ac);
            }
        }
        if (expression.hasCssVariable()) {
            throw new WarningParamException("css-variable", expression.toStringFromStart());
        }
        if (ac.getTreatCssHacksAsWarnings() && expression.hasCssHack()) {
            throw new WarningParamException("css-hack", expression.toStringFromStart());
        }
        if (classname == null) return customValidatorFactory.createProperty(ac, atRule, property, expression);
        try {
            Constructor<?> constructor;
            Class[] parametersType;
            boolean isCssWide = false;
            CssIdent cssIdent = null;
            if (expression.getCount() == 1 && expression.getValue().getRawType() == 0) {
                cssIdent = expression.getValue().getIdent();
                isCssWide = CssIdent.isCssWide(cssIdent);
            }
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0 && isCssWide) {
                parametersType = new Class[]{};
                constructor = Class.forName(classname).getConstructor(parametersType);
                Object[] parameters = new Object[]{};
                expression.next();
                CssProperty cssProperty = (CssProperty)constructor.newInstance(parameters);
                cssProperty.value = cssIdent;
                return cssProperty;
            }
            parametersType = new Class[]{ac.getClass(), expression.getClass(), Boolean.TYPE};
            constructor = Class.forName(classname).getConstructor(parametersType);
            Object[] parameters = new Object[]{ac, expression, Boolean.TRUE};
            return (CssProperty)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            boolean recognized;
            Exception ex;
            block32: {
                InvalidParamException exP;
                block33: {
                    if (Util.onDebug) {
                        e.printStackTrace();
                    }
                    InvocationTargetException iv = e;
                    ex = (Exception)iv.getTargetException();
                    recognized = false;
                    if (!(ex instanceof InvalidParamException)) break block32;
                    exP = (InvalidParamException)ex;
                    if (!customPropertySupport) break block33;
                    CSSCustomProperty cSSCustomProperty = customValidatorFactory.createProperty(ac, atRule, property, expression);
                    if ("value".equals(exP.getErrorID()) && exP.getMessageParts() != null) {
                        if (cSSCustomProperty.recognizeValue(ac, exP.getMessageParts()[0])) {
                            recognized = true;
                            toReturn = cSSCustomProperty;
                            break block32;
                        } else if (ac.getTreatVendorExtensionsAsWarnings() && this.isVendorExtension(exP.getMessageParts()[0])) {
                            ac.getFrame().addWarning("Unrecognized value " + exP.getMessageParts()[0] + ". Might be a vendor extension.", 1);
                            recognized = true;
                        }
                    }
                    break block32;
                }
                if ("value".equals(exP.getErrorID()) && exP.getMessageParts() != null && ac.getTreatVendorExtensionsAsWarnings() && this.isVendorExtension(exP.getMessageParts()[0])) {
                    throw new WarningParamException("vendor-extension", exP.getMessageParts()[0]);
                }
            }
            if (recognized) return toReturn;
            throw ex;
        }
    }

    private String setClassName(AtRule atRule, String media, ApplContext ac, String property) {
        String className;
        String prefix = atRule.lookupPrefix();
        if (!prefix.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append('@').append(atRule.keyword()).append('.').append(property);
            className = PropertiesLoader.getProfile(ac.getPropertyKey()).getProperty(sb.toString());
            if (className != null || atRule.isPropertyLookupStrict()) {
                return className;
            }
        }
        if ((className = PropertiesLoader.getProfile(ac.getPropertyKey()).getProperty(property)) != null && media != null && !media.equals("all")) {
            String propMedia = PropertiesLoader.mediaProperties.getProperty(property);
            if (propMedia == null) {
                return className;
            }
            ArrayList<String> list = this.getMediaList(media);
            for (String medium : list) {
                if (propMedia.indexOf(medium.toLowerCase()) != -1 || propMedia.equals("all")) continue;
                ac.getFrame().addWarning("noexistence-media", new String[]{property, medium + " (" + propMedia + ")"});
            }
        }
        return className;
    }

    private String findClosestPropertyName(AtRule atRule, ApplContext ac, String property) {
        int mindist = 100000;
        Set<Object> propertyList = PropertiesLoader.getProfile(ac.getPropertyKey()).keySet();
        String bestFit = null;
        String prefix = atRule.lookupPrefix();
        if (!prefix.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append('@').append(atRule.keyword()).append('.').append(property);
            property = sb.toString();
        }
        for (String string : propertyList) {
            int dist = CssPropertyFactory.getLevenshteinDistance(property, string);
            if (dist < 0 || dist >= mindist) continue;
            bestFit = string;
            mindist = dist;
            if (mindist != 1) continue;
            return bestFit;
        }
        if (mindist <= 2) {
            return bestFit;
        }
        return null;
    }

    private boolean isVendorExtension(String property) {
        if (property != null && property.length() > 0 && !property.startsWith("-oxy-")) {
            if (property.startsWith("prince-") && property.length() > "prince-".length()) {
                return true;
            }
            return (property.charAt(0) == '-' || property.charAt(0) == '_') && property.indexOf(45, 2) != -1;
        }
        return false;
    }

    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            int upper_left = p[0];
            char t_j = t.charAt(j - 1);
            p[0] = j;
            for (i = 1; i <= n; ++i) {
                int upper = p[i];
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                p[i] = Math.min(Math.min(p[i - 1] + 1, p[i] + 1), upper_left + cost);
                upper_left = upper;
            }
        }
        return p[n];
    }
}

