/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.yaml.prettyprinter;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.representer.Representer;
import ro.sync.yaml.validator.YAMLValidator;
import ro.sync.yaml.validator.YAMLWellformedException;

public class YAMLPrettyPrinter {
    private YAMLPrettyPrinter() {
    }

    public static String formatAndIndentYamlContent(Reader documentReader, int indentSize, int lineWidth) throws YAMLWellformedException, IOException {
        String string;
        DumperOptions dumperOptions = new DumperOptions();
        int actualIndent = indentSize > 10 ? 10 : indentSize;
        dumperOptions.setIndent(actualIndent);
        dumperOptions.setIndicatorIndent(actualIndent < 2 ? 0 : indentSize - 2);
        dumperOptions.setProcessComments(true);
        dumperOptions.setWidth(lineWidth);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setProcessComments(true);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions), new Representer(dumperOptions), dumperOptions, loaderOptions);
        String formattedContent = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Iterator events = yaml.parse(documentReader).iterator();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            Emitter emitter = new Emitter((Writer)writer, dumperOptions);
            while (events.hasNext()) {
                emitter.emit((Event)events.next());
            }
            string = formattedContent = ((Object)out).toString().replaceAll("%TAG ! !\n%TAG !! tag:yaml.org,2002:\n", "");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MarkedYAMLException e) {
                throw YAMLValidator.createCustomException(e);
            }
        }
        ((OutputStream)out).close();
        return string;
    }
}

