/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xquery.prettyprint.base;

import java.io.Reader;
import java.util.Arrays;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.editor.xquery.prettyprint.base.ExpressionType;
import ro.sync.exml.editor.xquery.prettyprint.base.ExpressionsManager;
import ro.sync.exml.editor.xquery.prettyprint.base.OutputHandler;
import ro.sync.exml.editor.xquery.prettyprint.base.PrettyPrinterOptions;
import ro.sync.exml.editor.xquery.prettyprint.base.ReaderWithCounter;
import ro.sync.exml.editor.xquery.prettyprint.base.WhitespaceBuffer;
import ro.sync.exml.editor.xquery.prettyprint.base.WhitespaceConstants;
import ro.sync.exml.editor.xquery.prettyprint.base.XQueryPrettyPrintException;
import ro.sync.exml.editor.xquery.prettyprint.base.XQueryPrettyPrintExceptionFactory;
import ro.sync.exml.editor.xquery.prettyprint.base.properties.WsData;
import ro.sync.exml.editor.xquery.prettyprint.parser.ParseException;
import ro.sync.exml.editor.xquery.prettyprint.parser.Token;
import ro.sync.exml.editor.xquery.prettyprint.parser.TokenMgrError;
import ro.sync.exml.editor.xquery.prettyprint.parser.XQueryPrettyPrinterConstants;

public abstract class XQueryPrettyPrinterBase
implements XQueryPrettyPrinterConstants,
WhitespaceConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XQueryPrettyPrinterBase.class.getName());
    protected static final WsData DEFAULT_WS_DATA = new WsData();
    private int indentLevel;
    protected boolean preserveXmlElementWhitespace;
    protected PrettyPrinterOptions ppOptions;
    protected ExpressionsManager exprManager = new ExpressionsManager();
    private final WhitespaceBuffer wsBuffer = new WhitespaceBuffer();
    private final Stack<OutputHandler> outputHandlerStack = new Stack();
    private static final int[] XML_TEXT_TOKENS = new int[]{318, 313, 315, 316};

    public void prettyPrint(Reader reader, PrettyPrinterOptions ppOptions) throws XQueryPrettyPrintException {
        this.ppOptions = ppOptions;
        if (reader == null) {
            throw XQueryPrettyPrintExceptionFactory.createException("Reader is null!");
        }
        OutputHandler outputHandler = this.getOutputHandler();
        if (outputHandler == null) {
            throw XQueryPrettyPrintExceptionFactory.createException("No output handler has been set!");
        }
        try {
            ReaderWithCounter counterReader = new ReaderWithCounter(reader);
            this.prettyPrintInternal(counterReader);
            this.flushWhiteSpaces();
            int inputCharCount = counterReader.getNonWhitespaceCharsCount();
            int outputCharCount = outputHandler.getNonWhitespaceCharCount();
            if (inputCharCount != outputCharCount) {
                LOGGER.info("The number of non whitespace characters in the pretty printed content is different from the one in the input: {} != {}", (Object)outputCharCount, (Object)inputCharCount);
                throw XQueryPrettyPrintExceptionFactory.createException("The XQuery formatter cannot handle this input!");
            }
        }
        catch (XQueryPrettyPrintException e) {
            throw e;
        }
        catch (TokenMgrError e) {
            throw XQueryPrettyPrintExceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw XQueryPrettyPrintExceptionFactory.createException(e);
        }
        catch (Throwable t) {
            throw XQueryPrettyPrintExceptionFactory.createException(t);
        }
    }

    protected abstract void prettyPrintInternal(Reader var1) throws XQueryPrettyPrintException, ParseException;

    public OutputHandler getOutputHandler() {
        if (!this.outputHandlerStack.isEmpty()) {
            return this.outputHandlerStack.peek();
        }
        return null;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandlerStack.push(outputHandler);
    }

    protected void write(String text) throws XQueryPrettyPrintException {
        OutputHandler outputHandler = this.getOutputHandler();
        if (outputHandler != null) {
            outputHandler.write(text);
        }
    }

    protected void write(Token token) throws XQueryPrettyPrintException {
        if (token != null) {
            this.flushWhiteSpaces();
            this.write(token.image);
        }
    }

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    protected void decreaseIndent() {
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    protected void writeNewLine() {
        this.getWhitespaceBuffer().writeNewLine(this.getIndent());
    }

    private WhitespaceBuffer getWhitespaceBuffer() {
        return this.wsBuffer;
    }

    private StringBuilder getIndent() {
        StringBuilder indent = new StringBuilder();
        String masterIndent = this.ppOptions.getMasterIndent();
        if (masterIndent != null && !masterIndent.isEmpty()) {
            indent.append(masterIndent);
        }
        if (this.ppOptions.isIndentWithTabs()) {
            indent.ensureCapacity(indent.length() + this.indentLevel);
            for (int i = 0; i < this.indentLevel; ++i) {
                indent.append('\t');
            }
        } else {
            int currentBlockIndentSize = this.indentLevel * this.ppOptions.getBlockIndentSize();
            indent.ensureCapacity(indent.length() + currentBlockIndentSize);
            for (int i = 0; i < currentBlockIndentSize; ++i) {
                indent.append(' ');
            }
        }
        return indent;
    }

    protected void writeWhiteSpace() throws XQueryPrettyPrintException {
        this.getWhitespaceBuffer().writeWhitespace();
    }

    protected void whiteSpacesMatched(Token wsToken) throws XQueryPrettyPrintException {
        if (this.ppOptions.isPreserveLineBreaks() && wsToken != null) {
            this.getWhitespaceBuffer().addLineBreaksTopreserve(this.countNewLines(wsToken.image));
        }
    }

    protected void flushWhiteSpaces() throws XQueryPrettyPrintException {
        int lineBreaksToPreserve = this.getWhitespaceBuffer().getLineBreaksToPreserve();
        if (this.ppOptions.isPreserveLineBreaks() && lineBreaksToPreserve > 0) {
            StringBuilder indent = this.getIndent().insert(0, '\n');
            StringBuilder newLines = new StringBuilder(indent.length() * lineBreaksToPreserve);
            for (int i = 0; i < lineBreaksToPreserve; ++i) {
                newLines.append((CharSequence)indent);
            }
            this.write(newLines.toString());
        } else {
            this.write(this.getWhitespaceBuffer().getContent());
        }
        this.getWhitespaceBuffer().clear();
    }

    protected int countNewLines(String str) {
        int newLines = 0;
        if (str != null && !str.isEmpty()) {
            int length = str.length();
            if (length == 1) {
                char wsCh = str.charAt(0);
                if (wsCh == '\n' || wsCh == '\r') {
                    newLines = 1;
                }
            } else {
                int lfCount = 0;
                int crCount = 0;
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if ('\n' == c) {
                        ++lfCount;
                        continue;
                    }
                    if ('\r' != c) continue;
                    ++crCount;
                }
                newLines = Math.max(lfCount, crCount);
            }
        }
        return newLines;
    }

    private static boolean isXmlTextToken(Token t) {
        return t != null && Arrays.stream(XML_TEXT_TOKENS).anyMatch(value -> t.kind == value);
    }

    public abstract Token getToken(int var1);

    protected void elementContentTokenAction() throws XQueryPrettyPrintException {
        Token currentToken = this.getToken(0);
        Token nextToken = this.getToken(1);
        if (currentToken == null || nextToken == null || currentToken.kind == 314) {
            return;
        }
        if (nextToken.kind == 314) {
            int nextNextTokenIndex = 2;
            Token nextNextToken = this.getToken(2);
            if (nextNextToken != null) {
                if (nextNextToken.kind == 317) {
                    this.decreaseIndent();
                }
                if (!this.preserveXmlElementWhitespace) {
                    if (XQueryPrettyPrinterBase.isXmlTextToken(currentToken) || XQueryPrettyPrinterBase.isXmlTextToken(nextNextToken)) {
                        this.writeWhiteSpace();
                    } else {
                        this.writeNewLine();
                    }
                }
            }
        } else if (nextToken.kind == 317) {
            this.decreaseIndent();
        }
    }

    protected void logToken(String message, Token t) {
        if (t != null) {
            LOGGER.info("{}{} - img: |{}|", new Object[]{message, tokenImage[t.kind], t.image});
        } else {
            LOGGER.info("{} NULL!", (Object)message);
        }
    }

    protected void startExpression(ExpressionType type) {
        this.exprManager.startExpression(type);
    }

    protected void endExpression(ExpressionType type) {
        this.exprManager.endExpression(type);
    }

    protected void pushOutputHandler(OutputHandler outputHandler) {
        this.outputHandlerStack.push(outputHandler);
    }

    protected void popOutputHandler() {
        this.outputHandlerStack.pop();
    }
}

