/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xquery.prettyprint.base;

import ro.sync.exml.editor.xquery.prettyprint.base.XQueryPrettyPrintException;
import ro.sync.exml.editor.xquery.prettyprint.parser.ParseException;
import ro.sync.exml.editor.xquery.prettyprint.parser.TokenMgrError;

public final class XQueryPrettyPrintExceptionFactory {
    private static final String CANNOT_FORMAT = "Cannot format the document.";

    private XQueryPrettyPrintExceptionFactory() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static XQueryPrettyPrintException createException(TokenMgrError err) {
        int lineNumber = Math.max(err.getLineNumber(), -1);
        int columnNumber = Math.max(err.getColumnNumber(), -1);
        int length = -1;
        return new XQueryPrettyPrintException(XQueryPrettyPrintExceptionFactory.formatMessage(err), lineNumber, columnNumber, length, err);
    }

    public static XQueryPrettyPrintException createException(ParseException ex) {
        int lineNumber = -1;
        int columnNumber = -1;
        int length = -1;
        if (ex.currentToken != null) {
            lineNumber = ex.currentToken.beginLine;
            columnNumber = ex.currentToken.beginColumn;
            String image = ex.currentToken.image;
            if (image != null) {
                length = image.length();
            }
        }
        return new XQueryPrettyPrintException(XQueryPrettyPrintExceptionFactory.formatMessage(ex), lineNumber, columnNumber, length, ex);
    }

    public static XQueryPrettyPrintException createException(Throwable t) {
        return new XQueryPrettyPrintException(XQueryPrettyPrintExceptionFactory.formatMessage(t), t);
    }

    private static String formatMessage(Throwable t) {
        String errMessage = t.getMessage();
        if (errMessage == null) {
            return CANNOT_FORMAT;
        }
        return CANNOT_FORMAT + " " + errMessage;
    }

    public static XQueryPrettyPrintException createException(String message) {
        return new XQueryPrettyPrintException(message);
    }
}

