/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xquery.prettyprint.base;

import java.io.IOException;
import java.io.Reader;

public class ReaderWithCounter
extends Reader {
    private final Reader reader;
    private boolean closed;
    private int charCounter;

    public ReaderWithCounter(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed!");
        }
        int charRead = this.reader.read(cbuf, off, len);
        if (charRead != -1) {
            for (int i = off; i < off + charRead; ++i) {
                char ch = cbuf[i];
                if (Character.isWhitespace(ch)) continue;
                ++this.charCounter;
            }
        }
        return charRead;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.closed = true;
    }

    public int getNonWhitespaceCharsCount() {
        return this.charCounter;
    }
}

