/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xquery.prettyprint.base;

import ro.sync.exml.editor.xquery.prettyprint.base.OutputHandler;
import ro.sync.exml.editor.xquery.prettyprint.base.XQueryPrettyPrintException;

public class BufferedOutputHandler
implements OutputHandler {
    private final StringBuilder content = new StringBuilder();
    private boolean hasNewLines;

    public boolean hasNewlines() {
        return this.startsWithNewlines() || this.content.toString().trim().contains("\n");
    }

    @Override
    public void write(String string) throws XQueryPrettyPrintException {
        if (!this.hasNewLines && string.contains("\n")) {
            this.hasNewLines = true;
        }
        this.content.append(string);
    }

    public boolean startsWithNewlines() {
        return this.content.length() > 0 && this.content.charAt(0) == '\n';
    }

    public String getContent(boolean removeLastTrailingLineBreak) {
        String contentAfterNewLine;
        int index;
        String bufferContent = null;
        if (removeLastTrailingLineBreak && (index = this.content.lastIndexOf("\n")) > -1 && (contentAfterNewLine = this.content.substring(index + 1)).trim().isEmpty()) {
            bufferContent = this.content.substring(0, index);
        }
        return bufferContent != null ? bufferContent : this.content.toString();
    }

    @Override
    public int getNonWhitespaceCharCount() {
        return 0;
    }
}

