/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ChildBreaks;
import org.htmlcleaner.CleanTimeValues;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.Html4TagProvider;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.NestingState;
import org.htmlcleaner.OpenTags;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagPos;
import org.htmlcleaner.Utils;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.conditional.ITagNodeCondition;

public class HtmlCleaner {
    private static final String MARKER_ATTRIBUTE = "htmlcleaner_marker";
    public static int HTML_4 = 4;
    public static int HTML_5 = 5;
    private CleanerProperties properties;
    private CleanerTransformations transformations;

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider iTagInfoProvider) {
        this(iTagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties cleanerProperties) {
        this(null, cleanerProperties);
    }

    public HtmlCleaner(ITagInfoProvider iTagInfoProvider, CleanerProperties cleanerProperties) {
        CleanerProperties cleanerProperties2 = this.properties = cleanerProperties == null ? new CleanerProperties() : cleanerProperties;
        if (iTagInfoProvider == null && this.properties.getTagInfoProvider() == null) {
            if (this.properties.getHtmlVersion() == HTML_4) {
                this.properties.setTagInfoProvider((ITagInfoProvider)Html4TagProvider.INSTANCE);
            } else {
                this.properties.setTagInfoProvider((ITagInfoProvider)Html5TagProvider.INSTANCE);
            }
        } else if (iTagInfoProvider != null) {
            this.properties.setTagInfoProvider((ITagInfoProvider)(iTagInfoProvider == null ? Html4TagProvider.INSTANCE : iTagInfoProvider));
        }
    }

    public TagNode clean(String string) {
        try {
            return this.clean(new StringReader(string), new CleanTimeValues());
        }
        catch (IOException iOException) {
            throw new HtmlCleanerException((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagNode clean(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            TagNode tagNode = this.clean(inputStreamReader, new CleanTimeValues());
            return tagNode;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {}
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, this.properties.getCharset());
    }

    @Deprecated
    public TagNode clean(URL uRL, String string) throws IOException {
        CharSequence charSequence = Utils.readUrl((URL)uRL, (String)string);
        StringReader stringReader = new StringReader(charSequence.toString());
        return this.clean(stringReader, new CleanTimeValues());
    }

    @Deprecated
    public TagNode clean(URL uRL) throws IOException {
        return this.clean(uRL, this.properties.getCharset());
    }

    public TagNode clean(InputStream inputStream, String string) throws IOException {
        return this.clean(new InputStreamReader(inputStream, string), new CleanTimeValues());
    }

    public TagNode clean(InputStream inputStream) throws IOException {
        return this.clean(inputStream, this.properties.getCharset());
    }

    public TagNode clean(Reader reader) throws IOException {
        return this.clean(reader, new CleanTimeValues());
    }

    protected TagNode clean(Reader reader, CleanTimeValues cleanTimeValues) throws IOException {
        this.pushNesting(cleanTimeValues);
        cleanTimeValues._headOpened = false;
        cleanTimeValues._bodyOpened = false;
        cleanTimeValues._headTags.clear();
        cleanTimeValues.allTags.clear();
        cleanTimeValues.pruneTagSet = new HashSet<ITagNodeCondition>(this.properties.getPruneTagSet());
        cleanTimeValues.allowTagSet = new HashSet<ITagNodeCondition>(this.properties.getAllowTagSet());
        this.transformations = this.properties.getCleanerTransformations();
        cleanTimeValues.pruneNodeSet.clear();
        cleanTimeValues.htmlNode = this.newTagNode("html");
        cleanTimeValues.bodyNode = this.newTagNode("body");
        cleanTimeValues.headNode = this.newTagNode("head");
        cleanTimeValues.rootNode = null;
        cleanTimeValues.htmlNode.addChild((Object)cleanTimeValues.headNode);
        cleanTimeValues.htmlNode.addChild((Object)cleanTimeValues.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader, cleanTimeValues);
        htmlTokenizer.start();
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        List<BaseToken> list = htmlTokenizer.getTokenList();
        this.closeAll(list, cleanTimeValues);
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        this.createDocumentNodes(list, cleanTimeValues);
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        this.calculateRootNode(cleanTimeValues, htmlTokenizer.getNamespacePrefixes());
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        while (this.markNodesToPrune(list, cleanTimeValues, 0)) {
            if (!Thread.currentThread().isInterrupted()) continue;
            this.handleInterruption();
            return null;
        }
        if (cleanTimeValues.pruneNodeSet != null && !cleanTimeValues.pruneNodeSet.isEmpty()) {
            Iterator iterator = cleanTimeValues.pruneNodeSet.iterator();
            while (iterator.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.handleInterruption();
                    return null;
                }
                TagNode tagNode = (TagNode)((Object)iterator.next());
                TagNode tagNode2 = tagNode.getParent();
                if (tagNode2 == null) continue;
                tagNode2.removeChild((Object)tagNode);
            }
        }
        cleanTimeValues.rootNode.setDocType(htmlTokenizer.getDocType());
        this.popNesting(cleanTimeValues);
        return cleanTimeValues.rootNode;
    }

    private boolean markNodesToPrune(List list, CleanTimeValues cleanTimeValues, int n2) {
        if (n2 > this.properties.getMaxDepth()) {
            return false;
        }
        boolean bl = false;
        for (Object e2 : list) {
            if (!(e2 instanceof TagNode) || cleanTimeValues.pruneNodeSet.contains(e2)) continue;
            TagNode tagNode = (TagNode)((Object)e2);
            if (this.addIfNeededToPruneSet(tagNode, cleanTimeValues)) {
                bl = true;
                continue;
            }
            if (tagNode.isEmpty()) continue;
            bl |= this.markNodesToPrune(tagNode.getAllChildren(), cleanTimeValues, n2 + 1);
        }
        return bl;
    }

    private void calculateRootNode(CleanTimeValues cleanTimeValues, Set<String> set) {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        cleanTimeValues.rootNode = cleanTimeValues.htmlNode;
        if (this.properties.isOmitHtmlEnvelope()) {
            object2 = cleanTimeValues.bodyNode.getAllChildren();
            cleanTimeValues.rootNode = new TagNode(null);
            if (object2 != null) {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    cleanTimeValues.rootNode.addChild(object);
                }
            }
        }
        object2 = cleanTimeValues.rootNode.getAttributes();
        if (cleanTimeValues.rootNode.hasAttribute("xmlns")) {
            cleanTimeValues.rootNode.addNamespaceDeclaration("", cleanTimeValues.rootNode.getAttributeByName("xmlns"));
        }
        if (this.properties.isNamespacesAware() && set != null) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                if (Thread.currentThread().isInterrupted()) {
                    this.handleInterruption();
                    return;
                }
                object = (String)iterator.next();
                if (cleanTimeValues.namespaceMap.containsKey(object) || object2.containsKey(string = "xmlns:" + (String)object) || ((String)object).equals("xml") || ((String)object).equals("")) continue;
                if (((String)object).equals("svg")) {
                    cleanTimeValues.rootNode.addAttribute(string, "http://www.w3.org/2000/svg");
                    continue;
                }
                if (((String)object).equals("xlink")) {
                    cleanTimeValues.rootNode.addAttribute(string, "http://www.w3.org/1999/xlink");
                    continue;
                }
                cleanTimeValues.rootNode.addAttribute(string, (String)object);
            }
        }
    }

    private void addAttributesToTag(TagNode tagNode, Map<String, String> map) {
        if (map != null) {
            Map<String, String> map2 = tagNode.getAttributes();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                if (map2.containsKey(string)) continue;
                String string2 = entry.getValue();
                tagNode.addAttribute(string, string2);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tagInfo, CleanTimeValues cleanTimeValues) {
        boolean bl = true;
        if (tagInfo != null) {
            if (tagInfo.getFatalTags().isEmpty()) {
                return true;
            }
            bl = false;
            for (String string : tagInfo.getFatalTags()) {
                if (!this.getOpenTags(cleanTimeValues).tagExists(string, cleanTimeValues)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean mustAddRequiredParent(TagInfo tagInfo, CleanTimeValues cleanTimeValues) {
        Object object3;
        Object object22;
        if (tagInfo == null) {
            return false;
        }
        if (tagInfo.getRequiredParentTags().isEmpty()) {
            return false;
        }
        int n2 = -1;
        for (Object object22 : tagInfo.getFatalTags()) {
            if (object22 == null || (object3 = this.getOpenTags(cleanTimeValues).findTag((String)object22, cleanTimeValues)) == null) continue;
            n2 = object3.position;
        }
        boolean bl = true;
        for (Object object3 : tagInfo.getRequiredParentTags()) {
            TagPos tagPos;
            if (object3 == null || (tagPos = this.getOpenTags(cleanTimeValues).findTag((String)object3, cleanTimeValues)) == null) continue;
            bl = tagPos.position <= n2;
        }
        if (!bl) {
            return false;
        }
        object22 = this.getOpenTags((CleanTimeValues)cleanTimeValues).list.listIterator(this.getOpenTags((CleanTimeValues)cleanTimeValues).list.size());
        while (object22.hasPrevious()) {
            object3 = (TagPos)object22.previous();
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return object3.position <= n2;
            }
            if (!tagInfo.isHigher(object3.name)) continue;
            return object3.position <= n2;
        }
        return true;
    }

    private TagNode newTagNode(String string) {
        TagNode tagNode = new TagNode(string);
        return tagNode;
    }

    private TagNode createTagNode(TagNode tagNode) {
        tagNode.setFormed();
        return tagNode;
    }

    private boolean isAllowedInLastOpenTag(BaseToken baseToken, CleanTimeValues cleanTimeValues) {
        TagPos tagPos = this.getOpenTags(cleanTimeValues).getLastTagPos();
        if (tagPos != null && tagPos.info != null) {
            return tagPos.info.allowsItem(baseToken);
        }
        return true;
    }

    private void saveToLastOpenTag(List list, Object object, CleanTimeValues cleanTimeValues) {
        TagNode tagNode;
        TagPos tagPos = this.getOpenTags(cleanTimeValues).getLastTagPos();
        TagPos tagPos2 = this.getOpenTags(cleanTimeValues).findTagToPlaceRubbish();
        if (tagPos2 != null && (tagNode = (TagNode)((Object)list.get(tagPos2.position))) != null) {
            tagNode.addItemForMoving(object);
            return;
        }
    }

    private boolean isStartToken(Object object) {
        return object instanceof TagNode && !((TagNode)((Object)object)).isFormed();
    }

    private boolean isAllowedAsForeignMarkup(String string, CleanTimeValues cleanTimeValues) {
        if (!this.properties.isNamespacesAware()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.contains(":")) {
            return true;
        }
        if (cleanTimeValues.namespace == null || cleanTimeValues.namespace.size() == 0) {
            return false;
        }
        String string2 = (String)cleanTimeValues.namespace.peek();
        if (string2 == null) {
            return false;
        }
        return !string2.equals("http://www.w3.org/1999/xhtml");
    }

    private void handleEndTagToken(BaseToken baseToken, ListIterator<BaseToken> listIterator, List list, CleanTimeValues cleanTimeValues) {
        EndTagToken endTagToken = (EndTagToken)baseToken;
        String string = endTagToken.name;
        TagInfo tagInfo = this.getTagInfo(string, cleanTimeValues);
        if (tagInfo != null) {
            string = tagInfo.getName();
        }
        if (tagInfo == null && this.properties.isOmitUnknownTags() && !this.isAllowedAsForeignMarkup(string, cleanTimeValues) || tagInfo != null && tagInfo.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
            listIterator.set(null);
        } else if (tagInfo != null && !tagInfo.allowsBody()) {
            listIterator.set(null);
        } else {
            TagPos tagPos = this.getOpenTags(cleanTimeValues).findTag(string, cleanTimeValues);
            if (tagPos != null) {
                Object object;
                int n2;
                Object object2;
                List<TagNode> list2 = this.closeSnippet(list, tagPos, endTagToken, cleanTimeValues);
                if (list2.size() > 0) {
                    TagNode tagNode = list2.get(0);
                    if (tagNode.hasAttribute("xmlns")) {
                        cleanTimeValues.namespace.pop();
                    }
                    if ((object2 = this.getTagInfo(tagNode.getName(), cleanTimeValues)) != null && object2.getAssumedNamespace() != null && !cleanTimeValues.namespace.isEmpty() && object2.getAssumedNamespace().equals(cleanTimeValues.namespace.lastElement()) && !tagNode.hasAttribute("xmlns")) {
                        cleanTimeValues.namespace.pop();
                    }
                }
                listIterator.set(null);
                for (n2 = list2.size() - 1; n2 >= 0; --n2) {
                    object2 = list2.get(n2);
                    if (n2 <= 0 || tagInfo == null || !tagInfo.isContinueAfter(object2.getName())) continue;
                    object = object2.makeCopy();
                    ((TagNode)((Object)object)).setAutoGenerated(true);
                    listIterator.add((BaseToken)object);
                    listIterator.previous();
                }
                if (!this.getChildBreaks(cleanTimeValues).isEmpty()) {
                    while (tagPos.position < this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                        this.getChildBreaks(cleanTimeValues).pop();
                    }
                }
                while (!this.getChildBreaks(cleanTimeValues).isEmpty() && string.equals(this.getChildBreaks(cleanTimeValues).getLastBreakingTag()) && tagPos.position == this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                    if (list.get(((TagPos)this.getChildBreaks((CleanTimeValues)cleanTimeValues).closedByChildBreak.peek()).position) != null) {
                        n2 = this.getChildBreaks((CleanTimeValues)cleanTimeValues).pop().position;
                        object2 = list.get(n2);
                        if (object2 instanceof TagNode) {
                            this.reopenBrokenNode(listIterator, (TagNode)((Object)object2), cleanTimeValues);
                            continue;
                        }
                        if (!(object2 instanceof List)) continue;
                        object = (List)object2;
                        object = this.flattenNestedList((List)object);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            TagNode tagNode = (TagNode)((Object)iterator.next());
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            listIterator.add((BaseToken)tagNode);
                            this.makeTree(list, list.listIterator(list.size() - 1), cleanTimeValues);
                        }
                        list.set(n2, null);
                        continue;
                    }
                    this.getChildBreaks(cleanTimeValues).pop();
                }
            }
        }
    }

    private void handleStartTagToken(BaseToken baseToken, ListIterator<BaseToken> listIterator, List list, CleanTimeValues cleanTimeValues) {
        Object object;
        Object object2;
        TagNode tagNode = (TagNode)baseToken;
        String string = tagNode.getName();
        TagInfo tagInfo = this.getTagInfo(string, cleanTimeValues);
        TagPos tagPos = this.getOpenTags(cleanTimeValues).isEmpty() ? null : this.getOpenTags(cleanTimeValues).getLastTagPos();
        TagInfo tagInfo2 = tagPos == null ? null : this.getTagInfo(tagPos.name, cleanTimeValues);
        cleanTimeValues.allTags.add(string);
        if (tagInfo != null && tagInfo.getAssumedNamespace() != null && !tagNode.hasAttribute("xmlns")) {
            cleanTimeValues.namespace.push(tagInfo.getAssumedNamespace());
        }
        for (String string2 : tagNode.getAttributes().keySet()) {
            if (string2.toLowerCase().indexOf("xmlns:") == -1) continue;
            object2 = string2.toLowerCase().split("xmlns:")[1];
            object = tagNode.getAttributeByName(string2);
            tagNode.addNamespaceDeclaration(((String)object2).toLowerCase(), (String)object);
            cleanTimeValues.namespaceMap.put(((String)object2).toLowerCase(), object);
        }
        if (tagNode.hasAttribute("xmlns")) {
            String string2;
            string2 = tagNode.getAttributeByName("xmlns");
            if (string2.equals("https://www.w3.org/1999/xhtml") || string2.equals("http://w3.org/1999/xhtml")) {
                string2 = "http://www.w3.org/1999/xhtml";
                object2 = tagNode.getAttributes();
                object2.put("xmlns", "http://www.w3.org/1999/xhtml");
                tagNode.setAttributes((Map<String, String>)object2);
            }
            if ("html".equals(string) && string2.equals("http://www.w3.org/TR/REC-html40")) {
                tagNode.removeAttribute("xmlns");
            } else if (string2.trim().isEmpty()) {
                tagNode.removeAttribute("xmlns");
            } else {
                cleanTimeValues.namespace.push(string2);
                tagNode.addNamespaceDeclaration("", string2);
                cleanTimeValues.namespaceMap.put("", string2);
            }
            if (!this.properties.isNamespacesAware()) {
                tagNode.removeAttribute("xmlns");
            }
        }
        boolean bl = this.properties.isIgnoreAttributesCase();
        if (this.isAllowedAsForeignMarkup(string, cleanTimeValues)) {
            tagNode.setForeignMarkup(true, bl);
        } else {
            tagNode.setForeignMarkup(false, bl);
        }
        string = tagNode.getName();
        if ("html".equals(string)) {
            this.addAttributesToTag(cleanTimeValues.htmlNode, tagNode.getAttributes());
            listIterator.set(null);
            return;
        }
        if ("body".equals(string)) {
            cleanTimeValues._bodyOpened = true;
            this.addAttributesToTag(cleanTimeValues.bodyNode, tagNode.getAttributes());
            listIterator.set(null);
            return;
        }
        if ("head".equals(string)) {
            cleanTimeValues._headOpened = true;
            this.addAttributesToTag(cleanTimeValues.headNode, tagNode.getAttributes());
            listIterator.set(null);
            return;
        }
        if (tagInfo == null && this.properties.isOmitUnknownTags() && !this.isAllowedAsForeignMarkup(string, cleanTimeValues)) {
            listIterator.set(null);
            this.properties.fireUglyHtml(true, tagNode, ErrorType.Unknown);
            return;
        }
        if (tagInfo != null && tagInfo.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
            listIterator.set(null);
            this.properties.fireUglyHtml(true, tagNode, ErrorType.Deprecated);
            return;
        }
        if (tagInfo == null && tagInfo2 != null && !tagInfo2.allowsAnything() && !tagInfo2.allowsItem((BaseToken)tagNode)) {
            this.closeSnippet(list, tagPos, (Object)tagNode, cleanTimeValues);
            listIterator.previous();
            return;
        }
        if (tagInfo != null && tagInfo.hasPermittedTags() && this.getOpenTags(cleanTimeValues).someAlreadyOpen(tagInfo.getPermittedTags())) {
            listIterator.set(null);
            return;
        }
        if (tagInfo != null && tagInfo.isUnique() && this.getOpenTags(cleanTimeValues).tagEncountered(string)) {
            listIterator.set(null);
            this.properties.fireHtmlError(true, tagNode, ErrorType.UniqueTagDuplicated);
            return;
        }
        if (!this.isFatalTagSatisfied(tagInfo, cleanTimeValues)) {
            listIterator.set(null);
            this.properties.fireHtmlError(true, tagNode, ErrorType.FatalTagMissing);
            return;
        }
        if (this.mustAddRequiredParent(tagInfo, cleanTimeValues)) {
            object2 = (String)tagInfo.getRequiredParentTags().iterator().next();
            object = this.newTagNode((String)object2);
            if (this.isAllowedInLastOpenTag((BaseToken)object, cleanTimeValues)) {
                ((TagNode)((Object)object)).setAutoGenerated(true);
                listIterator.previous();
                listIterator.add((BaseToken)object);
                listIterator.previous();
                this.properties.fireHtmlError(true, tagNode, ErrorType.RequiredParentMissing);
            } else {
                this.saveToLastOpenTag(list, baseToken, cleanTimeValues);
                listIterator.set(null);
            }
            return;
        }
        if (tagInfo != null && tagPos != null && tagInfo.isMustCloseTag(tagInfo2)) {
            this.getChildBreaks(cleanTimeValues).addBreak(tagPos, new TagPos(listIterator.previousIndex(), tagInfo.getName(), this.getTagInfo(string, cleanTimeValues), cleanTimeValues));
            boolean bl2 = !tagNode.hasAttribute("id");
            this.properties.fireHtmlError(bl2, (TagNode)((Object)list.get(tagPos.position)), ErrorType.UnpermittedChild);
            object = this.closeSnippet(list, tagPos, (Object)tagNode, cleanTimeValues);
            int n2 = object.size();
            if (tagInfo.hasCopyTags() && n2 > 0) {
                Object object3;
                ListIterator listIterator2 = object.listIterator(n2);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (listIterator2.hasPrevious()) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.handleInterruption();
                        return;
                    }
                    object3 = (TagNode)((Object)listIterator2.previous());
                    if (!tagInfo.isCopy(((TagNode)((Object)object3)).getName())) break;
                    arrayList.add(0, object3);
                }
                if (arrayList.size() > 0) {
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        if (Thread.currentThread().isInterrupted()) {
                            this.handleInterruption();
                            return;
                        }
                        TagNode tagNode2 = (TagNode)((Object)object3.next());
                        if (!HtmlCleaner.isCopiedTokenEqualToNextThreeCopiedTokens(tagNode2, listIterator)) {
                            listIterator.add((BaseToken)tagNode2.makeCopy());
                            continue;
                        }
                        object3.remove();
                    }
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        listIterator.previous();
                    }
                }
            }
            listIterator.previous();
            return;
        }
        if (!this.isAllowedInLastOpenTag(baseToken, cleanTimeValues)) {
            object2 = this.getOpenTags(cleanTimeValues).getLastTagPos();
            if (object2 != null && ((TagPos)object2).info != null && ((TagPos)object2).info.getPreferredChildTag() != null) {
                object = this.newTagNode(((TagPos)object2).info.getPreferredChildTag());
                if (this.isAllowedInLastOpenTag((BaseToken)object, cleanTimeValues) && this.getTagInfo(((TagPos)object2).info.getPreferredChildTag(), cleanTimeValues) != null && this.getTagInfo(((TagPos)object2).info.getPreferredChildTag(), cleanTimeValues).allowsItem(baseToken)) {
                    ((TagNode)((Object)object)).setAutoGenerated(true);
                    listIterator.previous();
                    listIterator.add((BaseToken)object);
                    listIterator.previous();
                    this.properties.fireHtmlError(true, tagNode, ErrorType.RequiredParentMissing);
                } else {
                    this.saveToLastOpenTag(list, baseToken, cleanTimeValues);
                    listIterator.set(null);
                }
            } else {
                this.saveToLastOpenTag(list, baseToken, cleanTimeValues);
                listIterator.set(null);
            }
            return;
        }
        if (tagInfo != null && !tagInfo.allowsBody()) {
            object2 = this.createTagNode(tagNode);
            this.addPossibleHeadCandidate(tagInfo, (TagNode)((Object)object2), cleanTimeValues);
            listIterator.set((BaseToken)object2);
            return;
        }
        this.getOpenTags(cleanTimeValues).addTag(string, this.getTagInfo(string, cleanTimeValues), listIterator.previousIndex(), cleanTimeValues);
    }

    void makeTree(List list, ListIterator<BaseToken> listIterator, CleanTimeValues cleanTimeValues) {
        while (listIterator.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            BaseToken baseToken = listIterator.next();
            if (baseToken instanceof EndTagToken) {
                this.handleEndTagToken(baseToken, listIterator, list, cleanTimeValues);
                continue;
            }
            if (this.isStartToken(baseToken)) {
                this.handleStartTagToken(baseToken, listIterator, list, cleanTimeValues);
                continue;
            }
            if (cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened && this.properties.isKeepWhitespaceAndCommentsInHead()) {
                BaseToken baseToken2;
                ContentNode contentNode;
                if (baseToken instanceof CommentNode) {
                    if (this.getOpenTags(cleanTimeValues).getLastTagPos() == null) {
                        cleanTimeValues._headTags.add(new ProxyTagNode((CommentNode)baseToken, cleanTimeValues.bodyNode));
                    }
                } else if (baseToken instanceof ContentNode && (contentNode = (ContentNode)baseToken).isBlank() && (baseToken2 = (BaseToken)list.get(list.size() - 1)) == baseToken) {
                    cleanTimeValues._headTags.add(new ProxyTagNode(contentNode, cleanTimeValues.bodyNode));
                }
            }
            if (this.isAllowedInLastOpenTag(baseToken, cleanTimeValues)) continue;
            this.saveToLastOpenTag(list, baseToken, cleanTimeValues);
            listIterator.set(null);
        }
    }

    private static boolean isCopiedTokenEqualToNextThreeCopiedTokens(TagNode tagNode, ListIterator<BaseToken> listIterator) {
        int n2 = 0;
        int n3 = 0;
        while (listIterator.hasNext() && n2 < 3) {
            BaseToken baseToken = listIterator.next();
            ++n2;
            if (!(baseToken instanceof TagNode) || !((TagNode)baseToken).isCopy() || !HtmlCleaner.areCopiedTokensEqual((TagNode)baseToken, tagNode)) break;
            ++n3;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            listIterator.previous();
        }
        return n3 == 3;
    }

    private List<TagNode> flattenNestedList(List list) {
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>();
        for (Object e2 : list) {
            if (e2 instanceof TagNode) {
                arrayList.add((TagNode)((Object)e2));
                continue;
            }
            if (!(e2 instanceof List)) continue;
            arrayList.addAll((List)e2);
        }
        return arrayList;
    }

    private static boolean areCopiedTokensEqual(TagNode tagNode, TagNode tagNode2) {
        return tagNode.name.equals(tagNode2.name) && tagNode.getAttributes().equals(tagNode2.getAttributes());
    }

    private void reopenBrokenNode(ListIterator<BaseToken> listIterator, TagNode tagNode, CleanTimeValues cleanTimeValues) {
        TagNode tagNode2 = tagNode;
        TagNode tagNode3 = tagNode2.makeCopy();
        tagNode3.setAutoGenerated(true);
        tagNode3.removeAttribute("id");
        listIterator.add((BaseToken)tagNode3);
        this.getOpenTags(cleanTimeValues).addTag(tagNode2.getName(), this.getTagInfo(tagNode2.getName(), cleanTimeValues), listIterator.previousIndex(), cleanTimeValues);
    }

    protected boolean isRemovingNodeReasonablySafe(TagNode tagNode) {
        return !tagNode.hasAttribute("id") && !tagNode.hasAttribute("name") && !tagNode.hasAttribute("class");
    }

    private void createDocumentNodes(List list, CleanTimeValues cleanTimeValues) {
        TagNode tagNode;
        Object object2;
        for (Object object2 : list) {
            if (object2 == null) continue;
            boolean bl = true;
            if (object2 instanceof TagNode) {
                tagNode = (TagNode)((Object)object2);
                TagInfo tagInfo = this.getTagInfo(tagNode.getName(), cleanTimeValues);
                this.addPossibleHeadCandidate(tagInfo, tagNode, cleanTimeValues);
            } else if (object2 instanceof ContentNode) {
                boolean bl2 = bl = !"".equals(object2.toString());
            }
            if (!bl) continue;
            cleanTimeValues.bodyNode.addChild(object2);
        }
        object2 = cleanTimeValues._headTags.iterator();
        while (object2.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            TagNode tagNode2 = (TagNode)((Object)object2.next());
            boolean bl = true;
            for (tagNode = tagNode2.getParent(); tagNode != null; tagNode = tagNode.getParent()) {
                if (!cleanTimeValues._headTags.contains((Object)tagNode)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            tagNode2.removeFromTree();
            cleanTimeValues.headNode.addChild((Object)tagNode2);
        }
    }

    private List<TagNode> closeSnippet(List list, TagPos tagPos, Object object, CleanTimeValues cleanTimeValues) {
        TagNode tagNode;
        Object object2;
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>();
        ListIterator<Object> listIterator = list.listIterator(tagPos.position);
        TagNode tagNode2 = null;
        boolean bl = false;
        Object e2 = listIterator.next();
        if (this.isStartToken(e2) && (object2 = this.getTagInfo((tagNode = (TagNode)((Object)e2)).getName(), cleanTimeValues)) != null && object2.getAssumedNamespace() != null) {
            bl = true;
        }
        boolean bl2 = false;
        while (object == null && !bl2 || object != null && e2 != object) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return arrayList;
            }
            if (this.isStartToken(e2)) {
                object2 = (TagNode)((Object)e2);
                arrayList.add((TagNode)((Object)object2));
                List<? extends BaseToken> list2 = ((TagNode)((Object)object2)).getItemsToMove();
                if (list2 != null) {
                    this.pushNesting(cleanTimeValues);
                    this.makeTree(list2, list2.listIterator(0), cleanTimeValues);
                    this.closeAll(list2, cleanTimeValues);
                    ((TagNode)((Object)object2)).setItemsToMove(null);
                    this.popNesting(cleanTimeValues);
                }
                TagNode tagNode3 = this.createTagNode((TagNode)((Object)object2));
                TagInfo tagInfo = this.getTagInfo(tagNode3.getName(), cleanTimeValues);
                this.addPossibleHeadCandidate(tagInfo, tagNode3, cleanTimeValues);
                if (tagNode2 != null) {
                    tagNode2.addChildren(list2);
                    tagNode2.addChild((Object)tagNode3);
                    listIterator.set(null);
                } else if (list2 != null) {
                    list2.add((BaseToken)tagNode3);
                    listIterator.set(list2);
                } else {
                    listIterator.set((Object)tagNode3);
                }
                this.getOpenTags(cleanTimeValues).removeTag(tagNode3.getName());
                tagNode2 = tagNode3;
            } else if (tagNode2 != null) {
                listIterator.set(null);
                if (e2 != null) {
                    tagNode2.addChild(e2);
                }
            }
            if (listIterator.hasNext()) {
                e2 = listIterator.next();
                continue;
            }
            bl2 = true;
        }
        if (bl && !cleanTimeValues.namespace.isEmpty()) {
            cleanTimeValues.namespace.pop();
        }
        return arrayList;
    }

    private void closeAll(List list, CleanTimeValues cleanTimeValues) {
        TagPos tagPos = this.getOpenTags(cleanTimeValues).findFirstTagPos();
        for (TagPos tagPos2 : this.getOpenTags((CleanTimeValues)cleanTimeValues).list) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            this.properties.fireHtmlError(true, (TagNode)((Object)list.get(tagPos2.position)), ErrorType.UnclosedTag);
        }
        if (tagPos != null) {
            this.closeSnippet(list, tagPos, null, cleanTimeValues);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened)) {
            cleanTimeValues._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    protected Set<ITagNodeCondition> getPruneTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.pruneTagSet;
    }

    protected Set<ITagNodeCondition> getAllowTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allowTagSet;
    }

    protected void addPruneNode(TagNode tagNode, CleanTimeValues cleanTimeValues) {
        tagNode.setPruned(true);
        cleanTimeValues.pruneNodeSet.add(tagNode);
    }

    public TagInfo getTagInfo(String string, CleanTimeValues cleanTimeValues) {
        String string2;
        TagInfo tagInfo = null;
        tagInfo = this.getTagInfoProvider().getTagInfo(string);
        if (tagInfo != null && tagInfo.getAssumedNamespace() != null && cleanTimeValues.namespace != null && cleanTimeValues.namespace.size() > 0 && (string2 = (String)cleanTimeValues.namespace.peek()) == tagInfo.getAssumedNamespace()) {
            return tagInfo;
        }
        if (!this.isAllowedAsForeignMarkup(string, cleanTimeValues)) {
            return this.getTagInfoProvider().getTagInfo(string);
        }
        return null;
    }

    private boolean addIfNeededToPruneSet(TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (cleanTimeValues.pruneTagSet != null) {
            for (ITagNodeCondition iTagNodeCondition : cleanTimeValues.pruneTagSet) {
                if (!iTagNodeCondition.satisfy(tagNode)) continue;
                this.addPruneNode(tagNode, cleanTimeValues);
                this.properties.fireConditionModification(iTagNodeCondition, tagNode);
                return true;
            }
        }
        if (cleanTimeValues.allowTagSet != null && !cleanTimeValues.allowTagSet.isEmpty()) {
            for (ITagNodeCondition iTagNodeCondition : cleanTimeValues.allowTagSet) {
                if (!iTagNodeCondition.satisfy(tagNode)) continue;
                return false;
            }
            if (!tagNode.isAutoGenerated()) {
                this.properties.fireUserDefinedModification(true, tagNode, ErrorType.NotAllowedTag);
            }
            this.addPruneNode(tagNode, cleanTimeValues);
            return true;
        }
        return false;
    }

    protected Set<String> getAllTags(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.properties.getTagInfoProvider();
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public String getInnerHtml(TagNode tagNode) {
        if (tagNode != null) {
            String string = new SimpleXmlSerializer(this.properties).getAsString(tagNode);
            int n2 = string.indexOf("<" + tagNode.getName());
            n2 = string.indexOf(62, n2 + 1);
            int n3 = string.lastIndexOf(60);
            return n2 >= 0 && n2 <= n3 ? string.substring(n2 + 1, n3) : null;
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode tagNode, String string) {
        if (tagNode != null) {
            Object object;
            String string2 = tagNode.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(string2).append(" htmlcleaner_marker=''>").append(string).append("</").append(string2).append(">");
            for (TagNode tagNode2 = tagNode.getParent(); tagNode2 != null; tagNode2 = tagNode2.getParent()) {
                object = tagNode2.getName();
                stringBuilder.insert(0, "<" + object + ">");
                stringBuilder.append("</").append((String)object).append(">");
            }
            object = this.clean(stringBuilder.toString());
            TagNode tagNode3 = ((TagNode)((Object)object)).findElementHavingAttribute(MARKER_ATTRIBUTE, true);
            if (tagNode3 != null) {
                tagNode.setChildren(tagNode3.getAllChildren());
            }
        }
    }

    public void initCleanerTransformations(Map map) {
        this.transformations = new CleanerTransformations(map);
    }

    private OpenTags getOpenTags(CleanTimeValues cleanTimeValues) {
        return ((NestingState)cleanTimeValues.nestingStates.peek()).getOpenTags();
    }

    private ChildBreaks getChildBreaks(CleanTimeValues cleanTimeValues) {
        return ((NestingState)cleanTimeValues.nestingStates.peek()).getChildBreaks();
    }

    private NestingState pushNesting(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.push(new NestingState(new OpenTags(this), new ChildBreaks()));
    }

    private NestingState popNesting(CleanTimeValues cleanTimeValues) {
        return (NestingState)cleanTimeValues.nestingStates.pop();
    }

    protected void handleInterruption() {
    }
}

