/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pdf.PDFPainter;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderMP4
extends AbstractImagePreloader {
    private static final Log LOG = LogFactory.getLog(PDFPainter.class);
    private static final Set<String> TYPES = new HashSet<String>(Arrays.asList("ftyp", "mdat", "moov", "pnot", "udta", "uuid", "moof", "free", "skip", "jP2 ", "wide", "load", "ctab", "imap", "matt", "kmat", "clip", "crgn", "sync", "chap", "tmcd", "scpt", "ssrc", "PICT"));
    private static final Map<String, String> SUBTYPES = new HashMap<String, String>(){
        {
            this.put("3g2a", "video/3gpp2");
            this.put("3g2b", "video/3gpp2");
            this.put("3g2c", "video/3gpp2");
            this.put("3ge6", "video/3gpp");
            this.put("3ge7", "video/3gpp");
            this.put("3gg6", "video/3gpp");
            this.put("3gp1", "video/3gpp");
            this.put("3gp2", "video/3gpp");
            this.put("3gp3", "video/3gpp");
            this.put("3gp4", "video/3gpp");
            this.put("3gp5", "video/3gpp");
            this.put("3gp6", "video/3gpp");
            this.put("3gp6", "video/3gpp");
            this.put("3gp6", "video/3gpp");
            this.put("3gs7", "video/3gpp");
            this.put("avc1", "video/mp4");
            this.put("F4V", "video/mp4");
            this.put("F4P", "video/mp4");
            this.put("iso2", "video/mp4");
            this.put("isom", "video/mp4");
            this.put("KDDI", "video/3gpp2");
            this.put("M4V ", "video/x-m4v");
            this.put("M4VH", "video/x-m4v");
            this.put("M4VP", "video/x-m4v");
            this.put("mmp4", "video/mp4");
            this.put("mp41", "video/mp4");
            this.put("mp42", "video/mp4");
            this.put("mqt", "video/quicktime");
            this.put("NDSC", "video/mp4");
            this.put("NDSH", "video/mp4");
            this.put("NDSM", "video/mp4");
            this.put("NDSP", "video/mp4");
            this.put("NDSS", "video/mp4");
            this.put("NDXC", "video/mp4");
            this.put("NDXH", "video/mp4");
            this.put("NDXM", "video/mp4");
            this.put("NDXP", "video/mp4");
            this.put("NDXS", "video/mp4");
            this.put("qt  ", "video/quicktime");
        }
    };
    private byte[] lastTkhd;
    private static final Set<String> CONTAINERS = new HashSet<String>(Arrays.asList("moov", "mdia", "trak"));
    private static final String HANDLER_REFERENCE_ATOM = "hdlr";
    private static final String TRACK_HEADER_ATOM = "tkhd";

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws ImageException, IOException {
        boolean bl;
        if (!ImageUtil.hasImageInputStream((Source)source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream((Source)source);
        byte[] byArray = this.getHeader(imageInputStream, 12);
        String string2 = this.readString(byArray, 4);
        String string3 = this.readString(byArray, 8);
        boolean bl2 = bl = TYPES.contains(string2) && SUBTYPES.containsKey(string3);
        if (bl) {
            ImageInfo imageInfo = new ImageInfo(string, SUBTYPES.get(string3));
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        if (!TYPES.contains(string2)) {
            LOG.debug((Object)("Unknow MP4 Type: " + string2));
        }
        if (!SUBTYPES.containsKey(string3)) {
            LOG.debug((Object)("Unknow MP4 Subtype: " + string3));
        }
        return null;
    }

    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) throws IOException {
        imageInputStream.mark();
        ImageSize imageSize = new ImageSize();
        imageSize.setResolution((double)imageContext.getSourceResolution());
        this.findSize(imageInputStream, imageSize);
        imageSize.calcSizeFromPixels();
        imageInputStream.reset();
        return imageSize;
    }

    private void findSize(ImageInputStream imageInputStream, ImageSize imageSize) throws IOException {
        byte[] byArray = new byte[8];
        imageInputStream.read(byArray);
        long l2 = this.readUint32(byArray, 0);
        String string = this.readString(byArray, 4);
        if (CONTAINERS.contains(string)) {
            this.findSize(imageInputStream, imageSize);
        } else if (string.equals(TRACK_HEADER_ATOM)) {
            this.lastTkhd = new byte[(int)(l2 - 8L)];
            imageInputStream.read(this.lastTkhd);
            this.findSize(imageInputStream, imageSize);
        } else if (string.equals(HANDLER_REFERENCE_ATOM)) {
            byte[] byArray2 = new byte[(int)(l2 - 8L)];
            imageInputStream.read(byArray2);
            if (byArray2[8] == 118 && byArray2[9] == 105 && byArray2[10] == 100 && byArray2[11] == 101) {
                imageSize.setSizeInPixels(this.readFixedPoint1616(this.lastTkhd, this.lastTkhd.length - 8), this.readFixedPoint1616(this.lastTkhd, this.lastTkhd.length - 4));
            }
        } else {
            imageInputStream.skipBytes(l2 - 8L);
            this.findSize(imageInputStream, imageSize);
        }
    }

    private String readString(byte[] byArray, int n2) {
        return new String(byArray, n2, 4);
    }

    private int readUint32(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    private int readFixedPoint1616(byte[] byArray, int n2) {
        return this.readUint32(byArray, n2) / 65536;
    }
}

