/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.util.ColorWithFallback;
import org.apache.fop.util.OCAColor;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfile;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfileParser;

public final class ColorUtil {
    public static final String CMYK_PSEUDO_PROFILE = "#CMYK";
    public static final String SEPARATION_PSEUDO_PROFILE = "#Separation";
    public static final String ALPHA_PSEUDO_PROFILE = "#alpha";
    private static Map<String, Color> colorMap;
    private static final Log log;

    private ColorUtil() {
    }

    public static Color parseColorString(FOUserAgent fOUserAgent, String string) throws PropertyException {
        if (string == null) {
            return null;
        }
        Color color = colorMap.get(string.toLowerCase());
        if (color == null) {
            if (string.startsWith("#")) {
                color = ColorUtil.parseWithHash(string);
            } else if (string.startsWith("rgb(")) {
                color = ColorUtil.parseAsRGB(string);
            } else if (string.startsWith("rgba(")) {
                color = ColorUtil.parseAsRGBA(string);
            } else {
                if (string.startsWith("url(")) {
                    throw new PropertyException("Colors starting with url( are not yet supported!");
                }
                if (string.startsWith("java.awt.Color")) {
                    color = ColorUtil.parseAsJavaAWTColor(string);
                } else if (string.startsWith("system-color(")) {
                    color = ColorUtil.parseAsSystemColor(string);
                } else if (string.startsWith("fop-rgb-icc")) {
                    color = ColorUtil.parseAsFopRgbIcc(fOUserAgent, string);
                } else if (string.startsWith("fop-rgb-named-color")) {
                    color = ColorUtil.parseAsFopRgbNamedColor(fOUserAgent, string);
                } else if (string.startsWith("cie-lab-color")) {
                    color = ColorUtil.parseAsCIELabColor(fOUserAgent, string);
                } else if (string.startsWith("cmyk")) {
                    color = ColorUtil.parseAsCMYK(string);
                } else if (string.startsWith("oca")) {
                    color = ColorUtil.parseAsOCA(string);
                }
            }
            if (color == null) {
                throw new PropertyException("Unknown Color: " + string);
            }
            colorMap.put(string, color);
        }
        return color;
    }

    private static Color parseAsSystemColor(String string) throws PropertyException {
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 == -1 || n3 == -1) {
            throw new PropertyException("Unknown color format: " + string + ". Must be system-color(x)");
        }
        string = string.substring(n2 + 1, n3);
        return colorMap.get(string);
    }

    private static Color parseAsJavaAWTColor(String string) throws PropertyException {
        float f2;
        float f3;
        float f4;
        block5: {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            int n2 = string.indexOf("[");
            int n3 = string.indexOf("]");
            try {
                if (n2 != -1 && n3 != -1) {
                    String[] stringArray = (string = string.substring(n2 + 1, n3)).split(",");
                    if (stringArray.length != 3) {
                        throw new PropertyException("Invalid number of arguments for a java.awt.Color: " + string);
                    }
                    f4 = Float.parseFloat(stringArray[0].trim().substring(2)) / 255.0f;
                    f3 = Float.parseFloat(stringArray[1].trim().substring(2)) / 255.0f;
                    f2 = Float.parseFloat(stringArray[2].trim().substring(2)) / 255.0f;
                    if ((double)f4 < 0.0 || (double)f4 > 1.0 || (double)f3 < 0.0 || (double)f3 > 1.0 || (double)f2 < 0.0 || (double)f2 > 1.0) {
                        throw new PropertyException("Color values out of range");
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Invalid format for a java.awt.Color: " + string);
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        }
        return new Color(f4, f3, f2);
    }

    private static Color parseAsRGB(String string) throws PropertyException {
        Color color;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            string = string.substring(n2 + 1, n3);
            try {
                String[] stringArray = string.split(",");
                if (stringArray.length != 3) {
                    throw new PropertyException("Invalid number of arguments: rgb(" + string + ")");
                }
                float f2 = ColorUtil.parseComponent255(stringArray[0], string);
                float f3 = ColorUtil.parseComponent255(stringArray[1], string);
                float f4 = ColorUtil.parseComponent255(stringArray[2], string);
                int n4 = (int)((double)(f2 * 255.0f) + 0.5);
                int n5 = (int)((double)(f3 * 255.0f) + 0.5);
                int n6 = (int)((double)(f4 * 255.0f) + 0.5);
                color = new Color(n4, n5, n6);
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be rgb(r,g,b)");
        }
        return color;
    }

    private static Color parseAsRGBA(String string) throws PropertyException {
        Color color;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            string = string.substring(n2 + 1, n3);
            try {
                String[] stringArray = string.split(",");
                if (stringArray.length != 4) {
                    throw new PropertyException("Invalid number of arguments: rgba(" + string + ")");
                }
                float f2 = ColorUtil.parseComponent255(stringArray[0], string);
                float f3 = ColorUtil.parseComponent255(stringArray[1], string);
                float f4 = ColorUtil.parseComponent255(stringArray[2], string);
                float f5 = Float.parseFloat(stringArray[3]);
                if (f5 > 1.0f && f5 <= 255.0f) {
                    f5 = ColorUtil.parseComponent255(stringArray[3], string);
                }
                int n4 = (int)((double)(f2 * 255.0f) + 0.5);
                int n5 = (int)((double)(f3 * 255.0f) + 0.5);
                int n6 = (int)((double)(f4 * 255.0f) + 0.5);
                int n7 = (int)((double)(f5 * 255.0f) + 0.5);
                color = new Color(n4, n5, n6, n7);
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be rgba(r,g,b,a)");
        }
        return color;
    }

    private static float parseComponent255(String string, String string2) throws PropertyException {
        float f2 = (string = string.trim()).endsWith("%") ? Float.parseFloat(string.substring(0, string.length() - 1)) / 100.0f : Float.parseFloat(string) / 255.0f;
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            throw new PropertyException("Color value out of range for " + string2 + ": " + string + ". Valid range: [0..255] or [0%..100%]");
        }
        return f2;
    }

    private static float parseComponent1(String string, String string2) throws PropertyException {
        return ColorUtil.parseComponent(string, 0.0f, 1.0f, string2);
    }

    private static float parseComponent(String string, float f2, float f3, String string2) throws PropertyException {
        float f4 = Float.parseFloat(string.trim());
        if (f4 < f2 || f4 > f3) {
            throw new PropertyException("Color value out of range for " + string2 + ": " + string + ". Valid range: [" + f2 + ".." + f3 + "]");
        }
        return f4;
    }

    private static Color parseFallback(ListIterator<String> listIterator, String string) throws PropertyException {
        float f2 = ColorUtil.parseComponent1(listIterator.next(), string);
        float f3 = ColorUtil.parseComponent1(listIterator.next(), string);
        float f4 = ColorUtil.parseComponent1(listIterator.next(), string);
        float f5 = 1.0f;
        if (ALPHA_PSEUDO_PROFILE.equals(listIterator.next())) {
            f5 = ColorUtil.parseComponent1(listIterator.next(), string);
        } else {
            listIterator.previous();
        }
        Color color = new Color(f2, f3, f4, f5);
        return color;
    }

    private static Color parseWithHash(String string) throws PropertyException {
        Color color;
        try {
            int n2 = string.length();
            int n3 = n2 == 5 || n2 == 9 ? Integer.parseInt(string.substring(n2 == 5 ? 3 : 7), 16) : 255;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n2 == 4 || n2 == 5) {
                n4 = Integer.parseInt(string.substring(1, 2), 16) * 17;
                n5 = Integer.parseInt(string.substring(2, 3), 16) * 17;
                n6 = Integer.parseInt(string.substring(3, 4), 16) * 17;
            } else if (n2 == 7 || n2 == 9) {
                n4 = Integer.parseInt(string.substring(1, 3), 16);
                n5 = Integer.parseInt(string.substring(3, 5), 16);
                n6 = Integer.parseInt(string.substring(5, 7), 16);
            } else {
                throw new NumberFormatException();
            }
            color = new Color(n4, n5, n6, n3);
        }
        catch (RuntimeException runtimeException) {
            throw new PropertyException("Unknown color format: " + string + ". Must be #RGB. #RGBA, #RRGGBB, or #RRGGBBAA");
        }
        return color;
    }

    private static Color parseAsFopRgbIcc(FOUserAgent fOUserAgent, String string) throws PropertyException {
        Color color;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            String[] stringArray = string.substring(n2 + 1, n3).split(",");
            try {
                Object object;
                if (stringArray.length < 5) {
                    throw new PropertyException("Too few arguments for rgb-icc() function");
                }
                ListIterator<String> listIterator = Arrays.asList(stringArray).listIterator();
                Color color2 = ColorUtil.parseFallback(listIterator, string);
                String string2 = listIterator.next().trim();
                if (string2.equals("")) {
                    throw new PropertyException("ICC profile name missing");
                }
                Object object2 = null;
                String string3 = null;
                String string4 = listIterator.next();
                String string5 = listIterator.next();
                if (ColorUtil.isPseudoProfile(string2)) {
                    if (CMYK_PSEUDO_PROFILE.equalsIgnoreCase(string2)) {
                        object2 = ColorSpaces.getDeviceCMYKColorSpace();
                    } else if (SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(string2)) {
                        object2 = new NamedColorSpace(string5, color2, SEPARATION_PSEUDO_PROFILE, null);
                    } else assert (false) : "Incomplete implementation";
                } else {
                    string3 = string4.trim();
                    if (string3.equals("")) {
                        throw new PropertyException("ICC profile source missing");
                    }
                    string3 = ColorUtil.unescapeString(string3);
                }
                if (!(object2 instanceof NamedColorSpace)) {
                    listIterator.previous();
                }
                float[] fArray = ColorUtil.getICCComponents(listIterator);
                if (object2 instanceof NamedColorSpace && fArray.length == 0) {
                    fArray = new float[]{1.0f};
                }
                if (fOUserAgent != null && string3 != null) {
                    object = RenderingIntent.AUTO;
                    object2 = fOUserAgent.getColorSpaceCache().get(string2, string3, object);
                }
                if (object2 != null) {
                    if (ColorSpaces.isDeviceColorSpace((ColorSpace)object2)) {
                        object = color2.getRGBComponents(null);
                        Color color3 = new Color((ColorSpace)object2, fArray, (float)object[3]);
                        color = new ColorWithAlternatives((float)object[0], (float)object[1], (float)object[2], (float)object[3], new Color[]{color3});
                    }
                    color = new ColorWithFallback((ColorSpace)object2, fArray, 1.0f, null, color2);
                }
                log.warn((Object)("Color profile '" + string3 + "' not found. Using sRGB replacement values."));
                color = color2;
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be fop-rgb-icc(r,g,b,NCNAME,src,....)");
        }
        return color;
    }

    private static float[] getICCComponents(ListIterator<String> listIterator) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (listIterator.hasNext()) {
            arrayList.add(Float.valueOf(Float.parseFloat(listIterator.next().trim())));
        }
        float[] fArray = new float[arrayList.size()];
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            float f2;
            fArray[n2] = f2 = ((Float)iterator.next()).floatValue();
            ++n2;
        }
        return fArray;
    }

    private static Color parseAsFopRgbNamedColor(FOUserAgent fOUserAgent, String string) throws PropertyException {
        Color color;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            String[] stringArray = string.substring(n2 + 1, n3).split(",");
            try {
                Object object;
                if (stringArray.length != 6) {
                    throw new PropertyException("rgb-named-color() function must have 6 arguments");
                }
                Color color2 = ColorUtil.parseFallback(Arrays.asList(stringArray).listIterator(), string);
                String string2 = stringArray[3].trim();
                if (string2 == null || "".equals(string2)) {
                    throw new PropertyException("ICC profile name missing");
                }
                ICC_ColorSpace iCC_ColorSpace = null;
                if (ColorUtil.isPseudoProfile(string2)) {
                    throw new IllegalArgumentException("Pseudo-profiles are not allowed with fop-rgb-named-color()");
                }
                String string3 = stringArray[4].trim();
                if (string3 == null || "".equals(string3)) {
                    throw new PropertyException("ICC profile source missing");
                }
                string3 = ColorUtil.unescapeString(string3);
                String string4 = ColorUtil.unescapeString(stringArray[5].trim());
                if (fOUserAgent != null && string3 != null) {
                    object = RenderingIntent.AUTO;
                    iCC_ColorSpace = (ICC_ColorSpace)fOUserAgent.getColorSpaceCache().get(string2, string3, object);
                }
                if (iCC_ColorSpace != null) {
                    object = iCC_ColorSpace.getProfile();
                    if (NamedColorProfileParser.isNamedColorProfile((ICC_Profile)object)) {
                        NamedColorProfileParser namedColorProfileParser = new NamedColorProfileParser();
                        NamedColorProfile namedColorProfile = namedColorProfileParser.parseProfile((ICC_Profile)object, string2, string3);
                        NamedColorSpace namedColorSpace = namedColorProfile.getNamedColor(string4);
                        if (namedColorSpace != null) {
                            color = new ColorWithFallback((ColorSpace)namedColorSpace, new float[]{1.0f}, 1.0f, null, color2);
                        }
                        log.warn((Object)("Color '" + string4 + "' does not exist in named color profile: " + string3));
                        color = color2;
                    }
                    log.warn((Object)("ICC profile is no named color profile: " + string3));
                    color = color2;
                }
                log.warn((Object)("Color profile '" + string3 + "' not found. Using sRGB replacement values."));
                color = color2;
            }
            catch (IOException iOException) {
                throw new PropertyException((Exception)iOException);
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be fop-rgb-named-color(r,g,b,NCNAME,src,color-name)");
        }
        return color;
    }

    private static Color parseAsCIELabColor(FOUserAgent fOUserAgent, String string) throws PropertyException {
        ColorWithFallback colorWithFallback;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            try {
                String[] stringArray = string.substring(n2 + 1, n3).split(",");
                if (stringArray.length != 6) {
                    throw new PropertyException("cie-lab-color() function must have 6 arguments");
                }
                float f2 = ColorUtil.parseComponent255(stringArray[0], string);
                float f3 = ColorUtil.parseComponent255(stringArray[1], string);
                float f4 = ColorUtil.parseComponent255(stringArray[2], string);
                Color color = new Color(f2, f3, f4);
                float f5 = ColorUtil.parseComponent(stringArray[3], 0.0f, 100.0f, string);
                float f6 = ColorUtil.parseComponent(stringArray[4], -127.0f, 127.0f, string);
                float f7 = ColorUtil.parseComponent(stringArray[5], -127.0f, 127.0f, string);
                CIELabColorSpace cIELabColorSpace = ColorSpaces.getCIELabColorSpaceD50();
                Color color2 = cIELabColorSpace.toColor(f5, f6, f7, 1.0f);
                colorWithFallback = new ColorWithFallback(color2, color);
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be cie-lab-color(r,g,b,Lightness,a-value,b-value)");
        }
        return colorWithFallback;
    }

    private static String unescapeString(String string) {
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"") || string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static Color parseAsCMYK(String string) throws PropertyException {
        ColorWithAlternatives colorWithAlternatives;
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            string = string.substring(n2 + 1, n3);
            String[] stringArray = string.split(",");
            try {
                if (stringArray.length != 4) {
                    throw new PropertyException("Invalid number of arguments: cmyk(" + string + ")");
                }
                float f2 = ColorUtil.parseComponent1(stringArray[0], string);
                float f3 = ColorUtil.parseComponent1(stringArray[1], string);
                float f4 = ColorUtil.parseComponent1(stringArray[2], string);
                float f5 = ColorUtil.parseComponent1(stringArray[3], string);
                float[] fArray = new float[]{f2, f3, f4, f5};
                Color color = DeviceCMYKColorSpace.createCMYKColor((float[])fArray);
                float[] fArray2 = color.getRGBColorComponents(null);
                colorWithAlternatives = new ColorWithAlternatives(fArray2[0], fArray2[1], fArray2[2], new Color[]{color});
            }
            catch (RuntimeException runtimeException) {
                throw new PropertyException((Exception)runtimeException);
            }
        } else {
            throw new PropertyException("Unknown color format: " + string + ". Must be cmyk(c,m,y,k)");
        }
        return colorWithAlternatives;
    }

    private static Color parseAsOCA(String string) throws PropertyException {
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        if (n2 != -1 && n3 != -1) {
            OCAColor.OCAColorValue oCAColorValue;
            if ((string = string.substring(n2 + 1, n3)).equals("blue")) {
                oCAColorValue = OCAColor.OCAColorValue.BLUE;
            } else if (string.equals("red")) {
                oCAColorValue = OCAColor.OCAColorValue.RED;
            } else if (string.equals("magenta")) {
                oCAColorValue = OCAColor.OCAColorValue.MAGENTA;
            } else if (string.equals("green")) {
                oCAColorValue = OCAColor.OCAColorValue.GREEN;
            } else if (string.equals("cyan")) {
                oCAColorValue = OCAColor.OCAColorValue.CYAN;
            } else if (string.equals("yellow")) {
                oCAColorValue = OCAColor.OCAColorValue.YELLOW;
            } else if (string.equals("black")) {
                oCAColorValue = OCAColor.OCAColorValue.BLACK;
            } else if (string.equals("brown")) {
                oCAColorValue = OCAColor.OCAColorValue.BROWN;
            } else if (string.equals("medium-color")) {
                oCAColorValue = OCAColor.OCAColorValue.MEDIUM_COLOR;
            } else if (string.equals("device-default")) {
                oCAColorValue = OCAColor.OCAColorValue.DEVICE_DEFAULT;
            } else {
                throw new PropertyException("Unknwon OCA color: " + string);
            }
            return new OCAColor(oCAColorValue);
        }
        throw new PropertyException("Unknown color format: " + string + ". Must be oca(color-name)");
    }

    public static String colorToString(Color color) {
        ColorSpace colorSpace = color.getColorSpace();
        if (color instanceof ColorWithAlternatives) {
            return ColorUtil.toFunctionCall((ColorWithAlternatives)color);
        }
        if (colorSpace != null && colorSpace.getType() == 9) {
            StringBuffer stringBuffer = new StringBuffer(24);
            float[] fArray = color.getColorComponents(null);
            stringBuffer.append("cmyk(").append(fArray[0]).append(",").append(fArray[1]).append(",").append(fArray[2]).append(",").append(fArray[3]).append(")");
            return stringBuffer.toString();
        }
        return ColorUtil.toRGBFunctionCall(color);
    }

    private static String toRGBFunctionCall(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#');
        String string = Integer.toHexString(color.getRed());
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = Integer.toHexString(color.getGreen());
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        string = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        if (color.getAlpha() != 255) {
            string = Integer.toHexString(color.getAlpha());
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static Color getsRGBFallback(ColorWithAlternatives colorWithAlternatives) {
        Color color;
        if (colorWithAlternatives instanceof ColorWithFallback) {
            color = ((ColorWithFallback)colorWithAlternatives).getFallbackColor();
            if (!color.getColorSpace().isCS_sRGB()) {
                color = ColorUtil.toSRGBColor(color);
            }
        } else {
            color = ColorUtil.toSRGBColor((Color)colorWithAlternatives);
        }
        return color;
    }

    private static Color toSRGBColor(Color color) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        float[] fArray = color.getRGBColorComponents(null);
        float[] fArray2 = color.getComponents(null);
        float f2 = fArray2[fArray2.length - 1];
        return new Color(colorSpace, fArray, f2);
    }

    private static String toFunctionCall(ColorWithAlternatives colorWithAlternatives) {
        String string;
        Object object;
        ColorSpace colorSpace = colorWithAlternatives.getColorSpace();
        if (colorSpace.isCS_sRGB() && !colorWithAlternatives.hasAlternativeColors()) {
            return ColorUtil.toRGBFunctionCall((Color)colorWithAlternatives);
        }
        if (colorSpace instanceof CIELabColorSpace) {
            return ColorUtil.toCIELabFunctionCall(colorWithAlternatives);
        }
        Object object2 = colorWithAlternatives;
        if (colorWithAlternatives.hasAlternativeColors() && ColorSpaces.isDeviceColorSpace((ColorSpace)((Color)(object = colorWithAlternatives.getAlternativeColors()[0])).getColorSpace())) {
            colorSpace = ((Color)object).getColorSpace();
            object2 = object;
        }
        object = ColorSpaces.getColorSpaceOrigin((ColorSpace)colorSpace);
        Color color = ColorUtil.getsRGBFallback(colorWithAlternatives);
        float[] fArray = color.getComponents(null);
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("(");
        stringBuilder.append(fArray[0]).append(",");
        stringBuilder.append(fArray[1]).append(",");
        stringBuilder.append(fArray[2]).append(",");
        if (fArray[3] != 1.0f) {
            stringBuilder.append("#alpha,").append(fArray[3]).append(",");
        }
        String string2 = object.getProfileName();
        stringBuilder.append(string2).append(",");
        if (object.getProfileURI() != null) {
            stringBuilder.append("\"").append(object.getProfileURI()).append("\"");
        }
        if (colorSpace instanceof NamedColorSpace) {
            NamedColorSpace namedColorSpace = (NamedColorSpace)colorSpace;
            string = SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(string2) ? "fop-rgb-icc" : "fop-rgb-named-color";
            stringBuilder.append(",").append(namedColorSpace.getColorName());
        } else {
            float[] fArray2;
            string = "fop-rgb-icc";
            for (float f2 : fArray2 = ((Color)object2).getColorComponents(null)) {
                stringBuilder.append(",");
                stringBuilder.append(f2);
            }
        }
        stringBuilder.append(")");
        return string + stringBuilder;
    }

    private static String toCIELabFunctionCall(ColorWithAlternatives colorWithAlternatives) {
        Color color = ColorUtil.getsRGBFallback(colorWithAlternatives);
        StringBuffer stringBuffer = new StringBuffer("cie-lab-color(");
        stringBuffer.append(color.getRed()).append(',');
        stringBuffer.append(color.getGreen()).append(',');
        stringBuffer.append(color.getBlue());
        CIELabColorSpace cIELabColorSpace = (CIELabColorSpace)colorWithAlternatives.getColorSpace();
        float[] fArray = cIELabColorSpace.toNativeComponents(colorWithAlternatives.getColorComponents(null));
        for (int i2 = 0; i2 < 3; ++i2) {
            stringBuffer.append(',').append(fArray[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static Color createColor(int n2, int n3, int n4) {
        return new Color(n2, n3, n4);
    }

    private static void initializeColorMap() {
        colorMap = Collections.synchronizedMap(new HashMap());
        colorMap.put("aliceblue", ColorUtil.createColor(240, 248, 255));
        colorMap.put("antiquewhite", ColorUtil.createColor(250, 235, 215));
        colorMap.put("aqua", ColorUtil.createColor(0, 255, 255));
        colorMap.put("aquamarine", ColorUtil.createColor(127, 255, 212));
        colorMap.put("azure", ColorUtil.createColor(240, 255, 255));
        colorMap.put("beige", ColorUtil.createColor(245, 245, 220));
        colorMap.put("bisque", ColorUtil.createColor(255, 228, 196));
        colorMap.put("black", ColorUtil.createColor(0, 0, 0));
        colorMap.put("blanchedalmond", ColorUtil.createColor(255, 235, 205));
        colorMap.put("blue", ColorUtil.createColor(0, 0, 255));
        colorMap.put("blueviolet", ColorUtil.createColor(138, 43, 226));
        colorMap.put("brown", ColorUtil.createColor(165, 42, 42));
        colorMap.put("burlywood", ColorUtil.createColor(222, 184, 135));
        colorMap.put("cadetblue", ColorUtil.createColor(95, 158, 160));
        colorMap.put("chartreuse", ColorUtil.createColor(127, 255, 0));
        colorMap.put("chocolate", ColorUtil.createColor(210, 105, 30));
        colorMap.put("coral", ColorUtil.createColor(255, 127, 80));
        colorMap.put("cornflowerblue", ColorUtil.createColor(100, 149, 237));
        colorMap.put("cornsilk", ColorUtil.createColor(255, 248, 220));
        colorMap.put("crimson", ColorUtil.createColor(220, 20, 60));
        colorMap.put("cyan", ColorUtil.createColor(0, 255, 255));
        colorMap.put("darkblue", ColorUtil.createColor(0, 0, 139));
        colorMap.put("darkcyan", ColorUtil.createColor(0, 139, 139));
        colorMap.put("darkgoldenrod", ColorUtil.createColor(184, 134, 11));
        colorMap.put("darkgray", ColorUtil.createColor(169, 169, 169));
        colorMap.put("darkgreen", ColorUtil.createColor(0, 100, 0));
        colorMap.put("darkgrey", ColorUtil.createColor(169, 169, 169));
        colorMap.put("darkkhaki", ColorUtil.createColor(189, 183, 107));
        colorMap.put("darkmagenta", ColorUtil.createColor(139, 0, 139));
        colorMap.put("darkolivegreen", ColorUtil.createColor(85, 107, 47));
        colorMap.put("darkorange", ColorUtil.createColor(255, 140, 0));
        colorMap.put("darkorchid", ColorUtil.createColor(153, 50, 204));
        colorMap.put("darkred", ColorUtil.createColor(139, 0, 0));
        colorMap.put("darksalmon", ColorUtil.createColor(233, 150, 122));
        colorMap.put("darkseagreen", ColorUtil.createColor(143, 188, 143));
        colorMap.put("darkslateblue", ColorUtil.createColor(72, 61, 139));
        colorMap.put("darkslategray", ColorUtil.createColor(47, 79, 79));
        colorMap.put("darkslategrey", ColorUtil.createColor(47, 79, 79));
        colorMap.put("darkturquoise", ColorUtil.createColor(0, 206, 209));
        colorMap.put("darkviolet", ColorUtil.createColor(148, 0, 211));
        colorMap.put("deeppink", ColorUtil.createColor(255, 20, 147));
        colorMap.put("deepskyblue", ColorUtil.createColor(0, 191, 255));
        colorMap.put("dimgray", ColorUtil.createColor(105, 105, 105));
        colorMap.put("dimgrey", ColorUtil.createColor(105, 105, 105));
        colorMap.put("dodgerblue", ColorUtil.createColor(30, 144, 255));
        colorMap.put("firebrick", ColorUtil.createColor(178, 34, 34));
        colorMap.put("floralwhite", ColorUtil.createColor(255, 250, 240));
        colorMap.put("forestgreen", ColorUtil.createColor(34, 139, 34));
        colorMap.put("fuchsia", ColorUtil.createColor(255, 0, 255));
        colorMap.put("gainsboro", ColorUtil.createColor(220, 220, 220));
        colorMap.put("ghostwhite", ColorUtil.createColor(248, 248, 255));
        colorMap.put("gold", ColorUtil.createColor(255, 215, 0));
        colorMap.put("goldenrod", ColorUtil.createColor(218, 165, 32));
        colorMap.put("gray", ColorUtil.createColor(128, 128, 128));
        colorMap.put("green", ColorUtil.createColor(0, 128, 0));
        colorMap.put("greenyellow", ColorUtil.createColor(173, 255, 47));
        colorMap.put("grey", ColorUtil.createColor(128, 128, 128));
        colorMap.put("honeydew", ColorUtil.createColor(240, 255, 240));
        colorMap.put("hotpink", ColorUtil.createColor(255, 105, 180));
        colorMap.put("indianred", ColorUtil.createColor(205, 92, 92));
        colorMap.put("indigo", ColorUtil.createColor(75, 0, 130));
        colorMap.put("ivory", ColorUtil.createColor(255, 255, 240));
        colorMap.put("khaki", ColorUtil.createColor(240, 230, 140));
        colorMap.put("lavender", ColorUtil.createColor(230, 230, 250));
        colorMap.put("lavenderblush", ColorUtil.createColor(255, 240, 245));
        colorMap.put("lawngreen", ColorUtil.createColor(124, 252, 0));
        colorMap.put("lemonchiffon", ColorUtil.createColor(255, 250, 205));
        colorMap.put("lightblue", ColorUtil.createColor(173, 216, 230));
        colorMap.put("lightcoral", ColorUtil.createColor(240, 128, 128));
        colorMap.put("lightcyan", ColorUtil.createColor(224, 255, 255));
        colorMap.put("lightgoldenrodyellow", ColorUtil.createColor(250, 250, 210));
        colorMap.put("lightgray", ColorUtil.createColor(211, 211, 211));
        colorMap.put("lightgreen", ColorUtil.createColor(144, 238, 144));
        colorMap.put("lightgrey", ColorUtil.createColor(211, 211, 211));
        colorMap.put("lightpink", ColorUtil.createColor(255, 182, 193));
        colorMap.put("lightsalmon", ColorUtil.createColor(255, 160, 122));
        colorMap.put("lightseagreen", ColorUtil.createColor(32, 178, 170));
        colorMap.put("lightskyblue", ColorUtil.createColor(135, 206, 250));
        colorMap.put("lightslategray", ColorUtil.createColor(119, 136, 153));
        colorMap.put("lightslategrey", ColorUtil.createColor(119, 136, 153));
        colorMap.put("lightsteelblue", ColorUtil.createColor(176, 196, 222));
        colorMap.put("lightyellow", ColorUtil.createColor(255, 255, 224));
        colorMap.put("lime", ColorUtil.createColor(0, 255, 0));
        colorMap.put("limegreen", ColorUtil.createColor(50, 205, 50));
        colorMap.put("linen", ColorUtil.createColor(250, 240, 230));
        colorMap.put("magenta", ColorUtil.createColor(255, 0, 255));
        colorMap.put("maroon", ColorUtil.createColor(128, 0, 0));
        colorMap.put("mediumaquamarine", ColorUtil.createColor(102, 205, 170));
        colorMap.put("mediumblue", ColorUtil.createColor(0, 0, 205));
        colorMap.put("mediumorchid", ColorUtil.createColor(186, 85, 211));
        colorMap.put("mediumpurple", ColorUtil.createColor(147, 112, 219));
        colorMap.put("mediumseagreen", ColorUtil.createColor(60, 179, 113));
        colorMap.put("mediumslateblue", ColorUtil.createColor(123, 104, 238));
        colorMap.put("mediumspringgreen", ColorUtil.createColor(0, 250, 154));
        colorMap.put("mediumturquoise", ColorUtil.createColor(72, 209, 204));
        colorMap.put("mediumvioletred", ColorUtil.createColor(199, 21, 133));
        colorMap.put("midnightblue", ColorUtil.createColor(25, 25, 112));
        colorMap.put("mintcream", ColorUtil.createColor(245, 255, 250));
        colorMap.put("mistyrose", ColorUtil.createColor(255, 228, 225));
        colorMap.put("moccasin", ColorUtil.createColor(255, 228, 181));
        colorMap.put("navajowhite", ColorUtil.createColor(255, 222, 173));
        colorMap.put("navy", ColorUtil.createColor(0, 0, 128));
        colorMap.put("oldlace", ColorUtil.createColor(253, 245, 230));
        colorMap.put("olive", ColorUtil.createColor(128, 128, 0));
        colorMap.put("olivedrab", ColorUtil.createColor(107, 142, 35));
        colorMap.put("orange", ColorUtil.createColor(255, 165, 0));
        colorMap.put("orangered", ColorUtil.createColor(255, 69, 0));
        colorMap.put("orchid", ColorUtil.createColor(218, 112, 214));
        colorMap.put("palegoldenrod", ColorUtil.createColor(238, 232, 170));
        colorMap.put("palegreen", ColorUtil.createColor(152, 251, 152));
        colorMap.put("paleturquoise", ColorUtil.createColor(175, 238, 238));
        colorMap.put("palevioletred", ColorUtil.createColor(219, 112, 147));
        colorMap.put("papayawhip", ColorUtil.createColor(255, 239, 213));
        colorMap.put("peachpuff", ColorUtil.createColor(255, 218, 185));
        colorMap.put("peru", ColorUtil.createColor(205, 133, 63));
        colorMap.put("pink", ColorUtil.createColor(255, 192, 203));
        colorMap.put("plum ", ColorUtil.createColor(221, 160, 221));
        colorMap.put("plum", ColorUtil.createColor(221, 160, 221));
        colorMap.put("powderblue", ColorUtil.createColor(176, 224, 230));
        colorMap.put("purple", ColorUtil.createColor(128, 0, 128));
        colorMap.put("red", ColorUtil.createColor(255, 0, 0));
        colorMap.put("rosybrown", ColorUtil.createColor(188, 143, 143));
        colorMap.put("royalblue", ColorUtil.createColor(65, 105, 225));
        colorMap.put("saddlebrown", ColorUtil.createColor(139, 69, 19));
        colorMap.put("salmon", ColorUtil.createColor(250, 128, 114));
        colorMap.put("sandybrown", ColorUtil.createColor(244, 164, 96));
        colorMap.put("seagreen", ColorUtil.createColor(46, 139, 87));
        colorMap.put("seashell", ColorUtil.createColor(255, 245, 238));
        colorMap.put("sienna", ColorUtil.createColor(160, 82, 45));
        colorMap.put("silver", ColorUtil.createColor(192, 192, 192));
        colorMap.put("skyblue", ColorUtil.createColor(135, 206, 235));
        colorMap.put("slateblue", ColorUtil.createColor(106, 90, 205));
        colorMap.put("slategray", ColorUtil.createColor(112, 128, 144));
        colorMap.put("slategrey", ColorUtil.createColor(112, 128, 144));
        colorMap.put("snow", ColorUtil.createColor(255, 250, 250));
        colorMap.put("springgreen", ColorUtil.createColor(0, 255, 127));
        colorMap.put("steelblue", ColorUtil.createColor(70, 130, 180));
        colorMap.put("tan", ColorUtil.createColor(210, 180, 140));
        colorMap.put("teal", ColorUtil.createColor(0, 128, 128));
        colorMap.put("thistle", ColorUtil.createColor(216, 191, 216));
        colorMap.put("tomato", ColorUtil.createColor(255, 99, 71));
        colorMap.put("turquoise", ColorUtil.createColor(64, 224, 208));
        colorMap.put("violet", ColorUtil.createColor(238, 130, 238));
        colorMap.put("wheat", ColorUtil.createColor(245, 222, 179));
        colorMap.put("white", ColorUtil.createColor(255, 255, 255));
        colorMap.put("whitesmoke", ColorUtil.createColor(245, 245, 245));
        colorMap.put("yellow", ColorUtil.createColor(255, 255, 0));
        colorMap.put("yellowgreen", ColorUtil.createColor(154, 205, 50));
        colorMap.put("transparent", (Color)new ColorWithAlternatives(0, 0, 0, 0, null));
    }

    public static Color lightenColor(Color color, float f2) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.lightenColor((Color)color, (float)f2);
    }

    public static boolean isPseudoProfile(String string) {
        return CMYK_PSEUDO_PROFILE.equalsIgnoreCase(string) || SEPARATION_PSEUDO_PROFILE.equalsIgnoreCase(string);
    }

    public static boolean isGray(Color color) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.isGray((Color)color);
    }

    public static Color toCMYKGrayColor(float f2) {
        return org.apache.xmlgraphics.java2d.color.ColorUtil.toCMYKGrayColor((float)f2);
    }

    static {
        log = LogFactory.getLog(ColorUtil.class);
        ColorUtil.initializeColorMap();
    }
}

