/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SimpleSVGUserAgent;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;

public class SVGUserAgent
extends SimpleSVGUserAgent {
    private SVGEventProducer eventProducer;
    private Exception lastException;
    private static ThreadLocal<String> userStylesheetUri = new ThreadLocal();
    private static ThreadLocal<String> imageMapsStylesheetUri = new ThreadLocal();
    private boolean isAnEmbeddedSVG;

    public SVGUserAgent(FOUserAgent fOUserAgent, FontFamilyResolver fontFamilyResolver, AffineTransform affineTransform) {
        super(affineTransform, fontFamilyResolver, fOUserAgent.getSourceResolution());
        this.eventProducer = SVGEventProducer.Provider.get((EventBroadcaster)fOUserAgent.getEventBroadcaster());
    }

    public SVGUserAgent(FOUserAgent fOUserAgent, FontFamilyResolver fontFamilyResolver) {
        this(fOUserAgent, fontFamilyResolver, new AffineTransform());
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void displayError(String string) {
        this.eventProducer.error((Object)this, string, null);
    }

    public void displayError(Exception exception) {
        this.lastException = exception;
        this.eventProducer.error((Object)this, exception.getLocalizedMessage(), exception);
    }

    public void displayMessage(String string) {
        this.eventProducer.info((Object)this, string);
    }

    public void showAlert(String string) {
        this.eventProducer.alert((Object)this, string);
    }

    public SVGUserAgent(FOUserAgent fOUserAgent, FOPFontFamilyResolverImpl fOPFontFamilyResolverImpl, AffineTransform affineTransform, boolean bl) {
        this(fOUserAgent, (FontFamilyResolver)fOPFontFamilyResolverImpl, affineTransform);
        this.isAnEmbeddedSVG = bl;
    }

    public String getUserStyleSheetURI() {
        Object object = null;
        if (this.isAnEmbeddedSVG) {
            object = userStylesheetUri.get();
        }
        if (object == null) {
            object = imageMapsStylesheetUri.get();
        }
        if (object != null) {
            object = "chemistry-user-stylesheet://" + (String)object;
        }
        return object;
    }

    public static void setUserStylesheetUri(String string) {
        userStylesheetUri.set(string);
    }

    public static void removeUserStylesheetUri() {
        userStylesheetUri.remove();
    }

    public static void setImageMapsStylesheetUri(String string) {
        imageMapsStylesheetUri.set(string);
    }
}

