/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.StructureType;

public class PageSequenceStructElem
extends PDFStructElem {
    private static final long serialVersionUID = -9146602678931267198L;
    private List<PDFStructElem> regionBefores = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionAfters = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionStarts = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionEnds = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> footnoteSeparator = new ArrayList<PDFStructElem>();

    PageSequenceStructElem(PDFObject pDFObject, StructureType structureType) {
        super(pDFObject, structureType);
    }

    void addContent(String string, PDFStructElem pDFStructElem) {
        if (string.equals("xsl-region-before")) {
            this.regionBefores.add(pDFStructElem);
        } else if (string.equals("xsl-region-after")) {
            this.regionAfters.add(pDFStructElem);
        } else if (string.equals("xsl-region-start")) {
            this.regionStarts.add(pDFStructElem);
        } else if (string.equals("xsl-region-end")) {
            this.regionEnds.add(pDFStructElem);
        } else if (string.equals("xsl-footnote-separator")) {
            this.footnoteSeparator.add(pDFStructElem);
        } else {
            this.addKid((PDFObject)pDFStructElem);
        }
    }

    @Override
    protected boolean attachKids() {
        assert (!this.kids.isEmpty());
        PDFArray pDFArray = new PDFArray();
        this.addRegions(pDFArray, this.regionBefores);
        this.addRegions(pDFArray, this.regionStarts);
        if (this.kids != null) {
            this.addRegions(pDFArray, this.kids);
        }
        this.addRegions(pDFArray, this.regionEnds);
        this.addRegions(pDFArray, this.footnoteSeparator);
        this.addRegions(pDFArray, this.regionAfters);
        this.put("K", pDFArray);
        return true;
    }

    private void addRegions(PDFArray pDFArray, List<? extends PDFObject> list) {
        if (!list.isEmpty()) {
            for (PDFObject pDFObject : list) {
                pDFArray.add((Object)pDFObject);
            }
        }
    }
}

