/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.PageViewport;
import org.apache.fop.image.loader.batik.PreloaderSVG;
import org.apache.fop.render.extensions.prepress.PageBoundaries;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class MarksIFRenderer {
    protected static final Log log = LogFactory.getLog(MarksIFRenderer.class);
    private static MarksIFRenderer instance;

    private MarksIFRenderer() {
    }

    public static MarksIFRenderer getInstance() {
        if (instance == null) {
            instance = new MarksIFRenderer();
        }
        return instance;
    }

    void paintMarks(IFPainter iFPainter, PageViewport pageViewport, String string) throws IFException {
        if (string != null) {
            List<String> list = Arrays.asList(string.split(" "));
            if (list.contains("crop")) {
                this.drawCropMarks(iFPainter, pageViewport);
            }
            if (list.contains("cross")) {
                this.drawCrossMarks(iFPainter, pageViewport);
            }
        }
    }

    private void drawCropMarks(IFPainter iFPainter, PageViewport pageViewport) {
        Rectangle rectangle = pageViewport.getViewArea();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = pageViewport.getPage().getRegionViewport(57).getBPD();
        int n5 = pageViewport.getPage().getRegionViewport(56).getBPD();
        int n6 = pageViewport.getPage().getRegionViewport(61).getIPD();
        int n7 = pageViewport.getPage().getRegionViewport(59).getIPD();
        PageBoundaries pageBoundaries = new PageBoundaries(pageViewport.getViewArea().getSize(), pageViewport.getForeignAttributes());
        Rectangle rectangle2 = pageBoundaries.getCropBox();
        int n8 = rectangle2.y;
        int n9 = n2 - rectangle2.width - rectangle2.x;
        int n10 = n3 - rectangle2.height - rectangle2.y;
        int n11 = rectangle2.x;
        String string = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + n2 + "\" height=\"" + n3 + "\" viewBox=\"0 0 " + n2 + " " + n3 + "\" overflow=\"visible\">\n  <style type=\"text/css\">\n    .line { fill:none; stroke:black; stroke-width:0.1 }\n    .circle { fill:none; stroke:black; stroke-width:0.1 }\n  </style>\n  <g id=\"crop-marks\">\n    <!-- TOP-LEFT-CORNER -->\n    <polyline class=\"line\" points=\"" + (0.4 * (double)n6 + (double)n11) + "," + (n4 + n8) + " " + (0.9 * (double)n6 + (double)n11) + "," + (n4 + n8) + "\"/>\n    <polyline class=\"line\" points=\"" + (n6 + n11) + "," + (0.4 * (double)n4 + (double)n8) + " " + (n6 + n11) + "," + (0.9 * (double)n4 + (double)n8) + "\"/>\n    <!-- TOP-RIGHT-CORNER -->\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.9 * (double)n7 - (double)n9) + "," + (n4 + n8) + " " + ((double)n2 - 0.4 * (double)n7 - (double)n9) + "," + (n4 + n8) + "\"/>\n    <polyline class=\"line\" points=\"" + (n2 - n7 - n9) + "," + (0.4 * (double)n4 + (double)n8) + " " + (n2 - n7 - n9) + "," + (0.9 * (double)n4 + (double)n8) + "\"/>\n    <!-- BOTTOM-LEFT-CORNER -->\n    <polyline class=\"line\" points=\"" + (0.4 * (double)n6 + (double)n11) + "," + (n3 - n5 - n10) + " " + (0.9 * (double)n6 + (double)n11) + "," + (n3 - n5 - n10) + "\"/>\n    <polyline class=\"line\" points=\"" + (n6 + n11) + "," + ((double)n3 - 0.9 * (double)n5 - (double)n10) + " " + (n6 + n11) + "," + ((double)n3 - 0.4 * (double)n5 - (double)n10) + "\"/>\n    <!-- BOTTOM-RIGHT-CORNER -->\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.9 * (double)n7 - (double)n9) + "," + (n3 - n5 - n10) + " " + ((double)n2 - 0.4 * (double)n7 - (double)n9) + "," + (n3 - n5 - n10) + "\"/>\n    <polyline class=\"line\" points=\"" + (n2 - n7 - n9) + "," + ((double)n3 - 0.4 * (double)n5 - (double)n10) + " " + (n2 - n7 - n9) + "," + ((double)n3 - 0.9 * (double)n5 - (double)n10) + "\"/>\n  </g>\n</svg>";
        this.drawMarksSVGShape(iFPainter, rectangle, string);
    }

    private void drawCrossMarks(IFPainter iFPainter, PageViewport pageViewport) {
        Rectangle rectangle = pageViewport.getViewArea();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = pageViewport.getPage().getRegionViewport(57).getBPD();
        int n5 = pageViewport.getPage().getRegionViewport(56).getBPD();
        int n6 = pageViewport.getPage().getRegionViewport(61).getIPD();
        int n7 = pageViewport.getPage().getRegionViewport(59).getIPD();
        PageBoundaries pageBoundaries = new PageBoundaries(pageViewport.getViewArea().getSize(), pageViewport.getForeignAttributes());
        Rectangle rectangle2 = pageBoundaries.getCropBox();
        int n8 = rectangle2.y;
        int n9 = n2 - rectangle2.width - rectangle2.x;
        int n10 = n3 - rectangle2.height - rectangle2.y;
        int n11 = rectangle2.x;
        String string = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + n2 + "\" height=\"" + n3 + "\" viewBox=\"0 0 " + n2 + " " + n3 + "\" overflow=\"visible\">\n  <style type=\"text/css\">\n    .line { fill:none; stroke:black; stroke-width:0.1 }\n    .circle { fill:none; stroke:black; stroke-width:0.1 }\n  </style>\n  <g id=\"registration-marks\">\n    <!-- TOP-LEFT-CORNER -->\n    <polyline class=\"line\" points=\"" + (0.3 * (double)n6 + (double)n11) + "," + (0.5 * (double)n4 + (double)n8) + " " + (0.6 * (double)n6 + (double)n11) + "," + (0.5 * (double)n4 + (double)n8) + "\"/>\n    <polyline class=\"line\" points=\"" + (0.45 * (double)n6 + (double)n11) + "," + (0.35 * (double)n4 + (double)n8) + " " + (0.45 * (double)n6 + (double)n11) + "," + (0.65 * (double)n4 + (double)n8) + "\"/>\n    <circle class=\"circle\" cx=\"" + (0.45 * (double)n6 + (double)n11) + "\" cy=\"" + (0.5 * (double)n4 + (double)n8) + "\" r=\"" + 0.13 * (double)n6 + "\"/>\n    <circle cx=\"" + (0.45 * (double)n6 + (double)n11) + "\" cy=\"" + (0.5 * (double)n4 + (double)n8) + "\" r=\"" + 0.08 * (double)n6 + "\"/>\n    <!-- TOP-RIGHT-CORNER -->\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.6 * (double)n7 - (double)n9) + "," + (0.5 * (double)n4 + (double)n8) + " " + ((double)n2 - 0.3 * (double)n7 - (double)n9) + "," + (0.5 * (double)n4 + (double)n8) + "\"/>\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "," + (0.35 * (double)n4 + (double)n8) + " " + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "," + (0.65 * (double)n4 + (double)n8) + "\"/>\n    <circle class=\"circle\" cx=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "\" cy=\"" + (0.5 * (double)n4 + (double)n8) + "\" r=\"" + 0.13 * (double)n7 + "\"/>\n    <circle cx=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "\" cy=\"" + (0.5 * (double)n4 + (double)n8) + "\" r=\"" + 0.08 * (double)n7 + "\"/>\n    <!-- BOTTOM-LEFT-CORNER -->\n    <polyline class=\"line\" points=\"" + (0.3 * (double)n6 + (double)n11) + "," + ((double)n3 - 0.5 * (double)n5 - (double)n10) + " " + (0.6 * (double)n6 + (double)n11) + "," + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\"/>\n    <polyline class=\"line\" points=\"" + (0.45 * (double)n6 + (double)n11) + "," + ((double)n3 - 0.65 * (double)n5 - (double)n10) + " " + (0.45 * (double)n6 + (double)n11) + "," + ((double)n3 - 0.35 * (double)n5 - (double)n10) + "\"/>\n    <circle class=\"circle\" cx=\"" + (0.45 * (double)n6 + (double)n11) + "\" cy=\"" + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\" r=\"" + 0.13 * (double)n6 + "\"/>\n    <circle cx=\"" + (0.45 * (double)n6 + (double)n11) + "\" cy=\"" + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\" r=\"" + 0.08 * (double)n6 + "\"/>\n    <!-- BOTTOM-RIGHT-CORNER -->\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.6 * (double)n7 - (double)n9) + "," + ((double)n3 - 0.5 * (double)n5 - (double)n10) + " " + ((double)n2 - 0.3 * (double)n7 - (double)n9) + "," + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\"/>\n    <polyline class=\"line\" points=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "," + ((double)n3 - 0.65 * (double)n5 - (double)n10) + " " + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "," + ((double)n3 - 0.35 * (double)n5 - (double)n10) + "\"/>\n    <circle class=\"circle\" cx=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "\" cy=\"" + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\" r=\"" + 0.13 * (double)n7 + "\"/>\n    <circle cx=\"" + ((double)n2 - 0.45 * (double)n7 - (double)n9) + "\" cy=\"" + ((double)n3 - 0.5 * (double)n5 - (double)n10) + "\" r=\"" + 0.08 * (double)n7 + "\"/>\n  </g>\n</svg>";
        this.drawMarksSVGShape(iFPainter, rectangle, string);
    }

    private void drawMarksSVGShape(IFPainter iFPainter, Rectangle rectangle, String string) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)string);
            }
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
            SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument("area.svg", (InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
            iFPainter.drawImage((Document)sVGDocument, rectangle);
        }
        catch (IOException | IFException throwable) {
            log.error((Object)throwable, throwable);
        }
    }
}

