/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.IDTracker;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.BasicLinkArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.GlyphMapping;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.pdf.PDFLinkRectangleWithShape;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.ChemistryEvaluationStampRenderer;
import org.apache.fop.render.intermediate.ChemistryForegroundRenderer;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFGraphicContext;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFSerializer;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.ImageMapIFRenderer;
import org.apache.fop.render.intermediate.MarksIFRenderer;
import org.apache.fop.render.intermediate.PageIndexContext;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.ActionSet;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.GoToXYAction;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.render.intermediate.extensions.URIAction;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreAdapter;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreSchema;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IFRenderer
extends AbstractPathOrientedRenderer {
    protected static final Log log = LogFactory.getLog(IFRenderer.class);
    public static final String IF_MIME_TYPE = "application/X-fop-intermediate-format";
    private IFDocumentHandler documentHandler;
    private IFPainter painter;
    protected Renderer mimic;
    private boolean inPageSequence;
    private Stack graphicContextStack = new Stack();
    private Stack viewportDimensionStack = new Stack();
    private IFGraphicContext graphicContext = new IFGraphicContext();
    private Metadata documentMetadata;
    private Map idPositions = new HashMap();
    private List unfinishedGoTos = new ArrayList();
    protected Map pageIndices = new HashMap();
    private BookmarkTree bookmarkTree;
    private List deferredDestinations = new ArrayList();
    private List deferredLinks = new ArrayList();
    private ActionSet actionSet = new ActionSet();
    private TextUtil textUtil = new TextUtil();
    private Stack<String> ids = new Stack();
    public static final ThreadLocal<IFRenderer> IF_RENDERER_INSTANCE = new ThreadLocal();

    public IFRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        IF_RENDERER_INSTANCE.set(this);
    }

    public String getMimeType() {
        return IF_MIME_TYPE;
    }

    public void setDocumentHandler(IFDocumentHandler iFDocumentHandler) {
        this.documentHandler = iFDocumentHandler;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        if (this.documentHandler == null) {
            this.documentHandler = this.createDefaultDocumentHandler();
        }
        IFUtil.setupFonts((IFDocumentHandler)this.documentHandler, (FontInfo)fontInfo);
        this.fontInfo = fontInfo;
    }

    private void handleIFException(IFException iFException) {
        if (iFException.getCause() instanceof SAXException) {
            throw new RuntimeException(iFException.getCause());
        }
        throw new RuntimeException(iFException);
    }

    private void handleIFExceptionWithIOException(IFException iFException) throws IOException {
        Throwable throwable = iFException.getCause();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        this.handleIFException(iFException);
    }

    public boolean supportsOutOfOrder() {
        return this.documentHandler != null ? this.documentHandler.supportsPagesOutOfOrder() : false;
    }

    protected IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this.documentHandler.getDocumentNavigationHandler();
    }

    protected boolean hasDocumentNavigation() {
        return this.getDocumentNavigationHandler() != null;
    }

    protected IFDocumentHandler createDefaultDocumentHandler() {
        FOUserAgent fOUserAgent = this.getUserAgent();
        IFSerializer iFSerializer = new IFSerializer(new IFContext(fOUserAgent));
        if (fOUserAgent.isAccessibilityEnabled()) {
            fOUserAgent.setStructureTreeEventHandler(iFSerializer.getStructureTreeEventHandler());
        }
        return iFSerializer;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        try {
            if (outputStream != null) {
                StreamResult streamResult = new StreamResult(outputStream);
                if (this.getUserAgent().getOutputFile() != null) {
                    streamResult.setSystemId(this.getUserAgent().getOutputFile().toURI().toURL().toExternalForm());
                }
                if (this.documentHandler == null) {
                    this.documentHandler = this.createDefaultDocumentHandler();
                }
                this.documentHandler.setResult((Result)streamResult);
            }
            super.startRenderer(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rendering areas via IF document handler (" + this.documentHandler.getClass().getName() + ")..."));
            }
            this.documentHandler.startDocument();
            this.documentHandler.startDocumentHeader();
        }
        catch (IFException iFException) {
            this.handleIFExceptionWithIOException(iFException);
        }
    }

    public void stopRenderer() throws IOException {
        try {
            if (this.inPageSequence) {
                this.documentHandler.endPageSequence();
                this.inPageSequence = false;
            }
            this.documentHandler.startDocumentTrailer();
            if (this.hasDocumentNavigation()) {
                this.finishOpenGoTos();
                Iterator iterator = this.deferredDestinations.iterator();
                while (iterator.hasNext()) {
                    NamedDestination namedDestination = (NamedDestination)iterator.next();
                    iterator.remove();
                    this.getDocumentNavigationHandler().renderNamedDestination(namedDestination);
                }
                if (this.bookmarkTree != null) {
                    this.getDocumentNavigationHandler().renderBookmarkTree(this.bookmarkTree);
                }
            }
            this.documentHandler.endDocumentTrailer();
            this.documentHandler.endDocument();
        }
        catch (IFException iFException) {
            this.handleIFExceptionWithIOException(iFException);
        }
        this.pageIndices.clear();
        this.idPositions.clear();
        this.actionSet.clear();
        super.stopRenderer();
        log.debug((Object)"Rendering finished.");
    }

    public void setDocumentLocale(Locale locale) {
        this.documentHandler.setDocumentLocale(locale);
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
        if (offDocumentItem instanceof DestinationData) {
            this.renderDestination((DestinationData)offDocumentItem);
        } else if (offDocumentItem instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)offDocumentItem);
        } else if (offDocumentItem instanceof OffDocumentExtensionAttachment) {
            ExtensionAttachment extensionAttachment = ((OffDocumentExtensionAttachment)offDocumentItem).getAttachment();
            if ("adobe:ns:meta/".equals(extensionAttachment.getCategory())) {
                this.renderXMPMetadata((XMPMetadata)extensionAttachment);
            } else {
                try {
                    this.documentHandler.handleExtensionObject((Object)extensionAttachment);
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
    }

    private void renderDestination(DestinationData destinationData) {
        if (!this.hasDocumentNavigation()) {
            return;
        }
        String string = destinationData.getIDRef();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("DestinationData must contain a ID reference");
        }
        PageViewport pageViewport = destinationData.getPageViewport();
        if (pageViewport != null) {
            GoToXYAction goToXYAction = this.getGoToActionForID(string, pageViewport.getPageIndex());
            NamedDestination namedDestination = new NamedDestination(string, (AbstractAction)goToXYAction);
            this.deferredDestinations.add(namedDestination);
        } else {
            log.debug((Object)("Unresolved destination item received: " + destinationData.getIDRef()));
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarkData) {
        assert (this.bookmarkTree == null);
        if (!this.hasDocumentNavigation()) {
            return;
        }
        this.bookmarkTree = new BookmarkTree();
        for (int i2 = 0; i2 < bookmarkData.getCount(); ++i2) {
            BookmarkData bookmarkData2 = bookmarkData.getSubData(i2);
            Bookmark bookmark = this.renderBookmarkItem(bookmarkData2);
            this.bookmarkTree.addBookmark(bookmark);
        }
    }

    private Bookmark renderBookmarkItem(BookmarkData bookmarkData) {
        String string = bookmarkData.getIDRef();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("DestinationData must contain a ID reference");
        }
        GoToXYAction goToXYAction = null;
        PageViewport pageViewport = bookmarkData.getPageViewport();
        if (pageViewport != null) {
            goToXYAction = this.getGoToActionForID(string, pageViewport.getPageIndex());
        } else {
            log.debug((Object)("Bookmark with IDRef \"" + string + "\" has a null PageViewport."));
        }
        Bookmark bookmark = new Bookmark(bookmarkData.getBookmarkTitle(), bookmarkData.showChildItems(), (AbstractAction)goToXYAction);
        for (int i2 = 0; i2 < bookmarkData.getCount(); ++i2) {
            bookmark.addChildBookmark(this.renderBookmarkItem(bookmarkData.getSubData(i2)));
        }
        return bookmark;
    }

    private void renderXMPMetadata(XMPMetadata xMPMetadata) {
        this.documentMetadata = xMPMetadata.getMetadata();
    }

    private GoToXYAction getGoToActionForID(String string, int n2) {
        GoToXYAction goToXYAction = (GoToXYAction)this.actionSet.get(string);
        if (goToXYAction == null) {
            Point point = (Point)this.idPositions.get(string);
            if (n2 >= 0 && point != null) {
                goToXYAction = new GoToXYAction(string, n2, point, (PageIndexContext)this.documentHandler.getContext());
            } else {
                goToXYAction = new GoToXYAction(string, n2, null, (PageIndexContext)this.documentHandler.getContext());
                this.unfinishedGoTos.add(goToXYAction);
            }
            goToXYAction = (GoToXYAction)this.actionSet.put((AbstractAction)goToXYAction);
        }
        return goToXYAction;
    }

    private void finishOpenGoTos() {
        int n2 = this.unfinishedGoTos.size();
        if (n2 > 0) {
            Point point = new Point(0, 0);
            while (!this.unfinishedGoTos.isEmpty()) {
                GoToXYAction goToXYAction = (GoToXYAction)this.unfinishedGoTos.get(0);
                this.noteGoToPosition(goToXYAction, point);
            }
        }
    }

    private void noteGoToPosition(GoToXYAction goToXYAction, Point point) {
        goToXYAction.setTargetLocation(point);
        try {
            this.getDocumentNavigationHandler().addResolvedAction((AbstractAction)goToXYAction);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        this.unfinishedGoTos.remove(goToXYAction);
    }

    private void noteGoToPosition(GoToXYAction goToXYAction, PageViewport pageViewport, Point point) {
        goToXYAction.setPageIndex(pageViewport.getPageIndex());
        this.noteGoToPosition(goToXYAction, point);
    }

    private void saveAbsolutePosition(String string, PageViewport pageViewport, int n2, int n3, AffineTransform affineTransform) {
        Point point = new Point(n2, n3);
        affineTransform.transform(point, point);
        this.idPositions.put(string, point);
        GoToXYAction goToXYAction = (GoToXYAction)this.actionSet.get(string);
        if (goToXYAction != null) {
            this.noteGoToPosition(goToXYAction, pageViewport, point);
        }
    }

    private void saveAbsolutePosition(String string, int n2, int n3) {
        this.saveAbsolutePosition(string, this.currentPageViewport, n2, n3, this.graphicContext.getTransform());
    }

    private void saveBlockPosIfTargetable(Block block) {
        String string = this.getTargetableID((Area)block);
        String string2 = this.getTargetableNDID((Area)block);
        if (this.hasDocumentNavigation() && (string != null || string2 != null)) {
            int n2 = block.getXOffset();
            int n3 = block.getYOffset() + block.getSpaceBefore();
            int n4 = block.getPositioning();
            if (n4 != 3 && n4 != 2) {
                n2 += this.currentIPPosition;
                n3 += this.currentBPPosition;
            }
            this.saveAbsolutePosition(string, this.currentPageViewport, n2, n3, this.graphicContext.getTransform());
            if (string2 != null) {
                this.saveAbsolutePosition(string2, this.currentPageViewport, n2, n3, this.graphicContext.getTransform());
            }
        }
    }

    private void saveInlinePosIfTargetable(InlineArea inlineArea) {
        String string = this.getTargetableID(inlineArea);
        String string2 = this.getTargetableNDID(inlineArea);
        if (this.hasDocumentNavigation() && (string != null || string2 != null)) {
            int n2 = 5000;
            int n3 = this.currentIPPosition;
            int n4 = this.currentBPPosition + inlineArea.getBlockProgressionOffset() - n2;
            this.saveAbsolutePosition(string, n3, n4);
            if (string2 != null) {
                this.saveAbsolutePosition(string2, n3, n4);
            }
        }
    }

    private String getTargetableID(Area area) {
        String string = (String)area.getTrait(Trait.PROD_ID);
        if (string == null || string.length() == 0 || !this.currentPageViewport.isFirstWithID(string) || this.idPositions.containsKey(string)) {
            return null;
        }
        return string;
    }

    private String getTargetableNDID(Area area) {
        String string = area.getForeignAttributeValue(ChemistryExtensions.ATT_QNAME_ND_ID);
        if (string == null || string.length() == 0 || this.idPositions.containsKey(string)) {
            return null;
        }
        return string;
    }

    public void startPageSequence(PageSequence pageSequence) {
        try {
            if (this.inPageSequence) {
                this.documentHandler.endPageSequence();
                this.documentHandler.getContext().setLanguage(null);
            } else {
                if (this.documentMetadata == null) {
                    this.documentMetadata = this.createDefaultDocumentMetadata();
                }
                this.documentHandler.handleExtensionObject((Object)this.documentMetadata);
                this.documentHandler.endDocumentHeader();
                this.inPageSequence = true;
            }
            this.establishForeignAttributes(pageSequence.getForeignAttributes());
            this.documentHandler.getContext().setLanguage(pageSequence.getLocale());
            this.documentHandler.startPageSequence(null);
            this.resetForeignAttributes();
            this.processExtensionAttachments((AreaTreeObject)pageSequence);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    private Metadata createDefaultDocumentMetadata() {
        Metadata metadata = new Metadata();
        DublinCoreAdapter dublinCoreAdapter = DublinCoreSchema.getAdapter((Metadata)metadata);
        if (this.getUserAgent().getTitle() != null) {
            dublinCoreAdapter.setTitle(this.getUserAgent().getTitle());
        }
        if (this.getUserAgent().getAuthor() != null) {
            dublinCoreAdapter.addCreator(this.getUserAgent().getAuthor());
        }
        if (this.getUserAgent().getKeywords() != null) {
            dublinCoreAdapter.addSubject(this.getUserAgent().getKeywords());
        }
        XMPBasicAdapter xMPBasicAdapter = XMPBasicSchema.getAdapter((Metadata)metadata);
        if (this.getUserAgent().getProducer() != null) {
            xMPBasicAdapter.setCreatorTool(this.getUserAgent().getProducer());
        } else {
            xMPBasicAdapter.setCreatorTool(Version.getVersion());
        }
        xMPBasicAdapter.setMetadataDate(new Date());
        if (this.getUserAgent().getCreationDate() != null) {
            xMPBasicAdapter.setCreateDate(this.getUserAgent().getCreationDate());
        } else {
            xMPBasicAdapter.setCreateDate(xMPBasicAdapter.getMetadataDate());
        }
        return metadata;
    }

    public void preparePage(PageViewport pageViewport) {
        super.preparePage(pageViewport);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderPage() " + pageViewport));
        }
        try {
            this.pageIndices.put(pageViewport.getKey(), pageViewport.getPageIndex());
            Rectangle rectangle = pageViewport.getViewArea();
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            this.establishForeignAttributes(pageViewport.getForeignAttributes());
            this.documentHandler.getContext().setPageIndex(pageViewport.getPageIndex());
            this.documentHandler.getContext().setPageNumber(pageViewport.getPageNumber());
            this.documentHandler.startPage(pageViewport.getPageIndex(), pageViewport.getPageNumberString(), pageViewport.getSimplePageMasterName(), dimension);
            this.resetForeignAttributes();
            this.documentHandler.startPageHeader();
            this.processExtensionAttachments((AreaTreeObject)pageViewport);
            this.documentHandler.endPageHeader();
            this.painter = this.documentHandler.startPageContent();
            super.renderPage(pageViewport);
            String string = pageViewport.getForeignAttributeValue(ChemistryExtensions.ATT_QNAME_FOREGROUND_IMAGE);
            ChemistryForegroundRenderer.getInstance().paintForeground(this.painter, rectangle, string);
            ChemistryEvaluationStampRenderer.getInstance().paintStamp(this.painter, rectangle, this.deferredLinks);
            String string2 = pageViewport.getForeignAttributeValue(ChemistryExtensions.ATT_QNAME_MARKS);
            MarksIFRenderer.getInstance().paintMarks(this.painter, pageViewport, string2);
            this.painter = null;
            this.documentHandler.endPageContent();
            this.documentHandler.startPageTrailer();
            if (this.hasDocumentNavigation()) {
                Iterator iterator = this.deferredLinks.iterator();
                while (iterator.hasNext()) {
                    Link link = (Link)iterator.next();
                    iterator.remove();
                    this.getDocumentNavigationHandler().renderLink(link);
                }
            }
            this.documentHandler.endPageTrailer();
            this.establishForeignAttributes(pageViewport.getForeignAttributes());
            this.documentHandler.endPage();
            this.documentHandler.getContext().setPageIndex(-1);
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    private void processExtensionAttachments(AreaTreeObject areaTreeObject) throws IFException {
        if (areaTreeObject.hasExtensionAttachments()) {
            for (ExtensionAttachment extensionAttachment : areaTreeObject.getExtensionAttachments()) {
                this.documentHandler.handleExtensionObject((Object)extensionAttachment);
            }
        }
    }

    private void establishForeignAttributes(Map map) {
        this.documentHandler.getContext().setForeignAttributes(map);
    }

    private void resetForeignAttributes() {
        this.documentHandler.getContext().resetForeignAttributes();
    }

    private void establishStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.documentHandler.getContext().setStructureTreeElement(structureTreeElement);
    }

    private void resetStructurePointer() {
        this.documentHandler.getContext().resetStructureTreeElement();
    }

    protected void saveGraphicsState() {
        this.graphicContextStack.push(this.graphicContext);
        this.graphicContext = (IFGraphicContext)this.graphicContext.clone();
    }

    protected void restoreGraphicsState() {
        while (this.graphicContext.getGroupStackSize() > 0) {
            IFGraphicContext.Group[] groupArray = this.graphicContext.dropGroups();
            for (int i2 = groupArray.length - 1; i2 >= 0; --i2) {
                try {
                    groupArray[i2].end(this.painter);
                    continue;
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
        this.graphicContext = (IFGraphicContext)this.graphicContextStack.pop();
    }

    private void pushGroup(IFGraphicContext.Group group) {
        this.graphicContext.pushGroup(group);
        try {
            group.start(this.painter);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected List breakOutOfStateStack() {
        log.debug((Object)"Block.FIXED --> break out");
        ArrayList<IFGraphicContext> arrayList = new ArrayList<IFGraphicContext>();
        while (!this.graphicContextStack.empty()) {
            IFGraphicContext.Group[] groupArray = this.graphicContext.getGroups();
            for (int i2 = groupArray.length - 1; i2 >= 0; --i2) {
                try {
                    groupArray[i2].end(this.painter);
                    continue;
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
            arrayList.add(0, this.graphicContext);
            this.graphicContext = (IFGraphicContext)this.graphicContextStack.pop();
        }
        return arrayList;
    }

    protected void restoreStateStackAfterBreakOut(List list) {
        log.debug((Object)"Block.FIXED --> restoring context after break-out");
        for (Object e2 : list) {
            IFGraphicContext.Group[] groupArray;
            this.graphicContextStack.push(this.graphicContext);
            this.graphicContext = (IFGraphicContext)e2;
            for (IFGraphicContext.Group group : groupArray = this.graphicContext.getGroups()) {
                try {
                    group.start(this.painter);
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
        log.debug((Object)"restored.");
    }

    protected void concatenateTransformationMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.concatenateTransformationMatrixMpt(this.ptToMpt(affineTransform), false);
        }
    }

    private void concatenateTransformationMatrixMpt(AffineTransform affineTransform, boolean bl) {
        if (bl || !affineTransform.isIdentity()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("-----concatenateTransformationMatrix: " + affineTransform));
            }
            IFGraphicContext.Group group = new IFGraphicContext.Group(affineTransform);
            this.pushGroup(group);
        }
    }

    protected void beginTextObject() {
    }

    protected void endTextObject() {
    }

    protected void renderRegionViewport(RegionViewport regionViewport) {
        Dimension dimension = new Dimension(regionViewport.getIPD(), regionViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        this.documentHandler.getContext().setRegionType(regionViewport.getRegionReference().getRegionClass());
        super.renderRegionViewport(regionViewport);
        this.viewportDimensionStack.pop();
    }

    protected void renderBlockViewport(BlockViewport blockViewport, List list) {
        boolean bl = false;
        if (this.maybeStartLayer((Area)blockViewport)) {
            bl = true;
        }
        Dimension dimension = new Dimension(blockViewport.getIPD(), blockViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        int n2 = this.currentIPPosition;
        int n3 = this.currentBPPosition;
        CTM cTM = blockViewport.getCTM();
        int n4 = blockViewport.getBorderAndPaddingWidthStart();
        int n5 = blockViewport.getBorderAndPaddingWidthBefore();
        if (blockViewport.getPositioning() == 2 || blockViewport.getPositioning() == 3) {
            Object object;
            Cloneable cloneable;
            List list2 = null;
            if (blockViewport.getPositioning() == 3) {
                list2 = this.breakOutOfStateStack();
            }
            int n6 = blockViewport.getXOffset();
            int n7 = blockViewport.getYOffset();
            if (blockViewport.getPositioning() == 2 && (cloneable = this.getCoordinatesForFOReferenceAreaRelativeToCSSReferenceArea()) != null) {
                object = this.getAbsolutPointRelativeToFOReferenceArea(blockViewport, (Point)cloneable);
                n6 = ((Point)object).x;
                n7 = ((Point)object).y;
            }
            cloneable = new AffineTransform();
            ((AffineTransform)cloneable).translate(n6, n7);
            ((AffineTransform)cloneable).translate(-n4, -n5);
            object = blockViewport.getForeignAttributeValue(FOX_TRANSFORM);
            if (object != null) {
                AffineTransform affineTransform = AWTTransformProducer.createAffineTransform((String)object);
                ((AffineTransform)cloneable).concatenate(affineTransform);
            }
            this.saveGraphicsState();
            this.concatenateTransformationMatrixMpt((AffineTransform)cloneable, false);
            float f2 = n4 + blockViewport.getBorderAndPaddingWidthEnd();
            float f3 = n5 + blockViewport.getBorderAndPaddingWidthAfter();
            this.drawBackAndBorders((Area)blockViewport, 0.0f, 0.0f, ((float)dimension.width + f2) / 1000.0f, ((float)dimension.height + f3) / 1000.0f);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n4, n5);
            this.concatenateTransformationMatrixMpt(affineTransform, false);
            AffineTransform affineTransform2 = cTM.toAffineTransform();
            this.startViewport(affineTransform2, blockViewport.getClipRectangle());
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            this.endViewport();
            this.restoreGraphicsState();
            if (list2 != null) {
                this.restoreStateStackAfterBreakOut(list2);
            }
            this.currentIPPosition = n2;
            this.currentBPPosition = n3;
        } else {
            if (blockViewport.getPositioning() == 1) {
                this.currentIPPosition += blockViewport.getXOffset();
                this.currentBPPosition += blockViewport.getYOffset();
                this.containingIPPosition += blockViewport.getXOffset();
            }
            this.currentBPPosition += blockViewport.getSpaceBefore();
            this.handleBlockTraits(blockViewport);
            this.currentIPPosition += blockViewport.getStartIndent();
            CTM cTM2 = new CTM((double)this.containingIPPosition, (double)this.currentBPPosition);
            cTM = cTM2.multiply(cTM);
            this.currentBPPosition += n5;
            this.startVParea(cTM, blockViewport.getClipRectangle());
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            this.endVParea();
            this.currentIPPosition = n2;
            this.currentBPPosition = n3;
            this.currentBPPosition += blockViewport.getAllocBPD();
        }
        this.viewportDimensionStack.pop();
        this.maybeEndLayer((Area)blockViewport, bl);
    }

    public void renderInlineViewport(InlineViewport inlineViewport) {
        StructureTreeElement structureTreeElement = (StructureTreeElement)inlineViewport.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
        this.establishStructureTreeElement(structureTreeElement);
        this.pushID((Area)inlineViewport);
        Dimension dimension = new Dimension(inlineViewport.getIPD(), inlineViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        super.renderInlineViewport(inlineViewport);
        this.viewportDimensionStack.pop();
        this.resetStructurePointer();
        this.popID((Area)inlineViewport);
    }

    protected void startVParea(CTM cTM, Rectangle rectangle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("startVParea() ctm=" + cTM + ", clippingRect=" + rectangle));
        }
        AffineTransform affineTransform = new AffineTransform(cTM.toArray());
        this.startViewport(affineTransform, rectangle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("startVPArea: " + affineTransform + " --> " + this.graphicContext.getTransform()));
        }
    }

    private void startViewport(AffineTransform affineTransform, Rectangle rectangle) {
        this.saveGraphicsState();
        try {
            IFGraphicContext.Viewport viewport = new IFGraphicContext.Viewport(affineTransform, (Dimension)this.viewportDimensionStack.peek(), rectangle);
            this.graphicContext.pushGroup((IFGraphicContext.Group)viewport);
            viewport.start(this.painter);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void endVParea() {
        log.trace((Object)"endVParea()");
        this.endViewport();
        if (log.isTraceEnabled()) {
            log.trace((Object)("endVPArea() --> " + this.graphicContext.getTransform()));
        }
    }

    private void endViewport() {
        this.restoreGraphicsState();
    }

    protected void startLayer(String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("startLayer() layer=" + string));
        }
        this.saveGraphicsState();
        this.pushGroup(new IFGraphicContext.Group(string));
    }

    protected void endLayer() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"endLayer()");
        }
        this.restoreGraphicsState();
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        this.saveInlinePosIfTargetable(inlineArea);
        this.pushID(inlineArea);
        super.renderInlineArea(inlineArea);
        this.popID(inlineArea);
    }

    public void renderInlineParent(InlineParent inlineParent) {
        String string;
        String string2;
        Rectangle rectangle = null;
        GoToXYAction goToXYAction = null;
        if (inlineParent.getPositioning() == 1) {
            this.currentIPPosition += inlineParent.getXOffset();
            this.currentBPPosition += inlineParent.getYOffset();
        }
        int n2 = this.currentIPPosition;
        int n3 = this.currentBPPosition + inlineParent.getBlockProgressionOffset();
        rectangle = new Rectangle(n2, n3, inlineParent.getIPD(), inlineParent.getBPD());
        AffineTransform affineTransform = this.graphicContext.getTransform();
        rectangle = affineTransform.createTransformedShape(rectangle).getBounds();
        super.renderInlineParent(inlineParent);
        boolean bl = false;
        Trait.InternalLink internalLink = (Trait.InternalLink)inlineParent.getTrait(Trait.INTERNAL_LINK);
        if (internalLink != null) {
            boolean bl2;
            bl = true;
            string2 = internalLink.getPVKey();
            string = internalLink.getIDRef();
            boolean bl3 = string2 != null && string2.length() > 0;
            boolean bl4 = bl2 = string != null && string.length() > 0;
            if (bl3 && bl2) {
                Integer n4 = (Integer)this.pageIndices.get(string2);
                goToXYAction = this.getGoToActionForID(string, n4 != null ? n4 : -1);
            }
        }
        if (!bl && (string2 = (Trait.ExternalLink)inlineParent.getTrait(Trait.EXTERNAL_LINK)) != null && (string = string2.getDestination()) != null && string.length() > 0) {
            bl = true;
            goToXYAction = new URIAction(string, string2.newWindow());
            goToXYAction = this.actionSet.put((AbstractAction)goToXYAction);
        }
        if (bl) {
            string2 = (StructureTreeElement)inlineParent.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
            goToXYAction.setStructureTreeElement((StructureTreeElement)string2);
            string = new Link(goToXYAction, rectangle);
            this.deferredLinks.add(string);
        } else if (inlineParent instanceof BasicLinkArea && (string2 = (BasicLinkArea)inlineParent).getResolver() != null) {
            string = string2.getResolver().getIDRefs()[0];
            goToXYAction = this.getGoToActionForID(string, -1);
            Link link = new Link((AbstractAction)goToXYAction, rectangle);
            this.deferredLinks.add(link);
        }
        if (inlineParent.getPositioning() == 1) {
            this.currentIPPosition -= inlineParent.getXOffset();
            this.currentBPPosition -= inlineParent.getYOffset();
        }
    }

    protected void renderBlock(Block block) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderBlock() " + block));
        }
        this.saveBlockPosIfTargetable(block);
        this.pushID((Area)block);
        IFContext iFContext = this.documentHandler.getContext();
        Locale locale = iFContext.getLanguage();
        iFContext.setLanguage(block.getLocale());
        String string = iFContext.getLocation();
        iFContext.setLocation(block.getLocation());
        super.renderBlock(block);
        iFContext.setLocation(string);
        iFContext.setLanguage(locale);
        this.popID((Area)block);
    }

    private void pushID(Area area) {
        String string;
        if (!(area instanceof InlineArea)) {
            this.saveAreaCoordinatesRelativeToItsParent(area);
        }
        if ((string = (String)area.getTrait(Trait.PROD_ID)) != null) {
            this.ids.push(string);
            this.documentHandler.getContext().setID(string);
        }
    }

    private void popID(Area area) {
        String string;
        if (!(area instanceof InlineArea)) {
            this.removeAreaCoordinatesRelativeToItsParent();
        }
        if ((string = (String)area.getTrait(Trait.PROD_ID)) != null) {
            this.ids.pop();
            this.documentHandler.getContext().setID(this.ids.empty() ? "" : this.ids.peek());
        }
    }

    private Typeface getTypeface(String string) {
        Typeface typeface = this.fontInfo.getFonts().get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        return typeface;
    }

    protected void renderText(TextArea textArea) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderText() " + textArea));
        }
        this.renderInlineAreaBackAndBorders((InlineArea)((Object)textArea));
        Color color = (Color)textArea.getTrait(Trait.COLOR);
        this.beginTextObject();
        String string = this.getInternalFontNameForArea((Area)textArea);
        int n2 = (Integer)textArea.getTrait(Trait.FONT_SIZE);
        StructureTreeElement structureTreeElement = (StructureTreeElement)textArea.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
        this.establishStructureTreeElement(structureTreeElement);
        Typeface typeface = this.getTypeface(string);
        FontTriplet fontTriplet = (FontTriplet)textArea.getTrait(Trait.FONT);
        try {
            this.painter.setFont(fontTriplet.getName(), fontTriplet.getStyle(), Integer.valueOf(fontTriplet.getWeight()), "normal", Integer.valueOf(n2), color);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        int n3 = this.currentIPPosition + textArea.getBorderAndPaddingWidthStart();
        int n4 = this.currentBPPosition + textArea.getBlockProgressionOffset() + textArea.getBaselineOffset();
        this.textUtil.flush();
        this.textUtil.setStartPosition(n3, n4);
        this.textUtil.setSpacing(textArea.getTextLetterSpaceAdjust(), textArea.getTextWordSpaceAdjust());
        this.documentHandler.getContext().setHyphenated(textArea.isHyphenated());
        super.renderText(textArea);
        this.addSpaceAfterLastWord(textArea);
        this.textUtil.flush();
        this.renderTextDecoration((FontMetrics)typeface, n2, (InlineArea)((Object)textArea), n4, n3);
        this.documentHandler.getContext().setHyphenated(false);
        this.resetStructurePointer();
    }

    private void addSpaceAfterLastWord(TextArea textArea) {
        Character c2 = textArea.getSpaceThatFollows();
        StringBuffer stringBuffer = this.textUtil.text;
        int n2 = stringBuffer.length();
        if (c2 != null && n2 > 0 && !GlyphMapping.isSpace(stringBuffer.charAt(n2 - 1))) {
            this.textUtil.addChar(c2.charValue());
            this.textUtil.adjust(0);
        }
    }

    protected void renderWord(WordArea wordArea) {
        Font font = this.getFontFromArea(wordArea.getParentArea());
        String string = wordArea.getWord();
        int[][] nArray = wordArea.getGlyphPositionAdjustments();
        Area area = wordArea.getParentArea();
        assert (area instanceof AbstractTextArea);
        if (nArray == null) {
            this.renderTextWithAdjustments(string, wordArea.getLetterAdjustArray(), wordArea.isReversed(), font, (AbstractTextArea)area);
        } else if (IFUtil.isDPOnlyDX((int[][])nArray)) {
            this.renderTextWithAdjustments(string, IFUtil.convertDPToDX((int[][])nArray), wordArea.isReversed(), font, (AbstractTextArea)area);
        } else {
            this.renderTextWithAdjustments(string, nArray, wordArea.isReversed(), font, (AbstractTextArea)area);
        }
        this.textUtil.nextIsSpace = wordArea.isNextIsSpace();
        super.renderWord(wordArea);
    }

    protected void renderSpace(SpaceArea spaceArea) {
        Font font = this.getFontFromArea(spaceArea.getParentArea());
        String string = spaceArea.getSpace();
        Area area = spaceArea.getParentArea();
        assert (area instanceof AbstractTextArea);
        AbstractTextArea abstractTextArea = (AbstractTextArea)area;
        this.renderTextWithAdjustments(string, (int[])null, false, font, abstractTextArea);
        super.renderSpace(spaceArea);
    }

    private void renderTextWithAdjustments(String string, int[] nArray, boolean bl, Font font, AbstractTextArea abstractTextArea) {
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.textUtil.addChar(c2);
            int n3 = 0;
            if (nArray != null && i2 < n2) {
                n3 += nArray[i2];
            }
            this.textUtil.adjust(n3);
        }
    }

    private void renderTextWithAdjustments(String string, int[][] nArray, boolean bl, Font font, AbstractTextArea abstractTextArea) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.textUtil.addChar(string.charAt(i2));
            if (nArray == null) continue;
            this.textUtil.adjust(nArray[i2]);
        }
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        this.drawImage(image.getURL(), rectangle2D, image.getForeignAttributes());
    }

    protected void drawImage(String string, Rectangle2D rectangle2D, Map map) {
        Rectangle rectangle2 = new Rectangle(this.currentIPPosition + (int)rectangle2D.getX(), this.currentBPPosition + (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        string = URISpecification.getURL((String)string);
        try {
            this.establishForeignAttributes(map);
            this.painter.drawImage(string, rectangle2);
            new ImageMapIFRenderer((sVGDocument, rectangle) -> this.painter.drawImage((Document)sVGDocument, rectangle)).drawImageMap(rectangle2, map);
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    public void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
        this.endTextObject();
        Rectangle rectangle = new Rectangle(this.currentIPPosition + (int)rectangle2D.getX(), this.currentBPPosition + (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        Document document = foreignObject.getDocument();
        try {
            this.establishForeignAttributes(foreignObject.getForeignAttributes());
            this.painter.drawImage(document, rectangle);
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    public void renderLeader(Leader leader) {
        this.renderInlineAreaBackAndBorders((InlineArea)leader);
        int n2 = leader.getRuleStyle();
        int n3 = leader.getRuleThickness();
        int n4 = this.currentIPPosition + leader.getBorderAndPaddingWidthStart();
        int n5 = this.currentBPPosition + leader.getBlockProgressionOffset() + n3 / 2;
        int n6 = this.currentIPPosition + leader.getBorderAndPaddingWidthStart() + leader.getIPD();
        Color color = (Color)leader.getTrait(Trait.COLOR);
        Point point = new Point(n4, n5);
        Point point2 = new Point(n6, n5);
        try {
            this.painter.drawLine(point, point2, n3, color, RuleStyle.valueOf((int)n2));
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        super.renderLeader(leader);
    }

    protected void clip() {
        throw new IllegalStateException("Not used");
    }

    protected void clipRect(float f2, float f3, float f4, float f5) {
        this.pushGroup(new IFGraphicContext.Group());
        try {
            this.painter.clipRect(this.toMillipointRectangle(f2, f3, f4, f5));
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void clipBackground(float f2, float f3, float f4, float f5, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) {
        this.pushGroup(new IFGraphicContext.Group());
        Rectangle rectangle = this.toMillipointRectangle(f2, f3, f4, f5);
        try {
            this.painter.clipBackground(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void closePath() {
        throw new IllegalStateException("Not used");
    }

    protected void drawBackground(float f2, float f3, float f4, float f5, Trait.Background background, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) {
        if (this.painter.isBackgroundRequired(borderProps, borderProps2, borderProps3, borderProps4)) {
            super.drawBackground(f2, f3, f4, f5, background, borderProps, borderProps2, borderProps3, borderProps4);
        }
    }

    protected void drawBorders(float f2, float f3, float f4, float f5, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4, int n2, Color color) {
        Rectangle rectangle = this.toMillipointRectangle(f2, f3, f4, f5);
        try {
            BorderProps borderProps5;
            BorderProps borderProps6;
            BorderProps borderProps7 = borderProps;
            BorderProps borderProps8 = borderProps2;
            if (n2 == -1 || (n2 & 1) == 0) {
                borderProps6 = borderProps3;
                borderProps5 = borderProps4;
            } else {
                borderProps6 = borderProps4;
                borderProps5 = borderProps3;
            }
            this.painter.drawBorderRect(rectangle, borderProps7, borderProps8, borderProps6, borderProps5, color);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void drawBorderLine(float f2, float f3, float f4, float f5, boolean bl, boolean bl2, int n2, Color color) {
        this.updateColor(color, true);
        this.fillRect(f2, f3, f4 - f2, f5 - f3);
    }

    private int toMillipoints(float f2) {
        return Math.round(f2 * 1000.0f);
    }

    private Rectangle toMillipointRectangle(float f2, float f3, float f4, float f5) {
        return new Rectangle(this.toMillipoints(f2), this.toMillipoints(f3), this.toMillipoints(f4), this.toMillipoints(f5));
    }

    protected void fillRect(float f2, float f3, float f4, float f5) {
        try {
            this.painter.fillRect(this.toMillipointRectangle(f2, f3, f4, f5), this.graphicContext.getPaint());
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void moveTo(float f2, float f3) {
        throw new IllegalStateException("Not used");
    }

    protected void lineTo(float f2, float f3) {
        throw new IllegalStateException("Not used");
    }

    protected void updateColor(Color color, boolean bl) {
        if (bl) {
            this.graphicContext.setPaint((Paint)color);
        } else {
            this.graphicContext.setColor(color);
        }
    }

    public void processInternalLinkFromForeignObject(final PDFLinkRectangleWithShape pDFLinkRectangleWithShape, String string) {
        boolean bl;
        String string2;
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        boolean bl2 = (string2 = this.identifyPVKeyFromIDTracker(string)) != null && string2.length() > 0;
        boolean bl3 = bl = string != null && string.length() > 0;
        if (bl2 && bl) {
            Integer n2 = (Integer)this.pageIndices.get(string2);
            GoToXYAction goToXYAction = this.getGoToActionForID(string, n2 != null ? n2 : -1);
            Link link = new Link((AbstractAction)goToXYAction, pDFLinkRectangleWithShape){

                public Rectangle getTargetRect() {
                    return pDFLinkRectangleWithShape;
                }
            };
            this.deferredLinks.add(link);
        }
    }

    private String identifyPVKeyFromIDTracker(String string) {
        PageViewport pageViewport;
        String string2 = null;
        IDTracker iDTracker = AreaTreeHandler.AREA_TREE_HANDLER_INSTANCE.get().getIDTracker();
        if (iDTracker != null && (pageViewport = iDTracker.getFirstPageViewportContaining(string)) != null) {
            string2 = pageViewport.getKey();
        }
        return string2;
    }

    private class TextUtil {
        private static final int INITIAL_BUFFER_SIZE = 16;
        private int[][] dp = new int[16][];
        private final StringBuffer text = new StringBuffer();
        private int startx;
        private int starty;
        private int tls;
        private int tws;
        private boolean nextIsSpace;

        private TextUtil() {
        }

        void addChar(char c2) {
            this.text.append(c2);
        }

        void adjust(int n2) {
            if (n2 != 0) {
                this.adjust(new int[]{n2, 0, n2, 0});
            }
        }

        void adjust(int[] nArray) {
            if (!IFUtil.isPAIdentity((int[])nArray)) {
                int n2 = this.text.length();
                if (n2 > this.dp.length - 1) {
                    int n3 = Math.max(this.dp.length, n2 + 1) + 16;
                    int[][] nArrayArray = new int[n3][];
                    System.arraycopy(this.dp, 0, nArrayArray, 0, this.dp.length);
                    this.dp = nArrayArray;
                }
                if (this.dp[n2 - 1] == null) {
                    this.dp[n2 - 1] = new int[4];
                }
                IFUtil.adjustPA((int[])this.dp[n2 - 1], (int[])nArray);
            }
        }

        void reset() {
            if (this.text.length() > 0) {
                this.text.setLength(0);
                int n2 = this.dp.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.dp[i2] = null;
                }
            }
        }

        void setStartPosition(int n2, int n3) {
            this.startx = n2;
            this.starty = n3;
        }

        void setSpacing(int n2, int n3) {
            this.tls = n2;
            this.tws = n3;
        }

        void flush() {
            if (this.text.length() > 0) {
                try {
                    IFRenderer.this.painter.drawText(this.startx, this.starty, this.tls, this.tws, this.trimAdjustments(this.dp, this.text.length()), this.text.toString(), this.nextIsSpace);
                }
                catch (IFException iFException) {
                    IFRenderer.this.handleIFException(iFException);
                }
                this.reset();
            }
        }

        void drawText(int n2, int n3, int n4, int n5, int[][] nArray, String string, boolean bl) throws IFException {
            IFRenderer.this.painter.drawText(this.startx, this.starty, this.tls, this.tws, nArray, string, bl);
        }

        private int[][] trimAdjustments(int[][] nArray, int n2) {
            if (nArray != null) {
                int[] nArray2;
                int n3;
                int n4 = n2;
                int n5 = nArray.length;
                int n6 = n3 = n4 < n5 ? n4 : n5;
                while (n3 > 0 && ((nArray2 = nArray[n3 - 1]) == null || IFUtil.isPAIdentity((int[])nArray2))) {
                    --n3;
                }
                if (n3 == 0) {
                    nArray = null;
                } else if (n3 < n5) {
                    nArray = IFUtil.copyDP((int[][])nArray, (int)0, (int)n3);
                }
            }
            return nArray;
        }
    }
}

