/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.StreamCache;
import org.apache.xmlgraphics.image.loader.impl.VideoMP4Image;

public class VideoStreamCache
implements StreamCache {
    private VideoMP4Image image;
    private ByteArrayOutputStream output;

    public VideoStreamCache(VideoMP4Image videoMP4Image) {
        this.image = videoMP4Image;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new ByteArrayOutputStream(512);
        }
        return this.output;
    }

    public void write(byte[] byArray) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outputContents(OutputStream outputStream) throws IOException {
        if (this.output == null) {
            return 0;
        }
        this.output.close();
        this.output = null;
        InputStream inputStream = this.image.createInputStream();
        try {
            int n2 = IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            return n2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public int getSize() throws IOException {
        if (this.output == null) {
            return 0;
        }
        return this.output.size();
    }

    public void clear() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

