/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFLinkQuadPointsBuilder;
import org.apache.fop.pdf.PDFLinkRectangleWithShape;
import org.apache.fop.pdf.PDFObject;

public class PDFLink
extends PDFObject {
    public static final int EXTERNAL = 0;
    public static final int INTERNAL = 1;
    private float ulx;
    private float uly;
    private float brx;
    private float bry;
    private String color;
    private PDFAction action;
    private Integer structParent;
    private Shape shape;

    public PDFLink(Shape shape) {
        if (shape instanceof PDFLinkRectangleWithShape) {
            this.shape = ((PDFLinkRectangleWithShape)shape).getOriginalShape();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.ulx = (float)rectangle2D.getX();
        this.uly = (float)rectangle2D.getY();
        this.brx = (float)(rectangle2D.getX() + rectangle2D.getWidth());
        this.bry = (float)(rectangle2D.getY() + rectangle2D.getHeight());
        this.color = "0 0 0";
    }

    public void setAction(PDFAction pDFAction) {
        this.action = pDFAction;
    }

    public void setStructParent(int n2) {
        this.structParent = n2;
    }

    public String toPDFString() {
        this.getDocumentSafely().getProfile().verifyAnnotAllowed();
        Object object = "";
        if (this.getDocumentSafely().getProfile().getPDFAMode().isEnabled()) {
            int n2 = 0;
            n2 |= 4;
            n2 |= 8;
            object = "/F " + (n2 |= 0x10);
        }
        String string = new PDFLinkQuadPointsBuilder(this.shape).getQuadPoints();
        String string2 = "<< /Type /Annot\n/Subtype /Link\n/Rect [ " + this.ulx + " " + this.uly + " " + this.brx + " " + this.bry + " ]\n" + string + "/C [ " + this.color + " ]\n/Border [ 0 0 0 ]\n/A " + this.action.getAction() + "\n/H /I\n" + (String)(this.structParent != null ? "/StructParent " + this.structParent.toString() + "\n" : "") + (String)object + "\n>>";
        return string2;
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (this == pDFObject) {
            return true;
        }
        if (pDFObject == null || !(pDFObject instanceof PDFLink)) {
            return false;
        }
        PDFLink pDFLink = (PDFLink)pDFObject;
        if (pDFLink.ulx != this.ulx || pDFLink.uly != this.uly || pDFLink.brx != this.brx || pDFLink.bry != this.bry) {
            return false;
        }
        return pDFLink.color.equals(this.color) && pDFLink.action.getAction().equals(this.action.getAction());
    }

    public void getChildren(Set<PDFObject> set) {
        super.getChildren(set);
        if (this.action.hasObjectNumber()) {
            set.add((PDFObject)this.action);
        }
        this.action.getChildren(set);
    }
}

