/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.OTFSubSetFile;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.fonts.type1.Type1SubsetFile;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCFFStream;
import org.apache.fop.pdf.PDFCFFStreamType0C;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDPart;
import org.apache.fop.pdf.PDFDPartRoot;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFJavaScriptLaunchAction;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLayer;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNameTreeNode;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFNavigator;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFSeparationColorSpace;
import org.apache.fop.pdf.PDFSetOCGStateAction;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFToUnicodeCMap;
import org.apache.fop.pdf.PDFTransitionAction;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;
import org.apache.fop.pdf.RefPDFFont;
import org.apache.fop.pdf.Version;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFFactory {
    public static final int DEFAULT_PDF_RESOLUTION = 72;
    private PDFDocument document;
    private Log log = LogFactory.getLog(PDFFactory.class);
    private int subsetFontCounter = -1;
    private Map<String, PDFDPart> dparts = new HashMap<String, PDFDPart>();
    private EventBroadcaster eventBroadcaster;

    public PDFFactory(PDFDocument pDFDocument) {
        this.document = pDFDocument;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pDFPages) {
        PDFRoot pDFRoot = new PDFRoot(this.document, pDFPages);
        pDFRoot.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pDFRoot);
        return pDFRoot;
    }

    public PDFPages makePages() {
        PDFPages pDFPages = new PDFPages(this.getDocument());
        pDFPages.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pDFPages);
        return pDFPages;
    }

    public PDFResources makeResources() {
        PDFResources pDFResources = new PDFResources(this.getDocument());
        pDFResources.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pDFResources);
        return pDFResources;
    }

    protected PDFInfo makeInfo(String string) {
        PDFInfo pDFInfo = new PDFInfo();
        pDFInfo.setProducer(string);
        this.getDocument().registerObject((PDFObject)pDFInfo);
        return pDFInfo;
    }

    public PDFMetadata makeMetadata(Metadata metadata, boolean bl) {
        PDFMetadata pDFMetadata = new PDFMetadata(metadata, bl);
        this.getDocument().registerObject((PDFObject)pDFMetadata);
        return pDFMetadata;
    }

    public PDFOutputIntent makeOutputIntent() {
        PDFOutputIntent pDFOutputIntent = new PDFOutputIntent();
        this.getDocument().registerObject((PDFObject)pDFOutputIntent);
        return pDFOutputIntent;
    }

    public PDFPage makePage(PDFResources pDFResources, int n2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, Rectangle2D rectangle2D4) {
        PDFPage pDFPage = new PDFPage(pDFResources, n2, rectangle2D, rectangle2D2, rectangle2D3, rectangle2D4);
        this.getDocument().assignObjectNumber((PDFObject)pDFPage);
        this.getDocument().getPages().addPage(pDFPage);
        return pDFPage;
    }

    public PDFPage makePage(PDFResources pDFResources, int n2, int n3, int n4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2, n3);
        return this.makePage(pDFResources, n4, double_, double_, double_, double_);
    }

    public PDFPage makePage(PDFResources pDFResources, int n2, int n3) {
        return this.makePage(pDFResources, n2, n3, -1);
    }

    public PDFFunction makeFunction(List list, List list2, float[] fArray, float[] fArray2, double d2) {
        PDFFunction pDFFunction = new PDFFunction(list, list2, fArray, fArray2, d2);
        pDFFunction = this.registerFunction(pDFFunction);
        return pDFFunction;
    }

    public PDFFunction registerFunction(PDFFunction pDFFunction) {
        PDFFunction pDFFunction2 = this.getDocument().findFunction(pDFFunction);
        if (pDFFunction2 == null) {
            this.getDocument().registerObject((PDFObject)pDFFunction);
        } else {
            pDFFunction = pDFFunction2;
        }
        return pDFFunction;
    }

    public PDFShading registerShading(PDFResourceContext pDFResourceContext, PDFShading pDFShading) {
        PDFShading pDFShading2 = this.getDocument().findShading(pDFShading);
        if (pDFShading2 == null) {
            this.getDocument().registerObject((PDFObject)pDFShading);
        } else {
            pDFShading = pDFShading2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.addShading(pDFShading);
        }
        return pDFShading;
    }

    public PDFPattern makePattern(PDFResourceContext pDFResourceContext, int n2, PDFResources pDFResources, int n3, int n4, List list, double d2, double d3, List list2, List list3, StringBuffer stringBuffer) {
        PDFPattern pDFPattern = new PDFPattern(pDFResources, 1, n3, n4, list, d2, d3, list2, list3, stringBuffer);
        PDFPattern pDFPattern2 = this.getDocument().findPattern(pDFPattern);
        if (pDFPattern2 == null) {
            this.getDocument().registerObject((PDFObject)pDFPattern);
        } else {
            pDFPattern = pDFPattern2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.addPattern(pDFPattern);
        }
        return pDFPattern;
    }

    public PDFPattern registerPattern(PDFResourceContext pDFResourceContext, PDFPattern pDFPattern) {
        PDFPattern pDFPattern2 = this.getDocument().findPattern(pDFPattern);
        if (pDFPattern2 == null) {
            this.getDocument().registerObject((PDFObject)pDFPattern);
        } else {
            pDFPattern = pDFPattern2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.addPattern(pDFPattern);
        }
        return pDFPattern;
    }

    protected PDFDestination getUniqueDestination(PDFDestination pDFDestination) {
        PDFDestination pDFDestination2 = this.getDocument().findDestination(pDFDestination);
        if (pDFDestination2 != null) {
            return pDFDestination2;
        }
        this.getDocument().addDestination(pDFDestination);
        return pDFDestination;
    }

    public PDFDestination makeDestination(String string, Object object) {
        PDFDestination pDFDestination = new PDFDestination(string, object);
        return this.getUniqueDestination(pDFDestination);
    }

    public PDFNames makeNames() {
        PDFNames pDFNames = new PDFNames();
        this.getDocument().assignObjectNumber((PDFObject)pDFNames);
        this.getDocument().addTrailerObject((PDFObject)pDFNames);
        return pDFNames;
    }

    public PDFPageLabels makePageLabels() {
        PDFPageLabels pDFPageLabels = new PDFPageLabels();
        this.getDocument().assignObjectNumber((PDFObject)pDFPageLabels);
        this.getDocument().addTrailerObject((PDFObject)pDFPageLabels);
        return pDFPageLabels;
    }

    public PDFDests makeDests(List list) {
        boolean bl = true;
        PDFDests pDFDests = new PDFDests();
        PDFArray pDFArray = new PDFArray((PDFObject)pDFDests);
        for (Object e2 : list) {
            PDFDestination pDFDestination = (PDFDestination)e2;
            PDFNameTreeNode pDFNameTreeNode = new PDFNameTreeNode();
            this.getDocument().registerObject((PDFObject)pDFNameTreeNode);
            pDFNameTreeNode.setLowerLimit(pDFDestination.getIDRef());
            pDFNameTreeNode.setUpperLimit(pDFDestination.getIDRef());
            pDFNameTreeNode.setNames(new PDFArray((PDFObject)pDFNameTreeNode));
            PDFArray pDFArray2 = pDFNameTreeNode.getNames();
            pDFArray2.add((Object)pDFDestination);
            pDFArray.add((Object)pDFNameTreeNode);
        }
        pDFDests.setLowerLimit(((PDFNameTreeNode)pDFArray.get(0)).getLowerLimit());
        pDFDests.setUpperLimit(((PDFNameTreeNode)pDFArray.get(pDFArray.length() - 1)).getUpperLimit());
        pDFDests.setKids(pDFArray);
        this.getDocument().registerObject((PDFObject)pDFDests);
        return pDFDests;
    }

    public PDFNameTreeNode makeNameTreeNode() {
        PDFNameTreeNode pDFNameTreeNode = new PDFNameTreeNode();
        this.getDocument().registerObject((PDFObject)pDFNameTreeNode);
        return pDFNameTreeNode;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, PDFAction pDFAction) {
        if (rectangle2D == null || pDFAction == null) {
            return null;
        }
        PDFLink pDFLink = new PDFLink(rectangle2D);
        pDFLink.setAction(pDFAction);
        this.getDocument().registerObject((PDFObject)pDFLink);
        return pDFLink;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, String string, String string2) {
        PDFLink pDFLink = new PDFLink(rectangle2D);
        this.getDocument().registerObject((PDFObject)pDFLink);
        PDFGoTo pDFGoTo = new PDFGoTo(string);
        pDFGoTo.setDestination(string2);
        this.getDocument().registerObject((PDFObject)pDFGoTo);
        PDFInternalLink pDFInternalLink = new PDFInternalLink(pDFGoTo.referencePDF());
        pDFLink.setAction((PDFAction)pDFInternalLink);
        return pDFLink;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, String string, boolean bl) {
        PDFLink pDFLink = new PDFLink(rectangle2D);
        this.getDocument().registerObject((PDFObject)pDFLink);
        PDFGoTo pDFGoTo = new PDFGoTo(string, bl);
        this.getDocument().registerObject((PDFObject)pDFGoTo);
        pDFLink.setAction((PDFAction)pDFGoTo);
        return pDFLink;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, String string, int n2, float f2) {
        Object object;
        PDFLink pDFLink = new PDFLink(rectangle2D);
        if (n2 == 0) {
            object = this.getExternalAction(string, false);
            if (!object.hasObjectNumber()) {
                this.getDocument().registerObject((PDFObject)object);
            }
            pDFLink.setAction((PDFAction)object);
        } else {
            object = this.getGoToReference(string, f2);
            PDFInternalLink pDFInternalLink = new PDFInternalLink((String)object);
            pDFLink.setAction((PDFAction)pDFInternalLink);
        }
        object = this.getDocument().findLink(pDFLink);
        if (object == null) {
            this.getDocument().registerObject((PDFObject)pDFLink);
        } else {
            pDFLink = object;
        }
        return pDFLink;
    }

    public PDFAction getExternalAction(String string, boolean bl) {
        URI uRI = this.getTargetUri(string);
        if (uRI != null) {
            String string2 = uRI.getScheme();
            String string3 = uRI.getPath();
            if (string3 == null) {
                string3 = uRI.getSchemeSpecificPart();
            }
            if (string2 == null && string3.toLowerCase().endsWith(".pdf")) {
                string2 = "file";
            }
            if (string2 == null) {
                return new PDFUri(uRI.toASCIIString());
            }
            if (string2.equalsIgnoreCase("embedded-file")) {
                return this.getActionForEmbeddedFile(string3, bl);
            }
            if (string2.equalsIgnoreCase("file")) {
                if (string3.startsWith("//")) {
                    string3 = string3.replace("/", "\\");
                } else if (string3.matches("^/[A-z]:/.*")) {
                    string3 = string3.substring(1);
                }
                if (string3.toLowerCase().endsWith(".pdf")) {
                    int n2 = -1;
                    String string4 = null;
                    String string5 = uRI.getFragment();
                    if (string5 != null) {
                        String string6 = string5.toLowerCase();
                        if (string6.startsWith("page=")) {
                            n2 = Integer.parseInt(string6.substring(5));
                        } else if (string6.startsWith("dest=")) {
                            string4 = string5.substring(5);
                        }
                    }
                    return this.getGoToPDFAction(string3, string4, n2, bl);
                }
                if (uRI.getQuery() != null || uRI.getFragment() != null) {
                    return new PDFUri(uRI.toASCIIString());
                }
                return this.getLaunchAction(string3, bl);
            }
            return new PDFUri(uRI.toASCIIString());
        }
        return new PDFUri(string);
    }

    private URI getTargetUri(String string) {
        URI uRI;
        try {
            uRI = new URI(string);
            String string2 = uRI.getScheme();
            String string3 = uRI.getSchemeSpecificPart();
            String string4 = uRI.getAuthority();
            if (string2 == null && string3.matches("//.*")) {
                uRI = this.getFileUri(string);
            } else if (string2 == null && string3.matches("/.*")) {
                uRI = this.getFileUri(string);
            } else if (string2 != null && string2.matches("[A-z]")) {
                uRI = this.getFileUri(string);
            } else if (string2 != null && string2.equalsIgnoreCase("file") && string4 != null) {
                uRI = this.getFileUri(string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = this.getFileUri(string);
        }
        return uRI;
    }

    private URI getFileUri(String string) {
        URI uRI;
        String string2 = null;
        String string3 = null;
        Object object = string;
        String string4 = string.toLowerCase();
        int n2 = string4.indexOf(".pdf#page=");
        if (n2 > 0 || (n2 = string4.indexOf(".pdf#dest=")) > 0) {
            object = string.substring(0, n2 + 4);
            string3 = string.substring(n2 + 5);
        }
        if (string4.startsWith("file://")) {
            string2 = "file";
            object = ((String)object).substring("file://".length());
        } else if (string4.startsWith("embedded-file:")) {
            string2 = "embedded-file";
            object = ((String)object).substring("embedded-file:".length());
        } else if (string4.startsWith("file:")) {
            string2 = "file";
            object = ((String)object).substring("file:".length());
        }
        try {
            object = ((String)object).replace("\\", "/");
            if (((String)object).matches("[A-z]:.*")) {
                string2 = string2 == null ? "file" : string2;
                object = "/" + (String)object;
            } else if (((String)object).matches("//.*")) {
                string2 = string2 == null ? "file" : string2;
                object = "//" + (String)object;
            } else if (((String)object).matches("/.*")) {
                string2 = string2 == null ? "file" : string2;
            }
            uRI = new URI(string2, (String)object, string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
        return uRI;
    }

    private PDFAction getActionForEmbeddedFile(String string, boolean bl) {
        Object object;
        PDFNames pDFNames = this.getDocument().getRoot().getNames();
        if (pDFNames == null) {
            throw new IllegalStateException("No Names dictionary present. Cannot create Launch Action for embedded file: " + string);
        }
        PDFEmbeddedFiles pDFEmbeddedFiles = pDFNames.getEmbeddedFiles();
        if (pDFEmbeddedFiles == null) {
            throw new IllegalStateException("No /EmbeddedFiles name tree present. Cannot create Launch Action for embedded file: " + string);
        }
        PDFArray pDFArray = pDFEmbeddedFiles.getNames();
        PDFFileSpec pDFFileSpec = null;
        for (int i2 = 0; i2 < pDFArray.length(); ++i2) {
            if (!((object = (PDFReference)pDFArray.get(++i2)).getObject() instanceof PDFFileSpec) || !((PDFFileSpec)object.getObject()).getUnicodeFilename().equals(string)) continue;
            pDFFileSpec = (PDFFileSpec)object.getObject();
            break;
        }
        if (pDFFileSpec == null) {
            throw new IllegalStateException("No embedded file with name " + string + " present.");
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("this.exportDataObject({cName:\"");
        ((StringBuffer)object).append(pDFFileSpec.getFilename());
        ((StringBuffer)object).append("\", nLaunch:2});");
        PDFJavaScriptLaunchAction pDFJavaScriptLaunchAction = new PDFJavaScriptLaunchAction(((StringBuffer)object).toString());
        return pDFJavaScriptLaunchAction;
    }

    public String getGoToReference(String string, float f2) {
        return this.getPDFGoTo(string, new Point2D.Float(0.0f, f2)).referencePDF();
    }

    public PDFGoTo getPDFGoTo(String string, Point2D point2D) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFGoTo pDFGoTo = new PDFGoTo(string, point2D);
        PDFGoTo pDFGoTo2 = this.getDocument().findGoTo(pDFGoTo);
        if (pDFGoTo2 == null) {
            this.getDocument().assignObjectNumber((PDFObject)pDFGoTo);
            this.getDocument().addTrailerObject((PDFObject)pDFGoTo);
        } else {
            pDFGoTo = pDFGoTo2;
        }
        return pDFGoTo;
    }

    private PDFGoToRemote getGoToPDFAction(String string, String string2, int n2, boolean bl) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec pDFFileSpec = new PDFFileSpec(string);
        PDFFileSpec pDFFileSpec2 = this.getDocument().findFileSpec(pDFFileSpec);
        if (pDFFileSpec2 == null) {
            this.getDocument().registerObject((PDFObject)pDFFileSpec);
        } else {
            pDFFileSpec = pDFFileSpec2;
        }
        PDFGoToRemote pDFGoToRemote = string2 == null && n2 == -1 ? new PDFGoToRemote(pDFFileSpec, bl) : (string2 != null ? new PDFGoToRemote(pDFFileSpec, string2, bl) : new PDFGoToRemote(pDFFileSpec, n2, bl));
        PDFGoToRemote pDFGoToRemote2 = this.getDocument().findGoToRemote(pDFGoToRemote);
        if (pDFGoToRemote2 == null) {
            this.getDocument().registerObject((PDFObject)pDFGoToRemote);
        } else {
            pDFGoToRemote = pDFGoToRemote2;
        }
        return pDFGoToRemote;
    }

    private PDFLaunch getLaunchAction(String string, boolean bl) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec pDFFileSpec = new PDFFileSpec(string);
        PDFFileSpec pDFFileSpec2 = this.getDocument().findFileSpec(pDFFileSpec);
        if (pDFFileSpec2 == null) {
            this.getDocument().registerObject((PDFObject)pDFFileSpec);
        } else {
            pDFFileSpec = pDFFileSpec2;
        }
        PDFLaunch pDFLaunch = new PDFLaunch(pDFFileSpec, bl);
        PDFLaunch pDFLaunch2 = this.getDocument().findLaunch(pDFLaunch);
        if (pDFLaunch2 == null) {
            this.getDocument().registerObject((PDFObject)pDFLaunch);
        } else {
            pDFLaunch = pDFLaunch2;
        }
        return pDFLaunch;
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, PDFReference pDFReference, boolean bl) {
        PDFOutline pDFOutline2 = new PDFOutline(string, pDFReference, bl);
        if (pDFOutline != null) {
            pDFOutline.addOutline(pDFOutline2);
        }
        this.getDocument().registerObject((PDFObject)pDFOutline2);
        return pDFOutline2;
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, PDFAction pDFAction, boolean bl) {
        return pDFAction == null ? null : this.makeOutline(pDFOutline, string, new PDFReference(pDFAction.getAction()), bl);
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, String string2, float f2, boolean bl) {
        String string3 = this.getGoToReference(string2, f2);
        return this.makeOutline(pDFOutline, string, new PDFReference(string3), bl);
    }

    public PDFEncoding makeEncoding(String string) {
        PDFEncoding pDFEncoding = new PDFEncoding(string);
        this.getDocument().registerObject((PDFObject)pDFEncoding);
        return pDFEncoding;
    }

    public PDFFont makeFont(String string, String string2, String string3, FontMetrics fontMetrics, FontDescriptor fontDescriptor) {
        PDFFont pDFFont = this.getDocument().findFont(string);
        if (pDFFont != null) {
            return pDFFont;
        }
        boolean bl = true;
        if (fontDescriptor == null) {
            PDFFont pDFFont2 = new PDFFont(string, FontType.TYPE1, string2, (Object)string3);
            this.getDocument().registerObject((PDFObject)pDFFont2);
            if (bl && !PDFEncoding.isPredefinedEncoding((String)string3)) {
                CodePointMapping codePointMapping;
                if (string3 != null) {
                    codePointMapping = CodePointMapping.getMapping((String)string3);
                } else {
                    Typeface typeface = (Typeface)fontMetrics;
                    codePointMapping = CodePointMapping.getMapping((String)typeface.getEncodingName());
                }
                this.generateToUnicodeCmap(pDFFont2, (SingleByteEncoding)codePointMapping);
            }
            return pDFFont2;
        }
        FontType fontType = fontMetrics.getFontType();
        String string4 = fontDescriptor.isSubsetEmbedded() ? this.createSubsetFontPrefix() : "";
        String string5 = string4 + string2;
        PDFFontDescriptor pDFFontDescriptor = this.makeFontDescriptor(fontDescriptor, string4);
        PDFFont pDFFont3 = null;
        pDFFont3 = PDFFont.createFont((String)string, (FontType)fontType, (String)string5, null);
        if (fontDescriptor instanceof RefPDFFont) {
            pDFFont3.setObjectNumber(((RefPDFFont)fontDescriptor).getRef().getObjectNumber());
            pDFFont3.setDocument(this.getDocument());
            this.getDocument().addObject((PDFObject)pDFFont3);
        } else {
            this.getDocument().registerObject((PDFObject)pDFFont3);
        }
        if (fontType == FontType.TYPE0 || fontType == FontType.CIDTYPE0) {
            PDFCMap pDFCMap;
            pDFFont3.setEncoding(string3);
            CIDFont cIDFont = fontMetrics instanceof LazyFont ? (CIDFont)((LazyFont)fontMetrics).getRealFont() : (CIDFont)fontMetrics;
            PDFCIDSystemInfo pDFCIDSystemInfo = new PDFCIDSystemInfo(cIDFont.getRegistry(), cIDFont.getOrdering(), cIDFont.getSupplement());
            pDFCIDSystemInfo.setDocument(this.document);
            assert (pDFFontDescriptor instanceof PDFCIDFontDescriptor);
            PDFCIDFont pDFCIDFont = new PDFCIDFont(string5, cIDFont.getCIDType(), cIDFont.getDefaultWidth(), this.getFontWidths(cIDFont), pDFCIDSystemInfo, (PDFCIDFontDescriptor)pDFFontDescriptor);
            this.getDocument().registerObject((PDFObject)pDFCIDFont);
            if (cIDFont instanceof MultiByteFont && ((MultiByteFont)cIDFont).getCmapStream() != null) {
                pDFCMap = new PDFCMap("fop-ucs-H", null);
                try {
                    pDFCMap.setData(IOUtils.toByteArray((InputStream)((MultiByteFont)cIDFont).getCmapStream()));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                pDFCMap = new PDFToUnicodeCMap(cIDFont.getCIDSet().getChars(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), false, this.eventBroadcaster, cIDFont instanceof MultiByteFont ? ((MultiByteFont)cIDFont).getSubstToOriginal() : null);
            }
            this.getDocument().registerObject((PDFObject)pDFCMap);
            assert (pDFFont3 instanceof PDFFontType0);
            ((PDFFontType0)pDFFont3).setCMAP(pDFCMap);
            ((PDFFontType0)pDFFont3).setDescendantFonts(pDFCIDFont);
        } else if (fontType == FontType.TYPE1C && (fontMetrics instanceof LazyFont || fontMetrics instanceof MultiByteFont)) {
            this.handleType1CFont(pDFFontDescriptor, pDFFont3, fontMetrics, string, string2, fontDescriptor);
        } else {
            PDFFontNonBase14 pDFFontNonBase14;
            Object[] objectArray;
            Object object;
            Map map;
            assert (pDFFont3 instanceof PDFFontNonBase14);
            PDFFontNonBase14 pDFFontNonBase142 = (PDFFontNonBase14)pDFFont3;
            pDFFontNonBase142.setDescriptor(pDFFontDescriptor);
            SingleByteFont singleByteFont = fontMetrics instanceof LazyFont ? (SingleByteFont)((LazyFont)fontMetrics).getRealFont() : (SingleByteFont)fontMetrics;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            if (singleByteFont.getEmbeddingMode() == EmbeddingMode.SUBSET) {
                map = singleByteFont.getUsedGlyphs();
                if (fontType == FontType.TYPE1 && map.size() > 0) {
                    object = new TreeSet(map.keySet());
                    object.remove(0);
                    if (object.size() > 0) {
                        n2 = (Integer)object.first();
                        n3 = (Integer)object.last();
                        objectArray = new int[n3 - n2 + 1];
                        for (int i2 = n2; i2 < n3 + 1; ++i2) {
                            if (map.get(i2) != null) {
                                if (i2 - singleByteFont.getFirstChar() < fontMetrics.getWidths().length) {
                                    objectArray[i2 - n2] = fontMetrics.getWidths()[i2 - singleByteFont.getFirstChar()];
                                    continue;
                                }
                                bl2 = true;
                                break;
                            }
                            objectArray[i2 - n2] = '\u0000';
                        }
                        pDFFontNonBase142.setWidthMetrics(n2, n3, new PDFArray(null, (int[])objectArray));
                    }
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                n2 = singleByteFont.getFirstChar();
                n3 = singleByteFont.getLastChar();
                pDFFontNonBase142.setWidthMetrics(n2, n3, new PDFArray(null, fontMetrics.getWidths()));
            }
            map = singleByteFont.getEncoding();
            if (singleByteFont.isSymbolicFont()) {
                if (bl) {
                    this.generateToUnicodeCmap((PDFFont)pDFFontNonBase142, (SingleByteEncoding)map);
                }
            } else if (PDFEncoding.isPredefinedEncoding((String)map.getName())) {
                pDFFont3.setEncoding(map.getName());
            } else if (map.getName().equals("FOPPDFEncoding")) {
                if (fontType == FontType.TRUETYPE) {
                    pDFFont3.setEncoding(string3);
                } else {
                    object = map.getCharNameMap();
                    objectArray = map.getUnicodeCharMap();
                    PDFArray pDFArray = new PDFArray();
                    int n4 = objectArray.length;
                    if (((Object)object).length < n4) {
                        n4 = ((Object)object).length;
                    }
                    int n5 = Integer.MIN_VALUE;
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (objectArray[i3] - '\u0001' != n5) {
                            pDFArray.add((double)objectArray[i3]);
                        }
                        n5 = objectArray[i3];
                        pDFArray.add((Object)new PDFName((String)object[i3]));
                    }
                    pDFFontNonBase14 = new PDFEncoding(singleByteFont.getEncodingName());
                    this.getDocument().registerObject((PDFObject)pDFFontNonBase14);
                    pDFFontNonBase14.setDifferences(pDFArray);
                    pDFFont3.setEncoding((PDFEncoding)pDFFontNonBase14);
                    if (map.getUnicodeCharMap() != null) {
                        this.generateToUnicodeCmap((PDFFont)pDFFontNonBase142, (SingleByteEncoding)map);
                    }
                }
            } else {
                object = this.createPDFEncoding((SingleByteEncoding)map, singleByteFont.getFontName());
                if (object instanceof PDFEncoding) {
                    pDFFont3.setEncoding((PDFEncoding)object);
                } else {
                    pDFFont3.setEncoding((String)object);
                }
                if (bl) {
                    this.generateToUnicodeCmap((PDFFont)pDFFontNonBase142, (SingleByteEncoding)map);
                }
            }
            if (singleByteFont.hasAdditionalEncodings()) {
                int n6 = singleByteFont.getAdditionalEncodingCount();
                for (int i4 = 0; i4 < n6; ++i4) {
                    SimpleSingleByteEncoding simpleSingleByteEncoding = singleByteFont.getAdditionalEncoding(i4);
                    String string6 = string + "_" + (i4 + 1);
                    Object object2 = this.createPDFEncoding((SingleByteEncoding)simpleSingleByteEncoding, singleByteFont.getFontName());
                    pDFFontNonBase14 = (PDFFontNonBase14)PDFFont.createFont((String)string6, (FontType)fontType, (String)string2, (Object)object2);
                    pDFFontNonBase14.setDescriptor(pDFFontDescriptor);
                    pDFFontNonBase14.setWidthMetrics(simpleSingleByteEncoding.getFirstChar(), simpleSingleByteEncoding.getLastChar(), new PDFArray(null, singleByteFont.getAdditionalWidths(i4)));
                    this.getDocument().registerObject((PDFObject)pDFFontNonBase14);
                    this.getDocument().getResources().addFont((PDFFont)pDFFontNonBase14);
                    if (!bl) continue;
                    this.generateToUnicodeCmap((PDFFont)pDFFontNonBase14, (SingleByteEncoding)simpleSingleByteEncoding);
                }
            }
        }
        return pDFFont3;
    }

    private void handleType1CFont(PDFFontDescriptor pDFFontDescriptor, PDFFont pDFFont, FontMetrics fontMetrics, String string, String string2, FontDescriptor fontDescriptor) {
        PDFFontNonBase14 pDFFontNonBase14 = (PDFFontNonBase14)pDFFont;
        pDFFontNonBase14.setDescriptor(pDFFontDescriptor);
        MultiByteFont multiByteFont = fontMetrics instanceof LazyFont ? (MultiByteFont)((LazyFont)fontMetrics).getRealFont() : (MultiByteFont)fontMetrics;
        Map<Integer, Integer> map = multiByteFont.getUsedGlyphs();
        TreeSet<Integer> treeSet = new TreeSet<Integer>(map.keySet());
        treeSet.remove(0);
        int n2 = treeSet.size();
        Iterator<String> iterator = multiByteFont.getUsedGlyphNames().values().iterator();
        n2 = this.setupFontMetrics(pDFFontNonBase14, pDFFontDescriptor, iterator, 0, n2, fontMetrics);
        List<PDFFontNonBase14> list = this.addAdditionalEncodings(fontMetrics, fontDescriptor, string, string2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PDFFontNonBase14 pDFFontNonBase142 = list.get(i2);
            int n3 = 256 * (i2 + 1);
            n2 = this.setupFontMetrics(pDFFontNonBase142, pDFFontDescriptor, iterator, n3, n2, fontMetrics);
        }
    }

    private int setupFontMetrics(PDFFontNonBase14 pDFFontNonBase14, PDFFontDescriptor pDFFontDescriptor, Iterator<String> iterator, int n2, int n3, FontMetrics fontMetrics) {
        pDFFontNonBase14.setDescriptor(pDFFontDescriptor);
        PDFArray pDFArray = new PDFArray();
        int n4 = 0;
        pDFArray.add((double)n4);
        int n5 = Math.min(n3, 255);
        int[] nArray = new int[n5 + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = fontMetrics.getWidth(n2 + i2, 1);
            pDFArray.add((Object)new PDFName(iterator.next()));
            --n3;
        }
        pDFFontNonBase14.setWidthMetrics(n4, n5, new PDFArray(null, nArray));
        PDFEncoding pDFEncoding = new PDFEncoding("WinAnsiEncoding");
        this.getDocument().registerTrailerObject((PDFObject)pDFEncoding);
        pDFEncoding.setDifferences(pDFArray);
        pDFFontNonBase14.setEncoding(pDFEncoding);
        return n3;
    }

    private List<PDFFontNonBase14> addAdditionalEncodings(FontMetrics fontMetrics, FontDescriptor fontDescriptor, String string, String string2) {
        CustomFont customFont;
        ArrayList<PDFFontNonBase14> arrayList = new ArrayList<PDFFontNonBase14>();
        FontType fontType = fontMetrics.getFontType();
        if (fontDescriptor != null && fontType != FontType.TYPE0 && (customFont = fontMetrics instanceof LazyFont ? (CustomFont)((LazyFont)fontMetrics).getRealFont() : (CustomFont)fontMetrics).hasAdditionalEncodings()) {
            int n2 = customFont.getAdditionalEncodingCount();
            for (int i2 = arrayList.size(); i2 < n2; ++i2) {
                SimpleSingleByteEncoding simpleSingleByteEncoding = customFont.getAdditionalEncoding(i2);
                String string3 = string + "_" + (i2 + 1);
                Object object = this.createPDFEncoding((SingleByteEncoding)simpleSingleByteEncoding, customFont.getFontName());
                PDFFontNonBase14 pDFFontNonBase14 = (PDFFontNonBase14)PDFFont.createFont((String)string3, (FontType)fontType, (String)string2, (Object)object);
                this.getDocument().registerObject((PDFObject)pDFFontNonBase14);
                this.getDocument().getResources().addFont((PDFFont)pDFFontNonBase14);
                arrayList.add(pDFFontNonBase14);
            }
        }
        return arrayList;
    }

    private void generateToUnicodeCmap(PDFFont pDFFont, SingleByteEncoding singleByteEncoding) {
        PDFToUnicodeCMap pDFToUnicodeCMap = new PDFToUnicodeCMap(singleByteEncoding.getUnicodeCharMap(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), true, this.eventBroadcaster, null);
        this.getDocument().registerObject((PDFObject)pDFToUnicodeCMap);
        pDFFont.setToUnicode((PDFCMap)pDFToUnicodeCMap);
    }

    public Object createPDFEncoding(SingleByteEncoding singleByteEncoding, String string) {
        return PDFEncoding.createPDFEncoding((SingleByteEncoding)singleByteEncoding, (String)string);
    }

    private PDFWArray getFontWidths(CIDFont cIDFont) {
        PDFWArray pDFWArray = new PDFWArray();
        if (cIDFont instanceof MultiByteFont && ((MultiByteFont)cIDFont).getWidthsMap() != null) {
            Map<Integer, Integer> map = ((MultiByteFont)cIDFont).getWidthsMap();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                pDFWArray.addEntry(entry.getKey().intValue(), new int[]{entry.getValue()});
            }
        } else {
            int[] nArray = cIDFont.getCIDSet().getWidths();
            pDFWArray.addEntry(0, nArray);
        }
        return pDFWArray;
    }

    private String createSubsetFontPrefix() {
        ++this.subsetFontCounter;
        DecimalFormat decimalFormat = new DecimalFormat("00000");
        String string = decimalFormat.format(this.subsetFontCounter);
        StringBuffer stringBuffer = new StringBuffer("E");
        for (char c2 : string.toCharArray()) {
            stringBuffer.append((char)(c2 + 17));
        }
        stringBuffer.append("+");
        return stringBuffer.toString();
    }

    private PDFFontDescriptor makeFontDescriptor(FontDescriptor fontDescriptor, String string) {
        Object object = null;
        object = fontDescriptor.getFontType() == FontType.TYPE0 || fontDescriptor.getFontType() == FontType.CIDTYPE0 ? new PDFCIDFontDescriptor(string + fontDescriptor.getEmbedFontName(), fontDescriptor.getFontBBox(), fontDescriptor.getCapHeight(), fontDescriptor.getFlags(), fontDescriptor.getItalicAngle(), fontDescriptor.getStemV(), null) : new PDFFontDescriptor(string + fontDescriptor.getEmbedFontName(), fontDescriptor.getAscender(), fontDescriptor.getDescender(), fontDescriptor.getCapHeight(), fontDescriptor.getFlags(), new PDFRectangle(fontDescriptor.getFontBBox()), fontDescriptor.getItalicAngle(), fontDescriptor.getStemV());
        this.getDocument().registerObject((PDFObject)object);
        if (fontDescriptor.isEmbeddable()) {
            CustomFont customFont;
            AbstractPDFStream abstractPDFStream = this.makeFontFile(fontDescriptor, string);
            if (abstractPDFStream != null) {
                object.setFontFile(fontDescriptor.getFontType(), abstractPDFStream);
                this.getDocument().registerObject((PDFObject)abstractPDFStream);
            }
            if ((customFont = this.getCustomFont(fontDescriptor)) instanceof CIDFont && this.document.getProfile().pdfAMode.getPart() < 2) {
                CIDFont cIDFont = (CIDFont)customFont;
                this.buildCIDSet((PDFFontDescriptor)object, cIDFont);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCIDSet(PDFFontDescriptor pDFFontDescriptor, CIDFont cIDFont) {
        BitSet bitSet = cIDFont.getCIDSet().getGlyphIndices();
        PDFStream pDFStream = this.makeStream(null, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bitSet.length() / 8 + 1);
        int n2 = 0;
        int n3 = bitSet.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 % 8;
            boolean bl = bitSet.get(i2);
            if (bl) {
                n2 |= 1 << 7 - n4;
            }
            if (n4 != 7) continue;
            byteArrayOutputStream.write(n2);
            n2 = 0;
        }
        byteArrayOutputStream.write(n2);
        try {
            pDFStream.setData(byteArrayOutputStream.toByteArray());
            pDFFontDescriptor.setCIDSet((AbstractPDFStream)pDFStream);
        }
        catch (IOException iOException) {
            this.log.error((Object)("Failed to write CIDSet [" + cIDFont + "] " + cIDFont.getEmbedFontName()), (Throwable)iOException);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractPDFStream makeFontFile(FontDescriptor fontDescriptor, String string) {
        if (fontDescriptor.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + fontDescriptor.getFontType());
        }
        CustomFont customFont = this.getCustomFont(fontDescriptor);
        InputStream inputStream = null;
        try {
            inputStream = customFont.getInputStream();
            if (inputStream == null) {
                AbstractPDFStream abstractPDFStream = null;
                return abstractPDFStream;
            }
            AbstractPDFStream abstractPDFStream = null;
            if (fontDescriptor.getFontType() == FontType.TYPE0) {
                byte[] byArray;
                MultiByteFont multiByteFont = (MultiByteFont)customFont;
                FontFileReader fontFileReader = new FontFileReader(inputStream);
                String string2 = OFFontLoader.readHeader(fontFileReader);
                boolean bl = multiByteFont.isOTFFile();
                if (customFont.getEmbeddingMode() == EmbeddingMode.FULL) {
                    byArray = fontFileReader.getAllBytes();
                    if (bl) {
                        this.document.setPDFVersion(Version.V1_6);
                    }
                } else {
                    byArray = this.getFontSubsetBytes(fontFileReader, multiByteFont, string2, string, fontDescriptor, bl);
                }
                abstractPDFStream = this.getFontStream(customFont, byArray, bl);
            } else if (fontDescriptor.getFontType() == FontType.TYPE1) {
                if (customFont.getEmbeddingMode() != EmbeddingMode.SUBSET) {
                    abstractPDFStream = this.fullyEmbedType1Font(inputStream);
                } else {
                    assert (customFont instanceof SingleByteFont);
                    SingleByteFont singleByteFont = (SingleByteFont)customFont;
                    Type1SubsetFile type1SubsetFile = new Type1SubsetFile();
                    byte[] byArray = type1SubsetFile.createSubset(inputStream, singleByteFont);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    PFBParser pFBParser = new PFBParser();
                    PFBData pFBData = pFBParser.parsePFB((InputStream)byteArrayInputStream);
                    abstractPDFStream = new PDFT1Stream();
                    ((PDFT1Stream)abstractPDFStream).setData(pFBData);
                }
            } else if (fontDescriptor.getFontType() == FontType.TYPE1C) {
                if (customFont.getEmbeddingMode() != EmbeddingMode.SUBSET) {
                    byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                    PDFCFFStream pDFCFFStream = new PDFCFFStream("Type1C");
                    pDFCFFStream.setData(byArray);
                    PDFCFFStream pDFCFFStream2 = pDFCFFStream;
                    return pDFCFFStream2;
                }
                FontFileReader fontFileReader = new FontFileReader(inputStream);
                String string3 = OFFontLoader.readHeader(fontFileReader);
                byte[] byArray = this.getFontSubsetBytes(fontFileReader, (MultiByteFont)customFont, string3, string, fontDescriptor, true);
                abstractPDFStream = this.getFontStream(customFont, byArray, true);
            } else {
                if (fontDescriptor.getFontType() == FontType.CIDTYPE0) {
                    byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                    PDFCFFStream pDFCFFStream = new PDFCFFStream("CIDFontType0C");
                    pDFCFFStream.setData(byArray);
                    PDFCFFStream pDFCFFStream3 = pDFCFFStream;
                    return pDFCFFStream3;
                }
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                abstractPDFStream = new PDFTTFStream(byArray.length);
                ((PDFTTFStream)abstractPDFStream).setData(byArray, byArray.length);
            }
            AbstractPDFStream abstractPDFStream2 = abstractPDFStream;
            return abstractPDFStream2;
        }
        catch (IOException iOException) {
            this.log.error((Object)("Failed to embed font [" + fontDescriptor + "] " + fontDescriptor.getEmbedFontName()), (Throwable)iOException);
            AbstractPDFStream abstractPDFStream = null;
            return abstractPDFStream;
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private AbstractPDFStream fullyEmbedType1Font(InputStream inputStream) throws IOException {
        PFBParser pFBParser = new PFBParser();
        PFBData pFBData = pFBParser.parsePFB(inputStream);
        PDFT1Stream pDFT1Stream = new PDFT1Stream();
        pDFT1Stream.setData(pFBData);
        return pDFT1Stream;
    }

    private byte[] getFontSubsetBytes(FontFileReader fontFileReader, MultiByteFont multiByteFont, String string, String string2, FontDescriptor fontDescriptor, boolean bl) throws IOException {
        if (bl) {
            OTFSubSetFile oTFSubSetFile = new OTFSubSetFile();
            oTFSubSetFile.readFont(fontFileReader, string2 + fontDescriptor.getEmbedFontName(), string, multiByteFont);
            return oTFSubSetFile.getFontSubset();
        }
        TTFSubSetFile tTFSubSetFile = new TTFSubSetFile();
        tTFSubSetFile.readFont(fontFileReader, multiByteFont.getTTCName(), string, multiByteFont);
        return tTFSubSetFile.getFontSubset();
    }

    private AbstractPDFStream getFontStream(CustomFont customFont, byte[] byArray, boolean bl) throws IOException {
        PDFCFFStreamType0C pDFCFFStreamType0C;
        if (bl) {
            pDFCFFStreamType0C = new PDFCFFStreamType0C(customFont);
            pDFCFFStreamType0C.setData(byArray, byArray.length);
        } else {
            pDFCFFStreamType0C = new PDFTTFStream(byArray.length);
            ((PDFTTFStream)pDFCFFStreamType0C).setData(byArray, byArray.length);
        }
        return pDFCFFStreamType0C;
    }

    private CustomFont getCustomFont(FontDescriptor fontDescriptor) {
        Typeface typeface = fontDescriptor instanceof LazyFont ? ((LazyFont)fontDescriptor).getRealFont() : (Typeface)fontDescriptor;
        if (!(typeface instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + fontDescriptor.getClass().getName());
        }
        return (CustomFont)typeface;
    }

    public PDFStream makeStream(String string, boolean bl) {
        PDFStream pDFStream = new PDFStream();
        pDFStream.setDocument(this.getDocument());
        pDFStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), string);
        if (bl) {
            this.getDocument().registerObject((PDFObject)pDFStream);
        }
        return pDFStream;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream pDFICCStream = new PDFICCStream();
        this.getDocument().registerObject((PDFObject)pDFICCStream);
        return pDFICCStream;
    }

    public PDFICCBasedColorSpace makeICCBasedColorSpace(PDFResourceContext pDFResourceContext, String string, PDFICCStream pDFICCStream) {
        PDFICCBasedColorSpace pDFICCBasedColorSpace = new PDFICCBasedColorSpace(string, pDFICCStream);
        this.getDocument().registerObject((PDFObject)pDFICCBasedColorSpace);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addColorSpace((PDFColorSpace)pDFICCBasedColorSpace);
        } else {
            this.getDocument().getResources().addColorSpace((PDFColorSpace)pDFICCBasedColorSpace);
        }
        return pDFICCBasedColorSpace;
    }

    public PDFSeparationColorSpace makeSeparationColorSpace(PDFResourceContext pDFResourceContext, NamedColorSpace namedColorSpace) {
        String string = namedColorSpace.getColorName();
        Double d2 = 0.0;
        Double d3 = 1.0;
        List<Double> list = Arrays.asList(d2, d3);
        List<Double> list2 = Arrays.asList(d2, d3, d2, d3, d2, d3);
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
        float[] fArray2 = namedColorSpace.getRGBColor().getColorComponents(null);
        PDFFunction pDFFunction = this.makeFunction(list, list2, fArray, fArray2, 1.0);
        PDFSeparationColorSpace pDFSeparationColorSpace = new PDFSeparationColorSpace(string, pDFFunction);
        this.getDocument().registerObject((PDFObject)pDFSeparationColorSpace);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addColorSpace((PDFColorSpace)pDFSeparationColorSpace);
        } else {
            this.getDocument().getResources().addColorSpace((PDFColorSpace)pDFSeparationColorSpace);
        }
        return pDFSeparationColorSpace;
    }

    public PDFArray makeArray(int[] nArray) {
        PDFArray pDFArray = new PDFArray(null, nArray);
        this.getDocument().registerObject((PDFObject)pDFArray);
        return pDFArray;
    }

    public PDFGState makeGState(Map map, PDFGState pDFGState) {
        PDFGState pDFGState2 = new PDFGState();
        pDFGState2.addValues(PDFGState.DEFAULT);
        pDFGState2.addValues(map);
        PDFGState pDFGState3 = this.getDocument().findGState(pDFGState2, pDFGState);
        if (pDFGState3 != null) {
            return pDFGState3;
        }
        PDFGState pDFGState4 = new PDFGState();
        pDFGState4.addValues(map);
        this.getDocument().registerObject((PDFObject)pDFGState4);
        return pDFGState4;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList pDFAnnotList = new PDFAnnotList();
        this.getDocument().assignObjectNumber((PDFObject)pDFAnnotList);
        return pDFAnnotList;
    }

    public PDFLayer makeLayer(String string) {
        PDFLayer pDFLayer = new PDFLayer(string);
        this.getDocument().registerObject((PDFObject)pDFLayer);
        return pDFLayer;
    }

    public PDFSetOCGStateAction makeSetOCGStateAction(String string) {
        PDFSetOCGStateAction pDFSetOCGStateAction = new PDFSetOCGStateAction(string);
        this.getDocument().registerObject((PDFObject)pDFSetOCGStateAction);
        return pDFSetOCGStateAction;
    }

    public PDFTransitionAction makeTransitionAction(String string) {
        PDFTransitionAction pDFTransitionAction = new PDFTransitionAction(string);
        this.getDocument().registerObject((PDFObject)pDFTransitionAction);
        return pDFTransitionAction;
    }

    public PDFNavigator makeNavigator(String string) {
        PDFNavigator pDFNavigator = new PDFNavigator(string);
        this.getDocument().registerObject((PDFObject)pDFNavigator);
        return pDFNavigator;
    }

    public void makeDPart(PDFPage pDFPage, String string) {
        PDFDPart pDFDPart;
        PDFDPartRoot pDFDPartRoot = this.getDocument().getRoot().getDPartRoot();
        if (this.dparts.containsKey(string)) {
            pDFDPart = this.dparts.get(string);
        } else {
            pDFDPart = new PDFDPart((PDFDictionary)pDFDPartRoot.dpart);
            pDFDPartRoot.add(pDFDPart);
            this.getDocument().registerTrailerObject((PDFObject)pDFDPart);
            this.dparts.put(string, pDFDPart);
        }
        pDFDPart.addPage(pDFPage);
        pDFPage.put("DPart", (Object)pDFDPart);
    }

    public PDFDPartRoot makeDPartRoot() {
        PDFDPartRoot pDFDPartRoot = new PDFDPartRoot(this.getDocument());
        this.getDocument().registerTrailerObject((PDFObject)pDFDPartRoot);
        return pDFDPartRoot;
    }

    public void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    public EventBroadcaster getEventBroadcaster() {
        return this.eventBroadcaster;
    }
}

