/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.table.TableAndCaption;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.layoutmgr.table.TableCaptionForNextPageLayoutManager;
import org.apache.fop.layoutmgr.table.TableCaptionLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableHeaderFooterPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class TableAndCaptionLayoutManager
extends BlockContainerLayoutManager {
    private static Log log = LogFactory.getLog(TableAndCaptionLayoutManager.class);
    private Block curBlockArea;
    private int lastSpaceWidth = -1;

    public TableAndCaptionLayoutManager(TableAndCaption tableAndCaption) {
        super(tableAndCaption);
    }

    public TableAndCaption getTableAndCaptionFO() {
        return (TableAndCaption)super.getBlockContainerFO();
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.addBundleAreas(positionIterator, layoutContext);
        this.getParentArea(null);
        this.addId();
        this.flush();
        this.curBlockArea = null;
        if (this.getTableAndCaptionFO().isRepeatingCaptionsOnNextPages()) {
            positionIterator = this.addPositionsForCaptions(positionIterator);
        }
        super.addAreas(positionIterator, layoutContext);
    }

    @Override
    public Area getParentArea(Area area) {
        return super.getParentArea((Area)this.curBlockArea);
    }

    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public List getNextKnuthElementsInternal(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        LayoutContext layoutContext2 = LayoutContext.copyOf(layoutContext);
        Stack stack2 = stack;
        if (stack2 != null) {
            stack2 = (Stack)stack.clone();
        }
        LayoutManager layoutManager2 = layoutManager;
        List<ListElement> list = this.getNextKnuthElementsInternalWithRepeatingCaptions(layoutContext, n2, stack, position, layoutManager);
        if (this.needsToMakeCaptionAsWideAsTable(layoutContext2)) {
            list = this.getNextKnuthElementsInternalWithRepeatingCaptions(layoutContext2, n2, stack2, position, layoutManager2);
        }
        return list;
    }

    public List<ListElement> getNextKnuthElementsInternalWithRepeatingCaptions(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        List list = super.getNextKnuthElementsInternal(layoutContext, n2, stack, position, layoutManager);
        if (this.getTableAndCaptionFO().isRepeatingCaptionsOnNextPages()) {
            CaptionsElementsBundle captionsElementsBundle = this.getCaptionsBundleAndRemoveTheCorrespondingKnuthBoxes(list, layoutContext);
            this.increasePenaltyBetweenRows(list, captionsElementsBundle);
            this.increaseSizeOfHeaderFooterElement(list, captionsElementsBundle);
        }
        return list;
    }

    private void increaseSizeOfHeaderFooterElement(List<ListElement> list, CaptionsElementsBundle captionsElementsBundle) {
        boolean bl;
        Position position;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Increasing size of header and footer elements, if any, adding ones if none.");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (ListElement listElement : list) {
            position = listElement.getPosition();
            if (!this.isTableHeaderFooterPosition(position)) continue;
            KnuthBox knuthBox = (KnuthBox)listElement;
            TableHeaderFooterPosition tableHeaderFooterPosition = (TableHeaderFooterPosition)position.getPosition();
            if (tableHeaderFooterPosition.header) {
                knuthBox.setWidth(knuthBox.getWidth() + captionsElementsBundle.topCaptionsHeight);
                bl2 = true;
            } else {
                knuthBox.setWidth(knuthBox.getWidth() + captionsElementsBundle.bottomCaptionsHeight);
                bl3 = true;
            }
            tableHeaderFooterPosition.captionsPositionsBundle = captionsElementsBundle;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("   =>  Increased size of: " + listElement + " " + listElement.getPosition() + " " + listElement.getLayoutManager()));
        }
        boolean bl4 = !bl2 && captionsElementsBundle.topCaptionsHeight > 0;
        boolean bl5 = bl = !bl3 && captionsElementsBundle.bottomCaptionsHeight > 0;
        if (bl4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Emulating a header");
            }
            position = new TableHeaderFooterPosition((LayoutManager)((Object)this), true, null);
            position.captionsPositionsBundle = captionsElementsBundle;
            list.add((ListElement)new KnuthBox(captionsElementsBundle.topCaptionsHeight, position, false));
        }
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Emulating a footer");
            }
            position = new TableHeaderFooterPosition((LayoutManager)((Object)this), false, null);
            position.captionsPositionsBundle = captionsElementsBundle;
            list.add((ListElement)new KnuthBox(captionsElementsBundle.bottomCaptionsHeight, position, false));
        }
    }

    private void increasePenaltyBetweenRows(List<ListElement> list, CaptionsElementsBundle captionsElementsBundle) {
        for (ListElement listElement : list) {
            Position position = listElement.getPosition();
            if (!this.isTableHFPenaltyPosition(position)) continue;
            ((TableHFPenaltyPosition)position.getPosition()).captionsPositionsBundle = captionsElementsBundle;
            BreakElement breakElement = (BreakElement)listElement;
            breakElement.setPenaltyWidth(breakElement.getPenaltyWidth() + captionsElementsBundle.topCaptionsHeight + captionsElementsBundle.bottomCaptionsHeight);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("   ->  Increased penalty of " + listElement + " " + listElement.getPosition() + " " + listElement.getLayoutManager()));
        }
    }

    private CaptionsElementsBundle getCaptionsBundleAndRemoveTheCorrespondingKnuthBoxes(List<ListElement> list, LayoutContext layoutContext) {
        CaptionsElementsBundle captionsElementsBundle = new CaptionsElementsBundle();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        boolean bl2 = false;
        Iterator<ListElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n6;
            ListElement listElement = iterator.next();
            Position position = listElement.getPosition();
            if (log.isDebugEnabled()) {
                log.debug((Object)("POS \t" + listElement + position.getClass() + " " + position));
            }
            if (this.isTableCaptionForNextPagePosition(position)) {
                n6 = this.getElementWidth(listElement);
                if (bl) {
                    n3 += n6;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Save npT " + listElement + " " + position));
                    }
                    captionsElementsBundle.npTCaptionElements.add(listElement);
                } else {
                    n5 += n6;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Save npB " + listElement + " " + position));
                    }
                    captionsElementsBundle.npBCaptionElements.add(listElement);
                }
                iterator.remove();
                bl2 = true;
                continue;
            }
            if (this.isTableCaptionPosition(position)) {
                n6 = this.getElementWidth(listElement);
                if (bl) {
                    n2 += n6;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Save nmT " + listElement + " " + position));
                    }
                    captionsElementsBundle.nmTCaptionElements.add(listElement);
                } else {
                    n4 += n6;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Save nmB " + listElement + " " + position));
                    }
                    captionsElementsBundle.nmBCaptionElements.add(listElement);
                }
                iterator.remove();
                bl2 = true;
                continue;
            }
            if (this.isTableGrid(position)) {
                bl = false;
                this.lastSpaceWidth = -1;
                bl2 = false;
                continue;
            }
            if (this.isBreakPossibilityAfterACaption(bl2, listElement)) {
                log.debug((Object)"Removing break possiblity after caption, it will remain dangling otherwise.");
                iterator.remove();
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        SpaceResolver.resolveElementList(captionsElementsBundle.nmTCaptionElements);
        SpaceResolver.resolveElementList(captionsElementsBundle.nmBCaptionElements);
        SpaceResolver.resolveElementList(captionsElementsBundle.npTCaptionElements);
        SpaceResolver.resolveElementList(captionsElementsBundle.npBCaptionElements);
        captionsElementsBundle.topCaptionsHeight = Math.max(n2, n3);
        captionsElementsBundle.bottomCaptionsHeight = Math.max(n4, n5);
        return captionsElementsBundle;
    }

    private boolean isBreakPossibilityAfterACaption(boolean bl, ListElement listElement) {
        return listElement instanceof BreakElement && bl;
    }

    private int getElementWidth(ListElement listElement) {
        int n2 = 0;
        if (listElement instanceof KnuthElement) {
            n2 = ((KnuthElement)listElement).getWidth();
            this.lastSpaceWidth = -1;
        } else if (listElement instanceof UnresolvedListElementWithLength) {
            n2 = ((UnresolvedListElementWithLength)listElement).getLength().getOpt();
            if (listElement instanceof SpaceElement) {
                if (this.lastSpaceWidth > 0) {
                    n2 = n2 < this.lastSpaceWidth ? 0 : (n2 -= this.lastSpaceWidth);
                    this.lastSpaceWidth = -1;
                } else {
                    this.lastSpaceWidth = n2;
                }
            }
        } else if (listElement instanceof BreakElement) {
            n2 = 0;
            this.lastSpaceWidth = -1;
        } else {
            log.warn((Object)("Cannot extact width of " + listElement));
            this.lastSpaceWidth = -1;
        }
        return n2;
    }

    private boolean needsToMakeCaptionAsWideAsTable(LayoutContext layoutContext) {
        boolean bl = false;
        List list = this.getChildLMs();
        if (this.getTableAndCaptionFO().isTableAndCaptionFound() && list.size() >= 2) {
            ArrayList<TableCaptionLayoutManager> arrayList = new ArrayList<TableCaptionLayoutManager>(2);
            TableLayoutManager tableLayoutManager = null;
            for (LayoutManager layoutManager : list) {
                if (layoutManager instanceof TableCaptionLayoutManager) {
                    arrayList.add((TableCaptionLayoutManager)((Object)layoutManager));
                    continue;
                }
                tableLayoutManager = (TableLayoutManager)((Object)layoutManager);
            }
            int n2 = tableLayoutManager.getContentAreaIPD() + tableLayoutManager.getMBP();
            int n3 = this.getCaptionsReferenceAreaIPD(arrayList);
            if (n3 > n2) {
                int n4 = n2;
                int n5 = this.getCaptionsMinimumIPD(arrayList);
                if (n4 < n5) {
                    n4 = n5;
                }
                layoutContext.setRefIPD(n4 + this.getMBP());
                boolean bl2 = this.breakBeforeServed;
                this.reset();
                this.breakBeforeServed = bl2;
                bl = true;
            }
        }
        return bl;
    }

    private int getCaptionsReferenceAreaIPD(List<TableCaptionLayoutManager> list) {
        int n2 = 0;
        for (TableCaptionLayoutManager tableCaptionLayoutManager : list) {
            n2 = Math.max(n2, tableCaptionLayoutManager.getContentAreaIPD() + tableCaptionLayoutManager.getMBP());
        }
        return n2;
    }

    private int getCaptionsMinimumIPD(List<TableCaptionLayoutManager> list) {
        int n2 = 0;
        for (TableCaptionLayoutManager tableCaptionLayoutManager : list) {
            n2 = Math.max(n2, tableCaptionLayoutManager.getMinimumIPD());
        }
        return n2;
    }

    private void addBundleAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.centerTable();
        if (this.getTableAndCaptionFO().isRepeatingCaptionsOnNextPages()) {
            positionIterator = this.addPositionsForCaptions(positionIterator);
        }
        super.addAreas(positionIterator, layoutContext);
    }

    private PositionIterator addPositionsForCaptions(PositionIterator positionIterator) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)"==============Add positions for repeating captions===================== ");
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object2 = null;
        TableHFPenaltyPosition tableHFPenaltyPosition = null;
        TableHeaderFooterPosition tableHeaderFooterPosition = null;
        while (positionIterator.hasNext()) {
            TableHeaderFooterPosition tableHeaderFooterPosition2;
            object = positionIterator.next();
            linkedList.add(object);
            if (object instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                object = ((SpaceResolver.SpaceHandlingBreakPosition)((Object)object)).getOriginalBreakPosition();
            }
            if (object == null) continue;
            if (object2 == null) {
                object2 = object;
            }
            if (object.getPosition() instanceof TableHeaderFooterPosition) {
                if (tableHeaderFooterPosition != null) continue;
                tableHeaderFooterPosition2 = (TableHeaderFooterPosition)object.getPosition();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Found TableHeaderFooterPosition from table " + object));
                }
                tableHeaderFooterPosition = tableHeaderFooterPosition2;
                continue;
            }
            if (object instanceof TableHeaderFooterPosition) {
                if (tableHeaderFooterPosition != null) continue;
                tableHeaderFooterPosition2 = (TableHeaderFooterPosition)((Object)object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Found Emulated TableHeaderFooterPosition from table-and-caption " + object));
                }
                tableHeaderFooterPosition = tableHeaderFooterPosition2;
                continue;
            }
            if (!(object instanceof TableHFPenaltyPosition) || tableHFPenaltyPosition != null) continue;
            tableHFPenaltyPosition = (TableHFPenaltyPosition)((Object)object);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(" Found penalty between rows " + object));
        }
        object = null;
        if (tableHeaderFooterPosition != null && object == null) {
            object = tableHeaderFooterPosition.captionsPositionsBundle;
        }
        if (tableHFPenaltyPosition != null && object == null) {
            object = tableHFPenaltyPosition.captionsPositionsBundle;
        }
        if (object != null) {
            if (this.isFirst((Position)object2)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add normal top captions, size: " + object.nmTCaptionElements.size()));
                }
                linkedList.addAll(0, this.notiyAndGetPositions(object.nmTCaptionElements));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add next page top captions, size: " + object.nmTCaptionElements.size()));
                }
                linkedList.addAll(0, this.notiyAndGetPositions(object.npTCaptionElements));
            }
            if (this.isFirst((Position)object2)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add normal bottom captions, size: " + object.nmTCaptionElements.size()));
                }
                linkedList.addAll(this.notiyAndGetPositions(object.nmBCaptionElements));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add next-page bottom captions, size: " + object.nmTCaptionElements.size()));
                }
                linkedList.addAll(this.notiyAndGetPositions(object.npBCaptionElements));
            }
        }
        positionIterator = new PositionIterator(linkedList.listIterator());
        return positionIterator;
    }

    @Override
    public boolean isFirst(Position position) {
        if (position instanceof TableHeaderFooterPosition) {
            return true;
        }
        return super.isFirst(position);
    }

    private Collection<? extends Position> notiyAndGetPositions(List<ListElement> list) {
        this.notify(list);
        ArrayList<Position> arrayList = new ArrayList<Position>(list.size());
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(list, 0, list.size());
        while (knuthPossPosIter.hasNext()) {
            Position position = knuthPossPosIter.next();
            if (position == null || position instanceof SpaceResolver.SpaceHandlingPosition || position instanceof SpaceResolver.SpaceHandlingBreakPosition && position.getPosition().getIndex() == -1) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    private void notify(List<ListElement> list) {
        int n2 = ElementListUtils.determinePreviousBreak(list, (int)0);
        SpaceResolver.performConditionalsNotification(list, 0, list.size() - 1, n2);
    }

    private void centerTable() {
        Map map = this.getTableAndCaptionFO().getForeignAttributes();
        boolean bl = "auto".equals(map.get(ChemistryExtensions.ATT_QNAME_MARGIN_LEFT));
        boolean bl2 = "auto".equals(map.get(ChemistryExtensions.ATT_QNAME_MARGIN_RIGHT));
        int n2 = this.getContentAreaIPD() + this.getMBP();
        if (bl && !bl2) {
            this.updateStartIndent(this.getParent().getContentAreaIPD() - n2);
        } else if (bl && bl2) {
            this.updateStartIndent((this.getParent().getContentAreaIPD() - n2) / 2);
        }
    }

    private boolean isTableGrid(Position position) {
        return position instanceof NonLeafPosition && position.getPosition() instanceof TableContentPosition;
    }

    private boolean isTableHeaderFooterPosition(Position position) {
        return position instanceof NonLeafPosition && position.getPosition() instanceof TableHeaderFooterPosition;
    }

    private boolean isTableHFPenaltyPosition(Position position) {
        return position instanceof NonLeafPosition && position.getPosition() instanceof TableHFPenaltyPosition;
    }

    private boolean isTableCaptionPosition(Position position) {
        boolean bl = false;
        if (position.getLM() instanceof TableCaptionLayoutManager) {
            bl = true;
        }
        if (!bl) {
            while (position instanceof NonLeafPosition) {
                if ((position = position.getPosition()) == null || !(position.getLM() instanceof TableCaptionLayoutManager)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean isTableCaptionForNextPagePosition(Position position) {
        boolean bl = false;
        if (position.getLM() instanceof TableCaptionForNextPageLayoutManager) {
            bl = true;
        }
        if (!bl) {
            while (position instanceof NonLeafPosition) {
                if ((position = position.getPosition()) == null || !(position.getLM() instanceof TableCaptionForNextPageLayoutManager)) continue;
                bl = true;
            }
        }
        return bl;
    }

    static class CaptionsElementsBundle {
        private List<ListElement> nmTCaptionElements = new ArrayList<ListElement>(1);
        private List<ListElement> npTCaptionElements = new ArrayList<ListElement>(1);
        private List<ListElement> nmBCaptionElements = new ArrayList<ListElement>(1);
        private List<ListElement> npBCaptionElements = new ArrayList<ListElement>(1);
        private int topCaptionsHeight;
        private int bottomCaptionsHeight;

        CaptionsElementsBundle() {
        }
    }
}

