/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.CSSMarginsUtil;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.FloatContentLayoutManager;
import org.apache.fop.layoutmgr.FootenoteUtil;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.list.ListBlockLayoutManager;
import org.apache.fop.layoutmgr.list.ListItemContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.BreakUtil;

public class ListItemLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager
implements BreakOpportunity {
    private static Log log = LogFactory.getLog(ListItemLayoutManager.class);
    private ListItemContentLayoutManager label;
    private ListItemContentLayoutManager body;
    private Block curBlockArea;
    private List<ListElement> labelList;
    private List<ListElement> bodyList;
    private Keep keepWithNextPendingOnLabel;
    private Keep keepWithNextPendingOnBody;

    public ListItemLayoutManager(ListItem listItem) {
        super((FObj)listItem);
        this.setLabel(listItem.getLabel());
        this.setBody(listItem.getBody());
    }

    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.getListItemFO().getCommonBorderPaddingBackground();
    }

    protected ListItem getListItemFO() {
        return (ListItem)this.fobj;
    }

    public void setLabel(ListItemLabel listItemLabel) {
        this.label = new ListItemContentLayoutManager(listItemLabel);
        this.label.setParent((LayoutManager)((Object)this));
    }

    public void setBody(ListItemBody listItemBody) {
        this.body = new ListItemContentLayoutManager(listItemBody);
        this.body.setParent((LayoutManager)((Object)this));
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceBefore, (PercentBaseContext)this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListItemFO().getCommonMarginBlock().spaceAfter, (PercentBaseContext)this).getSpace();
        this.startIndent = this.getListItemFO().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        this.endIndent = this.getListItemFO().getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        Keep keep;
        List list;
        KnuthBlockBox knuthBlockBox;
        Object object;
        Object object2;
        Object object3;
        this.referenceIPD = layoutContext.getRefIPD();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList)) {
            return linkedList;
        }
        this.addFirstVisibleMarks(linkedList, layoutContext, n2);
        LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
        layoutContext2.setFlags(2);
        this.label.initialize();
        boolean bl = false;
        Stack<LayoutManager> stack2 = null;
        Position position2 = null;
        LayoutManager layoutManager2 = null;
        if (position != null && position instanceof ListItemPosition) {
            ListItemPosition listItemPosition = (ListItemPosition)position;
            if (listItemPosition.labelLastIndex <= listItemPosition.labelFirstIndex) {
                bl = true;
            } else {
                position2 = listItemPosition.getOriginalLabelPosition();
                layoutManager2 = position2.getLM();
                object3 = layoutManager2;
                stack2 = new Stack<LayoutManager>();
                while (object3 != this) {
                    stack2.push((LayoutManager)object3);
                    if (!((object3 = object3.getParent()) instanceof ListItemContentLayoutManager)) continue;
                    object3 = object3.getParent();
                }
            }
        }
        this.labelList = !bl ? this.label.getNextKnuthElements(layoutContext2, n2, stack2, position2, layoutManager2) : new LinkedList<ListElement>();
        SpaceResolver.resolveElementList(this.labelList);
        ElementListObserver.observe(this.labelList, (String)"list-item-label", (String)this.label.getPartFO().getId());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        this.keepWithNextPendingOnLabel = layoutContext2.getKeepWithNextPending();
        layoutContext2 = this.makeChildLayoutContext(layoutContext);
        layoutContext2.setFlags(2);
        this.body.initialize();
        boolean bl2 = false;
        object3 = null;
        Position position3 = null;
        LayoutManager layoutManager3 = null;
        if (position != null && position instanceof ListItemPosition) {
            object2 = (ListItemPosition)position;
            if (object2.bodyLastIndex <= object2.bodyFirstIndex) {
                bl2 = true;
            } else {
                position3 = object2.getOriginalBodyPosition();
                layoutManager3 = position3.getLM();
                object = layoutManager3;
                object3 = new Stack();
                while (object != this) {
                    ((Stack)object3).push(object);
                    if (!((object = object.getParent()) instanceof ListItemContentLayoutManager)) continue;
                    object = object.getParent();
                }
            }
        }
        this.bodyList = !bl2 ? this.body.getNextKnuthElements(layoutContext2, n2, (Stack)object3, position3, layoutManager3) : new LinkedList<ListElement>();
        object2 = new ArrayList<ListElement>(this.bodyList);
        SpaceResolver.resolveElementList(this.bodyList);
        ElementListObserver.observe(this.bodyList, (String)"list-item-body", (String)this.body.getPartFO().getId());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        this.keepWithNextPendingOnBody = layoutContext2.getKeepWithNextPending();
        object = new LinkedList();
        if (!this.labelList.isEmpty() && this.labelList.get(0) instanceof KnuthBlockBox && (knuthBlockBox = (KnuthBlockBox)this.labelList.get(0)).getWidth() == 0 && knuthBlockBox.hasFloatAnchors()) {
            list = knuthBlockBox.getFloatContentLMs();
            object.add(new KnuthBlockBox(0, Collections.emptyList(), null, false, list));
            keep = this.getKeepTogether();
            object.add(new BreakElement((Position)new LeafPosition((LayoutManager)((Object)this), 0), keep.getPenalty(), keep.getContext(), layoutContext));
            this.labelList.remove(0);
            this.labelList.remove(0);
        }
        if (!this.bodyList.isEmpty() && this.bodyList.get(0) instanceof KnuthBlockBox && (knuthBlockBox = (KnuthBlockBox)this.bodyList.get(0)).getWidth() == 0 && knuthBlockBox.hasFloatAnchors()) {
            list = knuthBlockBox.getFloatContentLMs();
            object.add(new KnuthBlockBox(0, Collections.emptyList(), null, false, list));
            keep = this.getKeepTogether();
            object.add(new BreakElement((Position)new LeafPosition((LayoutManager)((Object)this), 0), keep.getPenalty(), keep.getContext(), layoutContext));
            this.bodyList.remove(0);
            this.bodyList.remove(0);
        }
        object.addAll(this.getCombinedKnuthElementsForListItem(this.labelList, this.bodyList, layoutContext));
        CSSMarginsUtil.collapseSpacesBefore((BlockStackingLayoutManager)((Object)this), (List<ListElement>)object2, linkedList);
        this.wrapPositionElements((List)object, linkedList, true);
        this.addLastVisibleMarks(linkedList, layoutContext, n2);
        CSSMarginsUtil.collapseSpacesAfter((BlockStackingLayoutManager)((Object)this), (List<ListElement>)object2, linkedList);
        this.addKnuthElementsForBreakAfter(linkedList, layoutContext);
        layoutContext.updateKeepWithNextPending(this.keepWithNextPendingOnLabel);
        layoutContext.updateKeepWithNextPending(this.keepWithNextPendingOnBody);
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        this.setFinished(true);
        this.resetSpaces();
        return linkedList;
    }

    protected void addFirstVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n2) {
        this.addKnuthElementsForSpaceBefore(list, n2);
        this.addKnuthElementsForBorderPaddingBefore(list, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(layoutContext);
    }

    private List getCombinedKnuthElementsForListItem(List<ListElement> list, List<ListElement> list2, LayoutContext layoutContext) {
        int n2;
        List[] listArray = new List[]{new ArrayList<ListElement>(list), new ArrayList<ListElement>(list2)};
        int[] nArray = new int[]{ElementListUtils.calcContentLength((List)listArray[0]), ElementListUtils.calcContentLength((List)listArray[1])};
        int[] nArray2 = new int[]{0, 0};
        int[] nArray3 = new int[]{-1, -1};
        int[] nArray4 = new int[]{-1, -1};
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = this.getBaselineDelta();
        if (n5 != 0) {
            if (n5 < 0) {
                n3 += -n5;
            } else {
                n4 += n5;
            }
        }
        int n6 = Math.max(n3, n4);
        int n7 = 0;
        Keep keep = Keep.KEEP_AUTO;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        while ((n2 = this.getNextStep(listArray, nArray3, nArray4, nArray2)) > 0) {
            Position position;
            Position position2;
            Position position3;
            if (nArray4[0] + 1 == listArray[0].size()) {
                keep = keep.compare(this.keepWithNextPendingOnLabel);
            }
            if (nArray4[1] + 1 == listArray[1].size()) {
                keep = keep.compare(this.keepWithNextPendingOnBody);
            }
            int n8 = n2 + this.getMaxRemainingHeight(nArray, nArray2) - n6;
            int n9 = 0;
            int n10 = 0;
            int n11 = 9;
            KnuthElement knuthElement = listArray[0].size() > 0 ? (KnuthElement)((Object)listArray[0].get(nArray4[0])) : null;
            Position position4 = position3 = knuthElement != null && knuthElement.getPosition() != null ? knuthElement.getPosition().getPosition() : null;
            if (knuthElement instanceof KnuthPenalty) {
                n9 = knuthElement.getWidth();
                n10 = knuthElement.getPenalty() == -1000 ? -1000 : Math.max(n10, knuthElement.getPenalty());
                n11 = BreakUtil.compareBreakClasses((int)n11, (int)((KnuthPenalty)knuthElement).getBreakClass());
            }
            knuthElement = listArray[1].size() > 0 ? (KnuthElement)((Object)listArray[1].get(nArray4[1])) : null;
            Position position5 = position2 = knuthElement != null && knuthElement.getPosition() != null ? knuthElement.getPosition().getPosition() : null;
            if (knuthElement instanceof KnuthPenalty) {
                n9 = Math.max(n9, knuthElement.getWidth());
                n10 = knuthElement.getPenalty() == -1000 ? -1000 : Math.max(n10, knuthElement.getPenalty());
                n11 = BreakUtil.compareBreakClasses((int)n11, (int)((KnuthPenalty)knuthElement).getBreakClass());
            }
            int n12 = n2 - n7 - n8;
            n8 += n9;
            LinkedList<FootnoteBodyLayoutManager> linkedList2 = new LinkedList<FootnoteBodyLayoutManager>();
            for (int i2 = 0; i2 < listArray.length; ++i2) {
                linkedList2.addAll(FootenoteUtil.getFootnotes(listArray[i2], nArray3[i2], nArray4[i2]));
            }
            LinkedList linkedList3 = new LinkedList();
            for (int i3 = 0; i3 < listArray.length; ++i3) {
                linkedList3.addAll(FloatContentLayoutManager.checkForFloats((List)listArray[i3], (int)nArray3[i3], (int)nArray4[i3]));
            }
            n7 += n12;
            ListItemPosition listItemPosition = new ListItemPosition((LayoutManager)((Object)this), nArray3[0], nArray4[0], nArray3[1], nArray4[1]);
            listItemPosition.setOriginalLabelPosition(position3);
            if ((position2 == null || position2.getLM() instanceof ListItemContentLayoutManager) && (position = this.extractBlock(listArray[1], nArray4[1] + 1)) != null) {
                position2 = position;
            }
            listItemPosition.setOriginalBodyPosition(position2);
            if (linkedList3.isEmpty()) {
                linkedList.add((ListElement)new KnuthBlockBox(n12, linkedList2, (Position)listItemPosition, false));
            } else {
                linkedList.add((ListElement)new KnuthBlockBox(0, Collections.emptyList(), (Position)listItemPosition, false, linkedList3));
                position = this.getKeepTogether();
                linkedList.add((ListElement)new BreakElement(listItemPosition, position.getPenalty(), position.getContext(), layoutContext));
                linkedList.add((ListElement)new KnuthBlockBox(n12, linkedList2, (Position)listItemPosition, false));
            }
            if (position2 != null && this.getKeepWithPrevious().isAuto() && this.shouldWeAvoidBreak(linkedList, position2.getLM())) {
                ++n10;
            }
            if (n7 >= n6) continue;
            position = keep.compare(this.getKeepTogether());
            int n13 = n10;
            if (n13 > -1000) {
                n13 = Math.max(n13, position.getPenalty());
                n11 = position.getContext();
            }
            linkedList.add((ListElement)new BreakElement(listItemPosition, n8, n13, n11, layoutContext));
        }
        return linkedList;
    }

    private Position extractBlock(List<ListElement> list, int n2) {
        ListElement listElement;
        Position position = null;
        LeafPosition leafPosition = null;
        if (list != null && n2 < list.size() && (listElement = list.get(n2)) != null && listElement.getLayoutManager() instanceof ListItemContentLayoutManager && (position = listElement.getPosition()) != null && position.getLM() instanceof ListItemContentLayoutManager && (position = position.getPosition()) != null && position.getPosition() != null && position.getLM() instanceof BlockLayoutManager) {
            leafPosition = new LeafPosition(position.getPosition().getLM(), 0);
        }
        return leafPosition;
    }

    private boolean shouldWeAvoidBreak(List<ListElement> list, LayoutManager layoutManager) {
        if (this.isChangingIPD(layoutManager)) {
            if (layoutManager instanceof BlockLayoutManager) {
                return true;
            }
            if (layoutManager instanceof ListBlockLayoutManager) {
                int n2 = 0;
                for (ListElement listElement : list) {
                    if (!(listElement instanceof BreakElement)) continue;
                    if (((BreakElement)listElement).getPenaltyValue() > 0) {
                        ++n2;
                        continue;
                    }
                    --n2;
                }
                return n2 > 0;
            }
        }
        return false;
    }

    private boolean isChangingIPD(LayoutManager layoutManager) {
        PageProvider pageProvider = layoutManager.getPSLM().getPageProvider();
        int n2 = pageProvider.getCurrentIPD();
        if (n2 == -1) {
            return false;
        }
        int n3 = pageProvider.getNextIPD();
        return n3 != n2;
    }

    private int getNextStep(List[] listArray, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        int[] nArray4 = new int[]{nArray3[0], nArray3[1]};
        nArray[0] = nArray2[0] + 1;
        nArray[1] = nArray2[1] + 1;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            while (nArray2[n2] + 1 < listArray[n2].size()) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + 1;
                KnuthElement knuthElement = (KnuthElement)((Object)listArray[n2].get(nArray2[n2]));
                if (knuthElement.isPenalty()) {
                    if (knuthElement.getPenalty() >= 1000) continue;
                    break;
                }
                if (knuthElement.isGlue()) {
                    KnuthElement knuthElement2;
                    if (nArray2[n2] > 0 && (knuthElement2 = (KnuthElement)((Object)listArray[n2].get(nArray2[n2] - 1))).isBox()) break;
                    int n5 = n2;
                    nArray3[n5] = nArray3[n5] + knuthElement.getWidth();
                    continue;
                }
                int n6 = n2;
                nArray3[n6] = nArray3[n6] + knuthElement.getWidth();
            }
            if (nArray2[n2] < nArray[n2]) {
                nArray3[n2] = nArray4[n2];
                continue;
            }
            ++n3;
        }
        if (n3 == 0) {
            return 0;
        }
        n2 = nArray4[0] == 0 && nArray4[1] == 0 ? Math.max(nArray2[0] >= nArray[0] ? nArray3[0] : Integer.MIN_VALUE, nArray2[1] >= nArray[1] ? nArray3[1] : Integer.MIN_VALUE) : Math.min(nArray2[0] >= nArray[0] ? nArray3[0] : Integer.MAX_VALUE, nArray2[1] >= nArray[1] ? nArray3[1] : Integer.MAX_VALUE);
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            if (nArray3[i2] <= n2) continue;
            nArray3[i2] = nArray4[i2];
            nArray2[i2] = nArray[i2] - 1;
        }
        return n2;
    }

    private int getMaxRemainingHeight(int[] nArray, int[] nArray2) {
        return Math.max(nArray[0] - nArray2[0], nArray[1] - nArray2[1]);
    }

    public List<ListElement> getChangedKnuthElements(List list, int n2) {
        Position position;
        this.labelList = this.label.getChangedKnuthElements(this.labelList, n2);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)((Object)listIterator.next());
            position = knuthElement.getPosition().getPosition();
            if (position != null) {
                knuthElement.setPosition(position);
                continue;
            }
            knuthElement.setPosition(new Position((LayoutManager)((Object)this)));
        }
        Position position2 = position = this.body.getChangedKnuthElements(list, n2);
        position = new Position();
        for (Object e2 : position2) {
            KnuthElement knuthElement = (KnuthElement)((Object)e2);
            knuthElement.setPosition((Position)new NonLeafPosition((LayoutManager)((Object)this), knuthElement.getPosition()));
            position.add((ListElement)knuthElement);
        }
        return position;
    }

    public boolean hasLineAreaDescendant() {
        return this.label.hasLineAreaDescendant() || this.body.hasLineAreaDescendant();
    }

    public int getBaselineOffset() {
        boolean bl;
        int n2 = -1;
        if (this.label.hasLineAreaDescendant()) {
            n2 = this.label.getBaselineOffset();
        }
        int n3 = -1;
        if (this.body.hasLineAreaDescendant()) {
            n3 = this.body.getBaselineOffset();
        }
        boolean bl2 = bl = ((ListItem)this.getFObj()).getRelativeAlign() == 12;
        if (bl && n2 != -1 && n3 != -1) {
            return Math.max(n2, n3);
        }
        if (n3 != -1) {
            return n3;
        }
        if (n2 != -1) {
            return n2;
        }
        return 0;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        KnuthPossPosIter knuthPossPosIter;
        this.getParentArea(null);
        this.addId();
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        Position position = null;
        Position position2 = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            if (!(position3 instanceof NonLeafPosition) || position3.getPosition() == null) continue;
            linkedList.add(position3.getPosition());
        }
        if (linkedList.isEmpty()) {
            this.reset();
            return;
        }
        this.registerMarkers(true, this.isFirst(position), this.isLast(position2));
        int n2 = ((ListItemPosition)((Object)linkedList.getFirst())).getLabelFirstIndex();
        int n3 = ((ListItemPosition)((Object)linkedList.getLast())).getLabelLastIndex();
        int n4 = ((ListItemPosition)((Object)linkedList.getFirst())).getBodyFirstIndex();
        int n5 = ((ListItemPosition)((Object)linkedList.getLast())).getBodyLastIndex();
        int n6 = ElementListUtils.determinePreviousBreak(this.labelList, (int)n2);
        SpaceResolver.performConditionalsNotification(this.labelList, n2, n3, n6);
        n6 = ElementListUtils.determinePreviousBreak(this.bodyList, (int)n4);
        SpaceResolver.performConditionalsNotification(this.bodyList, n4, n5, n6);
        int n7 = this.getBaselineDelta();
        if (n2 <= n3) {
            knuthPossPosIter = new KnuthPossPosIter(this.labelList, n2, n3 + 1);
            layoutContext2.setFlags(4, layoutContext.isFirstArea());
            layoutContext2.setFlags(8, layoutContext.isLastArea());
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            this.label.addAreas((PositionIterator)knuthPossPosIter, layoutContext2);
        }
        if (n4 <= n5) {
            knuthPossPosIter = new KnuthPossPosIter(this.bodyList, n4, n5 + 1);
            layoutContext2.setFlags(4, layoutContext.isFirstArea());
            layoutContext2.setFlags(8, layoutContext.isLastArea());
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            this.body.addAreas((PositionIterator)knuthPossPosIter, layoutContext2);
        }
        int n8 = this.curBlockArea.getChildAreas().size();
        assert (n8 >= 1 && n8 <= 2);
        if (n7 != 0 && n8 == 2) {
            Block block = (Block)this.curBlockArea.getChildAreas().get(0);
            Block block2 = (Block)this.curBlockArea.getChildAreas().get(1);
            if (n7 < 0) {
                int n9 = block.getSpaceBefore();
                int n10 = block.getSpaceAfter();
                TraitSetter.addSpaceBeforeAfter((Area)block, layoutContext.getSpaceAdjust(), MinOptMax.getInstance((int)(n9 + -n7)), MinOptMax.getInstance((int)n10));
            } else if (n7 > 0) {
                int n11 = block2.getSpaceBefore();
                int n12 = block2.getSpaceAfter();
                TraitSetter.addSpaceBeforeAfter((Area)block2, layoutContext.getSpaceAdjust(), MinOptMax.getInstance((int)(n11 + n7)), MinOptMax.getInstance((int)n12));
            }
        }
        int n13 = ((Block)this.curBlockArea.getChildAreas().get(0)).getAllocBPD();
        if (n8 == 2) {
            n13 = Math.max(n13, ((Block)this.curBlockArea.getChildAreas().get(1)).getAllocBPD());
        }
        this.curBlockArea.setBPD(n13);
        this.registerMarkers(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addBackground((Area)this.curBlockArea, this.getListItemFO().getCommonBorderPaddingBackground(), (PercentBaseContext)this);
        TraitSetter.addSpaceBeforeAfter((Area)this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    private int getBaselineDelta() {
        boolean bl;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean bl2 = bl = ((ListItem)this.getFObj()).getRelativeAlign() == 12;
        if (bl) {
            if (this.label.hasLineAreaDescendant()) {
                n2 = this.label.getBaselineOffset();
            }
            if (this.body.hasLineAreaDescendant()) {
                n3 = this.body.getBaselineOffset();
            }
            n4 = n2 - n3;
        }
        return n4;
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.parentLayoutManager.getParentArea((Area)this.curBlockArea);
            ListItem listItem = this.getListItemFO();
            TraitSetter.setProducerID((Area)this.curBlockArea, listItem.getId());
            TraitSetter.addBorders((Area)this.curBlockArea, listItem.getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addPadding((Area)this.curBlockArea, listItem.getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addMargins((Area)this.curBlockArea, listItem.getCommonBorderPaddingBackground(), listItem.getCommonMarginBlock(), (PercentBaseContext)this);
            TraitSetter.addBreaks((Area)this.curBlockArea, listItem.getBreakBefore(), listItem.getBreakAfter());
            int n2 = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(n2);
            this.curBlockArea.setBidiLevel(listItem.getBidiLevel());
            this.setCurrentArea((BlockParent)this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getListItemFO().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getListItemFO().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getListItemFO().getKeepWithNext();
    }

    public void reset() {
        super.reset();
        this.label.reset();
        this.body.reset();
    }

    public int getBreakBefore() {
        int n2 = BreakOpportunityHelper.getBreakBefore((AbstractLayoutManager)((Object)this));
        n2 = BreakUtil.compareBreakClasses((int)n2, (int)this.label.getBreakBefore());
        n2 = BreakUtil.compareBreakClasses((int)n2, (int)this.body.getBreakBefore());
        return n2;
    }

    public boolean isRestartable() {
        return true;
    }

    public int getMinimumIPD() {
        int n2 = this.getProvisionalDistanceBetweenStarts();
        return Math.max(this.label.getMaximumIPD(), n2) + this.body.getMinimumIPD() + this.getMBP();
    }

    public int getMaximumIPD() {
        int n2 = this.getProvisionalDistanceBetweenStarts();
        return Math.max(this.label.getMaximumIPD(), n2) + this.body.getMaximumIPD() + this.getMBP();
    }

    private int getProvisionalDistanceBetweenStarts() {
        Length length = ((ListItemLabel)this.label.getFObj()).getProvisionalDistanceBetweenStarts();
        int n2 = length.getValue((PercentBaseContext)this);
        return n2;
    }

    protected int getMBP() {
        ListItem listItem = this.getListItemFO();
        CommonMarginBlock commonMarginBlock = listItem.getCommonMarginBlock();
        CommonBorderPaddingBackground commonBorderPaddingBackground = listItem.getCommonBorderPaddingBackground();
        int n2 = (int)Math.ceil(commonMarginBlock.marginLeft.getNumericValue((PercentBaseContext)this) + commonMarginBlock.marginRight.getNumericValue((PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingStart(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingEnd(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getBorderStartWidth(false) + (double)commonBorderPaddingBackground.getBorderEndWidth(false));
        return n2;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    public class ListItemPosition
    extends Position {
        private int labelFirstIndex;
        private int labelLastIndex;
        private int bodyFirstIndex;
        private int bodyLastIndex;
        private Position originalLabelPosition;
        private Position originalBodyPosition;

        public ListItemPosition(LayoutManager layoutManager, int n2, int n3, int n4, int n5) {
            super(layoutManager);
            this.labelFirstIndex = n2;
            this.labelLastIndex = n3;
            this.bodyFirstIndex = n4;
            this.bodyLastIndex = n5;
        }

        public int getLabelFirstIndex() {
            return this.labelFirstIndex;
        }

        public int getLabelLastIndex() {
            return this.labelLastIndex;
        }

        public int getBodyFirstIndex() {
            return this.bodyFirstIndex;
        }

        public int getBodyLastIndex() {
            return this.bodyLastIndex;
        }

        public boolean generatesAreas() {
            return true;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("ListItemPosition:");
            stringBuffer.append(this.getIndex()).append("(");
            stringBuffer.append("label:").append(this.labelFirstIndex).append("-").append(this.labelLastIndex);
            stringBuffer.append(" body:").append(this.bodyFirstIndex).append("-").append(this.bodyLastIndex);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public Position getOriginalLabelPosition() {
            return this.originalLabelPosition;
        }

        public void setOriginalLabelPosition(Position position) {
            this.originalLabelPosition = position;
        }

        public Position getOriginalBodyPosition() {
            return this.originalBodyPosition;
        }

        public void setOriginalBodyPosition(Position position) {
            this.originalBodyPosition = position;
        }
    }
}

