/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.LinkResolver;
import org.apache.fop.area.Resolvable;
import org.apache.fop.fo.FObj;
import org.apache.fop.image.loader.batik.PreloaderSVG;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public class GraphicsLinksHelper {
    private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    private static final String SVG_NS = "http://www.w3.org/2000/svg";
    private PageSequenceLayoutManager pslm;
    private static Log log = LogFactory.getLog(BlockContainerLayoutManager.class);

    public GraphicsLinksHelper(PageSequenceLayoutManager pageSequenceLayoutManager) {
        this.pslm = pageSequenceLayoutManager;
    }

    private List<String> collectIdRefs(Document document) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = document.getElementsByTagNameNS(SVG_NS, "a");
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            NamedNodeMap namedNodeMap = nodeList.item(i2).getAttributes();
            Node node = namedNodeMap.getNamedItem("href");
            if (node == null) {
                node = namedNodeMap.getNamedItemNS(XLINK_NS, "href");
            }
            if (node == null || node.getNodeValue() == null) continue;
            this.addInternalLink(arrayList, node.getNodeValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collected links from SVG " + arrayList));
        }
        return arrayList;
    }

    private List<String> collectIdRefsFromImageMapAttributes(FObj fObj) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = fObj.getForeignAttributes();
        String string = (String)map.get(ChemistryExtensions.ATT_QNAME_MAP_AREAS_COUNT);
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                for (int i2 = 1; i2 < n2 + 1; ++i2) {
                    String string2 = (String)map.get(new QName("http://www.oxygenxml.com/chemistry/extensions/fop", "chfox", "map-area-href-" + i2));
                    this.addInternalLink(arrayList, string2);
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                log.error((Object)("Cannot handle image map data " + map + " exception was: " + runtimeException), (Throwable)runtimeException);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collected links from image map attributes: " + arrayList));
        }
        return arrayList;
    }

    private void addInternalLink(List<String> list, String string) {
        String string2 = this.checkInternal(string);
        if (string2 != null) {
            list.add(string2);
        }
    }

    private String checkInternal(String string) {
        string = string.startsWith("#") ? string.substring(1) : null;
        return string;
    }

    private void setupLinks(Area area, List<String> list) {
        if (list != null) {
            for (String string : list) {
                LinkResolver linkResolver = new LinkResolver(string, area);
                linkResolver.resolveIDRef(string, this.pslm.getFirstPVWithID(string));
                if (linkResolver.isResolved()) continue;
                this.pslm.addUnresolvedArea(string, (Resolvable)linkResolver);
            }
        }
    }

    public void setupLinks(String string, Document document, Area area, FObj fObj) {
        List<String> list = SVG_NS.equals(string) ? this.collectIdRefs(document) : new ArrayList<String>(0);
        list.addAll(this.collectIdRefsFromImageMapAttributes(fObj));
        this.setupLinks(area, list);
    }

    public void setupLinks(String string, Area area, FObj fObj) {
        if (string.endsWith("svg") || string.endsWith("svgz")) {
            try {
                SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
                SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument(string);
                this.setupLinks(SVG_NS, (Document)sVGDocument, area, fObj);
            }
            catch (IOException iOException) {
                log.error((Object)("Cannot determine internal links from " + string + " " + iOException));
            }
        } else {
            this.setupLinks(null, null, area, fObj);
        }
    }
}

