/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.UnresolvedListElement;

public class BreakElement
extends UnresolvedListElement {
    private int penaltyWidth;
    private int penaltyValue;
    private int breakClass;
    private List<ListElement> pendingBeforeMarks;
    private List<ListElement> pendingAfterMarks;

    public BreakElement(Position position, int n2, LayoutContext layoutContext) {
        this(position, n2, 9, layoutContext);
    }

    public BreakElement(Position position, int n2, int n3, LayoutContext layoutContext) {
        this(position, 0, n2, n3, layoutContext);
    }

    public BreakElement(Position position, int n2, int n3, int n4, LayoutContext layoutContext) {
        super(position);
        this.penaltyWidth = n2;
        this.penaltyValue = n3;
        this.setBreakClass(n4);
        this.pendingBeforeMarks = layoutContext.getPendingBeforeMarks();
        this.pendingAfterMarks = layoutContext.getPendingAfterMarks();
    }

    private static String getBreakClassName(int n2) {
        return AbstractBreaker.getBreakClassName((int)n2);
    }

    public boolean isConditional() {
        return false;
    }

    public int getPenaltyWidth() {
        return this.penaltyWidth;
    }

    public int getPenaltyValue() {
        return this.penaltyValue;
    }

    public void setPenaltyValue(int n2) {
        this.penaltyValue = n2;
    }

    public boolean isForcedBreak() {
        return this.penaltyValue == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public void setBreakClass(int n2) {
        switch (n2) {
            case 9: 
            case 28: 
            case 44: 
            case 75: 
            case 100: 
            case 104: {
                this.breakClass = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for break class: " + n2);
            }
        }
    }

    public List<ListElement> getPendingBeforeMarks() {
        return this.pendingBeforeMarks;
    }

    public List<ListElement> getPendingAfterMarks() {
        return this.pendingAfterMarks;
    }

    public void clearPendingMarks() {
        this.pendingBeforeMarks = null;
        this.pendingAfterMarks = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("BreakPossibility[p:");
        stringBuffer.append(KnuthPenalty.valueOf((int)this.penaltyValue));
        if (this.isForcedBreak()) {
            stringBuffer.append(" (forced break, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        } else if (this.penaltyValue >= 0 && this.breakClass != -1) {
            stringBuffer.append(" (keep constraint, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        }
        stringBuffer.append("; w:");
        stringBuffer.append(this.penaltyWidth);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setPenaltyWidth(int n2) {
        this.penaltyWidth = n2;
    }
}

