/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.traits.MinOptMax;

public class BalancingColumnBreakingAlgorithm
extends PageBreakingAlgorithm {
    private int columnCount;
    private List<Integer> idealBreaks;

    public BalancingColumnBreakingAlgorithm(LayoutManager layoutManager, PageProvider pageProvider, PageBreakingAlgorithm.PageBreakingLayoutListener pageBreakingLayoutListener, int n2, int n3, MinOptMax minOptMax, boolean bl, int n4) {
        super(layoutManager, pageProvider, pageBreakingLayoutListener, n2, n3, minOptMax, bl, false, false);
        this.columnCount = n4;
        this.considerTooShort = true;
    }

    protected double computeDemerits(BreakingAlgorithm.KnuthNode knuthNode, KnuthElement knuthElement, int n2, double d2) {
        double d3 = Double.MAX_VALUE;
        if (this.idealBreaks == null) {
            this.idealBreaks = this.calculateIdealBreaks(knuthNode.position);
        }
        LinkedList<Integer> linkedList = this.getPossibilityTrail(knuthNode);
        boolean bl = false;
        int n3 = this.columnCount + 1 - linkedList.size();
        if (linkedList.size() > this.idealBreaks.size()) {
            return d3;
        }
        for (int i2 = 0; i2 < linkedList.size(); ++i2) {
            if (linkedList.get(i2) == 0 || linkedList.get(i2).equals(this.idealBreaks.get(i2))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            d3 = n3;
        }
        return d3;
    }

    private List<Integer> calculateIdealBreaks(int n2) {
        ArrayList<ColumnContent> arrayList = null;
        ArrayList<ColumnContent> arrayList2 = null;
        List<ColumnContent> list = new ArrayList<ColumnContent>();
        list.add(new ColumnContent(n2, this.par.size() - 1));
        do {
            arrayList = arrayList2;
            arrayList2 = list;
            int n3 = this.getAverageColumnLength(list);
            if (n3 == 0) continue;
            list = this.getInitialBreaks(n2, n3);
        } while (!list.equals(arrayList2) && !list.equals(arrayList));
        list = this.sortElementsForBreaks(list);
        return this.getElementIdBreaks(list, n2);
    }

    private int getAverageColumnLength(List<ColumnContent> list) {
        int n2 = 0;
        for (ColumnContent columnContent : list) {
            n2 += this.calcContentLength(this.par, columnContent.startIndex, columnContent.endIndex);
        }
        return n2 / this.columnCount;
    }

    private List<ColumnContent> getInitialBreaks(int n2, int n3) {
        ArrayList<ColumnContent> arrayList = new ArrayList<ColumnContent>();
        int n4 = n2;
        int n5 = 0;
        int n6 = n3;
        int n7 = 0;
        int n8 = n2;
        boolean bl = false;
        int n9 = 1;
        for (int i2 = n2; i2 < this.par.size(); ++i2) {
            KnuthElement knuthElement = (KnuthElement)((Object)this.par.get(i2));
            if (this.isLegalBreak(i2, bl)) {
                int n10 = n5 + (knuthElement instanceof KnuthPenalty ? knuthElement.getWidth() : 0);
                if (n10 > n6 && n9 < this.columnCount) {
                    int n11;
                    if (n10 - n6 > n6 - n7) {
                        n11 = n8;
                        n5 = n7;
                    } else {
                        n11 = knuthElement instanceof KnuthPenalty ? i2 : i2 - 1;
                        n5 = n10;
                    }
                    arrayList.add(new ColumnContent(n4, n11));
                    i2 = this.getNextStartIndex(n11);
                    n4 = i2--;
                    ++n9;
                    n6 += n3;
                    continue;
                }
                n7 = n10;
                n8 = knuthElement instanceof KnuthPenalty ? i2 : i2 - 1;
                bl = false;
                continue;
            }
            n5 += knuthElement instanceof KnuthPenalty ? 0 : knuthElement.getWidth();
            bl = knuthElement instanceof KnuthBox;
        }
        assert (arrayList.size() == this.columnCount - 1);
        arrayList.add(new ColumnContent(n4, this.par.size() - 1));
        return arrayList;
    }

    private int getNextStartIndex(int n2) {
        int n3 = n2;
        ListIterator listIterator = this.par.listIterator(n2);
        while (listIterator.hasNext() && !(listIterator.next() instanceof KnuthBox)) {
            ++n3;
        }
        return n3;
    }

    private List<ColumnContent> sortElementsForBreaks(List<ColumnContent> list) {
        boolean bl;
        int n2 = 4000;
        do {
            bl = false;
            ColumnContent columnContent = list.get(list.size() - 1);
            int n3 = this.calcContentLength(this.par, columnContent.startIndex, columnContent.endIndex);
            for (int i2 = list.size() - 1; i2 > 0; --i2) {
                ColumnContent columnContent2 = list.get(i2 - 1);
                int n4 = this.calcContentLength(this.par, columnContent2.startIndex, columnContent2.endIndex);
                if (n4 < n3) {
                    int n5 = columnContent.startIndex;
                    boolean bl2 = true;
                    while (n5 <= columnContent.endIndex && !this.isLegalBreak(n5, bl2)) {
                        bl2 = this.par.get(++n5) instanceof KnuthBox;
                    }
                    if (n5 < columnContent.endIndex) {
                        if (bl2) {
                            --n5;
                        }
                        int n6 = this.getNextStartIndex(n5);
                        int n7 = this.calcContentLength(this.par, columnContent2.startIndex, n5);
                        if (n7 <= n2 + n3) {
                            columnContent2 = new ColumnContent(columnContent2.startIndex, n5);
                            list.set(i2 - 1, columnContent2);
                            list.set(i2, new ColumnContent(n6, columnContent.endIndex));
                            n4 = this.calcContentLength(this.par, columnContent2.startIndex, n5);
                            bl = true;
                        }
                    }
                }
                n3 = n4;
                columnContent = columnContent2;
            }
        } while (bl);
        return list;
    }

    private boolean isLegalBreak(int n2, boolean bl) {
        KnuthElement knuthElement = (KnuthElement)((Object)this.par.get(n2));
        return knuthElement instanceof KnuthPenalty && knuthElement.getPenalty() < 1000 || bl && knuthElement instanceof KnuthGlue;
    }

    private int calcContentLength(KnuthSequence knuthSequence, int n2, int n3) {
        return ElementListUtils.calcContentLength((List)knuthSequence, (int)n2, (int)n3) + this.getPenaltyWidth(n3);
    }

    private int getPenaltyWidth(int n2) {
        KnuthElement knuthElement = (KnuthElement)((Object)this.par.get(n2));
        return knuthElement instanceof KnuthPenalty ? knuthElement.getWidth() : 0;
    }

    private List<Integer> getElementIdBreaks(List<ColumnContent> list, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n2);
        for (ColumnContent columnContent : list) {
            if (list.get(list.size() - 1).equals(columnContent)) continue;
            arrayList.add(columnContent.endIndex);
        }
        return arrayList;
    }

    private LinkedList<Integer> getPossibilityTrail(BreakingAlgorithm.KnuthNode knuthNode) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        BreakingAlgorithm.KnuthNode knuthNode2 = knuthNode;
        do {
            linkedList.addFirst(knuthNode2.position);
        } while ((knuthNode2 = knuthNode2.previous) != null);
        return linkedList;
    }

    private static final class ColumnContent {
        public final int startIndex;
        public final int endIndex;

        ColumnContent(int n2, int n3) {
            this.startIndex = n2;
            this.endIndex = n3;
        }

        public int hashCode() {
            return this.startIndex << 16 | this.endIndex;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColumnContent)) {
                return false;
            }
            ColumnContent columnContent = (ColumnContent)object;
            return columnContent.startIndex == this.startIndex && columnContent.endIndex == this.endIndex;
        }

        public String toString() {
            return this.startIndex + "-" + this.endIndex;
        }
    }
}

