/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.parser.UnitProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.extensions.svg.SVGElement;
import org.apache.fop.fo.flow.RefIPDForExternalImages;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.InputDocumentLoader;
import org.apache.fop.svg.SimpleSVGUserAgent;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.io.XmlSourceUtil;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;
import org.apache.xmlgraphics.util.UnitConv;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import ro.sync.xml.xpath.SafeXPathChecker;

public class PreloaderSVG
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderSVG.class);
    private boolean batikAvailable = true;

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException {
        ImageInfo imageInfo = null;
        if (this.batikAvailable) {
            try {
                Loader loader = new Loader();
                if (!loader.isSupportedSource(source)) {
                    return null;
                }
                imageInfo = loader.getImage(string, source, imageContext);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
        }
        if (imageInfo != null) {
            XmlSourceUtil.closeQuietly((Source)source);
        }
        return imageInfo;
    }

    public static String getParserName() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            return sAXParserFactory.newSAXParser().getXMLReader().getClass().getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static UnitProcessor.Context verifyContextToHaveValidSize(Element element, BridgeContext bridgeContext, UnitProcessor.Context object) {
        if (object.getViewportWidth() < 0.0f || object.getViewportHeight() < 0.0f) {
            object = new UnitProcessor.DefaultContext(bridgeContext, element){

                public float getViewportWidth() {
                    float f2 = super.getViewportWidth();
                    if (f2 < 0.0f) {
                        f2 = 100.0f;
                    }
                    return f2;
                }

                public float getViewportHeight() {
                    float f2 = super.getViewportHeight();
                    if (f2 < 0.0f) {
                        f2 = 100.0f;
                    }
                    return f2;
                }
            };
        }
        return object;
    }

    private static double px2mpt(double d2, double d3) {
        return d2 * 1000.0 * 72.0 / d3;
    }

    private final class Loader {
        private Loader() {
        }

        private ImageInfo getImage(String string, Source source, ImageContext imageContext) {
            InputStream inputStream = null;
            try {
                SVGDocument sVGDocument;
                DOMSource dOMSource;
                if (source instanceof DOMSource) {
                    dOMSource = (DOMSource)source;
                    sVGDocument = (SVGDocument)dOMSource.getNode();
                } else {
                    inputStream = new UnclosableInputStream(XmlSourceUtil.needInputStream((Source)source));
                    int n2 = inputStream.available();
                    inputStream.mark(n2 + 1);
                    SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
                    sVGDocument = sAXSVGDocumentFactory.createSVGDocument(source.getSystemId(), inputStream);
                }
                dOMSource = this.createImageInfo(string, imageContext, sVGDocument);
                return dOMSource;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (inputStream != null) {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                PreloaderSVG.this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
            catch (IOException iOException) {
                log.debug((Object)("Error while trying to load stream as an SVG file: " + iOException.getMessage()));
                try {
                    inputStream.reset();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return null;
            }
        }

        private ImageInfo createImageInfo(String string, final ImageContext imageContext, final SVGDocument sVGDocument) {
            boolean bl;
            boolean bl2 = bl = string != null && string.endsWith(".template.svg");
            if (bl && InputDocumentLoader.shouldExpandXpathInSvgTemplates.get().booleanValue()) {
                this.expandXPathPlaceholders((Node)sVGDocument, new InputDocumentLoader());
            }
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            SimpleSVGUserAgent simpleSVGUserAgent = new SimpleSVGUserAgent(new AffineTransform(), (FontFamilyResolver)DefaultFontFamilyResolver.SINGLETON, imageContext.getSourceResolution()){

                public void displayMessage(String string) {
                    log.debug((Object)string);
                }

                public Dimension2D getViewportSize() {
                    double d2 = Math.ceil(UnitConv.mpt2px((double)RefIPDForExternalImages.getRefIPD().intValue(), (int)((int)imageContext.getSourceResolution())));
                    return new Dimension2DDouble(d2, d2);
                }
            };
            BridgeContext bridgeContext = new BridgeContext((UserAgent)simpleSVGUserAgent){

                public void initializeDocument(Document document) {
                    super.initializeDocument(document);
                }
            };
            try {
                bridgeContext.getClass().getMethod("initializeDocument", Document.class).invoke((Object)bridgeContext, sVGDocument);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)sVGSVGElement);
            context = PreloaderSVG.verifyContextToHaveValidSize((Element)sVGSVGElement, bridgeContext, context);
            String string2 = sVGSVGElement.getAttributeNS(null, "width");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            final String string3 = string2;
            float f2 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string2, (String)"width", (UnitProcessor.Context)context);
            string2 = sVGSVGElement.getAttributeNS(null, "height");
            if (string2.length() == 0) {
                string2 = "100%";
            }
            final String string4 = string2;
            float f3 = UnitProcessor.svgVerticalLengthToUserSpace((String)string2, (String)"height", (UnitProcessor.Context)context);
            float[] fArray = SVGElement.imposePercentualProportionsFromViewBox((Element)sVGSVGElement, string3, string4, f2, f3);
            f2 = fArray[0];
            f3 = fArray[1];
            int n2 = (int)Math.round(PreloaderSVG.px2mpt(f2, imageContext.getSourceResolution()));
            int n3 = (int)Math.round(PreloaderSVG.px2mpt(f3, imageContext.getSourceResolution()));
            ImageInfo imageInfo = new ImageInfo(string, "image/svg+xml");
            ImageSize imageSize = new ImageSize();
            imageSize.setSizeInMillipoints(n2, n3);
            imageSize.setResolution((double)imageContext.getSourceResolution());
            imageSize.calcPixelsFromSize();
            imageInfo.setSize(imageSize);
            ImageXMLDOM imageXMLDOM = new ImageXMLDOM(imageInfo, (Document)sVGDocument, BatikImageFlavors.SVG_DOM){

                public boolean isCacheable() {
                    boolean bl = super.isCacheable();
                    if (string3.contains("%") || string4.contains("%")) {
                        bl = false;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The image is not cacheable because it has percentual size, width: " + string3 + " heigt: " + string4 + ", " + sVGDocument.getBaseURI()));
                        }
                    }
                    return bl;
                }
            };
            imageInfo.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, imageXMLDOM);
            return imageInfo;
        }

        private boolean isSupportedSource(Source source) {
            if (source instanceof DOMSource) {
                DOMSource dOMSource = (DOMSource)source;
                return dOMSource.getNode() instanceof SVGDocument;
            }
            return ImageUtil.hasInputStream((Source)source);
        }

        private Node expandXPathPlaceholders(Node node, InputDocumentLoader inputDocumentLoader) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                String string = node.getNodeValue();
                Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
                Matcher matcher = pattern.matcher(string);
                int n2 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                while (matcher.find()) {
                    stringBuilder.append(string, n2, matcher.start());
                    stringBuilder.append(this.evaluateXPath(matcher.group(1), inputDocumentLoader));
                    n2 = matcher.end();
                }
                stringBuilder.append(string, n2, string.length());
                String string2 = stringBuilder.toString();
                if (!string2.equals(string)) {
                    node.setNodeValue(string2);
                }
            } else {
                NodeList nodeList = node.getChildNodes();
                int n3 = nodeList.getLength();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Node node2 = nodeList.item(i2);
                    this.expandXPathPlaceholders(node2, inputDocumentLoader);
                }
            }
            return node;
        }

        private String evaluateXPath(String string, InputDocumentLoader inputDocumentLoader) {
            XPathFactoryImpl xPathFactoryImpl = new XPathFactoryImpl();
            XPath xPath = xPathFactoryImpl.newXPath();
            SafeXPathChecker safeXPathChecker = new SafeXPathChecker();
            try {
                safeXPathChecker.check(string);
                XPathExpression xPathExpression = xPath.compile(string);
                Document document = inputDocumentLoader.getInputDocument();
                if (document != null) {
                    return (String)xPathExpression.evaluate(document, XPathConstants.STRING);
                }
            }
            catch (XPathExpressionException | SafeXPathChecker.UnsafeXPathException throwable) {
                log.error((Object)("Cannot evaluate: ${" + string + "}. " + throwable.getMessage()));
            }
            return string;
        }
    }
}

