/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.GlyfTable;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;

public class TTFSubSetFile
extends TTFFile {
    protected byte[] output;
    protected int realSize;
    protected int currentPos;
    protected Map<OFTableName, Integer> offsets = new HashMap<OFTableName, Integer>();
    private int checkSumAdjustmentOffset;
    protected int locaOffset;
    protected int[] glyphOffsets;
    protected Map<OFTableName, OFDirTabEntry> newDirTabs = new HashMap<OFTableName, OFDirTabEntry>();
    private MultiByteFont mbFont;

    public TTFSubSetFile() {
    }

    public TTFSubSetFile(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    private int determineTableCount() {
        int n2 = 4;
        if (this.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF glyphs are not supported");
        }
        n2 += 5;
        if (this.hasCvt()) {
            ++n2;
        }
        if (this.hasFpgm()) {
            ++n2;
        }
        if (this.hasPrep()) {
            ++n2;
        }
        if (!this.cid) {
            ++n2;
        }
        return n2;
    }

    protected void createDirectory() {
        int n2 = this.determineTableCount();
        this.writeByte((byte)0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.realSize += 4;
        this.writeUShort(n2);
        this.realSize += 2;
        int n3 = this.maxPow2(n2);
        int n4 = (int)Math.pow(2.0, n3) * 16;
        this.writeUShort(n4);
        this.realSize += 2;
        this.writeUShort(n3);
        this.realSize += 2;
        this.writeUShort(n2 * 16 - n4);
        this.realSize += 2;
        this.writeTableName(OFTableName.OS2);
        if (!this.cid) {
            this.writeTableName(OFTableName.CMAP);
        }
        if (this.hasCvt()) {
            this.writeTableName(OFTableName.CVT);
        }
        if (this.hasFpgm()) {
            this.writeTableName(OFTableName.FPGM);
        }
        this.writeTableName(OFTableName.GLYF);
        this.writeTableName(OFTableName.HEAD);
        this.writeTableName(OFTableName.HHEA);
        this.writeTableName(OFTableName.HMTX);
        this.writeTableName(OFTableName.LOCA);
        this.writeTableName(OFTableName.MAXP);
        this.writeTableName(OFTableName.NAME);
        this.writeTableName(OFTableName.POST);
        if (this.hasPrep()) {
            this.writeTableName(OFTableName.PREP);
        }
        this.newDirTabs.put(OFTableName.TABLE_DIRECTORY, new OFDirTabEntry(0L, (long)this.currentPos));
    }

    private void writeTableName(OFTableName oFTableName) {
        this.writeString(oFTableName.getName());
        this.offsets.put(oFTableName, this.currentPos);
        this.currentPos += 12;
        this.realSize += 16;
    }

    private boolean hasCvt() {
        return this.dirTabs.containsKey(OFTableName.CVT);
    }

    private boolean hasFpgm() {
        return this.dirTabs.containsKey(OFTableName.FPGM);
    }

    private boolean hasPrep() {
        return this.dirTabs.containsKey(OFTableName.PREP);
    }

    protected void createLoca(int n2) throws IOException {
        this.pad4();
        this.locaOffset = this.currentPos;
        int n3 = this.offsets.get(OFTableName.LOCA);
        this.writeULong(n3 + 4, this.currentPos);
        this.writeULong(n3 + 8, n2 * 4 + 4);
        this.currentPos += n2 * 4 + 4;
        this.realSize += n2 * 4 + 4;
    }

    private boolean copyTable(FontFileReader fontFileReader, OFTableName oFTableName) throws IOException {
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        if (oFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, oFTableName, 0L);
            this.writeBytes(fontFileReader.getBytes((int)oFDirTabEntry.getOffset(), (int)oFDirTabEntry.getLength()));
            this.updateCheckSum(this.currentPos, (int)oFDirTabEntry.getLength(), oFTableName);
            this.currentPos += (int)oFDirTabEntry.getLength();
            this.realSize += (int)oFDirTabEntry.getLength();
            return true;
        }
        return false;
    }

    protected boolean createCvt(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, OFTableName.CVT);
    }

    protected boolean createFpgm(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, OFTableName.FPGM);
    }

    protected boolean createName(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, OFTableName.NAME);
    }

    protected boolean createOS2(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, OFTableName.OS2);
    }

    protected void createMaxp(FontFileReader fontFileReader, int n2) throws IOException {
        OFTableName oFTableName = OFTableName.MAXP;
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        if (oFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, oFTableName, 0L);
            this.writeBytes(fontFileReader.getBytes((int)oFDirTabEntry.getOffset(), (int)oFDirTabEntry.getLength()));
            this.writeUShort(this.currentPos + 4, n2);
            this.updateCheckSum(this.currentPos, (int)oFDirTabEntry.getLength(), oFTableName);
            this.currentPos += (int)oFDirTabEntry.getLength();
            this.realSize += (int)oFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find maxp table");
        }
    }

    protected void createPost(FontFileReader fontFileReader) throws IOException {
        OFTableName oFTableName = OFTableName.POST;
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        if (oFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, oFTableName, 0L);
            int n2 = 32;
            byte[] byArray = new byte[n2];
            System.arraycopy(fontFileReader.getBytes((int)oFDirTabEntry.getOffset(), n2), 0, byArray, 0, n2);
            byArray[1] = 3;
            this.writeBytes(byArray);
            this.updateCheckSum(this.currentPos, n2, oFTableName);
            this.currentPos += n2;
            this.realSize += n2;
        }
    }

    protected boolean createPrep(FontFileReader fontFileReader) throws IOException {
        return this.copyTable(fontFileReader, OFTableName.PREP);
    }

    protected void createHhea(FontFileReader fontFileReader, int n2) throws IOException {
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(OFTableName.HHEA);
        if (oFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, OFTableName.HHEA, 0L);
            this.writeBytes(fontFileReader.getBytes((int)oFDirTabEntry.getOffset(), (int)oFDirTabEntry.getLength()));
            this.writeUShort((int)oFDirTabEntry.getLength() + this.currentPos - 2, n2);
            this.updateCheckSum(this.currentPos, (int)oFDirTabEntry.getLength(), OFTableName.HHEA);
            this.currentPos += (int)oFDirTabEntry.getLength();
            this.realSize += (int)oFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find hhea table");
        }
    }

    protected void createHead(FontFileReader fontFileReader) throws IOException {
        OFTableName oFTableName = OFTableName.HEAD;
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        if (oFDirTabEntry != null) {
            this.pad4();
            this.seekTab(fontFileReader, oFTableName, 0L);
            this.writeBytes(fontFileReader.getBytes((int)oFDirTabEntry.getOffset(), (int)oFDirTabEntry.getLength()));
            this.checkSumAdjustmentOffset = this.currentPos + 8;
            this.output[this.currentPos + 8] = 0;
            this.output[this.currentPos + 9] = 0;
            this.output[this.currentPos + 10] = 0;
            this.output[this.currentPos + 11] = 0;
            this.output[this.currentPos + 50] = 0;
            if (this.cid) {
                this.output[this.currentPos + 51] = 1;
            }
            this.updateCheckSum(this.currentPos, (int)oFDirTabEntry.getLength(), oFTableName);
            this.currentPos += (int)oFDirTabEntry.getLength();
            this.realSize += (int)oFDirTabEntry.getLength();
        } else {
            throw new IOException("Can't find head table");
        }
    }

    private void createGlyf(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        int n2;
        int n3;
        int n4;
        OFTableName oFTableName = OFTableName.GLYF;
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (oFDirTabEntry != null) {
            this.pad4();
            n6 = this.currentPos;
            int[] nArray = this.buildSubsetIndexToOrigIndexMap(map);
            this.glyphOffsets = new int[nArray.length];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                n3 = 0;
                n2 = nArray[n4];
                if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
                    n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
                }
                n3 = n2 >= this.mtxTab.length - 1 ? (int)this.lastLoca : (int)this.mtxTab[n2 + 1].getOffset();
                int n8 = (int)this.mtxTab[n2].getOffset();
                int n9 = n3 - n8;
                byte[] byArray = fontFileReader.getBytes((int)oFDirTabEntry.getOffset() + n8, n9);
                int n10 = n7;
                this.writeBytes(byArray);
                this.writeULong(this.locaOffset + n4 * 4, this.currentPos - n6);
                if (this.currentPos - n6 + n9 > n10) {
                    n10 = this.currentPos - n6 + n9;
                }
                this.glyphOffsets[n4] = this.currentPos;
                this.currentPos += n9;
                this.realSize += n9;
                n7 = n10;
            }
            n5 = this.currentPos - n6;
            this.currentPos += 12;
            this.realSize += 12;
        } else {
            throw new IOException("Can't find glyf table");
        }
        this.updateCheckSum(n6, n5 + 12, oFTableName);
        this.writeULong(this.locaOffset + map.size() * 4, n7);
        n4 = map.size() * 4 + 4;
        n3 = TTFSubSetFile.getCheckSum(this.output, this.locaOffset, n4);
        this.writeULong(this.offsets.get(OFTableName.LOCA), n3);
        n2 = (this.locaOffset + n4) % 4;
        this.newDirTabs.put(OFTableName.LOCA, new OFDirTabEntry((long)this.locaOffset, (long)(n4 + n2)));
    }

    protected int[] buildSubsetIndexToOrigIndexMap(Map<Integer, Integer> map) {
        int[] nArray = new int[map.size()];
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n2 = entry.getKey();
            int n3 = entry.getValue();
            if (nArray.length <= n3) continue;
            nArray[n3] = n2;
        }
        return nArray;
    }

    protected void createHmtx(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        OFTableName oFTableName = OFTableName.HMTX;
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(oFTableName);
        int n2 = map.size() * 2;
        int n3 = map.size() * 2;
        int n4 = n2 + n3;
        if (oFDirTabEntry != null) {
            this.pad4();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                Integer n5 = entry.getKey();
                if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n5)) {
                    n5 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n5);
                }
                Integer n6 = entry.getValue();
                this.writeUShort(this.currentPos + n6 * 4, this.mtxTab[n5].getWx());
                this.writeUShort(this.currentPos + n6 * 4 + 2, this.mtxTab[n5].getLsb());
            }
            this.updateCheckSum(this.currentPos, n4, oFTableName);
            this.currentPos += n4;
            this.realSize += n4;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    public void readFont(FontFileReader fontFileReader, String string, String string2, MultiByteFont multiByteFont) throws IOException {
        this.mbFont = multiByteFont;
        this.fontFile = fontFileReader;
        if (!this.checkTTC(string2, string)) {
            throw new IOException("Failed to read font");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(multiByteFont.getUsedGlyphs());
        this.output = new byte[fontFileReader.getFileSize()];
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.readIndexToLocation();
        this.scanGlyphs(fontFileReader, hashMap);
        this.createDirectory();
        boolean bl = this.createCvt(fontFileReader);
        if (!bl) {
            this.log.debug((Object)"TrueType: ctv table not present. Skipped.");
        }
        if (!(bl = this.createFpgm(fontFileReader))) {
            this.log.debug((Object)"TrueType: fpgm table not present. Skipped.");
        }
        this.createLoca(hashMap.size());
        this.createGlyf(fontFileReader, hashMap);
        this.createOS2(fontFileReader);
        this.createHead(fontFileReader);
        this.createHhea(fontFileReader, hashMap.size());
        this.createHmtx(fontFileReader, hashMap);
        this.createMaxp(fontFileReader, hashMap.size());
        this.createName(fontFileReader);
        this.createPost(fontFileReader);
        bl = this.createPrep(fontFileReader);
        if (!bl) {
            this.log.debug((Object)"TrueType: prep table not present. Skipped.");
        }
        this.pad4();
        this.createCheckSumAdjustment();
    }

    public byte[] getFontSubset() {
        byte[] byArray = new byte[this.realSize];
        System.arraycopy(this.output, 0, byArray, 0, this.realSize);
        return byArray;
    }

    private void handleGlyphSubset(TTFGlyphOutputStream tTFGlyphOutputStream) throws IOException {
        tTFGlyphOutputStream.startGlyphStream();
        for (int i2 = 0; i2 < this.glyphOffsets.length - 1; ++i2) {
            tTFGlyphOutputStream.streamGlyph(this.output, this.glyphOffsets[i2], this.glyphOffsets[i2 + 1] - this.glyphOffsets[i2]);
        }
        OFDirTabEntry oFDirTabEntry = this.newDirTabs.get(OFTableName.GLYF);
        long l2 = oFDirTabEntry.getLength() - ((long)this.glyphOffsets[this.glyphOffsets.length - 1] - oFDirTabEntry.getOffset());
        tTFGlyphOutputStream.streamGlyph(this.output, this.glyphOffsets[this.glyphOffsets.length - 1], (int)l2);
        tTFGlyphOutputStream.endGlyphStream();
    }

    public void stream(TTFOutputStream tTFOutputStream) throws IOException {
        SortedSet sortedSet = this.sortDirTabMap(this.newDirTabs);
        TTFTableOutputStream tTFTableOutputStream = tTFOutputStream.getTableOutputStream();
        TTFGlyphOutputStream tTFGlyphOutputStream = tTFOutputStream.getGlyphOutputStream();
        tTFOutputStream.startFontStream();
        for (Map.Entry entry : sortedSet) {
            if (((OFTableName)entry.getKey()).equals((Object)OFTableName.GLYF)) {
                this.handleGlyphSubset(tTFGlyphOutputStream);
                continue;
            }
            tTFTableOutputStream.streamTable(this.output, (int)((OFDirTabEntry)entry.getValue()).getOffset(), (int)((OFDirTabEntry)entry.getValue()).getLength());
        }
        tTFOutputStream.endFontStream();
    }

    protected void scanGlyphs(FontFileReader fontFileReader, Map<Integer, Integer> map) throws IOException {
        OFDirTabEntry oFDirTabEntry = (OFDirTabEntry)this.dirTabs.get(OFTableName.GLYF);
        if (oFDirTabEntry == null) {
            throw new IOException("Glyf table could not be found");
        }
        GlyfTable glyfTable = new GlyfTable(fontFileReader, this.mtxTab, oFDirTabEntry, map, this.mbFont);
        glyfTable.populateGlyphsWithComposites();
    }

    private int writeString(String string) {
        int n2 = 0;
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            this.writeBytes(byArray);
            n2 = byArray.length;
            this.currentPos += n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return n2;
    }

    private void writeByte(byte by) {
        this.output[this.currentPos++] = by;
    }

    protected void writeBytes(byte[] byArray) {
        if (byArray.length + this.currentPos > this.output.length) {
            byte[] byArray2 = new byte[this.output.length * 2];
            System.arraycopy(this.output, 0, byArray2, 0, this.output.length);
            this.output = byArray2;
        }
        System.arraycopy(byArray, 0, this.output, this.currentPos, byArray.length);
    }

    protected void writeUShort(int n2) {
        byte by = (byte)(n2 >> 8 & 0xFF);
        byte by2 = (byte)(n2 & 0xFF);
        this.writeByte(by);
        this.writeByte(by2);
    }

    protected void writeUShort(int n2, int n3) {
        byte by = (byte)(n3 >> 8 & 0xFF);
        byte by2 = (byte)(n3 & 0xFF);
        this.output[n2] = by;
        this.output[n2 + 1] = by2;
    }

    protected void writeULong(int n2, int n3) {
        byte by = (byte)(n3 >> 24 & 0xFF);
        byte by2 = (byte)(n3 >> 16 & 0xFF);
        byte by3 = (byte)(n3 >> 8 & 0xFF);
        byte by4 = (byte)(n3 & 0xFF);
        this.output[n2] = by;
        this.output[n2 + 1] = by2;
        this.output[n2 + 2] = by3;
        this.output[n2 + 3] = by4;
    }

    protected void pad4() {
        int n2 = this.getPadSize(this.currentPos);
        if (n2 < 4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.output[this.currentPos++] = 0;
                ++this.realSize;
            }
        }
    }

    private int maxPow2(int n2) {
        int n3 = 0;
        while (Math.pow(2.0, n3) <= (double)n2) {
            ++n3;
        }
        return n3 - 1;
    }

    protected void updateCheckSum(int n2, int n3, OFTableName oFTableName) {
        int n4 = TTFSubSetFile.getCheckSum(this.output, n2, n3);
        int n5 = this.offsets.get(oFTableName);
        int n6 = this.getPadSize(n2 + n3);
        this.newDirTabs.put(oFTableName, new OFDirTabEntry((long)n2, (long)(n3 + n6)));
        this.writeULong(n5, n4);
        this.writeULong(n5 + 4, n2);
        this.writeULong(n5 + 8, n3);
    }

    protected static int getCheckSum(byte[] byArray, int n2, int n3) {
        int n4 = n3 % 4;
        if (n4 != 0) {
            n3 += n4;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; i2 += 4) {
            long l3 = 0L;
            for (int i3 = 0; i3 < 4; ++i3) {
                l3 <<= 8;
                if (byArray.length <= n2 + i2 + i3) continue;
                l3 |= (long)(byArray[n2 + i2 + i3] & 0xFF);
            }
            l2 += l3;
        }
        return (int)l2;
    }

    protected void createCheckSumAdjustment() {
        long l2 = TTFSubSetFile.getCheckSum(this.output, 0, this.realSize);
        int n2 = (int)(-1313820742L - l2);
        this.writeULong(this.checkSumAdjustmentOffset, n2);
    }
}

