/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.OTFAdvancedTypographicTableReader;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.OTFFile;
import org.apache.fop.fonts.truetype.SVGGlyphData;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

public abstract class OpenFont {
    static final byte NTABS = 24;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    private static final String[] MAC_GLYPH_ORDERING = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    protected FontFileReader fontFile;
    public static final boolean TRACE_ENABLED = false;
    private static final String ENCODING = "WinAnsiEncoding";
    private static final short FIRST_CHAR = 0;
    protected boolean useKerning;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map<OFTableName, OFDirTabEntry> dirTabs;
    private Map<Integer, Map<Integer, Integer>> kerningTab;
    private Map<Integer, Map<Integer, Integer>> ansiKerningTab;
    private List<CMapSegment> cmaps;
    protected List<UnicodeMapping> unicodeMappings;
    private int upem;
    protected int nhmtx;
    private PostScriptVersion postScriptVersion;
    protected int locaFormat;
    protected long lastLoca;
    protected int numberOfGlyphs;
    protected OFMtxEntry[] mtxTab;
    protected String postScriptName = "";
    protected String fullName = "";
    protected String embedFontName = "";
    protected String notice = "";
    protected final Set<String> familyNames = new HashSet<String>();
    protected String subFamilyName = "";
    protected boolean cid = true;
    private long italicAngle;
    private long isFixedPitch;
    private int fontBBox1;
    private int fontBBox2;
    private int fontBBox3;
    private int fontBBox4;
    private int capHeight;
    private int os2CapHeight;
    private int underlinePosition;
    private int underlineThickness;
    private int strikeoutPosition;
    private int strikeoutThickness;
    private int xHeight;
    private int os2xHeight;
    private int ascender;
    private int descender;
    private int hheaAscender;
    private int hheaDescender;
    private int os2Ascender;
    private int os2Descender;
    private int usWeightClass;
    private short lastChar;
    private int[] ansiWidth;
    private Map<Integer, List<Integer>> ansiIndex;
    protected Map<Integer, SVGGlyphData> svgs;
    private final Map<Integer, Integer> glyphToUnicodeMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> unicodeToGlyphMap = new HashMap<Integer, Integer>();
    private boolean isCFF;
    protected boolean useAdvanced;
    protected OTFAdvancedTypographicTableReader advancedTableReader;
    protected Log log = LogFactory.getLog(TTFFile.class);

    public OpenFont() {
        this(true, false);
    }

    public OpenFont(boolean bl, boolean bl2) {
        this.useKerning = bl;
        this.useAdvanced = bl2;
    }

    public OFDirTabEntry getDirectoryEntry(OFTableName oFTableName) {
        return this.dirTabs.get(oFTableName);
    }

    public boolean seekTab(FontFileReader fontFileReader, OFTableName oFTableName, long l2) throws IOException {
        OFDirTabEntry oFDirTabEntry = this.dirTabs.get(oFTableName);
        if (oFDirTabEntry == null) {
            this.log.info((Object)("Dirtab " + oFTableName.getName() + " not found."));
            return false;
        }
        fontFileReader.seekSet(oFDirTabEntry.getOffset() + l2);
        return true;
    }

    public int convertTTFUnit2PDFUnit(int n2) {
        int n3;
        if (n2 < 0) {
            long l2 = n2 % this.upem;
            long l3 = 1000L * l2;
            long l4 = l3 != 0L ? l2 / l3 : 0L;
            n3 = -(-1000 * n2 / this.upem - (int)l4);
        } else {
            n3 = n2 / this.upem * 1000 + n2 % this.upem * 1000 / this.upem;
        }
        return n3;
    }

    protected boolean readCMAP() throws IOException {
        this.unicodeMappings = new ArrayList<UnicodeMapping>();
        if (!this.seekTab(this.fontFile, OFTableName.CMAP, 2L)) {
            return true;
        }
        int n2 = this.fontFile.readTTFUShort();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(n2 + " cmap tables"));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.fontFile.readTTFUShort();
            int n4 = this.fontFile.readTTFUShort();
            long l5 = this.fontFile.readTTFLong();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Platform ID: " + n3 + " Encoding: " + n4));
            }
            if (n3 == 3 && n4 == 1) {
                l2 = l5;
            }
            if (n3 == 3 && n4 == 0) {
                l3 = l5;
            }
            if (n3 != 3 || n4 != 10) continue;
            l4 = l5;
        }
        if (l4 > 0L) {
            return this.readUnicodeCmap(l4, 10);
        }
        if (l2 > 0L) {
            return this.readUnicodeCmap(l2, 1);
        }
        if (l3 > 0L) {
            return this.readUnicodeCmap(l3, 0);
        }
        this.log.fatal((Object)"Unsupported TrueType font: No Unicode or Symbol cmap table not present. Aborting");
        return false;
    }

    private boolean readUnicodeCmap(long l2, int n2) throws IOException {
        int n3 = 0;
        this.seekTab(this.fontFile, OFTableName.CMAP, l2);
        int n4 = this.fontFile.readTTFUShort();
        if (n4 < 8) {
            this.fontFile.readTTFUShort();
            this.fontFile.readTTFUShort();
        } else {
            this.fontFile.readTTFUShort();
            this.fontFile.readTTFULong();
            this.fontFile.readTTFULong();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CMAP format: " + n4));
        }
        if (n4 == 4) {
            int n5;
            int n6 = this.fontFile.readTTFUShort();
            int n7 = this.fontFile.readTTFUShort();
            int n8 = this.fontFile.readTTFUShort();
            int n9 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("segCountX2   : " + n6));
                this.log.debug((Object)("searchRange  : " + n7));
                this.log.debug((Object)("entrySelector: " + n8));
                this.log.debug((Object)("rangeShift   : " + n9));
            }
            int[] nArray = new int[n6 / 2];
            int[] nArray2 = new int[n6 / 2];
            int[] nArray3 = new int[n6 / 2];
            int[] nArray4 = new int[n6 / 2];
            for (n5 = 0; n5 < n6 / 2; ++n5) {
                nArray[n5] = this.fontFile.readTTFUShort();
            }
            this.fontFile.skip(2L);
            for (n5 = 0; n5 < n6 / 2; ++n5) {
                nArray2[n5] = this.fontFile.readTTFUShort();
            }
            for (n5 = 0; n5 < n6 / 2; ++n5) {
                nArray3[n5] = this.fontFile.readTTFShort();
            }
            for (n5 = 0; n5 < n6 / 2; ++n5) {
                nArray4[n5] = this.fontFile.readTTFUShort();
            }
            n5 = this.fontFile.getCurrentPos();
            BitSet bitSet = new BitSet(256);
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(i2 + ": " + nArray2[i2] + " - " + nArray[i2]));
                }
                if (this.log.isDebugEnabled() && this.isInPrivateUseArea(nArray2[i2], nArray[i2])) {
                    this.log.debug((Object)("Font contains glyphs in the Unicode private use area: " + Integer.toHexString(nArray2[i2]) + " - " + Integer.toHexString(nArray[i2])));
                }
                for (int i3 = nArray2[i2]; i3 <= nArray[i2]; ++i3) {
                    int n10;
                    if (i3 < 256 && i3 > this.lastChar) {
                        this.lastChar = (short)i3;
                    }
                    if (i3 < 256) {
                        bitSet.set(i3);
                    }
                    if (n3 >= this.mtxTab.length) continue;
                    if (nArray4[i2] != 0 && i3 != 65535) {
                        int n11 = n5 + (nArray4[i2] / 2 + (i3 - nArray2[i2]) + i2 - n6 / 2) * 2;
                        this.fontFile.seekSet((long)n11);
                        n10 = this.fontFile.readTTFUShort() + nArray3[i2] & 0xFFFF;
                        this.unicodeMappings.add(new UnicodeMapping(this, n10, i3));
                        this.mtxTab[n10].getUnicodeIndex().add(i3);
                        this.mapSymbol(n2, i3, bitSet, n10);
                        List<Integer> list = this.ansiIndex.get(i3);
                        if (list != null) {
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Integer n12 = (Integer)iterator.next();
                                this.ansiWidth[n12.intValue()] = this.mtxTab[n10].getWx();
                                if (!this.log.isTraceEnabled()) continue;
                                this.log.trace((Object)("Added width " + this.mtxTab[n10].getWx() + " uni: " + i3 + " ansi: " + n12));
                            }
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Idx: " + n10 + " Delta: " + nArray3[i2] + " Unicode: " + i3 + " name: " + this.mtxTab[n10].getName()));
                        }
                    } else {
                        n10 = i3 + nArray3[i2] & 0xFFFF;
                        if (n10 < this.mtxTab.length) {
                            this.mtxTab[n10].getUnicodeIndex().add(i3);
                        } else {
                            this.log.debug((Object)("Glyph " + n10 + " out of range: " + this.mtxTab.length));
                        }
                        this.unicodeMappings.add(new UnicodeMapping(this, n10, i3));
                        if (n10 < this.mtxTab.length) {
                            this.mtxTab[n10].getUnicodeIndex().add(i3);
                        } else {
                            this.log.debug((Object)("Glyph " + n10 + " out of range: " + this.mtxTab.length));
                        }
                        this.mapSymbol(n2, i3, bitSet, n10);
                        List<Integer> list = this.ansiIndex.get(i3);
                        if (list != null) {
                            for (Integer n13 : list) {
                                this.ansiWidth[n13.intValue()] = this.mtxTab[n10].getWx();
                            }
                        }
                    }
                    if (n10 >= this.mtxTab.length || this.mtxTab[n10].getUnicodeIndex().size() >= 2) continue;
                    ++n3;
                }
            }
        } else if (n4 == 12) {
            long l3 = this.fontFile.readTTFULong();
            block8: for (long i4 = 0L; i4 < l3; ++i4) {
                long l4 = this.fontFile.readTTFULong();
                long l5 = this.fontFile.readTTFULong();
                long l6 = this.fontFile.readTTFULong();
                if (l4 < 0L || l4 > 0x10FFFFL) {
                    this.log.warn((Object)"startCharCode outside Unicode range");
                    continue;
                }
                if (l4 >= 55296L && l4 <= 57343L) {
                    this.log.warn((Object)("startCharCode is a surrogate pair: " + l4));
                }
                if (l5 > 0L && l5 < l4 || l5 > 0x10FFFFL) {
                    this.log.warn((Object)"startCharCode outside Unicode range");
                    continue;
                }
                if (l5 >= 55296L && l5 <= 57343L) {
                    this.log.warn((Object)("endCharCode is a surrogate pair: " + l4));
                }
                for (long i5 = 0L; i5 <= l5 - l4; ++i5) {
                    long l7 = l6 + i5;
                    long l8 = l4 + i5;
                    if (l7 >= (long)this.numberOfGlyphs) {
                        this.log.warn((Object)"Format 12 cmap contains an invalid glyph index");
                        continue block8;
                    }
                    if (l8 > 0x10FFFFL) {
                        this.log.warn((Object)"Format 12 cmap contains character beyond UCS-4");
                    }
                    if (l7 > Integer.MAX_VALUE) {
                        this.log.error((Object)"glyphIndex > Integer.MAX_VALUE");
                        continue;
                    }
                    if (l8 > Integer.MAX_VALUE) {
                        this.log.error((Object)"startCharCode + j > Integer.MAX_VALUE");
                        continue;
                    }
                    if (l8 < 255L && l8 > (long)this.lastChar) {
                        this.lastChar = (short)l8;
                    }
                    int n14 = (int)l8;
                    int n15 = (int)l7;
                    List<Integer> list = null;
                    if (l8 <= 65535L) {
                        list = this.ansiIndex.get((int)l8);
                    }
                    this.unicodeMappings.add(new UnicodeMapping(this, n15, n14));
                    this.mtxTab[n15].getUnicodeIndex().add(n14);
                    if (list == null) continue;
                    for (Integer n16 : list) {
                        this.ansiWidth[n16.intValue()] = this.mtxTab[n15].getWx();
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("Added width " + this.mtxTab[n15].getWx() + " uni: " + i5 + " ansi: " + n16));
                    }
                }
            }
        } else {
            this.log.error((Object)("Cmap format not supported: " + n4));
            return false;
        }
        return true;
    }

    private void mapSymbol(int n2, int n3, BitSet bitSet, int n4) {
        int n5;
        if (n2 == 0 && n3 >= 61472 && n3 <= 61695 && !bitSet.get(n5 = n3 - 61440)) {
            this.unicodeMappings.add(new UnicodeMapping(this, n4, n5));
            this.mtxTab[n4].getUnicodeIndex().add(n5);
        }
    }

    private boolean isInPrivateUseArea(int n2, int n3) {
        return this.isInPrivateUseArea(n2) || this.isInPrivateUseArea(n3);
    }

    private boolean isInPrivateUseArea(int n2) {
        return n2 >= 57344 && n2 <= 63743;
    }

    public List<OFMtxEntry> getMtx() {
        return Collections.unmodifiableList(Arrays.asList(this.mtxTab));
    }

    public void readFont(FontFileReader fontFileReader, String string) throws IOException {
        this.readFont(fontFileReader, string, (String)null);
    }

    protected void initAnsiWidths() {
        int n2;
        this.ansiWidth = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            this.ansiWidth[n2] = this.mtxTab[0].getWx();
        }
        this.ansiIndex = new HashMap<Integer, List<Integer>>();
        for (n2 = 32; n2 < Glyphs.WINANSI_ENCODING.length; ++n2) {
            Integer n3 = n2;
            Integer n4 = Glyphs.WINANSI_ENCODING[n2];
            List<Integer> list = this.ansiIndex.get(n4);
            if (list == null) {
                list = new ArrayList<Integer>();
                this.ansiIndex.put(n4, list);
            }
            list.add(n3);
        }
    }

    public boolean readFont(FontFileReader fontFileReader, String string, String string2) throws IOException {
        this.initializeFont(fontFileReader);
        if (!this.checkTTC(string, string2)) {
            if (string2 == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + string2);
        }
        this.initializeFontAfterTTCSeek(fontFileReader);
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Number of glyphs in font: " + this.numberOfGlyphs));
        }
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.initAnsiWidths();
        this.readPostScript();
        this.readOS2();
        this.determineAscDesc();
        this.readSVG();
        this.readName();
        boolean bl = this.readPCLT();
        boolean bl2 = this.readCMAP();
        if (!bl2) {
            return false;
        }
        this.createCMaps();
        this.updateBBoxAndOffset();
        if (this.useKerning) {
            this.readKerning();
        }
        this.handleCharacterSpacing(fontFileReader);
        this.guessVerticalMetricsFromGlyphBBox();
        return true;
    }

    public void readFont(FontFileReader fontFileReader, String string, MultiByteFont multiByteFont) throws IOException {
        this.readFont(fontFileReader, string, multiByteFont.getTTCName());
    }

    protected abstract void updateBBoxAndOffset() throws IOException;

    protected abstract void readName() throws IOException;

    protected abstract void initializeFont(FontFileReader var1) throws IOException;

    protected void initializeFontAfterTTCSeek(FontFileReader fontFileReader) throws IOException {
    }

    protected void handleCharacterSpacing(FontFileReader fontFileReader) throws IOException {
        if (this.useAdvanced) {
            try {
                OTFAdvancedTypographicTableReader oTFAdvancedTypographicTableReader = new OTFAdvancedTypographicTableReader(this, fontFileReader);
                oTFAdvancedTypographicTableReader.readAll();
                this.advancedTableReader = oTFAdvancedTypographicTableReader;
            }
            catch (AdvancedTypographicTableFormatException advancedTypographicTableFormatException) {
                this.log.warn((Object)("Encountered format constraint violation in advanced (typographic) table (AT) in font '" + this.getFullName() + "', ignoring AT data: " + advancedTypographicTableFormatException.getMessage()));
            }
        }
    }

    protected void createCMaps() {
        int n2;
        UnicodeMapping unicodeMapping;
        this.cmaps = new ArrayList<CMapSegment>();
        if (this.unicodeMappings.isEmpty()) {
            return;
        }
        Iterator<UnicodeMapping> iterator = this.unicodeMappings.iterator();
        UnicodeMapping unicodeMapping2 = unicodeMapping = iterator.next();
        int n3 = unicodeMapping.getUnicodeIndex();
        int n4 = unicodeMapping.getGlyphIndex();
        while (iterator.hasNext()) {
            unicodeMapping = iterator.next();
            if (unicodeMapping2.getUnicodeIndex() + 1 != unicodeMapping.getUnicodeIndex() || unicodeMapping2.getGlyphIndex() + 1 != unicodeMapping.getGlyphIndex()) {
                n2 = unicodeMapping2.getUnicodeIndex();
                this.cmaps.add(new CMapSegment(n3, n2, n4));
                n3 = unicodeMapping.getUnicodeIndex();
                n4 = unicodeMapping.getGlyphIndex();
            }
            unicodeMapping2 = unicodeMapping;
        }
        n2 = unicodeMapping2.getUnicodeIndex();
        this.cmaps.add(new CMapSegment(n3, n2, n4));
    }

    public String getPostScriptName() {
        if (this.postScriptName.length() == 0) {
            return FontUtil.stripWhiteSpace((String)this.getFullName());
        }
        return this.postScriptName;
    }

    PostScriptVersion getPostScriptVersion() {
        return this.postScriptVersion;
    }

    public Set<String> getFamilyNames() {
        return this.familyNames;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCharSetName() {
        return ENCODING;
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    protected int getPadSize(int n2) {
        int n3 = 4 - n2 % 4;
        return n3 < 4 ? n3 : 0;
    }

    public int getFlags() {
        int n2 = 32;
        if (this.italicAngle != 0L) {
            n2 |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n2 |= 2;
        }
        if (this.hasSerifs) {
            n2 |= 1;
        }
        return n2;
    }

    public int getWeightClass() {
        return this.usWeightClass;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String string = Short.toString((short)(this.italicAngle / 65536L));
        return string;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return nArray;
    }

    public int[] getBBoxRaw() {
        int[] nArray = new int[]{this.fontBBox1, this.fontBBox2, this.fontBBox3, this.fontBBox4};
        return nArray;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return 0;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.mtxTab.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.convertTTFUnit2PDFUnit(this.mtxTab[i2].getWx());
        }
        return nArray;
    }

    public Rectangle[] getBoundingBoxes() {
        Rectangle[] rectangleArray = new Rectangle[this.mtxTab.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            int[] nArray = this.mtxTab[i2].getBoundingBox();
            rectangleArray[i2] = new Rectangle(this.convertTTFUnit2PDFUnit(nArray[0]), this.convertTTFUnit2PDFUnit(nArray[1]), this.convertTTFUnit2PDFUnit(nArray[2] - nArray[0]), this.convertTTFUnit2PDFUnit(nArray[3] - nArray[1]));
        }
        return rectangleArray;
    }

    public int[] getBBox(int n2) {
        int[] nArray = new int[4];
        if (n2 < this.mtxTab.length) {
            int[] nArray2 = this.mtxTab[n2].getBoundingBox();
            for (int i2 = 0; i2 < 4; ++i2) {
                nArray[i2] = this.convertTTFUnit2PDFUnit(nArray2[i2]);
            }
        }
        return nArray;
    }

    public int getCharWidth(int n2) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[n2]);
    }

    public int getCharWidthRaw(int n2) {
        if (this.ansiWidth != null) {
            return this.ansiWidth[n2];
        }
        return -1;
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        return this.kerningTab;
    }

    public Map<Integer, Map<Integer, Integer>> getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public int getUnderlinePosition() {
        return this.convertTTFUnit2PDFUnit(this.underlinePosition);
    }

    public int getUnderlineThickness() {
        return this.convertTTFUnit2PDFUnit(this.underlineThickness);
    }

    public int getStrikeoutPosition() {
        return this.convertTTFUnit2PDFUnit(this.strikeoutPosition);
    }

    public int getStrikeoutThickness() {
        return this.convertTTFUnit2PDFUnit(this.strikeoutThickness);
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isCFF() {
        return this.isCFF;
    }

    protected void readDirTabs() throws IOException {
        int n2 = this.fontFile.readTTFLong();
        switch (n2) {
            case 65536: {
                this.log.debug((Object)"sfnt version: OpenType 1.0");
                break;
            }
            case 0x4F54544F: {
                this.isCFF = true;
                this.log.debug((Object)"sfnt version: OpenType with CFF data");
                break;
            }
            case 1953658213: {
                this.log.debug((Object)"sfnt version: Apple TrueType");
                break;
            }
            case 1954115633: {
                this.log.debug((Object)"sfnt version: Apple Type 1 housed in sfnt wrapper");
                break;
            }
            default: {
                this.log.debug((Object)("Unknown sfnt version: " + Integer.toHexString(n2)));
            }
        }
        int n3 = this.fontFile.readTTFUShort();
        this.fontFile.skip(6L);
        this.dirTabs = new HashMap<OFTableName, OFDirTabEntry>();
        OFDirTabEntry[] oFDirTabEntryArray = new OFDirTabEntry[n3];
        this.log.debug((Object)("Reading " + n3 + " dir tables"));
        for (int i2 = 0; i2 < n3; ++i2) {
            oFDirTabEntryArray[i2] = new OFDirTabEntry();
            String string = oFDirTabEntryArray[i2].read(this.fontFile);
            this.dirTabs.put(OFTableName.getValue((String)string), oFDirTabEntryArray[i2]);
        }
        this.dirTabs.put(OFTableName.TABLE_DIRECTORY, new OFDirTabEntry(0L, (long)this.fontFile.getCurrentPos()));
        this.log.debug((Object)("dir tables: " + this.dirTabs.keySet()));
    }

    protected void readFontHeader() throws IOException {
        this.seekTab(this.fontFile, OFTableName.HEAD, 16L);
        int n2 = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("flags: " + n2 + " - " + Integer.toString(n2, 2)));
        }
        this.upem = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unit per em: " + this.upem));
        }
        this.fontFile.skip(16L);
        this.fontBBox1 = this.fontFile.readTTFShort();
        this.fontBBox2 = this.fontFile.readTTFShort();
        this.fontBBox3 = this.fontFile.readTTFShort();
        this.fontBBox4 = this.fontFile.readTTFShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("font bbox: xMin=" + this.fontBBox1 + " yMin=" + this.fontBBox2 + " xMax=" + this.fontBBox3 + " yMax=" + this.fontBBox4));
        }
        this.fontFile.skip(6L);
        this.locaFormat = this.fontFile.readTTFShort();
    }

    protected void getNumGlyphs() throws IOException {
        this.seekTab(this.fontFile, OFTableName.MAXP, 4L);
        this.numberOfGlyphs = this.fontFile.readTTFUShort();
    }

    protected void readHorizontalHeader() throws IOException {
        this.seekTab(this.fontFile, OFTableName.HHEA, 4L);
        this.hheaAscender = this.fontFile.readTTFShort();
        this.hheaDescender = this.fontFile.readTTFShort();
        this.fontFile.skip(26L);
        this.nhmtx = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("hhea.Ascender: " + this.formatUnitsForDebug(this.hheaAscender)));
            this.log.debug((Object)("hhea.Descender: " + this.formatUnitsForDebug(this.hheaDescender)));
            this.log.debug((Object)("Number of horizontal metrics: " + this.nhmtx));
        }
    }

    private void readSVG() throws IOException {
        OFDirTabEntry oFDirTabEntry = this.dirTabs.get(OFTableName.SVG);
        if (oFDirTabEntry != null) {
            this.svgs = new LinkedHashMap<Integer, SVGGlyphData>();
            this.fontFile.seekSet(oFDirTabEntry.getOffset());
            this.fontFile.readTTFUShort();
            this.fontFile.readTTFULong();
            this.fontFile.readTTFULong();
            int n2 = this.fontFile.readTTFUShort();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.fontFile.readTTFUShort();
                this.fontFile.readTTFUShort();
                SVGGlyphData sVGGlyphData = new SVGGlyphData();
                sVGGlyphData.svgDocOffset = this.fontFile.readTTFULong();
                sVGGlyphData.svgDocLength = this.fontFile.readTTFULong();
                this.svgs.put(n3, sVGGlyphData);
            }
            for (SVGGlyphData sVGGlyphData : this.svgs.values()) {
                this.seekTab(this.fontFile, OFTableName.SVG, sVGGlyphData.svgDocOffset);
                this.fontFile.readTTFUShort();
                this.fontFile.readTTFULong();
                this.fontFile.readTTFULong();
                sVGGlyphData.setSVG(this.fontFile.readTTFString((int)sVGGlyphData.svgDocLength));
            }
        }
    }

    protected void readHorizontalMetrics() throws IOException {
        int n2;
        this.seekTab(this.fontFile, OFTableName.HMTX, 0L);
        int n3 = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new OFMtxEntry[n3];
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"*** Widths array: \n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.mtxTab[n2] = new OFMtxEntry();
        }
        for (n2 = 0; n2 < this.nhmtx; ++n2) {
            this.mtxTab[n2].setWx(this.fontFile.readTTFUShort());
            this.mtxTab[n2].setLsb(this.fontFile.readTTFUShort());
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("   width[" + n2 + "] = " + this.convertTTFUnit2PDFUnit(this.mtxTab[n2].getWx()) + ";"));
        }
        if (this.cid && this.nhmtx < n3) {
            n2 = this.mtxTab[this.nhmtx - 1].getWx();
            for (int i2 = this.nhmtx; i2 < n3; ++i2) {
                this.mtxTab[i2].setWx(n2);
                this.mtxTab[i2].setLsb(this.fontFile.readTTFUShort());
            }
        }
    }

    protected void readPostScript() throws IOException {
        this.seekTab(this.fontFile, OFTableName.POST, 0L);
        int n2 = this.fontFile.readTTFLong();
        this.italicAngle = this.fontFile.readTTFULong();
        this.underlinePosition = this.fontFile.readTTFShort();
        this.underlineThickness = this.fontFile.readTTFShort();
        this.isFixedPitch = this.fontFile.readTTFULong();
        this.fontFile.skip(16L);
        this.log.debug((Object)("PostScript format: 0x" + Integer.toHexString(n2)));
        switch (n2) {
            case 65536: {
                this.log.debug((Object)"PostScript format 1");
                this.postScriptVersion = PostScriptVersion.V1;
                for (int i2 = 0; i2 < MAC_GLYPH_ORDERING.length; ++i2) {
                    this.mtxTab[i2].setName(MAC_GLYPH_ORDERING[i2]);
                }
                break;
            }
            case 131072: {
                int n3;
                this.log.debug((Object)"PostScript format 2");
                this.postScriptVersion = PostScriptVersion.V2;
                int n4 = 257;
                int n5 = this.fontFile.readTTFUShort();
                for (int i3 = 0; i3 < n5; ++i3) {
                    this.mtxTab[i3].setIndex(this.fontFile.readTTFUShort());
                    if (this.mtxTab[i3].getIndex() > n4 && this.mtxTab[i3].getIndex() <= Short.MAX_VALUE) {
                        n4 = this.mtxTab[i3].getIndex();
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("PostScript index: " + this.mtxTab[i3].getIndexAsString()));
                }
                String[] stringArray = new String[n4 - 257];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reading " + n4 + " glyphnames, that are not in the standard Macintosh set. Total number of glyphs=" + n5));
                }
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = this.fontFile.readTTFString(this.fontFile.readTTFUByte());
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    if (this.mtxTab[n3].getIndex() < MAC_GLYPH_ORDERING.length) {
                        this.mtxTab[n3].setName(MAC_GLYPH_ORDERING[this.mtxTab[n3].getIndex()]);
                        continue;
                    }
                    if (this.mtxTab[n3].isIndexReserved()) continue;
                    int n6 = this.mtxTab[n3].getIndex() - MAC_GLYPH_ORDERING.length;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(n6 + " i=" + n3 + " mtx=" + this.mtxTab.length + " ps=" + stringArray.length));
                    }
                    this.mtxTab[n3].setName(stringArray[n6]);
                }
                break;
            }
            case 196608: {
                this.log.debug((Object)"PostScript format 3");
                this.postScriptVersion = PostScriptVersion.V3;
                break;
            }
            default: {
                this.log.error((Object)("Unknown PostScript format: " + n2));
                this.postScriptVersion = PostScriptVersion.UNKNOWN;
            }
        }
    }

    protected void readOS2() throws IOException {
        OFDirTabEntry oFDirTabEntry = this.dirTabs.get(OFTableName.OS2);
        if (oFDirTabEntry != null) {
            this.seekTab(this.fontFile, OFTableName.OS2, 0L);
            int n2 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("OS/2 table: version=" + n2 + ", offset=" + oFDirTabEntry.getOffset() + ", len=" + oFDirTabEntry.getLength()));
            }
            this.fontFile.skip(2L);
            this.usWeightClass = this.fontFile.readTTFUShort();
            this.fontFile.skip(2L);
            int n3 = this.fontFile.readTTFUShort();
            this.isEmbeddable = n3 != 2;
            this.fontFile.skip(16L);
            this.strikeoutThickness = this.fontFile.readTTFShort();
            this.strikeoutPosition = this.fontFile.readTTFShort();
            this.fontFile.skip(2L);
            this.fontFile.skip(10L);
            this.fontFile.skip(16L);
            this.fontFile.skip(4L);
            this.fontFile.skip(6L);
            this.os2Ascender = this.fontFile.readTTFShort();
            this.os2Descender = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoAscender: " + this.os2Ascender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Ascender)));
                this.log.debug((Object)("sTypoDescender: " + this.os2Descender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Descender)));
            }
            int n4 = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoLineGap: " + n4));
            }
            n4 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinAscent: " + this.formatUnitsForDebug(n4)));
            }
            n4 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinDescent: " + this.formatUnitsForDebug(n4)));
            }
            if (oFDirTabEntry.getLength() >= 90L) {
                this.fontFile.skip(8L);
                this.os2xHeight = this.fontFile.readTTFShort();
                this.os2CapHeight = this.fontFile.readTTFShort();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sxHeight: " + this.os2xHeight));
                    this.log.debug((Object)("sCapHeight: " + this.os2CapHeight));
                }
            }
        } else {
            this.isEmbeddable = true;
        }
    }

    protected boolean readPCLT() throws IOException {
        OFDirTabEntry oFDirTabEntry = this.dirTabs.get(OFTableName.PCLT);
        if (oFDirTabEntry != null) {
            this.fontFile.seekSet(oFDirTabEntry.getOffset() + 4L + 4L + 2L);
            this.xHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("xHeight from PCLT: " + this.formatUnitsForDebug(this.xHeight)));
            this.fontFile.skip(4L);
            this.capHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("capHeight from PCLT: " + this.formatUnitsForDebug(this.capHeight)));
            this.fontFile.skip(34L);
            int n2 = this.fontFile.readTTFUByte();
            n2 >>= 6;
            this.hasSerifs = (n2 &= 3) != 1;
            return true;
        }
        return false;
    }

    protected void determineAscDesc() {
        int n2 = this.hheaAscender - this.hheaDescender;
        int n3 = this.os2Ascender - this.os2Descender;
        if (this.os2Ascender > 0 && n3 <= this.upem) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else if (this.hheaAscender > 0 && n2 <= this.upem) {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        } else if (this.os2Ascender > 0) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Font box height: " + (this.ascender - this.descender)));
            if (this.ascender - this.descender > this.upem) {
                this.log.debug((Object)"Ascender and descender together are larger than the em box.");
            }
        }
    }

    protected void guessVerticalMetricsFromGlyphBBox() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (OFMtxEntry oFMtxEntry : this.mtxTab) {
            if ("H".equals(oFMtxEntry.getName())) {
                n2 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if ("x".equals(oFMtxEntry.getName())) {
                n3 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if ("d".equals(oFMtxEntry.getName())) {
                n4 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if ("p".equals(oFMtxEntry.getName())) {
                n5 = oFMtxEntry.getBoundingBox()[1];
                continue;
            }
            List list = oFMtxEntry.getUnicodeIndex();
            if (list.size() <= 0) continue;
            char c2 = (char)((Integer)list.get(0)).intValue();
            if (c2 == 'H') {
                n2 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if (c2 == 'x') {
                n3 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if (c2 == 'd') {
                n4 = oFMtxEntry.getBoundingBox()[3];
                continue;
            }
            if (c2 != 'p') continue;
            n5 = oFMtxEntry.getBoundingBox()[1];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ascender from glyph 'd': " + this.formatUnitsForDebug(n4)));
            this.log.debug((Object)("Descender from glyph 'p': " + this.formatUnitsForDebug(n5)));
        }
        if (this.ascender - this.descender > this.upem) {
            this.log.debug((Object)"Replacing specified ascender/descender with derived values to get values which fit in the em box.");
            this.ascender = n4;
            this.descender = n5;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("xHeight from glyph 'x': " + this.formatUnitsForDebug(n3)));
            this.log.debug((Object)("CapHeight from glyph 'H': " + this.formatUnitsForDebug(n2)));
        }
        if (this.capHeight == 0) {
            this.capHeight = n2;
            if (this.capHeight == 0) {
                this.capHeight = this.os2CapHeight;
            }
            if (this.capHeight == 0) {
                this.log.debug((Object)"capHeight value could not be determined. The font may not work as expected.");
            }
        }
        if (this.xHeight == 0) {
            this.xHeight = n3;
            if (this.xHeight == 0) {
                this.xHeight = this.os2xHeight;
            }
            if (this.xHeight == 0) {
                this.log.debug((Object)"xHeight value could not be determined. The font may not work as expected.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readKerning() throws IOException {
        this.kerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        this.ansiKerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        OFDirTabEntry oFDirTabEntry = this.dirTabs.get(OFTableName.KERN);
        if (oFDirTabEntry != null) {
            Object object;
            this.seekTab(this.fontFile, OFTableName.KERN, 2L);
            for (int i2 = this.fontFile.readTTFUShort(); i2 > 0; --i2) {
                this.fontFile.skip(4L);
                int n2 = this.fontFile.readTTFUShort();
                if ((n2 & 1) == 0 || (n2 & 2) != 0 || (n2 & 4) != 0) {
                    return;
                }
                if (n2 >> 8 != 0) continue;
                n2 = this.fontFile.readTTFUShort();
                this.fontFile.skip(6L);
                while (n2-- > 0) {
                    void map;
                    int n3 = this.fontFile.readTTFUShort();
                    int n4 = this.fontFile.readTTFUShort();
                    short s2 = this.fontFile.readTTFShort();
                    if (s2 == 0) continue;
                    object = this.glyphToUnicode(n3);
                    Integer n5 = this.glyphToUnicode(n4);
                    if (object == null) {
                        this.log.debug((Object)("Ignoring kerning pair because no Unicode index was found for the first glyph " + n3));
                        continue;
                    }
                    if (n5 == null) {
                        this.log.debug((Object)("Ignoring kerning pair because Unicode index was found for the second glyph " + n3));
                        continue;
                    }
                    Map<Integer, Integer> map2 = this.kerningTab.get(object);
                    if (map2 == null) {
                        HashMap hashMap = new HashMap();
                    }
                    map.put(n5, this.convertTTFUnit2PDFUnit(s2));
                    this.kerningTab.put((Integer)object, (Map<Integer, Integer>)map);
                }
            }
            for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.kerningTab.entrySet()) {
                Integer[] integerArray;
                Integer n2;
                Integer n7 = entry.getKey();
                Integer n8 = this.unicodeToGlyph(n7);
                HashMap<Integer, Integer[]> hashMap = new HashMap<Integer, Integer[]>();
                object = entry.getValue();
                for (Map.Entry<Integer, Integer> entry2 : object.entrySet()) {
                    n2 = entry2.getKey();
                    integerArray = this.unicodeToGlyph(n2);
                    Integer[] integerArray2 = entry2.getValue();
                    for (Object e2 : this.mtxTab[integerArray.intValue()].getUnicodeIndex()) {
                        Integer[] integerArray3;
                        Integer n3 = (Integer)e2;
                        for (Integer n4 : integerArray3 = this.unicodeToWinAnsi(n3)) {
                            hashMap.put(n4, integerArray2);
                        }
                    }
                }
                if (hashMap.size() <= 0) continue;
                for (Map.Entry<Integer, Integer> entry3 : this.mtxTab[n8].getUnicodeIndex()) {
                    n2 = (Integer)((Object)entry3);
                    for (Integer n3 : integerArray = this.unicodeToWinAnsi(n2)) {
                        this.ansiKerningTab.put(n3, hashMap);
                    }
                }
            }
        }
    }

    public void stream(TTFOutputStream tTFOutputStream) throws IOException {
        SortedSet<Map.Entry<OFTableName, OFDirTabEntry>> sortedSet = this.sortDirTabMap(this.dirTabs);
        byte[] byArray = this.fontFile.getAllBytes();
        TTFTableOutputStream tTFTableOutputStream = tTFOutputStream.getTableOutputStream();
        TTFGlyphOutputStream tTFGlyphOutputStream = tTFOutputStream.getGlyphOutputStream();
        tTFOutputStream.startFontStream();
        for (Map.Entry entry : sortedSet) {
            int n2 = (int)((OFDirTabEntry)entry.getValue()).getOffset();
            int n3 = (int)((OFDirTabEntry)entry.getValue()).getLength();
            n3 += this.getPadSize(n2 + n3);
            if (((OFTableName)entry.getKey()).equals((Object)OFTableName.GLYF)) {
                this.streamGlyf(tTFGlyphOutputStream, byArray, n2, n3);
                continue;
            }
            tTFTableOutputStream.streamTable(byArray, n2, n3);
        }
        tTFOutputStream.endFontStream();
    }

    private void streamGlyf(TTFGlyphOutputStream tTFGlyphOutputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        tTFGlyphOutputStream.startGlyphStream();
        for (int i2 = 0; i2 < this.mtxTab.length - 1; ++i2) {
            n4 = (int)this.mtxTab[i2].getOffset() + n2;
            n5 = (int)this.mtxTab[i2 + 1].getOffset() + n2;
            tTFGlyphOutputStream.streamGlyph(byArray, n4, n5 - n4);
        }
        tTFGlyphOutputStream.streamGlyph(byArray, n5, n2 + n3 - n5);
        tTFGlyphOutputStream.endGlyphStream();
    }

    SortedSet<Map.Entry<OFTableName, OFDirTabEntry>> sortDirTabMap(Map<OFTableName, OFDirTabEntry> map) {
        TreeSet<Map.Entry<OFTableName, OFDirTabEntry>> treeSet = new TreeSet<Map.Entry<OFTableName, OFDirTabEntry>>(new Comparator<Map.Entry<OFTableName, OFDirTabEntry>>(){

            @Override
            public int compare(Map.Entry<OFTableName, OFDirTabEntry> entry, Map.Entry<OFTableName, OFDirTabEntry> entry2) {
                return (int)(entry.getValue().getOffset() - entry2.getValue().getOffset());
            }
        });
        treeSet.addAll(map.entrySet());
        return treeSet;
    }

    public List<CMapSegment> getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(String string, String string2) throws IOException {
        if ("ttcf".equals(string)) {
            int n2;
            this.fontFile.skip(4L);
            int n3 = (int)this.fontFile.readTTFULong();
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = this.fontFile.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + n3 + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            n2 = 0;
            long l2 = 0L;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.fontFile.seekSet(lArray[i2]);
                this.readDirTabs();
                this.readName();
                if (this.fullName.equals(string2)) {
                    n2 = 1;
                    l2 = lArray[i2];
                    this.log.info((Object)(this.fullName + " <-- selected"));
                } else {
                    this.log.info((Object)this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            this.fontFile.seekSet(l2);
            return n2 != 0;
        }
        this.fontFile.seekSet(0L);
        return true;
    }

    public final List<String> getTTCnames(FontFileReader fontFileReader) throws IOException {
        this.fontFile = fontFileReader;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string)) {
            int n2;
            fontFileReader.skip(4L);
            int n3 = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = fontFileReader.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + n3 + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            for (n2 = 0; n2 < n3; ++n2) {
                fontFileReader.seekSet(lArray[n2]);
                this.readDirTabs();
                this.readName();
                this.log.info((Object)this.fullName);
                arrayList.add(this.fullName);
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            fontFileReader.seekSet(0L);
            return arrayList;
        }
        this.log.error((Object)"Not a TTC!");
        return null;
    }

    private Integer[] unicodeToWinAnsi(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 32; i2 < Glyphs.WINANSI_ENCODING.length; ++i2) {
            if (n2 != Glyphs.WINANSI_ENCODING[i2]) continue;
            arrayList.add(i2);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.postScriptName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyNames);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int n2 = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + n2);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    private String formatUnitsForDebug(int n2) {
        return n2 + " -> " + this.convertTTFUnit2PDFUnit(n2) + " internal units";
    }

    private Integer glyphToUnicode(int n2) {
        return this.glyphToUnicodeMap.get(n2);
    }

    private Integer unicodeToGlyph(int n2) throws IOException {
        Integer n3 = this.unicodeToGlyphMap.get(n2);
        if (n3 == null) {
            throw new IOException("Glyph index not found for unicode value " + n2);
        }
        return n3;
    }

    String getGlyphName(int n2) {
        return this.mtxTab[n2].getName();
    }

    public boolean hasAdvancedTable() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.hasAdvancedTable();
        }
        return false;
    }

    public GlyphDefinitionTable getGDEF() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGDEF();
        }
        return null;
    }

    public GlyphSubstitutionTable getGSUB() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGSUB();
        }
        return null;
    }

    public GlyphPositioningTable getGPOS() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGPOS();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        FileInputStream fileInputStream = null;
        try {
            String string;
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = true;
            fileInputStream = new FileInputStream(stringArray[0]);
            FontFileReader fontFileReader = new FontFileReader((InputStream)fileInputStream);
            String string2 = null;
            if (stringArray.length >= 2) {
                string2 = stringArray[1];
            }
            OTFFile oTFFile = (bl = (string = OFFontLoader.readHeader(fontFileReader)).equals("OTTO")) ? new OTFFile() : new TTFFile(bl2, bl3);
            oTFFile.readFont(fontFileReader, string, string2);
            oTFFile.printStuff();
        }
        catch (IOException iOException) {
            try {
                System.err.println("Problem reading font: " + iOException.toString());
                iOException.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    public String getEmbedFontName() {
        return this.embedFontName;
    }

    public String getCopyrightNotice() {
        return this.notice;
    }

    static final class UnicodeMapping
    implements Comparable {
        private final int unicodeIndex;
        private final int glyphIndex;

        UnicodeMapping(OpenFont openFont, int n2, int n3) {
            this.unicodeIndex = n3;
            this.glyphIndex = n2;
            openFont.glyphToUnicodeMap.put(n2, n3);
            openFont.unicodeToGlyphMap.put(n3, n2);
        }

        public int getGlyphIndex() {
            return this.glyphIndex;
        }

        public int getUnicodeIndex() {
            return this.unicodeIndex;
        }

        public int hashCode() {
            int n2 = this.unicodeIndex;
            n2 = 19 * n2 + (n2 ^ this.glyphIndex);
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof UnicodeMapping) {
                UnicodeMapping unicodeMapping = (UnicodeMapping)object;
                if (this.unicodeIndex != unicodeMapping.unicodeIndex) {
                    return false;
                }
                return this.glyphIndex == unicodeMapping.glyphIndex;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof UnicodeMapping) {
                UnicodeMapping unicodeMapping = (UnicodeMapping)object;
                if (this.unicodeIndex > unicodeMapping.unicodeIndex) {
                    return 1;
                }
                if (this.unicodeIndex < unicodeMapping.unicodeIndex) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }

    public static enum PostScriptVersion {
        V1,
        V2,
        V3,
        UNKNOWN;

    }
}

