/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.awt.Rectangle;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.CharNormalize;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CIDFull;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.truetype.SVGGlyphData;
import org.apache.fop.util.CharUtilities;

public class MultiByteFont
extends CIDFont
implements Substitutable,
Positionable {
    private static final Log log = LogFactory.getLog(MultiByteFont.class);
    private String ttcName;
    private String encoding = "Identity-H";
    private int defaultWidth;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    protected final CIDSet cidSet;
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private int numMapped;
    private int numUnmapped;
    private int nextPrivateUse = 57344;
    private int firstPrivate;
    private int lastPrivate;
    private int firstUnmapped;
    private int lastUnmapped;
    protected Rectangle[] boundingBoxes;
    private boolean isOTFFile;
    private static final int NUM_MOST_LIKELY_GLYPHS = 256;
    private int[] mostLikelyGlyphs = new int[256];
    private LinkedHashMap<Integer, String> usedGlyphNames = new LinkedHashMap();
    private Map<Character, CharSequence> substToOriginal = new HashMap<Character, CharSequence>();

    public MultiByteFont(InternalResourceResolver internalResourceResolver, EmbeddingMode embeddingMode) {
        super(internalResourceResolver);
        this.setFontType(FontType.TYPE0);
        this.setEmbeddingMode(embeddingMode);
        this.cidSet = embeddingMode != EmbeddingMode.FULL ? new CIDSubset(this) : new CIDFull(this);
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public String getRegistry() {
        return "Adobe";
    }

    public String getOrdering() {
        return "UCS";
    }

    public int getSupplement() {
        return 0;
    }

    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setIsOTFFile(boolean bl) {
        this.isOTFFile = bl;
    }

    public boolean isOTFFile() {
        return this.isOTFFile;
    }

    public void setCIDType(CIDFontType cIDFontType) {
        this.cidType = cIDFontType;
    }

    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return FontUtil.stripWhiteSpace((String)super.getFontName());
        }
        return super.getFontName();
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileURI() != null || this.getEmbedResourceName() != null;
    }

    public boolean isSubsetEmbedded() {
        return this.getEmbeddingMode() != EmbeddingMode.FULL;
    }

    public CIDSet getCIDSet() {
        return this.cidSet;
    }

    public void mapUsedGlyphName(int n2, String string) {
        this.usedGlyphNames.put(n2, string);
    }

    public LinkedHashMap<Integer, String> getUsedGlyphNames() {
        return this.usedGlyphNames;
    }

    public String getEncodingName() {
        return this.encoding;
    }

    public int getWidth(int n2, int n3) {
        if (this.isEmbeddable()) {
            int n4 = this.cidSet.getOriginalGlyphIndex(n2);
            return n3 * this.width[n4];
        }
        return n3 * this.width[n2];
    }

    public int[] getWidths() {
        int[] nArray = new int[this.width.length];
        System.arraycopy(this.width, 0, nArray, 0, this.width.length);
        return nArray;
    }

    public Rectangle getBoundingBox(int n2, int n3) {
        int n4 = this.isEmbeddable() ? this.cidSet.getOriginalGlyphIndex(n2) : n2;
        Rectangle rectangle = this.boundingBoxes[n4];
        return new Rectangle(rectangle.x * n3, rectangle.y * n3, rectangle.width * n3, rectangle.height * n3);
    }

    public int findGlyphIndex(int n2) {
        int n3 = n2;
        int n4 = 0;
        if (n3 < 256 && this.mostLikelyGlyphs[n3] != 0) {
            return this.mostLikelyGlyphs[n3];
        }
        for (CMapSegment cMapSegment : this.cmap) {
            if (n4 != 0 || cMapSegment.getUnicodeStart() > n3 || cMapSegment.getUnicodeEnd() < n3) continue;
            n4 = cMapSegment.getGlyphStartIndex() + n3 - cMapSegment.getUnicodeStart();
            if (n3 < 256) {
                this.mostLikelyGlyphs[n3] = n4;
            }
            if (n4 == 0) continue;
            break;
        }
        return n4;
    }

    protected synchronized void addPrivateUseMapping(int n2, int n3) {
        assert (this.findGlyphIndex(n2) == 0);
        this.cmap.add(new CMapSegment(n2, n2, n3));
    }

    private int createPrivateUseMapping(int n2) {
        while (this.nextPrivateUse < 63744 && this.findGlyphIndex(this.nextPrivateUse) != 0) {
            ++this.nextPrivateUse;
        }
        if (this.nextPrivateUse < 63744) {
            int n3 = this.nextPrivateUse;
            this.addPrivateUseMapping(n3, n2);
            if (this.firstPrivate == 0) {
                this.firstPrivate = n3;
            }
            this.lastPrivate = n3;
            ++this.numMapped;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create private use mapping from " + CharUtilities.format((int)n3) + " to glyph index " + n2 + " in font '" + this.getFullName() + "'"));
            }
            return n3;
        }
        if (this.firstUnmapped == 0) {
            this.firstUnmapped = n2;
        }
        this.lastUnmapped = n2;
        ++this.numUnmapped;
        log.warn((Object)("Exhausted private use area: unable to map " + this.numUnmapped + " glyphs in glyph index range [" + this.firstUnmapped + "," + this.lastUnmapped + "] (inclusive) of font '" + this.getFullName() + "'"));
        return 0;
    }

    private int findCharacterFromGlyphIndex(int n2, boolean bl) {
        int n3 = 0;
        for (CMapSegment cMapSegment : this.cmap) {
            int n4 = cMapSegment.getGlyphStartIndex();
            int n5 = n4 + (cMapSegment.getUnicodeEnd() - cMapSegment.getUnicodeStart());
            if (n2 < n4 || n2 > n5) continue;
            n3 = cMapSegment.getUnicodeStart() + (n2 - n4);
            break;
        }
        if (n3 == 0 && bl) {
            n3 = this.createPrivateUseMapping(n2);
        }
        return n3;
    }

    private int findCharacterFromGlyphIndex(int n2) {
        return this.findCharacterFromGlyphIndex(n2, true);
    }

    protected BitSet getGlyphIndices() {
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        bitSet.set(1);
        bitSet.set(2);
        for (CMapSegment cMapSegment : this.cmap) {
            int n2 = cMapSegment.getUnicodeStart();
            int n3 = cMapSegment.getUnicodeEnd();
            int n4 = cMapSegment.getGlyphStartIndex();
            while (n2++ < n3 + 1) {
                bitSet.set(n4++);
            }
        }
        return bitSet;
    }

    protected char[] getChars() {
        char[] cArray = new char[this.width.length];
        for (CMapSegment cMapSegment : this.cmap) {
            int n2 = cMapSegment.getUnicodeStart();
            int n3 = cMapSegment.getUnicodeEnd();
            int n4 = cMapSegment.getGlyphStartIndex();
            while (n2 < n3 + 1) {
                cArray[n4++] = (char)n2++;
            }
        }
        return cArray;
    }

    public char mapChar(char c2) {
        this.notifyMapOperation();
        int n2 = this.findGlyphIndex(c2);
        if (n2 == 0) {
            this.warnMissingGlyph(c2);
            if (!this.isOTFFile) {
                n2 = this.findGlyphIndex(35);
            }
        }
        if (this.isEmbeddable()) {
            n2 = this.cidSet.mapChar(n2, c2);
        }
        if (this.isCID() && n2 > 256) {
            this.mapUnencodedChar(c2);
        }
        return (char)n2;
    }

    public int mapCodePoint(int n2) {
        this.notifyMapOperation();
        int n3 = this.findGlyphIndex(n2);
        if (n3 == 0) {
            for (char c2 : Character.toChars(n2)) {
                this.warnMissingGlyph(c2);
            }
            if (!this.isOTFFile) {
                n3 = this.findGlyphIndex(35);
            }
        }
        if (this.isEmbeddable()) {
            n3 = this.cidSet.mapCodePoint(n3, n2);
        }
        return (char)n3;
    }

    public boolean hasChar(char c2) {
        return this.hasCodePoint(c2);
    }

    public boolean hasCodePoint(int n2) {
        return this.findGlyphIndex(n2) != 0;
    }

    public void setDefaultWidth(int n2) {
        this.defaultWidth = n2;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String string) {
        this.ttcName = string;
    }

    public void setWidthArray(int[] nArray) {
        this.width = nArray;
    }

    public void setBBoxArray(Rectangle[] rectangleArray) {
        this.boundingBoxes = rectangleArray;
    }

    public Map<Integer, Integer> getUsedGlyphs() {
        return this.cidSet.getGlyphs();
    }

    public char getUnicodeFromGID(int n2) {
        return this.cidSet.getUnicodeFromGID(n2);
    }

    public int getGIDFromChar(char c2) {
        return this.cidSet.getGIDFromChar(c2);
    }

    public void setGDEF(GlyphDefinitionTable glyphDefinitionTable) {
        if (this.gdef != null && glyphDefinitionTable != null) {
            throw new IllegalStateException("font already associated with GDEF table");
        }
        this.gdef = glyphDefinitionTable;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public void setGSUB(GlyphSubstitutionTable glyphSubstitutionTable) {
        if (this.gsub != null && glyphSubstitutionTable != null) {
            throw new IllegalStateException("font already associated with GSUB table");
        }
        this.gsub = glyphSubstitutionTable;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public void setGPOS(GlyphPositioningTable glyphPositioningTable) {
        if (this.gpos != null && glyphPositioningTable != null) {
            throw new IllegalStateException("font already associated with GPOS table");
        }
        this.gpos = glyphPositioningTable;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    public boolean performsSubstitution() {
        return this.gsub != null;
    }

    public CharSequence performSubstitution(CharSequence charSequence, String string, String string2, List list, boolean bl) {
        if (this.gsub != null) {
            charSequence = this.gsub.preProcess(charSequence, string, this, list);
            GlyphSequence glyphSequence = this.charSequenceToGlyphSequence(charSequence, list);
            GlyphSequence glyphSequence2 = this.gsub.substitute(glyphSequence, string, string2);
            if (list != null) {
                list.clear();
                list.addAll(glyphSequence2.getAssociations());
            }
            if (!bl) {
                glyphSequence2 = MultiByteFont.elideControls(glyphSequence2);
            }
            CharSequence charSequence2 = this.mapGlyphsToChars(glyphSequence2);
            if (list != null) {
                int n2 = glyphSequence2.getGlyphs().limit();
                this.saveSubstitutions(charSequence, charSequence2, list, n2);
            }
            return charSequence2;
        }
        return charSequence;
    }

    public Map<Character, CharSequence> getSubstToOriginal() {
        return this.substToOriginal;
    }

    private void saveSubstitutions(CharSequence charSequence, CharSequence charSequence2, List<CharAssociation> list, int n2) {
        int n3 = 0;
        if (charSequence2.length() > 0 && this.isSaveable(list, charSequence.length())) {
            for (CharAssociation charAssociation : list) {
                if (!charAssociation.isDisjoint()) {
                    char c2 = charSequence2.charAt(n3);
                    CharSequence charSequence3 = charSequence.subSequence(charAssociation.getStart(), charAssociation.getEnd());
                    if (charAssociation.getCount() != 1 || charSequence3.charAt(0) != c2) {
                        this.substToOriginal.put(Character.valueOf(c2), charSequence3);
                    }
                } else {
                    log.warn((Object)("Cannot deal with disjoin glyph substitutions for " + charSequence + " -> " + charSequence2 + ", possibly loosing the ability to search for this text or copying it from the PDF reader"));
                }
                if (++n3 < n2) continue;
                break;
            }
        }
    }

    private boolean isSaveable(List<CharAssociation> list, int n2) {
        boolean bl = true;
        int n3 = 0;
        for (CharAssociation charAssociation : list) {
            if (charAssociation.getOffset() != n3) {
                bl = false;
                break;
            }
            n3 += charAssociation.getCount();
        }
        if (n3 != n2) {
            bl = false;
        }
        return bl;
    }

    public GlyphSequence charSequenceToGlyphSequence(CharSequence charSequence, List list) {
        CharSequence charSequence2 = this.normalize(charSequence, list);
        return this.mapCharsToGlyphs(charSequence2, list);
    }

    public CharSequence reorderCombiningMarks(CharSequence charSequence, int[][] nArray, String string, String string2, List list) {
        if (this.gdef != null) {
            GlyphSequence glyphSequence = this.mapCharsToGlyphs(charSequence, list);
            GlyphSequence glyphSequence2 = this.gdef.reorderCombiningMarks(glyphSequence, this.getUnscaledWidths(glyphSequence), nArray, string, string2);
            if (list != null) {
                list.clear();
                list.addAll(glyphSequence2.getAssociations());
            }
            CharSequence charSequence2 = this.mapGlyphsToChars(glyphSequence2);
            return charSequence2;
        }
        return charSequence;
    }

    protected int[] getUnscaledWidths(GlyphSequence glyphSequence) {
        int[] nArray = new int[glyphSequence.getGlyphCount()];
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 >= this.width.length) continue;
            nArray[i2] = this.width[i2];
        }
        return nArray;
    }

    public boolean performsPositioning() {
        return this.gpos != null;
    }

    public int[][] performPositioning(CharSequence charSequence, String string, String string2, int n2) {
        if (this.gpos != null) {
            int[][] nArray;
            GlyphSequence glyphSequence = this.mapCharsToGlyphs(charSequence, null);
            if (this.gpos.position(glyphSequence, string, string2, n2, this.width, nArray = new int[glyphSequence.getGlyphCount()][4])) {
                return this.scaleAdjustments(nArray, n2);
            }
            return null;
        }
        return null;
    }

    public int[][] performPositioning(CharSequence charSequence, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    private int[][] scaleAdjustments(int[][] nArray, int n2) {
        if (nArray != null) {
            for (int[] nArray2 : nArray) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    nArray2[i2] = nArray2[i2] * n2 / 1000;
                }
            }
            return nArray;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlyphSequence mapCharsToGlyphs(CharSequence charSequence, List arrayList) {
        IntBuffer intBuffer = IntBuffer.allocate(charSequence.length());
        IntBuffer intBuffer2 = IntBuffer.allocate(charSequence.length());
        int n2 = this.findGlyphIndex(35);
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = charSequence.charAt(i2);
            if (n4 >= 55296 && n4 < 56320) {
                char c2;
                if (i2 + 1 >= n3) throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at end of sequence");
                int n5 = n4;
                if ((c2 = charSequence.charAt(++i2)) < '\udc00' || c2 >= '\ue000') throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at index " + i2);
                n4 = 65536 + (n5 - 55296 << 10) + (c2 - 56320 << 0);
            } else if (n4 >= 56320 && n4 < 57344) {
                throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated low surrogate at index " + i2);
            }
            this.notifyMapOperation();
            int n6 = this.findGlyphIndex(n4);
            if (n6 == 0) {
                this.warnMissingGlyph((char)n4);
                n6 = n2;
            }
            intBuffer.put(n4);
            intBuffer2.put(n6);
        }
        IntBuffer intBuffer3 = intBuffer;
        ((Buffer)intBuffer3).flip();
        IntBuffer intBuffer4 = intBuffer2;
        ((Buffer)intBuffer4).flip();
        arrayList = arrayList != null && arrayList.size() == charSequence.length() ? new ArrayList(arrayList) : null;
        return new GlyphSequence(intBuffer, intBuffer2, arrayList);
    }

    private CharSequence mapGlyphsToChars(GlyphSequence glyphSequence) {
        int n2;
        int n3 = glyphSequence.getGlyphCount();
        int n4 = 35;
        ArrayList<Character> arrayList = new ArrayList<Character>(glyphSequence.getUTF16CharacterCount());
        int n5 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            n2 = glyphSequence.getGlyph(i2);
            int n6 = this.findCharacterFromGlyphIndex(n2);
            if (n6 == 0 || n6 > 0x10FFFF) {
                n6 = n4;
                log.warn((Object)("Unable to map glyph index " + n2 + " to Unicode scalar in font '" + this.getFullName() + "', substituting missing character '" + (char)n6 + "'"));
            }
            if (n6 > 65535) {
                int n7 = ((n6 -= 65536) >> 10 & 0x3FF) + 55296;
                int n8 = (n6 >> 0 & 0x3FF) + 56320;
                arrayList.add(Character.valueOf((char)n7));
                arrayList.add(Character.valueOf((char)n8));
                continue;
            }
            arrayList.add(Character.valueOf((char)n6));
        }
        CharBuffer charBuffer = CharBuffer.allocate(arrayList.size());
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            n2 = ((Character)object.next()).charValue();
            charBuffer.put((char)n2);
        }
        object = charBuffer;
        ((Buffer)object).flip();
        return charBuffer;
    }

    private CharSequence normalize(CharSequence charSequence, List list) {
        return this.hasDecomposable(charSequence) ? this.decompose(charSequence, list) : charSequence;
    }

    private boolean hasDecomposable(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (!CharNormalize.isDecomposable((int)c2)) continue;
            return true;
        }
        return false;
    }

    private CharSequence decompose(CharSequence charSequence, List list) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        int[] nArray = new int[CharNormalize.maximumDecompositionLength()];
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] nArray2;
            char c2 = charSequence.charAt(i2);
            for (int n3 : nArray2 = CharNormalize.decompose((int)c2, (int[])nArray)) {
                if (n3 <= 0) break;
                stringBuffer.append((char)n3);
            }
        }
        return stringBuffer;
    }

    private static GlyphSequence elideControls(GlyphSequence glyphSequence) {
        if (MultiByteFont.hasElidableControl(glyphSequence)) {
            int[] nArray = glyphSequence.getCharacterArray(false);
            IntBuffer intBuffer = IntBuffer.allocate(glyphSequence.getGlyphCount());
            ArrayList<CharAssociation> arrayList = new ArrayList<CharAssociation>(glyphSequence.getGlyphCount());
            int n2 = glyphSequence.getGlyphCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                int n4;
                CharAssociation charAssociation = glyphSequence.getAssociation(i2);
                int n5 = charAssociation.getEnd();
                for (n4 = charAssociation.getStart(); n4 < n5 && MultiByteFont.isElidableControl(n3 = nArray[n4]); ++n4) {
                }
                if (n4 == n5) continue;
                intBuffer.put(glyphSequence.getGlyph(i2));
                arrayList.add(charAssociation);
            }
            IntBuffer intBuffer2 = intBuffer;
            ((Buffer)intBuffer2).flip();
            return new GlyphSequence(glyphSequence.getCharacters(), intBuffer, arrayList, glyphSequence.getPredications());
        }
        return glyphSequence;
    }

    private static boolean hasElidableControl(GlyphSequence glyphSequence) {
        int[] nArray;
        for (int n2 : nArray = glyphSequence.getCharacterArray(false)) {
            if (!MultiByteFont.isElidableControl(n2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isElidableControl(int n2) {
        if (n2 < 32) {
            return true;
        }
        if (n2 >= 128 && n2 < 160) {
            return true;
        }
        if (n2 >= 8192 && n2 <= 8303) {
            if (n2 >= 8203 && n2 <= 8207) {
                return true;
            }
            if (n2 >= 8232 && n2 <= 8238) {
                return true;
            }
            if (n2 >= 8294) {
                return true;
            }
            return n2 == 8288;
        }
        return false;
    }

    public boolean hasFeature(int n2, String string, String string2, String string3) {
        Object object = n2 == 1 ? this.getGSUB() : (n2 == 2 ? this.getGPOS() : (n2 == 5 ? this.getGDEF() : null));
        return object != null && object.hasFeature(string, string2, string3);
    }

    public Map<Integer, Integer> getWidthsMap() {
        return null;
    }

    public InputStream getCmapStream() {
        return null;
    }

    public SVGGlyphData getSVG(int n2) {
        int n3 = this.findGlyphIndex(n2);
        return (SVGGlyphData)this.svgs.get(n3);
    }
}

