/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontFeatureSettings;
import org.apache.fop.fonts.TextFragment;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.CharUtilities;

public class GlyphMapping {
    private static final Log LOG = LogFactory.getLog(GlyphMapping.class);
    public final int startIndex;
    public final int endIndex;
    private int wordCharLength;
    public final int wordSpaceCount;
    public int letterSpaceCount;
    public MinOptMax areaIPD;
    public final boolean isHyphenated;
    public final boolean isSpace;
    public boolean breakOppAfter;
    public final Font font;
    public final int level;
    public final int[][] gposAdjustments;
    public String mapping;
    public List associations;
    public Character spaceThatFollows;
    private static ThreadLocal<Boolean> enableLatinLigatures = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static ThreadLocal<Boolean> enableLatinGlyphSubstitutions = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public GlyphMapping(int n2, int n3, int n4, int n5, MinOptMax minOptMax, boolean bl, boolean bl2, boolean bl3, Font font, int n6, int[][] nArray) {
        this(n2, n3, n4, n5, minOptMax, bl, bl2, bl3, font, n6, nArray, null, null);
    }

    public GlyphMapping(int n2, int n3, int n4, int n5, MinOptMax minOptMax, boolean bl, boolean bl2, boolean bl3, Font font, int n6, int[][] nArray, String string, List list) {
        assert (n2 <= n3);
        this.startIndex = n2;
        this.endIndex = n3;
        this.wordCharLength = -1;
        this.wordSpaceCount = n4;
        this.letterSpaceCount = n5;
        this.areaIPD = minOptMax;
        this.isHyphenated = bl;
        this.isSpace = bl2;
        this.breakOppAfter = bl3;
        this.font = font;
        this.level = n6;
        this.gposAdjustments = nArray;
        this.mapping = string;
        this.associations = list;
    }

    public static GlyphMapping doGlyphMapping(TextFragment textFragment, int n2, int n3, Font font, MinOptMax minOptMax, MinOptMax[] minOptMaxArray, char c2, char c3, boolean bl, int n4, boolean bl2, boolean bl3, boolean bl4) {
        return GlyphMapping.doGlyphMapping(textFragment, n2, n3, font, minOptMax, minOptMaxArray, c2, c3, bl, n4, bl2, bl3, bl4, null);
    }

    public static GlyphMapping doGlyphMapping(TextFragment textFragment, int n2, int n3, Font font, MinOptMax minOptMax, MinOptMax[] minOptMaxArray, char c2, char c3, boolean bl, int n4, boolean bl2, boolean bl3, boolean bl4, FontFeatureSettings fontFeatureSettings) {
        bl3 = true;
        GlyphMapping glyphMapping = (font.performsSubstitution() || font.performsPositioning()) && minOptMax.getOpt() == 0 ? GlyphMapping.processWordMapping(textFragment, n2, n3, font, c3, bl, n4, bl2, bl3, bl4, fontFeatureSettings) : GlyphMapping.processWordNoMapping(textFragment, n2, n3, font, minOptMax, minOptMaxArray, c2, c3, bl, n4);
        return glyphMapping;
    }

    public static void setEnableLatinLigatures(Boolean bl) {
        enableLatinLigatures.set(bl);
    }

    public static void setEnableLatinGlyphSubstitutions(Boolean bl) {
        enableLatinGlyphSubstitutions.set(bl);
    }

    public static boolean getEnableLatinGlyphSubstitutions() {
        return enableLatinGlyphSubstitutions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GlyphMapping processWordMapping(TextFragment textFragment, int n2, int n3, Font font, char c2, boolean bl, int n4, boolean bl2, boolean bl3, boolean bl4, FontFeatureSettings fontFeatureSettings) {
        Object object;
        CharSequence charSequence;
        ArrayList arrayList;
        int n5 = 0;
        String string = textFragment.getScript();
        String string2 = textFragment.getLanguage();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PW: [" + n2 + "," + n3 + "]: { +M, level = " + n4 + " }"));
        }
        CharSequence charSequence2 = textFragment.subSequence(n2, n3);
        string = GlyphMapping.computeDominantScript(string, charSequence2);
        string2 = GlyphMapping.computeLanguage(string2);
        ArrayList arrayList2 = arrayList = bl3 ? new ArrayList() : null;
        if (!(enableLatinLigatures.get().booleanValue() && enableLatinGlyphSubstitutions.get().booleanValue() || !"latn".equals(string))) {
            charSequence = charSequence2;
        } else {
            object = DefaultScriptProcessor.getFontFeatureSettings();
            try {
                DefaultScriptProcessor.setFontFeatureSettings(fontFeatureSettings);
                charSequence = font.performSubstitution(charSequence2, string, string2, arrayList, bl4);
            }
            finally {
                DefaultScriptProcessor.setFontFeatureSettings((FontFeatureSettings)object);
            }
        }
        object = null;
        if (font.performsPositioning()) {
            object = font.performPositioning(charSequence, string, string2);
        }
        if (GlyphMapping.useKerningAdjustments(font, string, string2)) {
            object = GlyphMapping.getKerningAdjustments(charSequence, font, (int[][])object);
        }
        charSequence = font.reorderCombiningMarks(charSequence, (int[][])object, string, string2, arrayList);
        MinOptMax minOptMax = MinOptMax.ZERO;
        int n6 = 0;
        int n7 = 0;
        int n8 = charSequence.length();
        while (n6 < n8) {
            int n9;
            int n10 = charSequence.charAt(n6);
            if (CharUtilities.containsSurrogatePairAt((CharSequence)charSequence, (int)n6)) {
                n10 = Character.toCodePoint((char)n10, charSequence.charAt(++n6));
            }
            if ((n9 = font.getCharWidth(n10)) < 0) {
                n9 = 0;
            }
            if (object != null) {
                n9 += object[n7][2];
            }
            minOptMax = minOptMax.plus(n9);
            ++n6;
            ++n7;
        }
        return new GlyphMapping(n2, n3, 0, n5, minOptMax, bl, false, c2 != '\u0000', font, n4, (int[][])object, (String)(!bl2 && CharUtilities.isSameSequence((CharSequence)charSequence, (CharSequence)charSequence2) ? null : charSequence.toString()), arrayList);
    }

    private static String computeLanguage(String string) {
        if (string == null || "none".equals(string)) {
            string = "dflt";
        }
        return string;
    }

    private static String computeDominantScript(String string, CharSequence charSequence) {
        if (string == null || "auto".equals(string)) {
            string = CharScript.scriptTagFromCode((int)CharScript.dominantScript((CharSequence)charSequence));
        }
        if ("zyyy".equals(string) || "auto".equals(string)) {
            string = "*";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String performSubstitution(Font font, CharSequence charSequence, FontFeatureSettings fontFeatureSettings, String string, String string2) {
        FontFeatureSettings fontFeatureSettings2 = DefaultScriptProcessor.getFontFeatureSettings();
        try {
            DefaultScriptProcessor.setFontFeatureSettings(fontFeatureSettings);
            string = GlyphMapping.computeDominantScript(string, charSequence);
            string2 = GlyphMapping.computeLanguage(string2);
            if (font.performsSubstitution()) {
                charSequence = font.performSubstitution(charSequence, string, string2, null, false);
            }
        }
        finally {
            DefaultScriptProcessor.setFontFeatureSettings(fontFeatureSettings2);
        }
        return charSequence.toString();
    }

    private static boolean useKerningAdjustments(Font font, String string, String string2) {
        return font.hasKerning() && !font.hasFeature(2, string, string2, "kern");
    }

    private static int[][] getKerningAdjustments(CharSequence charSequence, Font font, int[][] nArray) {
        int n2 = Character.codePointCount(charSequence, 0, charSequence.length());
        int[] nArray2 = new int[n2];
        int n3 = -1;
        int n4 = 0;
        Iterator iterator = CharUtilities.codepointsIter((CharSequence)charSequence).iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (n3 >= 0) {
                nArray2[n4] = font.getKernValue(n3, n5);
            }
            n3 = n5;
            ++n4;
        }
        boolean bl = false;
        for (int n6 : nArray2) {
            if (n6 == 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (nArray == null) {
                nArray = new int[n2][4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (n4 <= 0) continue;
                int[] nArray3 = nArray[n4 - 1];
                nArray3[2] = nArray3[2] + nArray2[n4];
            }
            return nArray;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static GlyphMapping processWordNoMapping(TextFragment textFragment, int n2, int n3, Font font, MinOptMax minOptMax, MinOptMax[] minOptMaxArray, char c2, char c3, boolean bl, int n4) {
        void var15_22;
        boolean bl2 = font.hasKerning();
        MinOptMax minOptMax2 = MinOptMax.ZERO;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PW: [" + n2 + "," + n3 + "]: { -M, level = " + n4 + " }"));
        }
        CharSequence charSequence = textFragment.subSequence(n2, n3);
        int n5 = 0;
        Iterator iterator = CharUtilities.codepointsIter((CharSequence)charSequence).iterator();
        while (iterator.hasNext()) {
            int c4 = (Integer)iterator.next();
            int n6 = font.getCharWidth(c4);
            minOptMax2 = minOptMax2.plus(n6);
            if (bl2) {
                int n7 = 0;
                if (n5 > 0) {
                    int n8 = Character.codePointAt(charSequence, n5 - 1);
                    n7 = font.getKernValue(n8, c4);
                } else if (c2 != '\u0000') {
                    n7 = font.getKernValue(c2, c4);
                }
                if (n7 != 0) {
                    GlyphMapping.addToLetterAdjust(minOptMaxArray, n2 + n5, n7);
                    minOptMax2 = minOptMax2.plus(n7);
                }
            }
            ++n5;
        }
        if (bl2 && c3 != '\u0000' && !GlyphMapping.isSpace(c3) && n3 > 0 && bl) {
            int n9;
            int n92 = textFragment.charAt(n3 - 1);
            if (Character.isLowSurrogate((char)n92)) {
                char c4 = textFragment.charAt(n3 - 2);
                n92 = Character.toCodePoint(c4, (char)n92);
            }
            if ((n9 = font.getKernValue(n92, c3)) != 0) {
                GlyphMapping.addToLetterAdjust(minOptMaxArray, n3, n9);
            }
        }
        int n10 = n3 - n2;
        boolean bl3 = false;
        if (n10 != 0) {
            int n11 = n10 - 1;
            if (c3 != '\u0000' && !GlyphMapping.isSpace(c3)) {
                ++var15_22;
            }
        }
        assert (var15_22 >= 0);
        minOptMax2 = minOptMax2.plus(minOptMax.mult((int)var15_22));
        return new GlyphMapping(n2, n3, 0, (int)var15_22, minOptMax2, bl, false, c3 != '\u0000' && !GlyphMapping.isSpace(c3), font, n4, null);
    }

    private static void addToLetterAdjust(MinOptMax[] minOptMaxArray, int n2, int n3) {
        minOptMaxArray[n2] = minOptMaxArray[n2] == null ? MinOptMax.getInstance((int)n3) : minOptMaxArray[n2].plus(n3);
    }

    public static boolean isSpace(char c2) {
        return c2 == ' ' || CharUtilities.isNonBreakableSpace((int)c2) || CharUtilities.isFixedWidthSpace((int)c2);
    }

    public int getWordLength() {
        if (this.wordCharLength == -1) {
            if (this.mapping != null) {
                this.wordCharLength = this.mapping.length();
            } else {
                assert (this.endIndex >= this.startIndex);
                this.wordCharLength = this.endIndex - this.startIndex;
            }
        }
        return this.wordCharLength;
    }

    public void addToAreaIPD(MinOptMax minOptMax) {
        this.areaIPD = this.areaIPD.plus(minOptMax);
    }

    public String toString() {
        return super.toString() + "{interval = [" + this.startIndex + "," + this.endIndex + "], isSpace = " + this.isSpace + ", level = " + this.level + ", areaIPD = " + this.areaIPD + ", letterSpaceCount = " + this.letterSpaceCount + ", wordSpaceCount = " + this.wordSpaceCount + ", isHyphenated = " + this.isHyphenated + ", font = " + this.font + "}";
    }
}

