/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.OptionalCharacterProperty;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.Typeface;

public final class CommonHyphenation {
    private static final Log LOG = LogFactory.getLog(CommonHyphenation.class);
    private static final PropertyCache<CommonHyphenation> CACHE = new PropertyCache();
    private int hash;
    public final StringProperty language;
    public final StringProperty country;
    public final StringProperty script;
    public final EnumProperty hyphenate;
    public final OptionalCharacterProperty hyphenationCharacter;
    public final NumberProperty hyphenationPushCharacterCount;
    public final NumberProperty hyphenationRemainCharacterCount;
    public final EnumProperty avoidBreakingLineAtHyphens;
    public final EnumProperty breakLineAtHyphens;
    private static final char HYPHEN_MINUS = '-';
    private static final char MINUS_SIGN = '\u2212';

    private CommonHyphenation(StringProperty stringProperty, StringProperty stringProperty2, StringProperty stringProperty3, EnumProperty enumProperty, OptionalCharacterProperty optionalCharacterProperty, NumberProperty numberProperty, NumberProperty numberProperty2, EnumProperty enumProperty2, EnumProperty enumProperty3) {
        this.language = stringProperty;
        this.country = stringProperty2;
        this.script = stringProperty3;
        this.hyphenate = enumProperty;
        this.hyphenationCharacter = optionalCharacterProperty;
        this.hyphenationPushCharacterCount = numberProperty;
        this.hyphenationRemainCharacterCount = numberProperty2;
        this.avoidBreakingLineAtHyphens = enumProperty2;
        this.breakLineAtHyphens = enumProperty3;
    }

    public static CommonHyphenation getInstance(PropertyList propertyList) throws PropertyException {
        StringProperty stringProperty = (StringProperty)propertyList.get(134);
        StringProperty stringProperty2 = (StringProperty)propertyList.get(81);
        StringProperty stringProperty3 = (StringProperty)propertyList.get(218);
        EnumProperty enumProperty = (EnumProperty)propertyList.get(116);
        OptionalCharacterProperty optionalCharacterProperty = (OptionalCharacterProperty)propertyList.get(117);
        NumberProperty numberProperty = (NumberProperty)propertyList.get(120);
        NumberProperty numberProperty2 = (NumberProperty)propertyList.get(121);
        EnumProperty enumProperty2 = (EnumProperty)propertyList.get(295);
        EnumProperty enumProperty3 = (EnumProperty)propertyList.get(296);
        CommonHyphenation commonHyphenation = new CommonHyphenation(stringProperty, stringProperty2, stringProperty3, enumProperty, optionalCharacterProperty, numberProperty, numberProperty2, enumProperty2, enumProperty3);
        return (CommonHyphenation)CACHE.fetch((Object)commonHyphenation);
    }

    public Character getHyphChar(Font font) {
        if (this.hyphenationCharacter.getObject() == null) {
            return null;
        }
        char c2 = this.hyphenationCharacter.getCharacter();
        if (font.hasChar(c2)) {
            return Character.valueOf(c2);
        }
        char c3 = c2;
        boolean bl = false;
        if (font.hasChar('-')) {
            c3 = '-';
            bl = true;
        } else if (font.hasChar('\u2212')) {
            Typeface typeface;
            c3 = '\u2212';
            FontMetrics fontMetrics = font.getFontMetrics();
            if (fontMetrics instanceof Typeface && !"SymbolEncoding".equals((typeface = (Typeface)fontMetrics).getEncodingName())) {
                bl = true;
            }
        } else {
            Typeface typeface;
            c3 = ' ';
            FontMetrics fontMetrics = font.getFontMetrics();
            if (fontMetrics instanceof Typeface && !"ZapfDingbatsEncoding".equals((typeface = (Typeface)fontMetrics).getEncodingName())) {
                bl = true;
            }
        }
        if (bl) {
            LOG.warn((Object)("Substituted specified hyphenation character (0x" + Integer.toHexString(c2) + ") with 0x" + Integer.toHexString(c3) + " because the font doesn't have the specified hyphenation character: " + font.getFontTriplet()));
        }
        return Character.valueOf(c3);
    }

    public int getHyphIPD(Font font) {
        Character c2 = this.getHyphChar(font);
        if (c2.charValue() == '\u00ad') {
            font.mapChar('-');
        }
        return c2 == null ? 0 : font.getCharWidth(c2.charValue());
    }

    public Locale getLocale() {
        return CommonHyphenation.toLocale(this.language.getString(), this.country.getString());
    }

    public static Locale toLocale(String string, String string2) {
        Locale locale = null;
        if (CommonHyphenation.isDefined(string)) {
            locale = CommonHyphenation.isDefined(string2) ? new Locale(string, string2) : new Locale(string);
        }
        return locale;
    }

    private static boolean isDefined(String string) {
        return string != null && !string.equalsIgnoreCase("none");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CommonHyphenation) {
            CommonHyphenation commonHyphenation = (CommonHyphenation)object;
            return commonHyphenation.language == this.language && commonHyphenation.country == this.country && commonHyphenation.script == this.script && commonHyphenation.hyphenate == this.hyphenate && commonHyphenation.hyphenationCharacter == this.hyphenationCharacter && commonHyphenation.hyphenationPushCharacterCount == this.hyphenationPushCharacterCount && commonHyphenation.hyphenationRemainCharacterCount == this.hyphenationRemainCharacterCount && commonHyphenation.avoidBreakingLineAtHyphens == this.avoidBreakingLineAtHyphens && commonHyphenation.breakLineAtHyphens == this.breakLineAtHyphens;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n2 = 17;
            n2 = 37 * n2 + (this.language == null ? 0 : this.language.hashCode());
            n2 = 37 * n2 + (this.script == null ? 0 : this.script.hashCode());
            n2 = 37 * n2 + (this.country == null ? 0 : this.country.hashCode());
            n2 = 37 * n2 + (this.hyphenate == null ? 0 : this.hyphenate.hashCode());
            n2 = 37 * n2 + (this.hyphenationCharacter == null ? 0 : this.hyphenationCharacter.hashCode());
            n2 = 37 * n2 + (this.hyphenationPushCharacterCount == null ? 0 : this.hyphenationPushCharacterCount.hashCode());
            n2 = 37 * n2 + (this.hyphenationRemainCharacterCount == null ? 0 : this.hyphenationRemainCharacterCount.hashCode());
            n2 = 37 * n2 + (this.avoidBreakingLineAtHyphens == null ? 0 : this.avoidBreakingLineAtHyphens.hashCode());
            this.hash = n2 = 37 * n2 + (this.breakLineAtHyphens == null ? 0 : this.breakLineAtHyphens.hashCode());
        }
        return this.hash;
    }
}

