/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.RefIPDForExternalImages;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.util.CompareUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;

public class CommonBorderPaddingBackground {
    private static final PropertyCache<CommonBorderPaddingBackground> CACHE = new PropertyCache();
    private int hash = -1;
    public final int backgroundAttachment;
    public final Color backgroundColor;
    public final String backgroundImage;
    public final int backgroundRepeat;
    public final Length backgroundPositionHorizontal;
    public final Length backgroundPositionVertical;
    public final Length backgroungImageTargetWidth;
    public final Length backgroungImageTargetHeight;
    private ImageInfo backgroundImageInfo;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int START = 2;
    public static final int END = 3;
    private static final BorderInfo DEFAULT_BORDER_INFO = BorderInfo.getInstance(95, new ConditionalNullLength(), null, new ConditionalNullLength(), new ConditionalNullLength());
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private CondLengthProperty[] padding = new CondLengthProperty[4];

    public static BorderInfo getDefaultBorderInfo() {
        return DEFAULT_BORDER_INFO;
    }

    CommonBorderPaddingBackground(PropertyList propertyList) throws PropertyException {
        this.backgroundAttachment = propertyList.get(8).getEnum();
        Color color = propertyList.get(9).getColor(propertyList.getFObj().getUserAgent());
        this.backgroundColor = color.getAlpha() == 0 ? null : color;
        String string = propertyList.get(10).getString();
        if (string == null || "none".equals(string)) {
            this.backgroundImage = "";
            this.backgroundRepeat = -1;
            this.backgroundPositionHorizontal = null;
            this.backgroundPositionVertical = null;
        } else {
            this.backgroundImage = string;
            this.backgroundRepeat = propertyList.get(14).getEnum();
            this.backgroundPositionHorizontal = propertyList.get(12).getLength();
            this.backgroundPositionVertical = propertyList.get(13).getLength();
        }
        this.backgroungImageTargetWidth = propertyList.get(292).getLength();
        this.backgroungImageTargetHeight = propertyList.get(293).getLength();
        this.initBorderInfo(propertyList, 0, 23, 25, 26, 172, 275, 276);
        this.initBorderInfo(propertyList, 1, 19, 21, 22, 171, 277, 278);
        this.initBorderInfo(propertyList, 2, 47, 49, 50, 177, 279, 280);
        this.initBorderInfo(propertyList, 3, 33, 35, 36, 174, 281, 282);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonBorderPaddingBackground getInstance(PropertyList propertyList) throws PropertyException {
        CommonBorderPaddingBackground commonBorderPaddingBackground = new CommonBorderPaddingBackground(propertyList);
        CommonBorderPaddingBackground commonBorderPaddingBackground2 = null;
        if (!(commonBorderPaddingBackground.padding[0] != null && !commonBorderPaddingBackground.padding[0].getLength().isAbsolute() || commonBorderPaddingBackground.padding[1] != null && !commonBorderPaddingBackground.padding[1].getLength().isAbsolute() || commonBorderPaddingBackground.padding[2] != null && !commonBorderPaddingBackground.padding[2].getLength().isAbsolute() || commonBorderPaddingBackground.padding[3] != null && !commonBorderPaddingBackground.padding[3].getLength().isAbsolute() || commonBorderPaddingBackground.backgroundPositionHorizontal != null && !commonBorderPaddingBackground.backgroundPositionHorizontal.isAbsolute() || commonBorderPaddingBackground.backgroundPositionVertical != null && !commonBorderPaddingBackground.backgroundPositionVertical.isAbsolute() || commonBorderPaddingBackground.backgroungImageTargetHeight != null && !commonBorderPaddingBackground.backgroungImageTargetHeight.isAbsolute() || commonBorderPaddingBackground.backgroungImageTargetWidth != null && !commonBorderPaddingBackground.backgroungImageTargetWidth.isAbsolute())) {
            commonBorderPaddingBackground2 = (CommonBorderPaddingBackground)CACHE.fetch((Object)commonBorderPaddingBackground);
        }
        String string = commonBorderPaddingBackground.backgroundImage.intern();
        synchronized (string) {
            if (!(commonBorderPaddingBackground2 != null && commonBorderPaddingBackground2 != commonBorderPaddingBackground || "".equals(commonBorderPaddingBackground.backgroundImage))) {
                String string2 = URISpecification.getURL((String)commonBorderPaddingBackground.backgroundImage);
                FObj fObj = propertyList.getFObj();
                FOUserAgent fOUserAgent = propertyList.getFObj().getUserAgent();
                ImageManager imageManager = fOUserAgent.getImageManager();
                ImageSessionContext imageSessionContext = fOUserAgent.getImageSessionContext();
                try {
                    ImageInfo imageInfo;
                    RefIPDForExternalImages.setRefIPD(100000);
                    commonBorderPaddingBackground.backgroundImageInfo = imageInfo = imageManager.getImageInfo(string2, imageSessionContext);
                }
                catch (ImageException imageException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageError((Object)fObj, string2, imageException, fObj.getLocator());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageNotFound((Object)fObj, string2, fileNotFoundException, fObj.getLocator());
                }
                catch (IOException iOException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageIOError((Object)fObj, string2, iOException, fObj.getLocator());
                }
            }
        }
        return commonBorderPaddingBackground2 != null ? commonBorderPaddingBackground2 : commonBorderPaddingBackground;
    }

    private void initBorderInfo(PropertyList propertyList, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws PropertyException {
        this.padding[n2] = propertyList.get(n6).getCondLength();
        int n9 = propertyList.get(n4).getEnum();
        FOUserAgent fOUserAgent = propertyList.getFObj().getUserAgent();
        this.setBorderInfo(BorderInfo.getInstance(n9, propertyList.get(n5).getCondLength(), propertyList.get(n3).getColor(fOUserAgent), propertyList.get(n7).getCondLength(), propertyList.get(n8).getCondLength()), n2);
    }

    private void setBorderInfo(BorderInfo borderInfo, int n2) {
        this.borderInfo[n2] = borderInfo;
    }

    public BorderInfo getBorderInfo(int n2) {
        if (this.borderInfo[n2] == null) {
            return CommonBorderPaddingBackground.getDefaultBorderInfo();
        }
        return this.borderInfo[n2];
    }

    public ImageInfo getImageInfo() {
        return this.backgroundImageInfo;
    }

    public int getBorderStartWidth(boolean bl) {
        return this.getBorderWidth(2, bl);
    }

    public int getBorderEndWidth(boolean bl) {
        return this.getBorderWidth(3, bl);
    }

    public int getBorderBeforeWidth(boolean bl) {
        return this.getBorderWidth(0, bl);
    }

    public int getBorderAfterWidth(boolean bl) {
        return this.getBorderWidth(1, bl);
    }

    public int getPaddingStart(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(2, bl, percentBaseContext);
    }

    public int getPaddingEnd(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(3, bl, percentBaseContext);
    }

    public int getPaddingBefore(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(0, bl, percentBaseContext);
    }

    public int getPaddingAfter(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(1, bl, percentBaseContext);
    }

    public int getBorderWidth(int n2, boolean bl) {
        if (this.borderInfo[n2] == null || this.borderInfo[n2].mStyle == 95 || this.borderInfo[n2].mStyle == 57 || bl && this.borderInfo[n2].mWidth.isDiscard()) {
            return 0;
        }
        return this.borderInfo[n2].mWidth.getLengthValue();
    }

    public int getBorderRadiusStart(int n2, boolean bl, PercentBaseContext percentBaseContext) {
        if (this.borderInfo[n2] == null) {
            return 0;
        }
        return this.borderInfo[n2].radiusStart.getLengthValue(percentBaseContext);
    }

    public int getBorderRadiusEnd(int n2, boolean bl, PercentBaseContext percentBaseContext) {
        if (this.borderInfo[n2] == null) {
            return 0;
        }
        return this.borderInfo[n2].radiusEnd.getLengthValue(percentBaseContext);
    }

    public Color getBorderColor(int n2) {
        if (this.borderInfo[n2] != null) {
            return this.borderInfo[n2].getColor();
        }
        return null;
    }

    public int getBorderStyle(int n2) {
        if (this.borderInfo[n2] != null) {
            return this.borderInfo[n2].mStyle;
        }
        return 95;
    }

    public int getPadding(int n2, boolean bl, PercentBaseContext percentBaseContext) {
        if (this.padding[n2] == null || bl && this.padding[n2].isDiscard()) {
            return 0;
        }
        return this.padding[n2].getLengthValue(percentBaseContext);
    }

    public CondLengthProperty getPaddingLengthProperty(int n2) {
        return this.padding[n2];
    }

    public int getIPPaddingAndBorder(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPaddingStart(bl, percentBaseContext) + this.getPaddingEnd(bl, percentBaseContext) + this.getBorderStartWidth(bl) + this.getBorderEndWidth(bl);
    }

    public int getBPPaddingAndBorder(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPaddingBefore(bl, percentBaseContext) + this.getPaddingAfter(bl, percentBaseContext) + this.getBorderBeforeWidth(bl) + this.getBorderAfterWidth(bl);
    }

    public String toString() {
        return "CommonBordersAndPadding (Before, After, Start, End):\nBorders: (" + this.getBorderBeforeWidth(false) + ", " + this.getBorderAfterWidth(false) + ", " + this.getBorderStartWidth(false) + ", " + this.getBorderEndWidth(false) + ")\nBorder Colors: (" + this.getBorderColor(0) + ", " + this.getBorderColor(1) + ", " + this.getBorderColor(2) + ", " + this.getBorderColor(3) + ")\nPadding: (" + this.getPaddingBefore(false, null) + ", " + this.getPaddingAfter(false, null) + ", " + this.getPaddingStart(false, null) + ", " + this.getPaddingEnd(false, null) + ")\n";
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.getImageInfo() != null;
    }

    public boolean hasBorder() {
        return this.getBorderBeforeWidth(false) + this.getBorderAfterWidth(false) + this.getBorderStartWidth(false) + this.getBorderEndWidth(false) > 0;
    }

    public boolean hasPadding(PercentBaseContext percentBaseContext) {
        return this.getPaddingBefore(false, percentBaseContext) + this.getPaddingAfter(false, percentBaseContext) + this.getPaddingStart(false, percentBaseContext) + this.getPaddingEnd(false, percentBaseContext) > 0;
    }

    public boolean hasBorderInfo() {
        return this.borderInfo[0] != null || this.borderInfo[1] != null || this.borderInfo[2] != null || this.borderInfo[3] != null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getBackgroundAttachment() {
        return this.backgroundAttachment;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public int getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public Length getBackgroundPositionHorizontal() {
        return this.backgroundPositionHorizontal;
    }

    public Length getBackgroundPositionVertical() {
        return this.backgroundPositionVertical;
    }

    public ImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }

    public BorderInfo[] getBorderInfo() {
        return this.borderInfo;
    }

    public CondLengthProperty[] getPadding() {
        return this.padding;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CommonBorderPaddingBackground) {
            CommonBorderPaddingBackground commonBorderPaddingBackground = (CommonBorderPaddingBackground)object;
            return this.backgroundAttachment == commonBorderPaddingBackground.backgroundAttachment && CompareUtil.equal((Object)this.backgroundColor, (Object)commonBorderPaddingBackground.backgroundColor) && CompareUtil.equal((Object)this.backgroundImage, (Object)commonBorderPaddingBackground.backgroundImage) && CompareUtil.equal((Object)this.backgroundPositionHorizontal, (Object)this.backgroundPositionHorizontal) && CompareUtil.equal((Object)this.backgroundPositionVertical, (Object)commonBorderPaddingBackground.backgroundPositionVertical) && this.backgroundRepeat == commonBorderPaddingBackground.backgroundRepeat && Arrays.equals(this.borderInfo, commonBorderPaddingBackground.borderInfo) && Arrays.equals(this.padding, commonBorderPaddingBackground.padding);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n2 = this.getHashCode(this.backgroundColor, this.backgroundImage, this.backgroundPositionHorizontal, this.backgroundPositionVertical, this.backgroungImageTargetWidth, this.backgroungImageTargetHeight, this.borderInfo[0], this.borderInfo[1], this.borderInfo[2], this.borderInfo[3], this.padding[0], this.padding[1], this.padding[2], this.padding[3]);
            n2 = 37 * n2 + this.backgroundAttachment;
            this.hash = n2 = 37 * n2 + this.backgroundRepeat;
        }
        return this.hash;
    }

    private int getHashCode(Object ... objectArray) {
        int n2 = 17;
        for (Object object : objectArray) {
            n2 = 37 * n2 + (object == null ? 0 : object.hashCode());
        }
        return n2;
    }

    public static final class BorderInfo {
        private static final PropertyCache<BorderInfo> CACHE = new PropertyCache();
        private int mStyle;
        private Color mColor;
        private CondLengthProperty mWidth;
        private CondLengthProperty radiusStart;
        private CondLengthProperty radiusEnd;
        private int hash = -1;

        private BorderInfo(int n2, CondLengthProperty condLengthProperty, Color color, CondLengthProperty condLengthProperty2, CondLengthProperty condLengthProperty3) {
            this.mStyle = n2;
            this.mWidth = condLengthProperty;
            this.mColor = color;
            this.radiusStart = condLengthProperty2;
            this.radiusEnd = condLengthProperty3;
        }

        public static BorderInfo getInstance(int n2, CondLengthProperty condLengthProperty, Color color, CondLengthProperty condLengthProperty2, CondLengthProperty condLengthProperty3) {
            BorderInfo borderInfo = new BorderInfo(n2, condLengthProperty, color, condLengthProperty2, condLengthProperty3);
            if ((condLengthProperty2 instanceof ConditionalNullLength || condLengthProperty2.getLength().isAbsolute()) && (condLengthProperty3 instanceof ConditionalNullLength || condLengthProperty3.getLength().isAbsolute())) {
                return (BorderInfo)CACHE.fetch((Object)borderInfo);
            }
            return borderInfo;
        }

        public int getStyle() {
            return this.mStyle;
        }

        public Color getColor() {
            return this.mColor;
        }

        public CondLengthProperty getWidth() {
            return this.mWidth;
        }

        public int getRetainedWidth() {
            if (this.mStyle == 95 || this.mStyle == 57) {
                return 0;
            }
            return this.mWidth.getLengthValue();
        }

        public CondLengthProperty getRadiusStart() {
            return this.radiusStart;
        }

        public CondLengthProperty getRadiusEnd() {
            return this.radiusEnd;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("BorderInfo");
            stringBuffer.append(" {");
            stringBuffer.append(this.mStyle);
            stringBuffer.append(", ");
            stringBuffer.append(this.mColor);
            stringBuffer.append(", ");
            stringBuffer.append(this.mWidth);
            stringBuffer.append(", ");
            stringBuffer.append(this.radiusStart);
            stringBuffer.append(", ");
            stringBuffer.append(this.radiusEnd);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BorderInfo)) {
                return false;
            }
            BorderInfo borderInfo = (BorderInfo)object;
            return this.mColor == borderInfo.mColor && this.mStyle == borderInfo.mStyle && this.mWidth == borderInfo.mWidth && this.radiusStart == borderInfo.radiusStart && this.radiusEnd == borderInfo.radiusEnd;
        }

        public int hashCode() {
            if (this.hash == -1) {
                int n2 = 17;
                n2 = 37 * n2 + (this.mColor == null ? 0 : this.mColor.hashCode());
                n2 = 37 * n2 + this.mStyle;
                n2 = 37 * n2 + (this.mWidth == null ? 0 : this.mWidth.hashCode());
                n2 = 37 * n2 + (this.radiusStart == null ? 0 : this.radiusStart.hashCode());
                this.hash = n2 = 37 * n2 + (this.radiusEnd == null ? 0 : this.radiusEnd.hashCode());
            }
            return this.hash;
        }
    }

    private static class ConditionalNullLength
    extends CondLengthProperty {
        private ConditionalNullLength() {
        }

        public Property getComponent(int n2) {
            throw new UnsupportedOperationException();
        }

        public Property getConditionality() {
            throw new UnsupportedOperationException();
        }

        public Length getLength() {
            throw new UnsupportedOperationException();
        }

        public Property getLengthComponent() {
            throw new UnsupportedOperationException();
        }

        public int getLengthValue() {
            return 0;
        }

        public int getLengthValue(PercentBaseContext percentBaseContext) {
            return 0;
        }

        public boolean isDiscard() {
            return true;
        }

        public void setComponent(int n2, Property property, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CondLength[0mpt, discard]";
        }
    }
}

