/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.xml.sax.Locator;

public class TableColumn
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int columnNumber;
    private Length columnWidth;
    private int numberColumnsRepeated;
    private int numberColumnsSpanned;
    private boolean isHeader;
    private boolean implicitColumn;
    private PropertyList pList;
    private boolean fill = false;

    public TableColumn(FONode fONode) {
        this(fONode, false);
    }

    public TableColumn(FONode fONode, boolean bl) {
        super(fONode);
        this.implicitColumn = bl;
    }

    public void bind(PropertyList propertyList) throws FOPException {
        TableEventProducer tableEventProducer;
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.columnNumber = propertyList.get(76).getNumeric().getValue();
        this.columnWidth = propertyList.get(77).getLength();
        this.numberColumnsRepeated = propertyList.get(164).getNumeric().getValue();
        this.numberColumnsSpanned = propertyList.get(165).getNumeric().getValue();
        super.bind(propertyList);
        if (this.numberColumnsRepeated <= 0) {
            tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            tableEventProducer.valueMustBeBiggerGtEqOne((Object)this, "number-columns-repeated", this.numberColumnsRepeated, this.getLocator());
        }
        if (this.numberColumnsSpanned <= 0) {
            tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            tableEventProducer.valueMustBeBiggerGtEqOne((Object)this, "number-columns-spanned", this.numberColumnsSpanned, this.getLocator());
        }
        if (this.columnWidth.getEnum() == 9) {
            if (!this.implicitColumn && !this.getTable().isAutoLayout()) {
                tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                tableEventProducer.warnImplicitColumns((Object)this, this.getLocator());
            }
            this.columnWidth = new TableColLength(1.0, (FObj)this);
        }
        this.setFill(ChemistryExtensions.isFill((FObj)this));
        if (!this.implicitColumn) {
            this.pList = propertyList;
        }
        this.isHeader = propertyList.get(289).getEnum() == 149;
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startColumn(this);
    }

    void setCollapsedBorders(CollapsingBorderModel collapsingBorderModel) {
        this.collapsingBorderModel = collapsingBorderModel;
        this.setCollapsedBorders();
    }

    public void endOfNode() throws FOPException {
        this.getFOEventHandler().endColumn(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Length length) {
        this.columnWidth = length;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    protected void setColumnNumber(int n2) {
        this.columnNumber = n2;
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated;
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned;
    }

    public String getLocalName() {
        return "table-column";
    }

    public int getNameId() {
        return 76;
    }

    public boolean isImplicitColumn() {
        return this.implicitColumn;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("fo:table-column");
        stringBuffer.append(" column-number=").append(this.getColumnNumber());
        if (this.getNumberColumnsRepeated() > 1) {
            stringBuffer.append(" number-columns-repeated=").append(this.getNumberColumnsRepeated());
        }
        if (this.getNumberColumnsSpanned() > 1) {
            stringBuffer.append(" number-columns-spanned=").append(this.getNumberColumnsSpanned());
        }
        stringBuffer.append(" column-width=").append(((Property)this.getColumnWidth()).getString());
        return stringBuffer.toString();
    }

    public Property getProperty(int n2) throws PropertyException {
        return this.pList.get(n2);
    }

    protected void releasePropertyList() {
        this.pList = null;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public final boolean isAutoLayout() {
        return this.getColumnWidth() instanceof TableColLength;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
    }

    public boolean isFill() {
        return this.fill;
    }
}

