/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;

public class PrimaryGridUnit
extends GridUnit {
    private TableCellLayoutManager cellLM;
    private List elements;
    private int rowIndex;
    private int colIndex;
    private List<GridUnit[]> rows;
    private int contentLength = -1;
    private boolean isSeparateBorderModel;
    private int halfBorderSeparationBPD;
    private Keep keepWithPrevious = Keep.KEEP_AUTO;
    private Keep keepWithNext = Keep.KEEP_AUTO;
    private int breakBefore = 9;
    private int breakAfter = 9;

    PrimaryGridUnit(TableCell tableCell, int n2) {
        super(tableCell, 0, 0);
        this.colIndex = n2;
        this.isSeparateBorderModel = tableCell.getTable().isSeparateBorderModel();
        this.halfBorderSeparationBPD = tableCell.getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
    }

    public TablePart getTablePart() {
        FONode fONode = this.cell.getParent();
        if (fONode instanceof TableRow) {
            fONode = fONode.getParent();
        }
        return (TablePart)fONode;
    }

    public TableCellLayoutManager getCellLM() {
        assert (this.cellLM != null);
        return this.cellLM;
    }

    public PrimaryGridUnit getPrimary() {
        return this;
    }

    public boolean isPrimary() {
        return true;
    }

    public void setElements(List list) {
        this.elements = list;
        this.contentLength = -1;
    }

    public List getElements() {
        return this.elements;
    }

    public int getBeforeAfterBorderWidth() {
        return this.getBeforeBorderWidth(0, 0) + this.getAfterBorderWidth(0);
    }

    public int getBeforeBorderWidth(int n2, int n3) {
        if (this.isSeparateBorderModel) {
            if (this.getCell() == null) {
                return 0;
            }
            CommonBorderPaddingBackground commonBorderPaddingBackground = this.getCell().getCommonBorderPaddingBackground();
            switch (n3) {
                case 0: 
                case 1: {
                    return commonBorderPaddingBackground.getBorderBeforeWidth(false) + this.halfBorderSeparationBPD;
                }
                case 2: {
                    if (commonBorderPaddingBackground.getBorderInfo(0).getWidth().isDiscard()) {
                        return 0;
                    }
                    return commonBorderPaddingBackground.getBorderBeforeWidth(true) + this.halfBorderSeparationBPD;
                }
            }
            assert (false);
            return 0;
        }
        int n4 = 0;
        for (GridUnit gridUnit : this.rows.get(n2)) {
            n4 = Math.max(n4, gridUnit.getBorderBefore(n3).getRetainedWidth());
        }
        return n4 / 2;
    }

    public int getAfterBorderWidth(int n2, int n3) {
        GridUnit[] gridUnitArray;
        if (this.isSeparateBorderModel) {
            if (this.getCell() == null) {
                return 0;
            }
            CommonBorderPaddingBackground commonBorderPaddingBackground = this.getCell().getCommonBorderPaddingBackground();
            switch (n3) {
                case 0: 
                case 1: {
                    return commonBorderPaddingBackground.getBorderAfterWidth(false) + this.halfBorderSeparationBPD;
                }
                case 2: {
                    if (commonBorderPaddingBackground.getBorderInfo(1).getWidth().isDiscard()) {
                        return 0;
                    }
                    return commonBorderPaddingBackground.getBorderAfterWidth(true) + this.halfBorderSeparationBPD;
                }
            }
            assert (false);
            return 0;
        }
        int n4 = 0;
        for (GridUnit gridUnit : gridUnitArray = this.rows.get(n2)) {
            n4 = Math.max(n4, gridUnit.getBorderAfter(n3).getRetainedWidth());
        }
        return n4 / 2;
    }

    public int getAfterBorderWidth(int n2) {
        return this.getAfterBorderWidth(this.getCell().getNumberRowsSpanned() - 1, n2);
    }

    public int getContentLength() {
        this.contentLength = ElementListUtils.calcContentLength((List)this.elements);
        return this.contentLength;
    }

    public List<GridUnit[]> getRows() {
        return this.rows;
    }

    public void addRow(GridUnit[] gridUnitArray) {
        if (this.rows == null) {
            this.rows = new ArrayList<GridUnit[]>();
        }
        this.rows.add(gridUnitArray);
    }

    void setRowIndex(int n2) {
        this.rowIndex = n2;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public int[] getStartEndBorderWidths() {
        int[] nArray = new int[2];
        if (this.getCell() == null) {
            return nArray;
        }
        if (this.getCell().getTable().isSeparateBorderModel()) {
            nArray[0] = this.getCell().getCommonBorderPaddingBackground().getBorderStartWidth(false);
            nArray[1] = this.getCell().getCommonBorderPaddingBackground().getBorderEndWidth(false);
        } else {
            for (GridUnit[] gridUnitArray : this.rows) {
                nArray[0] = Math.max(nArray[0], gridUnitArray[0].borderStart.getBorderInfo().getRetainedWidth());
                nArray[1] = Math.max(nArray[1], gridUnitArray[gridUnitArray.length - 1].borderEnd.getBorderInfo().getRetainedWidth());
            }
        }
        return nArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" rowIndex=").append(this.rowIndex);
        stringBuilder.append(" colIndex=").append(this.colIndex);
        return stringBuilder.toString();
    }

    public boolean hasSpanning() {
        return this.getCell().getNumberColumnsSpanned() > 1 || this.getCell().getNumberRowsSpanned() > 1;
    }

    public void createCellLM() {
        this.cellLM = new TableCellLayoutManager(this.cell, this);
    }

    public Keep getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void setKeepWithPrevious(Keep keep) {
        this.keepWithPrevious = keep;
    }

    public Keep getKeepWithNext() {
        return this.keepWithNext;
    }

    public void setKeepWithNext(Keep keep) {
        this.keepWithNext = keep;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public void setBreakBefore(int n2) {
        this.breakBefore = n2;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public void setBreakAfter(int n2) {
        this.breakAfter = n2;
    }
}

