/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.RefIPDForExternalImages;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.xml.sax.Locator;

public class ExternalGraphic
extends AbstractGraphics {
    private String src;
    private String url;
    private int intrinsicWidth;
    private int intrinsicHeight;
    private Length intrinsicAlignmentAdjust;
    private boolean instrisicSizeDetermined;

    public ExternalGraphic(FONode fONode) {
        super(fONode);
    }

    @Override
    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.src = propertyList.get(232).getString();
        this.url = URISpecification.getURL((String)this.src);
    }

    private void prepareIntrinsicSize(int n2) {
        if (!this.instrisicSizeDetermined) {
            FOUserAgent fOUserAgent = this.getUserAgent();
            ImageManager imageManager = fOUserAgent.getImageManager();
            ImageInfo imageInfo = null;
            try {
                RefIPDForExternalImages.setRefIPD(n2);
                imageInfo = imageManager.getImageInfo(this.url, fOUserAgent.getImageSessionContext());
            }
            catch (ImageException imageException) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                resourceEventProducer.imageError((Object)this, this.url, imageException, this.getLocator());
            }
            catch (FileNotFoundException fileNotFoundException) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                resourceEventProducer.imageNotFound((Object)this, this.url, fileNotFoundException, this.getLocator());
            }
            catch (IOException iOException) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                resourceEventProducer.imageIOError((Object)this, this.url, iOException, this.getLocator());
            }
            if (imageInfo != null) {
                this.intrinsicWidth = imageInfo.getSize().getWidthMpt();
                this.intrinsicHeight = imageInfo.getSize().getHeightMpt();
                int n3 = imageInfo.getSize().getBaselinePositionFromBottom();
                if (n3 != 0) {
                    this.intrinsicAlignmentAdjust = FixedLength.getInstance((double)(-n3));
                }
            }
            this.instrisicSizeDetermined = true;
        }
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().image(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public String getSrc() {
        return this.src;
    }

    public String getURL() {
        return this.url;
    }

    public String getLocalName() {
        return "external-graphic";
    }

    public int getNameId() {
        return 14;
    }

    @Override
    public int getIntrinsicWidth(int n2) {
        this.prepareIntrinsicSize(n2);
        return this.intrinsicWidth;
    }

    @Override
    public int getIntrinsicHeight(int n2) {
        this.prepareIntrinsicSize(n2);
        return this.intrinsicHeight;
    }

    @Override
    public Length getIntrinsicAlignmentAdjust(int n2) {
        this.prepareIntrinsicSize(n2);
        return this.intrinsicAlignmentAdjust;
    }
}

