/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URI;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.extensions.svg.SVGDOMContentHandlerFactory;
import org.apache.fop.fo.extensions.svg.SVGObj;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.xmlgraphics.util.UnitConv;
import org.w3c.dom.Element;

public class SVGElement
extends SVGObj {
    public SVGElement(FONode fONode) {
        super(fONode);
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return new SVGDOMContentHandlerFactory();
    }

    public Point2D getDimension(Point2D point2D) {
        Object object;
        final Point2D point2D2 = this.millipointsToPixels(point2D);
        Element element = this.element;
        try {
            URI uRI = this.getUserAgent().getResourceResolver().getBaseURI();
            if (uRI != null) {
                object = (SVGOMDocument)this.doc;
                object.setURLObject(uRI.toURL());
            }
        }
        catch (Exception exception) {
            log.error((Object)"Could not set base URL for svg", (Throwable)exception);
        }
        final float f2 = this.getUserAgent().getSourcePixelUnitToMillimeter();
        object = new SVGContext(){

            public float getPixelToMM() {
                return f2;
            }

            public float getPixelUnitToMillimeter() {
                return f2;
            }

            public Rectangle2D getBBox() {
                return new Rectangle2D.Double(0.0, 0.0, point2D2.getX(), point2D2.getY());
            }

            public AffineTransform getScreenTransform() {
                throw new UnsupportedOperationException("NYI");
            }

            public void setScreenTransform(AffineTransform affineTransform) {
                throw new UnsupportedOperationException("NYI");
            }

            public AffineTransform getCTM() {
                return new AffineTransform();
            }

            public AffineTransform getGlobalTransform() {
                return new AffineTransform();
            }

            public float getViewportWidth() {
                return (float)point2D2.getX();
            }

            public float getViewportHeight() {
                return (float)point2D2.getY();
            }

            public float getFontSize() {
                return 12.0f;
            }
        };
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        sVGOMElement.setSVGContext((SVGContext)object);
        sVGOMElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        int n2 = 12;
        Point2D point2D3 = SVGElement.getSize(n2, element, this.getUserAgent().getSourcePixelUnitToMillimeter(), point2D2);
        sVGOMElement.setSVGContext(null);
        double d2 = 72.0 / (double)this.getUserAgent().getSourceResolution();
        return new Point2D.Double(point2D3.getX() * d2, point2D3.getY() * d2);
    }

    private Point2D millipointsToPixels(Point2D point2D) {
        return new Point2D.Float((float)UnitConv.mpt2px((double)point2D.getX(), (int)((int)this.getUserAgent().getSourceResolution())), (float)UnitConv.mpt2px((double)point2D.getY(), (int)((int)this.getUserAgent().getSourceResolution())));
    }

    public static Point2D getSize(int n2, Element element, float f2, Point2D point2D) {
        PDFUnitContext pDFUnitContext = new PDFUnitContext(n2, element, f2, point2D);
        String string = element.getAttributeNS(null, "width");
        if (string.length() == 0) {
            string = "100%";
        }
        String string2 = string;
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string, (String)"width", (UnitProcessor.Context)pDFUnitContext);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            string = "100%";
        }
        String string3 = string;
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace((String)string, (String)"height", (UnitProcessor.Context)pDFUnitContext);
        float[] fArray = SVGElement.imposePercentualProportionsFromViewBox(element, string2, string3, f3, f4);
        f3 = fArray[0];
        f4 = fArray[1];
        return new Point2D.Float(f3, f4);
    }

    public static float[] imposePercentualProportionsFromViewBox(Element element, String string, String string2, float f2, float f3) {
        float[] fArray = new float[2];
        Point2D.Float float_ = SVGElement.getViewBoxSize(element);
        if (float_ != null) {
            float f4 = float_.x;
            float f5 = float_.y;
            if (string.contains("%") && string2.contains("%")) {
                f3 = f5 / f4 * f2;
            } else if (string.contains("%") || string2.contains("%")) {
                if (string.contains("%")) {
                    float f6 = SVGElement.getPercent(string);
                    f2 = f4 / f5 * f3 * f6;
                } else {
                    float f7 = SVGElement.getPercent(string2);
                    f3 = f5 / f4 * f2 * f7;
                }
            }
        } else if (string.contains("%") || string2.contains("%")) {
            log.warn((Object)("Found a SVG Element without a viewBox attribute but with percentual width or height:" + element.getBaseURI() + " - width = " + f2 + ", height = " + f3 + " Falling back to a viewBox = \"0 0 " + f2 + " " + f3 + "\"."));
            element.setAttribute("viewBox", String.valueOf("0 0 " + f2 + " " + f3));
        }
        element.setAttribute("width", String.valueOf(f2));
        element.setAttribute("height", String.valueOf(f3));
        fArray[0] = f2;
        fArray[1] = f3;
        return fArray;
    }

    private static float getPercent(String string) {
        try {
            return Float.parseFloat(string.substring(0, string.indexOf(37))) / 100.0f;
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
            return 1.0f;
        }
    }

    private static Point2D.Float getViewBoxSize(Element element) {
        String[] stringArray;
        Point2D.Float float_ = null;
        String string = element.getAttributeNS(null, "viewBox");
        if (string.length() != 0 && (stringArray = string.split("\\s|,")).length == 4) {
            try {
                float f2 = Float.parseFloat(stringArray[2]);
                float f3 = Float.parseFloat(stringArray[3]);
                float_ = new Point2D.Float(f2, f3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return float_;
    }

    public static class PDFUnitContext
    implements UnitProcessor.Context {
        private Element e;
        private int fontSize;
        private float pixeltoMM;
        private Point2D view;

        public PDFUnitContext(int n2, Element element, float f2, Point2D point2D) {
            this.e = element;
            this.fontSize = n2;
            this.pixeltoMM = f2;
            this.view = point2D;
        }

        public Element getElement() {
            return this.e;
        }

        public UnitProcessor.Context getParentElementContext() {
            return null;
        }

        public float getPixelToMM() {
            return this.pixeltoMM;
        }

        public float getPixelUnitToMillimeter() {
            return this.pixeltoMM;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            if (this.view.getX() < 0.0) {
                return 100.0f;
            }
            return (float)this.view.getX();
        }

        public float getViewportHeight() {
            if (this.view.getY() < 100.0) {
                return 100.0f;
            }
            return (float)this.view.getY();
        }
    }
}

